/* xorg-server.h.in						-*- c -*-
 *
 * This file is the template file for the xorg-server.h file which gets
 * installed as part of the SDK.  The #defines in this file overlap
 * with those from config.h, but only for those options that we want
 * to export to external modules.  Boilerplate autotool #defines such
 * as HAVE_STUFF and PACKAGE_NAME is kept in config.h
 *
 * It is still possible to update config.h.in using autoheader, since
 * autoheader only creates a .h.in file for the first
 * AM_CONFIG_HEADER() line, and thus does not overwrite this file.
 *
 * However, it should be kept in sync with this file.
 */

#ifndef _XORG_SERVER_H_
#define _XORG_SERVER_H_

#ifdef HAVE_XORG_CONFIG_H
#error Include xorg-config.h when building the X server
#endif

/* Support BigRequests extension */
#define BIGREQS 1

/* Default font path */
#define COMPILEDDEFAULTFONTPATH "/usr/share/fonts/misc,/usr/share/fonts/TTF,/usr/share/fonts/OTF,/usr/share/fonts/Type1,/usr/share/fonts/100dpi,/usr/share/fonts/75dpi"

/* Support Composite Extension */
#define COMPOSITE 1

/* Build DPMS extension */
#define DPMSExtension

/* Build DRI3 extension */
#define DRI3

/* Build GLX extension */
#define GLXEXT

/* Support XDM-AUTH*-1 */
#define HASXDMAUTH

/* Support SHM */
#define HAS_SHM

/* Define to 1 if you have the `reallocarray' function. */
#define HAVE_REALLOCARRAY

/* Define to 1 if you have the `strcasecmp' function. */
#define HAVE_STRCASECMP

/* Define to 1 if you have the `strcasestr' function. */
#define HAVE_STRCASESTR

/* Define to 1 if you have the `strlcat' function. */
#undef HAVE_STRLCAT

/* Define to 1 if you have the `strlcpy' function. */
#undef HAVE_STRLCPY

/* Define to 1 if you have the `strncasecmp' function. */
#define HAVE_STRNCASECMP

/* Define to 1 if you have the `strndup' function. */
#define HAVE_STRNDUP

/* Support IPv6 for TCP connections */
#define IPv6

/* Support MIT-SHM Extension */
#define MITSHM

/* Internal define for Xinerama */
#define PANORAMIX

/* Support Present extension */
#define PRESENT 1

/* Support RANDR extension */
#define RANDR 1

/* Support RENDER extension */
#define RENDER 1

/* Support X resource extension */
#define RES

/* Support MIT-SCREEN-SAVER extension */
#define SCREENSAVER

/* Support SHAPE extension */
#define SHAPE 1

/* Define to 1 on systems derived from System V Release 4 */
#undef SVR4

/* Support TCP socket connections */
#define TCPCONN 1

/* Support UNIX socket connections */
#define UNIXCONN 1

/* Support XCMisc extension */
#define XCMISC 1

/* Support Xdmcp */
#define XDMCP

/* Build XFree86 BigFont extension */
#undef XF86BIGFONT

/* Support XFree86 Video Mode extension */
#define XF86VIDMODE

/* Build XDGA support */
#define XFreeXDGA

/* Support Xinerama extension */
#define XINERAMA

/* Support X Input extension */
#define XINPUT 1

/* XKB default rules */
#define XKB_DFLT_RULES "evdev"

/* Build DRI extension */
#define XF86DRI

/* Build DRI2 extension */
#define DRI2

/* Build Xorg server */
#define XORGSERVER

/* Current Xorg version */
#define XORG_VERSION_CURRENT 12007000

/* Build Xv Extension */
#define XvExtension

/* Build XvMC Extension */
#define XvMCExtension

/* Support XSync extension */
#define XSYNC 1

/* Support XTest extension */
#define XTEST 1

/* Support Xv Extension */
#define XV

/* Vendor name */
#define XVENDORNAME "The X.Org Foundation"

/* BSD-compliant source */
/* #undef _BSD_SOURCE */

/* POSIX-compliant source */
/* #undef _POSIX_SOURCE */

/* X/Open-compliant source */
/* #undef _XOPEN_SOURCE */

/* Vendor web address for support */
#define __VENDORDWEBSUPPORT__ "http://wiki.x.org"

/* Location of configuration file */
#define XCONFIGFILE "xorg.conf"

/* Name of X server */
#define __XSERVERNAME__ "Xorg"

/* Building vgahw module */
#define WITH_VGAHW

/* System is BSD-like */
#undef CSRG_BASED

/* System has PC console */
#undef PCCONS_SUPPORT

/* System has PCVT console */
#undef PCVT_SUPPORT

/* System has syscons console */
#undef SYSCONS_SUPPORT

/* System has wscons console */
#undef WSCONS_SUPPORT

/* Loadable XFree86 server awesomeness */
#define XFree86LOADER

/* Use libpciaccess */
#define XSERVER_LIBPCIACCESS

/* X Access Control Extension */
#define XACE

/* Have X server platform bus support */
#define XSERVER_PLATFORM_BUS

#ifdef _LP64
#define _XSERVER64 1
#endif

/* Have support for X shared memory fence library (xshmfence) */
#define HAVE_XSHMFENCE

/* Use XTrans FD passing support */
#define XTRANS_SEND_FDS 1

/* Ask fontsproto to make font path element names const */
#define FONT_PATH_ELEMENT_NAME_CONST    1

/* byte order */
#define X_BYTE_ORDER X_LITTLE_ENDIAN

#endif /* _XORG_SERVER_H_ */
