/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateCollector;
import org.jetbrains.kotlin.fir.resolve.calls.TowerDataConsumer;
import org.jetbrains.kotlin.fir.resolve.calls.TowerDataKind;
import org.jetbrains.kotlin.fir.resolve.calls.TowerScopeLevel;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/PrioritizedTowerDataConsumer;", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerDataConsumer;", "resultCollector", "Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;", "consumers", "", "(Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;[Lorg/jetbrains/kotlin/fir/resolve/calls/TowerDataConsumer;)V", "getConsumers", "()[Lorg/jetbrains/kotlin/fir/resolve/calls/TowerDataConsumer;", "[Lorg/jetbrains/kotlin/fir/resolve/calls/TowerDataConsumer;", "getResultCollector", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;", "consume", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "kind", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerDataKind;", "towerScopeLevel", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerScopeLevel;", "group", "", "resolve"})
public final class PrioritizedTowerDataConsumer
extends TowerDataConsumer {
    @NotNull
    private final CandidateCollector resultCollector;
    @NotNull
    private final TowerDataConsumer[] consumers;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProcessorAction consume(@NotNull TowerDataKind kind, @NotNull TowerScopeLevel towerScopeLevel, int group) {
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(towerScopeLevel, "towerScopeLevel");
        if (this.skipGroup(group, this.resultCollector)) {
            return ProcessorAction.NEXT;
        }
        TowerDataConsumer[] towerDataConsumerArray = this.consumers;
        int n = towerDataConsumerArray.length;
        int n2 = 0;
        while (n2 < n) {
            void index2;
            TowerDataConsumer consumer = towerDataConsumerArray[n2];
            ProcessorAction action = consumer.consume(kind, towerScopeLevel, group * this.consumers.length + index2);
            if (action.stop()) {
                return ProcessorAction.STOP;
            }
            ++index2;
        }
        return ProcessorAction.NEXT;
    }

    @NotNull
    public final CandidateCollector getResultCollector() {
        return this.resultCollector;
    }

    @NotNull
    public final TowerDataConsumer[] getConsumers() {
        return this.consumers;
    }

    public PrioritizedTowerDataConsumer(@NotNull CandidateCollector resultCollector, TowerDataConsumer ... consumers) {
        Intrinsics.checkParameterIsNotNull(resultCollector, "resultCollector");
        Intrinsics.checkParameterIsNotNull(consumers, "consumers");
        this.resultCollector = resultCollector;
        this.consumers = consumers;
    }
}

