﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/kendra/Kendra_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/kendra/model/Highlight.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace kendra
{
namespace Model
{

  /**
   * <p>Provides text and information about where to highlight the
   * text.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/TextWithHighlights">AWS
   * API Reference</a></p>
   */
  class AWS_KENDRA_API TextWithHighlights
  {
  public:
    TextWithHighlights();
    TextWithHighlights(Aws::Utils::Json::JsonView jsonValue);
    TextWithHighlights& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The text to display to the user.</p>
     */
    inline const Aws::String& GetText() const{ return m_text; }

    /**
     * <p>The text to display to the user.</p>
     */
    inline bool TextHasBeenSet() const { return m_textHasBeenSet; }

    /**
     * <p>The text to display to the user.</p>
     */
    inline void SetText(const Aws::String& value) { m_textHasBeenSet = true; m_text = value; }

    /**
     * <p>The text to display to the user.</p>
     */
    inline void SetText(Aws::String&& value) { m_textHasBeenSet = true; m_text = std::move(value); }

    /**
     * <p>The text to display to the user.</p>
     */
    inline void SetText(const char* value) { m_textHasBeenSet = true; m_text.assign(value); }

    /**
     * <p>The text to display to the user.</p>
     */
    inline TextWithHighlights& WithText(const Aws::String& value) { SetText(value); return *this;}

    /**
     * <p>The text to display to the user.</p>
     */
    inline TextWithHighlights& WithText(Aws::String&& value) { SetText(std::move(value)); return *this;}

    /**
     * <p>The text to display to the user.</p>
     */
    inline TextWithHighlights& WithText(const char* value) { SetText(value); return *this;}


    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline const Aws::Vector<Highlight>& GetHighlights() const{ return m_highlights; }

    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline bool HighlightsHasBeenSet() const { return m_highlightsHasBeenSet; }

    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline void SetHighlights(const Aws::Vector<Highlight>& value) { m_highlightsHasBeenSet = true; m_highlights = value; }

    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline void SetHighlights(Aws::Vector<Highlight>&& value) { m_highlightsHasBeenSet = true; m_highlights = std::move(value); }

    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline TextWithHighlights& WithHighlights(const Aws::Vector<Highlight>& value) { SetHighlights(value); return *this;}

    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline TextWithHighlights& WithHighlights(Aws::Vector<Highlight>&& value) { SetHighlights(std::move(value)); return *this;}

    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline TextWithHighlights& AddHighlights(const Highlight& value) { m_highlightsHasBeenSet = true; m_highlights.push_back(value); return *this; }

    /**
     * <p>The beginning and end of the text that should be highlighted.</p>
     */
    inline TextWithHighlights& AddHighlights(Highlight&& value) { m_highlightsHasBeenSet = true; m_highlights.push_back(std::move(value)); return *this; }

  private:

    Aws::String m_text;
    bool m_textHasBeenSet;

    Aws::Vector<Highlight> m_highlights;
    bool m_highlightsHasBeenSet;
  };

} // namespace Model
} // namespace kendra
} // namespace Aws
