/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.internal.SearchContext;

public final class InnerHitsFetchSubPhase
implements FetchSubPhase {
    private final FetchPhase fetchPhase;

    public InnerHitsFetchSubPhase(FetchPhase fetchPhase) {
        this.fetchPhase = fetchPhase;
    }

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!(context.innerHits() != null && context.innerHits().getInnerHits().size() > 0)) {
            return;
        }
        for (Map.Entry<String, InnerHitsContext.InnerHitSubContext> entry : context.innerHits().getInnerHits().entrySet()) {
            InnerHitsContext.InnerHitSubContext innerHits = entry.getValue();
            TopDocsAndMaxScore[] topDocs = innerHits.topDocs(hits);
            for (int i = 0; i < hits.length; ++i) {
                SearchHit hit = hits[i];
                TopDocsAndMaxScore topDoc = topDocs[i];
                Map<String, SearchHits> results = hit.getInnerHits();
                if (results == null) {
                    results = new HashMap<String, SearchHits>();
                    hit.setInnerHits(results);
                }
                innerHits.queryResult().topDocs(topDoc, innerHits.sort() == null ? null : innerHits.sort().formats);
                int[] docIdsToLoad = new int[topDoc.topDocs.scoreDocs.length];
                for (int j = 0; j < topDoc.topDocs.scoreDocs.length; ++j) {
                    docIdsToLoad[j] = topDoc.topDocs.scoreDocs[j].doc;
                }
                innerHits.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
                innerHits.setUid(new Uid(hit.getType(), hit.getId()));
                innerHits.lookup().source().setSource(context.lookup().source().internalSourceRef());
                if (context.lookup().source().source() != null) {
                    innerHits.lookup().source().setSource(context.lookup().source().source());
                }
                this.fetchPhase.execute(innerHits);
                FetchSearchResult fetchResult = innerHits.fetchResult();
                SearchHit[] internalHits = fetchResult.fetchResult().hits().getHits();
                for (int j = 0; j < internalHits.length; ++j) {
                    ScoreDoc scoreDoc = topDoc.topDocs.scoreDocs[j];
                    SearchHit searchHitFields = internalHits[j];
                    searchHitFields.score(scoreDoc.score);
                    if (!(scoreDoc instanceof FieldDoc)) continue;
                    FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                    searchHitFields.sortValues(fieldDoc.fields, innerHits.sort().formats);
                }
                results.put(entry.getKey(), fetchResult.hits());
            }
        }
    }
}

