/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.UnionVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultResolvedVersionConstraint
implements ResolvedVersionConstraint {
    private final VersionSelector preferredVersionSelector;
    private final VersionSelector requiredVersionSelector;
    private final VersionSelector rejectedVersionsSelector;
    private final boolean rejectAll;

    public DefaultResolvedVersionConstraint(VersionConstraint parent, VersionSelectorScheme scheme) {
        this(parent.getRequiredVersion(), parent.getPreferredVersion(), parent.getStrictVersion(), parent.getRejectedVersions(), scheme);
    }

    @VisibleForTesting
    public DefaultResolvedVersionConstraint(String requiredVersion, String preferredVersion, String strictVersion, List<String> rejectedVersions, VersionSelectorScheme scheme) {
        boolean strict = !strictVersion.isEmpty();
        String version = strict ? strictVersion : requiredVersion;
        this.requiredVersionSelector = scheme.parseSelector(version);
        VersionSelector versionSelector = this.preferredVersionSelector = preferredVersion.isEmpty() ? null : scheme.parseSelector(preferredVersion);
        if (strict) {
            if (!rejectedVersions.isEmpty()) {
                throw new IllegalArgumentException("Cannot combine 'strict' and 'reject' in a single version constraint.");
            }
            this.rejectedVersionsSelector = this.getRejectionForStrict(version, scheme);
            this.rejectAll = false;
        } else {
            this.rejectedVersionsSelector = DefaultResolvedVersionConstraint.toRejectSelector(scheme, rejectedVersions);
            this.rejectAll = DefaultResolvedVersionConstraint.isRejectAll(version, rejectedVersions);
        }
    }

    private VersionSelector getRejectionForStrict(String version, VersionSelectorScheme versionSelectorScheme) {
        VersionSelector preferredSelector = versionSelectorScheme.parseSelector(version);
        return versionSelectorScheme.complementForRejection(preferredSelector);
    }

    private static VersionSelector toRejectSelector(VersionSelectorScheme scheme, List<String> rejectedVersions) {
        if (rejectedVersions.size() > 1) {
            return UnionVersionSelector.of(rejectedVersions, scheme);
        }
        return rejectedVersions.isEmpty() ? null : scheme.parseSelector(rejectedVersions.get(0));
    }

    @Override
    public VersionSelector getPreferredSelector() {
        return this.preferredVersionSelector;
    }

    @Override
    public VersionSelector getRequiredSelector() {
        return this.requiredVersionSelector;
    }

    @Override
    public VersionSelector getRejectedSelector() {
        return this.rejectedVersionsSelector;
    }

    @Override
    public boolean isRejectAll() {
        return this.rejectAll;
    }

    private static boolean isRejectAll(String preferredVersion, List<String> rejectedVersions) {
        return "".equals(preferredVersion) && DefaultResolvedVersionConstraint.hasMatchAllSelector(rejectedVersions);
    }

    private static boolean hasMatchAllSelector(List<String> rejectedVersions) {
        for (String version : rejectedVersions) {
            if (!"+".equals(version)) continue;
            return true;
        }
        return false;
    }
}

