/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class BBox {
    protected double xmin = Double.POSITIVE_INFINITY;
    protected double xmax = Double.NEGATIVE_INFINITY;
    protected double ymin = Double.POSITIVE_INFINITY;
    protected double ymax = Double.NEGATIVE_INFINITY;

    public BBox() {
    }

    public BBox(double x, double y) {
        this.add(x, y);
    }

    public BBox(LatLon a, LatLon b) {
        this(a.lon(), a.lat(), b.lon(), b.lat());
    }

    public BBox(BBox copy) {
        this.xmin = copy.xmin;
        this.xmax = copy.xmax;
        this.ymin = copy.ymin;
        this.ymax = copy.ymax;
    }

    public BBox(double x, double y, double r) {
        this(x - r, y - r, x + r, y + r);
    }

    public BBox(double ax, double ay, double bx, double by) {
        if (!(Double.isNaN(ax) || Double.isNaN(ay) || Double.isNaN(bx) || Double.isNaN(by))) {
            this.add(ax, ay);
            this.add(bx, by);
        }
    }

    public BBox(IWay<?> w) {
        for (INode ll : w.getNodes()) {
            this.add(ll);
        }
    }

    public BBox(INode n) {
        this((ILatLon)n);
    }

    public BBox(ILatLon ll) {
        this.add(ll);
    }

    public final void add(LatLon c) {
        this.add((ILatLon)c);
    }

    public final void add(ILatLon c) {
        if (c != null) {
            this.add(c.lon(), c.lat());
        }
    }

    public final void add(double x, double y) {
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            this.xmin = Math.min(this.xmin, x);
            this.xmax = Math.max(this.xmax, x);
            this.ymin = Math.min(this.ymin, y);
            this.ymax = Math.max(this.ymax, y);
        }
    }

    public final void add(BBox other) {
        if (other.isValid()) {
            this.xmin = Math.min(this.xmin, other.xmin);
            this.xmax = Math.max(this.xmax, other.xmax);
            this.ymin = Math.min(this.ymin, other.ymin);
            this.ymax = Math.max(this.ymax, other.ymax);
        }
    }

    public void addPrimitive(OsmPrimitive primitive, double extraSpace) {
        BBox primBbox = primitive.getBBox();
        this.add(primBbox.xmin - extraSpace, primBbox.ymin - extraSpace);
        this.add(primBbox.xmax + extraSpace, primBbox.ymax + extraSpace);
    }

    public double height() {
        if (this.isValid()) {
            return this.ymax - this.ymin;
        }
        return 0.0;
    }

    public double width() {
        if (this.isValid()) {
            return this.xmax - this.xmin;
        }
        return 0.0;
    }

    public boolean bounds(BBox b) {
        return this.xmin <= b.xmin && this.xmax >= b.xmax && this.ymin <= b.ymin && this.ymax >= b.ymax;
    }

    public boolean bounds(LatLon c) {
        return this.xmin <= c.lon() && this.xmax >= c.lon() && this.ymin <= c.lat() && this.ymax >= c.lat();
    }

    public boolean intersects(BBox b) {
        return this.xmin <= b.xmax && this.xmax >= b.xmin && this.ymin <= b.ymax && this.ymax >= b.ymin;
    }

    public LatLon getTopLeft() {
        return new LatLon(this.ymax, this.xmin);
    }

    public double getTopLeftLat() {
        return this.ymax;
    }

    public double getTopLeftLon() {
        return this.xmin;
    }

    public LatLon getBottomRight() {
        return new LatLon(this.ymin, this.xmax);
    }

    public double getBottomRightLat() {
        return this.ymin;
    }

    public double getBottomRightLon() {
        return this.xmax;
    }

    public LatLon getCenter() {
        return new LatLon(this.ymin + (this.ymax - this.ymin) / 2.0, this.xmin + (this.xmax - this.xmin) / 2.0);
    }

    byte getIndex(int level) {
        byte idx1 = QuadTiling.index(this.ymin, this.xmin, level);
        byte idx2 = QuadTiling.index(this.ymin, this.xmax, level);
        if (idx1 == -1) {
            idx1 = idx2;
        } else if (idx1 != idx2) {
            return -1;
        }
        byte idx3 = QuadTiling.index(this.ymax, this.xmin, level);
        if (idx1 == -1) {
            idx1 = idx3;
        } else if (idx1 != idx3) {
            return -1;
        }
        byte idx4 = QuadTiling.index(this.ymax, this.xmax, level);
        if (idx1 == -1) {
            idx1 = idx4;
        } else if (idx1 != idx4) {
            return -1;
        }
        return idx1;
    }

    public Rectangle2D toRectangle() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public int hashCode() {
        return Objects.hash(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBox b = (BBox)o;
        return Double.compare(b.xmax, this.xmax) == 0 && Double.compare(b.ymax, this.ymax) == 0 && Double.compare(b.xmin, this.xmin) == 0 && Double.compare(b.ymin, this.ymin) == 0;
    }

    public boolean bboxIsFunctionallyEqual(BBox other, Double maxDifference) {
        return BBox.bboxesAreFunctionallyEqual(this, other, maxDifference);
    }

    public static boolean bboxesAreFunctionallyEqual(BBox bbox1, BBox bbox2, Double maxDifference) {
        if (maxDifference == null) {
            maxDifference = 1.0E-7;
        }
        return bbox1 != null && bbox2 != null && Math.abs(bbox1.getBottomRightLat() - bbox2.getBottomRightLat()) <= maxDifference && Math.abs(bbox1.getBottomRightLon() - bbox2.getBottomRightLon()) <= maxDifference && Math.abs(bbox1.getTopLeftLat() - bbox2.getTopLeftLat()) <= maxDifference && Math.abs(bbox1.getTopLeftLon() - bbox2.getTopLeftLon()) <= maxDifference;
    }

    public boolean isValid() {
        return this.xmin <= this.xmax && this.ymin <= this.ymax;
    }

    public boolean isInWorld() {
        return this.xmin >= -180.0 && this.xmax <= 180.0 && this.ymin >= -90.0 && this.ymax <= 90.0 && this.isValid();
    }

    public String toString() {
        return "[ x: " + this.xmin + " -> " + this.xmax + ", y: " + this.ymin + " -> " + this.ymax + " ]";
    }

    public String toStringCSV(String separator) {
        return String.join((CharSequence)separator, LatLon.cDdFormatter.format(this.xmin), LatLon.cDdFormatter.format(this.ymin), LatLon.cDdFormatter.format(this.xmax), LatLon.cDdFormatter.format(this.ymax));
    }
}

