/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.HelpAction;
import org.openstreetmap.josm.tools.I18n;

public class HelpTagAction
extends HelpAction {
    private final JTable tagTable;
    private final IntFunction<String> tagKeySupplier;
    private final IntFunction<Map<String, Integer>> tagValuesSupplier;

    public HelpTagAction(JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier) {
        this.tagTable = Objects.requireNonNull(tagTable);
        this.tagKeySupplier = Objects.requireNonNull(tagKeySupplier);
        this.tagValuesSupplier = Objects.requireNonNull(tagValuesSupplier);
        this.putValue("Name", I18n.tr("Go to OSM wiki for tag help", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.tagTable.getSelectedRowCount() == 1) {
            int row = this.tagTable.getSelectedRow();
            String key = this.tagKeySupplier.apply(row);
            Map<String, Integer> m = this.tagValuesSupplier.apply(row);
            if (!m.isEmpty()) {
                String val = m.entrySet().iterator().next().getKey();
                MainApplication.worker.execute(() -> HelpTagAction.displayTagHelp(key, val));
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

