/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.overpass.OverpassWizardRegistration;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OverpassTurboQueryWizard;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;

public final class OverpassQueryWizardDialog
extends ExtendedDialog {
    private final HistoryComboBox queryWizard;
    private static final String HEADLINE_START = "<h3>";
    private static final String HEADLINE_END = "</h3>";
    private static final String TR_START = "<tr>";
    private static final String TR_END = "</tr>";
    private static final String TD_START = "<td>";
    private static final String TD_END = "</td>";
    private static final String SPAN_START = "<span>";
    private static final String SPAN_END = "</span>";
    private static final ListProperty OVERPASS_WIZARD_HISTORY = new ListProperty("download.overpass.wizard", (List<String>)new ArrayList<String>());
    private final transient OverpassTurboQueryWizard overpassQueryBuilder;
    private static final int BUILD_QUERY = 0;
    private static final int BUILD_AN_EXECUTE_QUERY = 1;
    private static final int CANCEL = 2;
    private static final String DESCRIPTION_STYLE = "<style type=\"text/css\">\ntable { border-spacing: 0pt;}\nh3 {text-align: center; padding: 8px;}\ntd {border: 1px solid #dddddd; text-align: left; padding: 8px;}\n#desc {width: 350px;}</style>\n";
    private final OverpassWizardRegistration.OverpassWizardCallbacks dsPanel;

    public OverpassQueryWizardDialog(OverpassWizardRegistration.OverpassWizardCallbacks callbacks) {
        super(callbacks.getParent(), I18n.tr("Overpass Turbo Query Wizard", new Object[0]), I18n.tr("Build query", new Object[0]), I18n.tr("Build query and execute", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.dsPanel = callbacks;
        this.queryWizard = new HistoryComboBox();
        this.overpassQueryBuilder = OverpassTurboQueryWizard.getInstance();
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel searchLabel = new JLabel(I18n.tr("Search:", new Object[0]));
        JTextComponent descPane = OverpassQueryWizardDialog.buildDescriptionSection();
        JScrollPane scroll = GuiHelper.embedInVerticalScrollPane(descPane);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        panel.add((Component)searchLabel, GBC.std().insets(0, 0, 0, 20).anchor(14));
        panel.add((Component)this.queryWizard, GBC.eol().insets(0, 0, 0, 15).fill(2).anchor(15));
        panel.add((Component)scroll, GBC.eol().fill(1).anchor(10));
        ArrayList<String> items = new ArrayList<String>((Collection<String>)OVERPASS_WIZARD_HISTORY.get());
        if (!items.isEmpty()) {
            this.queryWizard.setText((String)items.get(0));
        }
        this.queryWizard.setPossibleItemsTopDown(items);
        this.setCancelButton(3);
        this.setDefaultButton(2);
        this.setContent(panel, false);
    }

    @Override
    public void buttonAction(int buttonIndex, ActionEvent evt) {
        switch (buttonIndex) {
            case 0: {
                if (!this.buildQueryAction()) break;
                this.saveHistory();
                super.buttonAction(0, evt);
                break;
            }
            case 1: {
                if (!this.buildQueryAction()) break;
                this.saveHistory();
                super.buttonAction(1, evt);
                DownloadDialog.getInstance().startDownload();
                break;
            }
            default: {
                super.buttonAction(buttonIndex, evt);
            }
        }
    }

    private void saveHistory() {
        this.queryWizard.addCurrentItemToHistory();
        OVERPASS_WIZARD_HISTORY.put(this.queryWizard.getHistory());
    }

    private Optional<String> tryParseSearchTerm(String searchTerm) {
        try {
            return Optional.of(this.overpassQueryBuilder.constructQuery(searchTerm));
        }
        catch (IllegalStateException | UncheckedParseException ex) {
            Logging.error(ex);
            JOptionPane.showMessageDialog(this.dsPanel.getParent(), "<html>" + I18n.tr("The Overpass wizard could not parse the following query:", new Object[0]) + Utils.joinAsHtmlUnorderedList(Collections.singleton(Utils.escapeReservedCharactersHTML(searchTerm))) + "</html>", I18n.tr("Parse error", new Object[0]), 0);
            return Optional.empty();
        }
    }

    private boolean buildQueryAction() {
        String wizardSearchTerm = this.queryWizard.getText();
        Optional<String> q = this.tryParseSearchTerm(wizardSearchTerm);
        q.ifPresent(this.dsPanel::submitWizardResult);
        return q.isPresent();
    }

    private static JTextComponent buildDescriptionSection() {
        JEditorPane descriptionSection = new JEditorPane("text/html", OverpassQueryWizardDialog.getDescriptionContent());
        descriptionSection.setEditable(false);
        descriptionSection.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                OpenBrowser.displayUrl(e.getURL().toString());
            }
        });
        return descriptionSection;
    }

    private static String getDescriptionContent() {
        return "<html>" + DESCRIPTION_STYLE + "<body>" + HEADLINE_START + I18n.tr("Query Wizard", new Object[0]) + HEADLINE_END + "<p>" + I18n.tr("Allows you to interact with <i>Overpass API</i> by writing declarative, human-readable terms.", new Object[0]) + I18n.tr("The <i>Query Wizard</i> tool will transform those to a valid overpass query.", new Object[0]) + I18n.tr("For more detailed description see ", new Object[0]) + I18n.tr("<a href=\"{0}\">OSM Wiki</a>.", Config.getUrls().getOSMWebsite() + "/wiki/Overpass_turbo/Wizard") + "</p>" + HEADLINE_START + I18n.tr("Hints", new Object[0]) + HEADLINE_END + "<table>" + TR_START + TD_START + Utils.joinAsHtmlUnorderedList(Arrays.asList("<i>type:node</i>", "<i>type:relation</i>", "<i>type:way</i>")) + TD_END + TD_START + SPAN_START + I18n.tr("Download objects of a certain type.", new Object[0]) + SPAN_END + TD_END + TR_END + TR_START + TD_START + Utils.joinAsHtmlUnorderedList(Arrays.asList("<i>key=value in <u>location</u></i>", "<i>key=value around <u>location</u></i>", "<i>key=value in bbox</i>")) + TD_END + TD_START + I18n.tr("Download object by specifying a specific location. For example,", new Object[0]) + Utils.joinAsHtmlUnorderedList(Arrays.asList(I18n.tr("{0} all objects having {1} as attribute are downloaded.", "<i>tourism=hotel in Berlin</i> -", "'tourism=hotel'"), I18n.tr("{0} all object with the corresponding key/value pair located around Berlin. Note, the default value for radius is set to 1000m, but it can be changed in the generated query.", "<i>tourism=hotel around Berlin</i> -"), I18n.tr("{0} all objects within the current selection that have {1} as attribute.", "<i>tourism=hotel in bbox</i> -", "'tourism=hotel'"))) + SPAN_START + I18n.tr("Instead of <i>location</i> any valid place name can be used like address, city, etc.", new Object[0]) + SPAN_END + TD_END + TR_END + TR_START + TD_START + Utils.joinAsHtmlUnorderedList(Arrays.asList("<i>key=value</i>", "<i>key=*</i>", "<i>key~regex</i>", "<i>key!=value</i>", "<i>key!~regex</i>", "<i>key=\"combined value\"</i>")) + TD_END + TD_START + I18n.tr("<span>Download objects that have some concrete key/value pair, only the key with any contents for the value, the value matching some regular expression. \"Not equal\" operators are supported as well.</span>", new Object[0]) + TD_END + TR_END + TR_START + TD_START + Utils.joinAsHtmlUnorderedList(Arrays.asList(I18n.tr("<i>expression1 {0} expression2</i>", "or"), I18n.tr("<i>expression1 {0} expression2</i>", "and"))) + TD_END + TD_START + SPAN_START + I18n.tr("Basic logical operators can be used to create more sophisticated queries. Instead of \"or\" - \"|\", \"||\" can be used, and instead of \"and\" - \"&\", \"&&\".", new Object[0]) + SPAN_END + TD_END + TR_END + TR_START + TD_START + Utils.joinAsHtmlUnorderedList(Arrays.asList(I18n.tr("<i>ref ~ \"[0-9]+\"</i>", new Object[0]), I18n.tr("<i>name ~ /postnord/i in sweden</i>", new Object[0]))) + TD_END + TD_START + SPAN_START + I18n.tr("Regular expressions can be provided either as plain strings or with the regex notation. The modifier \"i\" makes the match case-insensitive", new Object[0]) + SPAN_END + TD_END + TR_END + "</table>" + "</body>" + "</html>";
    }
}

