/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.osmand.Location;
import net.osmand.data.MapObject;
import net.osmand.osm.PoiCategory;
import net.osmand.util.Algorithms;

public class Amenity
extends MapObject {
    public static final String WEBSITE = "website";
    public static final String PHONE = "phone";
    public static final String DESCRIPTION = "description";
    public static final String OPENING_HOURS = "opening_hours";
    public static final String CONTENT = "content";
    private String subType;
    private PoiCategory type;
    private String openingHours;
    private Map<String, String> additionalInfo;
    private AmenityRoutePoint routePoint;

    public PoiCategory getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setType(PoiCategory type) {
        this.type = type;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getOpeningHours() {
        return this.openingHours;
    }

    public String getAdditionalInfo(String key) {
        if (this.additionalInfo == null) {
            return null;
        }
        String str = this.additionalInfo.get(key);
        str = this.unzipContent(str);
        return str;
    }

    public String unzipContent(String str) {
        if (str != null && str.startsWith(" gz ")) {
            try {
                String s;
                int ind = 4;
                byte[] bytes = new byte[str.length() - ind];
                for (int i = ind; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    bytes[i - ind] = (byte)(ch - 128 - 32);
                }
                GZIPInputStream gzn = new GZIPInputStream(new ByteArrayInputStream(bytes));
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gzn, "UTF-8"));
                StringBuilder bld = new StringBuilder();
                while ((s = br.readLine()) != null) {
                    bld.append(s);
                }
                br.close();
                str = bld.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public Map<String, String> getAdditionalInfo() {
        if (this.additionalInfo == null) {
            return Collections.emptyMap();
        }
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = null;
        this.openingHours = null;
        if (additionalInfo != null) {
            for (Map.Entry<String, String> e : additionalInfo.entrySet()) {
                this.setAdditionalInfo(e.getKey(), e.getValue());
            }
        }
    }

    public void setRoutePoint(AmenityRoutePoint routePoint) {
        this.routePoint = routePoint;
    }

    public AmenityRoutePoint getRoutePoint() {
        return this.routePoint;
    }

    public void setAdditionalInfo(String tag, String value) {
        if ("name".equals(tag)) {
            this.setName(value);
        } else if ("name:en".equals(tag)) {
            this.setEnName(value);
        } else if (tag.startsWith("name:")) {
            this.setName(tag.substring("name:".length()), value);
        } else {
            if (this.additionalInfo == null) {
                this.additionalInfo = new LinkedHashMap<String, String>();
            }
            this.additionalInfo.put(tag, value);
            if (OPENING_HOURS.equals(tag)) {
                this.openingHours = value;
            }
        }
    }

    @Override
    public String toString() {
        return this.type.toString() + " : " + this.subType + " " + this.getName();
    }

    public String getSite() {
        return this.getAdditionalInfo(WEBSITE);
    }

    public void setSite(String site) {
        this.setAdditionalInfo(WEBSITE, site);
    }

    public String getPhone() {
        return this.getAdditionalInfo(PHONE);
    }

    public void setPhone(String phone) {
        this.setAdditionalInfo(PHONE, phone);
    }

    public String getContentSelected(String tag, String lang, String defLang) {
        String translateName;
        if (lang != null && !Algorithms.isEmpty(translateName = this.getAdditionalInfo(tag + ":" + lang))) {
            return lang;
        }
        String plainContent = this.getAdditionalInfo(tag);
        if (!Algorithms.isEmpty(plainContent)) {
            return defLang;
        }
        String enName = this.getAdditionalInfo(tag + ":en");
        if (!Algorithms.isEmpty(enName)) {
            return enName;
        }
        int maxLen = 0;
        String lng = defLang;
        for (String nm : this.getAdditionalInfo().keySet()) {
            if (!nm.startsWith(tag + ":")) continue;
            String key = nm.substring(tag.length() + 1);
            String cnt = this.getAdditionalInfo(tag + ":" + key);
            if (Algorithms.isEmpty(cnt) || cnt.length() <= maxLen) continue;
            maxLen = cnt.length();
            lng = key;
        }
        return lng;
    }

    public List<String> getNames(String tag, String defTag) {
        ArrayList<String> l = new ArrayList<String>();
        for (String nm : this.getAdditionalInfo().keySet()) {
            if (nm.startsWith(tag + ":")) {
                l.add(nm.substring(tag.length() + 1));
                continue;
            }
            if (!nm.equals(tag)) continue;
            l.add(defTag);
        }
        return l;
    }

    public String getContentLang(String tag, String lang) {
        String translateName;
        if (lang != null && !Algorithms.isEmpty(translateName = this.getAdditionalInfo(tag + ":" + lang))) {
            return translateName;
        }
        String plainName = this.getAdditionalInfo(tag);
        if (!Algorithms.isEmpty(plainName)) {
            return plainName;
        }
        String enName = this.getAdditionalInfo(tag + ":en");
        if (!Algorithms.isEmpty(enName)) {
            return enName;
        }
        for (String nm : this.getAdditionalInfo().keySet()) {
            if (!nm.startsWith(tag + ":")) continue;
            return this.getAdditionalInfo(nm);
        }
        return null;
    }

    public String getDescription(String lang) {
        String info = this.getContentLang(DESCRIPTION, lang);
        if (!Algorithms.isEmpty(info)) {
            return info;
        }
        return this.getContentLang(CONTENT, lang);
    }

    public void setDescription(String description) {
        this.setAdditionalInfo(DESCRIPTION, description);
    }

    public void setOpeningHours(String openingHours) {
        this.setAdditionalInfo(OPENING_HOURS, openingHours);
    }

    public static class AmenityRoutePoint {
        public double deviateDistance;
        public boolean deviationDirectionRight;
        public Location pointA;
        public Location pointB;
    }
}

