/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import org.netbeans.core.multitabs.TabDecorator;
import org.netbeans.core.multitabs.prefs.SettingsImpl;
import org.netbeans.swing.tabcontrol.TabData;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public class FolderNameTabDecorator
extends TabDecorator {
    private final SettingsImpl settings = new SettingsImpl();
    private static final String pathSeparator = System.getProperty("file.separator", "/");

    @Override
    public String getText(TabData tab) {
        FileObject folder;
        FileObject fo;
        TopComponent tc;
        DataObject dob;
        if (!this.settings.isShowFolderName()) {
            return null;
        }
        if (tab.getComponent() instanceof TopComponent && null != (dob = (DataObject)(tc = (TopComponent)tab.getComponent()).getLookup().lookup(DataObject.class)) && (fo = dob.getPrimaryFile()).isData() && null != (folder = fo.getParent())) {
            String folderName = folder.getNameExt() + pathSeparator;
            String defaultText = tab.getText();
            return FolderNameTabDecorator.merge(folderName, defaultText);
        }
        return null;
    }

    @Override
    public Icon getIcon(TabData tab) {
        return null;
    }

    @Override
    public Color getBackground(TabData tab, boolean selected) {
        return null;
    }

    @Override
    public Color getForeground(TabData tab, boolean selected) {
        return null;
    }

    @Override
    public void paintAfter(TabData tab, Graphics g, Rectangle tabRect, boolean isSelected) {
    }

    private static String merge(String prefix, String baseText) {
        if (null == baseText) {
            baseText = "";
        }
        StringBuilder res = new StringBuilder(prefix.length() + baseText.length());
        if (baseText.toLowerCase().startsWith("<html>")) {
            res.append("<html>");
            res.append(prefix);
            res.append(baseText.substring(6));
        } else {
            res.append(prefix);
            res.append(baseText);
        }
        return res.toString();
    }
}

