/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import java.io.IOException;
import java.io.InputStream;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ssh.SshRepository;
import org.apache.ivy.util.Message;

public class SshResource
implements Resource {
    private boolean resolved = false;
    private String uri = null;
    private boolean bExists = false;
    private long len = 0L;
    private long lastModified = 0L;
    private SshRepository repository = null;

    public SshResource() {
        this.resolved = true;
    }

    public SshResource(SshRepository sshRepository, String string) {
        this.uri = string;
        this.repository = sshRepository;
        this.resolved = false;
    }

    public SshResource(SshRepository sshRepository, String string, boolean bl, long l, long l2) {
        this.uri = string;
        this.bExists = bl;
        this.len = l;
        this.lastModified = l2;
        this.repository = sshRepository;
        this.resolved = true;
    }

    @Override
    public boolean exists() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.bExists;
    }

    @Override
    public long getContentLength() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.len;
    }

    @Override
    public long getLastModified() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.lastModified;
    }

    private void resolve() {
        Message.debug("SShResource: resolving " + this.uri);
        SshResource sshResource = this.repository.resolveResource(this.uri);
        this.len = sshResource.getContentLength();
        this.lastModified = sshResource.getLastModified();
        this.bExists = sshResource.exists();
        this.resolved = true;
        Message.debug("SShResource: resolved " + this);
    }

    @Override
    public String getName() {
        return this.uri;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SshResource:");
        stringBuffer.append(this.uri);
        stringBuffer.append(" (");
        stringBuffer.append(this.len);
        stringBuffer.append(")]");
        return stringBuffer.toString();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public Resource clone(String string) {
        return new SshResource(this.repository, string);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.repository.openStream(this);
    }
}

