/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AStoreable;
import org.objectweb.asm.Type;

final class PSubField
extends AStoreable {
    private final PainlessField field;

    PSubField(Location location, PainlessField field) {
        super(location);
        this.field = Objects.requireNonNull(field);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (this.write && Modifier.isFinal(this.field.javaField.getModifiers())) {
            throw this.createError(new IllegalArgumentException("Cannot write to read-only field [" + this.field.javaField.getName() + "] for type [" + PainlessLookupUtility.typeToCanonicalTypeName(this.field.javaField.getDeclaringClass()) + "]."));
        }
        this.actual = this.field.typeParameter;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (Modifier.isStatic(this.field.javaField.getModifiers())) {
            methodWriter.getStatic(Type.getType(this.field.javaField.getDeclaringClass()), this.field.javaField.getName(), MethodWriter.getType(this.field.typeParameter));
        } else {
            methodWriter.getField(Type.getType(this.field.javaField.getDeclaringClass()), this.field.javaField.getName(), MethodWriter.getType(this.field.typeParameter));
        }
    }

    @Override
    int accessElementCount() {
        return 1;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Class<?> actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
    }

    @Override
    void load(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (Modifier.isStatic(this.field.javaField.getModifiers())) {
            methodWriter.getStatic(Type.getType(this.field.javaField.getDeclaringClass()), this.field.javaField.getName(), MethodWriter.getType(this.field.typeParameter));
        } else {
            methodWriter.getField(Type.getType(this.field.javaField.getDeclaringClass()), this.field.javaField.getName(), MethodWriter.getType(this.field.typeParameter));
        }
    }

    @Override
    void store(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        if (Modifier.isStatic(this.field.javaField.getModifiers())) {
            methodWriter.putStatic(Type.getType(this.field.javaField.getDeclaringClass()), this.field.javaField.getName(), MethodWriter.getType(this.field.typeParameter));
        } else {
            methodWriter.putField(Type.getType(this.field.javaField.getDeclaringClass()), this.field.javaField.getName(), MethodWriter.getType(this.field.typeParameter));
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.field.javaField.getName());
    }
}

