/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;

public final class SDeclaration
extends AStatement {
    private final String type;
    private final String name;
    private AExpression expression;
    private Locals.Variable variable = null;

    public SDeclaration(Location location, String type, String name, AExpression expression) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        this.expression = expression;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        if (this.expression != null) {
            this.expression.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.name);
        if (this.expression != null) {
            this.expression.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        Class<?> clazz = scriptRoot.getPainlessLookup().canonicalTypeNameToType(this.type);
        if (clazz == null) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        if (this.expression != null) {
            this.expression.expected = clazz;
            this.expression.analyze(scriptRoot, locals);
            this.expression = this.expression.cast(scriptRoot, locals);
        }
        this.variable = locals.addVariable(this.location, clazz, this.name, false);
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeStatementOffset(this.location);
        if (this.expression == null) {
            Class<?> sort = this.variable.clazz;
            if (sort == Void.TYPE || sort == Boolean.TYPE || sort == Byte.TYPE || sort == Short.TYPE || sort == Character.TYPE || sort == Integer.TYPE) {
                methodWriter.push(0);
            } else if (sort == Long.TYPE) {
                methodWriter.push(0L);
            } else if (sort == Float.TYPE) {
                methodWriter.push(0.0f);
            } else if (sort == Double.TYPE) {
                methodWriter.push(0.0);
            } else {
                methodWriter.visitInsn(1);
            }
        } else {
            this.expression.write(classWriter, methodWriter, globals);
        }
        methodWriter.visitVarInsn(MethodWriter.getType(this.variable.clazz).getOpcode(54), this.variable.getSlot());
    }

    @Override
    public String toString() {
        if (this.expression == null) {
            return this.singleLineToString(this.type, this.name);
        }
        return this.singleLineToString(this.type, this.name, this.expression);
    }
}

