/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class ModeWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        ModeWidget modeWidget = new ModeWidget(view);
        return modeWidget;
    }

    private static class ModeWidget
    implements Widget {
        private final JLabel mode = new ToolTipLabel();
        private final View view;

        public ModeWidget(final View view) {
            this.view = view;
            this.mode.setToolTipText(jEdit.getProperty("view.status.mode-tooltip"));
            this.mode.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        new BufferOptions(view, view.getBuffer());
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.mode;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            if (buffer.isLoaded()) {
                this.mode.setText(buffer.getMode().toString());
            }
        }

        @Override
        public void propertiesChanged() {
        }
    }
}

