/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.WrappingProcessor;
import org.elasticsearch.script.ScriptService;

public final class ForEachProcessor
extends AbstractProcessor
implements WrappingProcessor {
    public static final String TYPE = "foreach";
    static final int MAX_RECURSE_PER_THREAD = 10;
    private final String field;
    private final Processor processor;
    private final boolean ignoreMissing;
    private final Consumer<Runnable> genericExecutor;

    ForEachProcessor(String tag, String field, Processor processor, boolean ignoreMissing, Consumer<Runnable> genericExecutor) {
        super(tag);
        this.field = field;
        this.processor = processor;
        this.ignoreMissing = ignoreMissing;
        this.genericExecutor = genericExecutor;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        List values = (List)ingestDocument.getFieldValue(this.field, List.class, this.ignoreMissing);
        if (values == null) {
            if (this.ignoreMissing) {
                handler.accept(ingestDocument, null);
            } else {
                handler.accept(null, new IllegalArgumentException("field [" + this.field + "] is null, cannot loop over its elements."));
            }
        } else {
            CopyOnWriteArrayList<Object> newValues = new CopyOnWriteArrayList<Object>();
            this.innerExecute(0, values, newValues, ingestDocument, handler);
        }
    }

    void innerExecute(int index, List<?> values, List<Object> newValues, IngestDocument document, BiConsumer<IngestDocument, Exception> handler) {
        if (index == values.size()) {
            document.setFieldValue(this.field, new ArrayList<Object>(newValues));
            handler.accept(document, null);
            return;
        }
        Object value = values.get(index);
        Object previousValue = document.getIngestMetadata().put("_value", value);
        Thread thread = Thread.currentThread();
        this.processor.execute(document, (result, e) -> {
            if (e != null) {
                newValues.add(document.getIngestMetadata().put("_value", previousValue));
                handler.accept((IngestDocument)null, (Exception)e);
            } else if (result == null) {
                handler.accept(null, null);
            } else {
                newValues.add(document.getIngestMetadata().put("_value", previousValue));
                if (thread == Thread.currentThread() && (index + 1) % 10 == 0) {
                    this.genericExecutor.accept(() -> this.innerExecute(index + 1, values, newValues, document, handler));
                } else {
                    this.innerExecute(index + 1, values, newValues, document, handler);
                }
            }
        });
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    public Processor getInnerProcessor() {
        return this.processor;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;
        private final Consumer<Runnable> genericExecutor;

        Factory(ScriptService scriptService, Consumer<Runnable> genericExecutor) {
            this.scriptService = scriptService;
            this.genericExecutor = genericExecutor;
        }

        public ForEachProcessor create(Map<String, Processor.Factory> factories, String tag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)ForEachProcessor.TYPE, (String)tag, config, (String)"field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)ForEachProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
            Map processorConfig = ConfigurationUtils.readMap((String)ForEachProcessor.TYPE, (String)tag, config, (String)"processor");
            Set entries = processorConfig.entrySet();
            if (entries.size() != 1) {
                throw ConfigurationUtils.newConfigurationException((String)ForEachProcessor.TYPE, (String)tag, (String)"processor", (String)"Must specify exactly one processor type");
            }
            Map.Entry entry = entries.iterator().next();
            Processor processor = ConfigurationUtils.readProcessor(factories, (ScriptService)this.scriptService, (String)((String)entry.getKey()), (Map)((Map)entry.getValue()));
            return new ForEachProcessor(tag, field, processor, ignoreMissing, this.genericExecutor);
        }
    }
}

