/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;

public final class SExpression
extends AStatement {
    private AExpression expression;

    public SExpression(Location location, AExpression expression) {
        super(location);
        this.expression = Objects.requireNonNull(expression);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.expression.storeSettings(settings);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.expression.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        Class<?> rtnType = locals.getReturnType();
        boolean isVoid = rtnType == Void.TYPE;
        this.expression.read = this.lastSource && !isVoid;
        this.expression.analyze(scriptRoot, locals);
        if (!this.lastSource && !this.expression.statement) {
            throw this.createError(new IllegalArgumentException("Not a statement."));
        }
        boolean rtn = this.lastSource && !isVoid && this.expression.actual != Void.TYPE;
        this.expression.expected = rtn ? rtnType : this.expression.actual;
        this.expression.internal = rtn;
        this.expression = this.expression.cast(scriptRoot, locals);
        this.methodEscape = rtn;
        this.loopEscape = rtn;
        this.allEscape = rtn;
        this.statementCount = 1;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeStatementOffset(this.location);
        this.expression.write(classWriter, methodWriter, globals);
        if (this.methodEscape) {
            methodWriter.returnValue();
        } else {
            methodWriter.writePop(MethodWriter.getType(this.expression.expected).getSize());
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.expression);
    }
}

