/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.event.download;

import java.io.File;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ArtifactOrigin;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.event.download.DownloadEvent;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.resolver.DependencyResolver;

public class EndArtifactDownloadEvent
extends DownloadEvent {
    public static final String NAME = "post-download-artifact";
    private DependencyResolver resolver;
    private ArtifactDownloadReport report;

    public EndArtifactDownloadEvent(DependencyResolver resolver, Artifact artifact, ArtifactDownloadReport report, File dest) {
        super(NAME, artifact);
        this.resolver = resolver;
        this.report = report;
        this.addAttribute("resolver", this.resolver.getName());
        this.addAttribute("status", this.report.getDownloadStatus().toString());
        this.addAttribute("details", this.report.getDownloadDetails());
        this.addAttribute("size", String.valueOf(this.report.getSize()));
        this.addAttribute("file", dest.getAbsolutePath());
        this.addAttribute("duration", String.valueOf(this.report.getDownloadTimeMillis()));
        ArtifactOrigin origin = report.getArtifactOrigin();
        if (!ArtifactOrigin.isUnknown(origin)) {
            this.addAttribute("origin", origin.getLocation());
            this.addAttribute("local", String.valueOf(origin.isLocal()));
        } else {
            this.addAttribute("origin", "");
            this.addAttribute("local", "");
        }
    }

    public ArtifactDownloadReport getReport() {
        return this.report;
    }

    public DependencyResolver getResolver() {
        return this.resolver;
    }
}

