/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.SourceFileReaderAbstract;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;

public class SourceFileReaderHardFile
extends SourceFileReaderAbstract
implements ISourceFileReader {
    public SourceFileReaderHardFile(Defines defines, File file, File outputFile, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        this.outputFile = outputFile;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        File parentFile = file.getAbsoluteFile().getParentFile();
        this.builder = new BlockUmlBuilder(config, charset, defines, this.getReader(charset), parentFile, FileWithSuffix.getFileName(file));
    }

    @Override
    protected SuggestedFile getSuggestedFile(BlockUml blockUml) {
        SuggestedFile suggested = SuggestedFile.fromOutputFile(this.outputFile, this.fileFormatOption.getFileFormat());
        return suggested;
    }
}

