/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasShortForm;

public enum PrimitiveType implements Serializable,
HasShortForm
{
    CLASS(EntityType.CLASS),
    OBJECT_PROPERTY(EntityType.OBJECT_PROPERTY),
    DATA_PROPERTY(EntityType.DATA_PROPERTY),
    ANNOTATION_PROPERTY(EntityType.ANNOTATION_PROPERTY),
    DATATYPE(EntityType.DATATYPE),
    NAMED_INDIVIDUAL(EntityType.NAMED_INDIVIDUAL),
    LITERAL("Literal", "Literal", "Literals"),
    IRI("IRI", "IRI", "IRIs");

    @Nonnull
    private final String shortForm;
    @Nonnull
    private final String printName;
    @Nonnull
    private final String pluralPrintName;

    private PrimitiveType(EntityType<?> entityType) {
        this(entityType.getShortForm(), entityType.getPrintName(), entityType.getPluralPrintName());
    }

    private PrimitiveType(@Nonnull String shortForm, String printName, String pluralPrintName) {
        this.shortForm = shortForm;
        this.printName = printName;
        this.pluralPrintName = pluralPrintName;
    }

    @Override
    public String getShortForm() {
        return this.shortForm;
    }

    public String getPrintName() {
        return this.printName;
    }

    public String getPluralPrintName() {
        return this.pluralPrintName;
    }
}

