/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.Socket;
import net.sf.sdedit.ui.components.DelayedActivity;
import net.sf.sdedit.ui.impl.DiagramTextTab;

public class Receiver
implements Runnable {
    private BufferedReader reader;
    private int delay = 100;
    private Socket socket;
    private boolean shutDown;
    private DelayedActivity waiter;
    private StringBuffer appendBuffer;

    public Receiver(final DiagramTextTab tab, BufferedReader reader, Socket socket) {
        this.reader = reader;
        this.socket = socket;
        this.shutDown = false;
        this.appendBuffer = new StringBuffer();
        this.waiter = new DelayedActivity(){

            @Override
            protected int getDelay() {
                return Receiver.this.delay;
            }

            @Override
            protected void perform() {
                tab.append(Receiver.this.appendBuffer.toString());
                Receiver.this.appendBuffer.setLength(0);
            }
        };
        this.waiter.start();
    }

    public void shutDown() {
        this.shutDown = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line = this.reader.readLine();
            if (line != null) {
                if ((line = line.trim()).toLowerCase().equals("end")) {
                    return;
                }
                DelayedActivity delayedActivity = this.waiter;
                synchronized (delayedActivity) {
                    this.appendBuffer.append(line + "\n");
                }
                this.waiter.indicateChange();
            }
        }
        catch (Exception e) {
            if (!this.shutDown) {
                e.printStackTrace();
            }
        }
        finally {
            if (!this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

