#ifndef _EFL_UI_DND_CONTAINER_EO_H_
#define _EFL_UI_DND_CONTAINER_EO_H_

#ifndef _EFL_UI_DND_CONTAINER_EO_CLASS_TYPE
#define _EFL_UI_DND_CONTAINER_EO_CLASS_TYPE

typedef Eo Efl_Ui_Dnd_Container;

#endif

#ifndef _EFL_UI_DND_CONTAINER_EO_TYPES
#define _EFL_UI_DND_CONTAINER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
#define EFL_UI_DND_CONTAINER_MIXIN efl_ui_dnd_container_mixin_get()

EWAPI const Efl_Class *efl_ui_dnd_container_mixin_get(void);

/**
 * @brief The time since mouse down happens to drag starts.
 *
 * @param[in] obj The object.
 * @param[in] time The drag delay time
 *
 * @ingroup Efl_Ui_Dnd_Container
 */
EOAPI void efl_ui_dnd_container_drag_delay_time_set(Eo *obj, double time);

/**
 * @brief The time since mouse down happens to drag starts.
 *
 * @param[in] obj The object.
 *
 * @return The drag delay time
 *
 * @ingroup Efl_Ui_Dnd_Container
 */
EOAPI double efl_ui_dnd_container_drag_delay_time_get(const Eo *obj);

/**
 * @brief This registers a drag for items in a container. Many items can be
 * dragged at a time. During dragging, there are three events emitted:
 * EFL_DND_EVENT_DRAG_POS, EFL_DND_EVENT_DRAG_ACCEPT, EFL_DND_EVENT_DRAG_DONE.
 *
 * @param[in] obj The object.
 * @param[in] data_func Data and its format
 * @param[in] item_func Item to determine drag start
 * @param[in] icon_func Icon used during drag
 * @param[in] icon_list_func Icons used for animations CHECKING
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Dnd_Container
 */
EOAPI void efl_ui_dnd_container_drag_item_add(Eo *obj, void *data_func_data, Efl_Dnd_Drag_Data_Get data_func, Eina_Free_Cb data_func_free_cb, void *item_func_data, Efl_Dnd_Item_Get item_func, Eina_Free_Cb item_func_free_cb, void *icon_func_data, Efl_Dnd_Drag_Icon_Create icon_func, Eina_Free_Cb icon_func_free_cb, void *icon_list_func_data, Efl_Dnd_Drag_Icon_List_Create icon_list_func, Eina_Free_Cb icon_list_func_free_cb, unsigned int seat);

/**
 * @brief Remove drag function of items in the container object.
 *
 * @param[in] obj The object.
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Dnd_Container
 */
EOAPI void efl_ui_dnd_container_drag_item_del(Eo *obj, unsigned int seat);

EOAPI void efl_ui_dnd_container_drop_item_add(Eo *obj, Efl_Ui_Selection_Format format, void *item_func_data, Efl_Dnd_Item_Get item_func, Eina_Free_Cb item_func_free_cb, unsigned int seat);

EOAPI void efl_ui_dnd_container_drop_item_del(Eo *obj, unsigned int seat);
#endif /* EFL_BETA_API_SUPPORT */

#endif
