/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AStoreable;

final class PSubShortcut
extends AStoreable {
    private final String value;
    private final String type;
    private final PainlessMethod getter;
    private final PainlessMethod setter;

    PSubShortcut(Location location, String value, String type, PainlessMethod getter, PainlessMethod setter) {
        super(location);
        this.value = value;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (!(this.getter == null || this.getter.returnType != Void.TYPE && this.getter.typeParameters.isEmpty())) {
            throw this.createError(new IllegalArgumentException("Illegal get shortcut on field [" + this.value + "] for type [" + this.type + "]."));
        }
        if (this.setter != null && (this.setter.returnType != Void.TYPE || this.setter.typeParameters.size() != 1)) {
            throw this.createError(new IllegalArgumentException("Illegal set shortcut on field [" + this.value + "] for type [" + this.type + "]."));
        }
        if (this.getter != null && this.setter != null && this.setter.typeParameters.get(0) != this.getter.returnType) {
            throw this.createError(new IllegalArgumentException("Shortcut argument types must match."));
        }
        if (this.getter == null && this.setter == null || this.read && this.getter == null || this.write && this.setter == null) {
            throw this.createError(new IllegalArgumentException("Illegal shortcut on field [" + this.value + "] for type [" + this.type + "]."));
        }
        this.actual = this.setter != null ? this.setter.typeParameters.get(0) : this.getter.returnType;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        methodWriter.invokeMethodCall(this.getter);
        if (!this.getter.returnType.equals(this.getter.javaMethod.getReturnType())) {
            methodWriter.checkCast(MethodWriter.getType(this.getter.returnType));
        }
    }

    @Override
    int accessElementCount() {
        return 1;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Class<?> actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
    }

    @Override
    void load(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        methodWriter.invokeMethodCall(this.getter);
        if (this.getter.returnType != this.getter.javaMethod.getReturnType()) {
            methodWriter.checkCast(MethodWriter.getType(this.getter.returnType));
        }
    }

    @Override
    void store(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        methodWriter.invokeMethodCall(this.setter);
        methodWriter.writePop(MethodWriter.getType(this.setter.returnType).getSize());
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.value);
    }
}

