/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.Label;

public final class SIf
extends AStatement {
    AExpression condition;
    final SBlock ifblock;

    public SIf(Location location, AExpression condition, SBlock ifblock) {
        super(location);
        this.condition = Objects.requireNonNull(condition);
        this.ifblock = ifblock;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.condition.storeSettings(settings);
        if (this.ifblock != null) {
            this.ifblock.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.condition.extractVariables(variables);
        if (this.ifblock != null) {
            this.ifblock.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.condition.expected = Boolean.TYPE;
        this.condition.analyze(scriptRoot, locals);
        this.condition = this.condition.cast(scriptRoot, locals);
        if (this.condition.constant != null) {
            throw this.createError(new IllegalArgumentException("Extraneous if statement."));
        }
        if (this.ifblock == null) {
            throw this.createError(new IllegalArgumentException("Extraneous if statement."));
        }
        this.ifblock.lastSource = this.lastSource;
        this.ifblock.inLoop = this.inLoop;
        this.ifblock.lastLoop = this.lastLoop;
        this.ifblock.analyze(scriptRoot, Locals.newLocalScope(locals));
        this.anyContinue = this.ifblock.anyContinue;
        this.anyBreak = this.ifblock.anyBreak;
        this.statementCount = this.ifblock.statementCount;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeStatementOffset(this.location);
        Label fals = new Label();
        this.condition.write(classWriter, methodWriter, globals);
        methodWriter.ifZCmp(153, fals);
        this.ifblock.continu = this.continu;
        this.ifblock.brake = this.brake;
        this.ifblock.write(classWriter, methodWriter, globals);
        methodWriter.mark(fals);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.condition, this.ifblock);
    }
}

