/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;

public final class SReturn
extends AStatement {
    private AExpression expression;

    public SReturn(Location location, AExpression expression) {
        super(location);
        this.expression = expression;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        if (this.expression != null) {
            this.expression.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        if (this.expression != null) {
            this.expression.extractVariables(variables);
        }
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (this.expression == null) {
            if (locals.getReturnType() != Void.TYPE) {
                throw this.location.createError(new ClassCastException("Cannot cast from [" + PainlessLookupUtility.typeToCanonicalTypeName(locals.getReturnType()) + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(Void.TYPE) + "]."));
            }
        } else {
            this.expression.expected = locals.getReturnType();
            this.expression.internal = true;
            this.expression.analyze(scriptRoot, locals);
            this.expression = this.expression.cast(scriptRoot, locals);
        }
        this.methodEscape = true;
        this.loopEscape = true;
        this.allEscape = true;
        this.statementCount = 1;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeStatementOffset(this.location);
        if (this.expression != null) {
            this.expression.write(classWriter, methodWriter, globals);
        }
        methodWriter.returnValue();
    }

    @Override
    public String toString() {
        return this.expression == null ? this.singleLineToString(new Object[0]) : this.singleLineToString(this.expression);
    }
}

