/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class TermsAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource> {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(TermsAggregatorFactory.class));
    static Boolean REMAP_GLOBAL_ORDS;
    static Boolean COLLECT_SEGMENT_ORDS;
    private final BucketOrder order;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;

    TermsAggregatorFactory(String name, ValuesSourceConfig<ValuesSource> config, BucketOrder order, IncludeExclude includeExclude, String executionHint, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, boolean showTermDocCountError, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metaData);
        this.order = order;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
        this.showTermDocCountError = showTermDocCountError;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, pipelineAggregators, metaData){
            {
                super(name, context, parent, subFactories, (List<PipelineAggregator>)pipelineAggregators, (Map<String, Object>)metaData);
                InternalOrder.validate(TermsAggregatorFactory.this.order, this);
            }

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    private static boolean isAggregationSort(BucketOrder order) {
        if (order instanceof InternalOrder.Aggregation) {
            return true;
        }
        if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            return compoundOrder.orderElements().stream().anyMatch(TermsAggregatorFactory::isAggregationSort);
        }
        return false;
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return TermsAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (!InternalOrder.isKeyOrder(this.order) && bucketCountThresholds.getShardSize() == TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        bucketCountThresholds.ensureValidity();
        if (valuesSource instanceof ValuesSource.Bytes) {
            Aggregator.SubAggCollectionMode cm;
            long maxOrd;
            ExecutionMode execution = null;
            if (this.executionHint != null) {
                execution = ExecutionMode.fromString(this.executionHint, deprecationLogger);
            }
            if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                execution = ExecutionMode.MAP;
            }
            long l = maxOrd = execution == ExecutionMode.GLOBAL_ORDINALS ? TermsAggregatorFactory.getMaxOrd(valuesSource, searchContext.searcher()) : -1L;
            if (execution == null) {
                execution = ExecutionMode.GLOBAL_ORDINALS;
            }
            if ((cm = this.collectMode) == null) {
                cm = Aggregator.SubAggCollectionMode.DEPTH_FIRST;
                if (this.factories != AggregatorFactories.EMPTY) {
                    cm = TermsAggregatorFactory.subAggCollectionMode(bucketCountThresholds.getShardSize(), maxOrd);
                }
            }
            DocValueFormat format = this.config.format();
            if (this.includeExclude != null && this.includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
            }
            return execution.create(this.name, this.factories, valuesSource, this.order, format, bucketCountThresholds, this.includeExclude, searchContext, parent, cm, this.showTermDocCountError, pipelineAggregators, metaData);
        }
        if (this.includeExclude != null && this.includeExclude.isRegexBased()) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            IncludeExclude.LongFilter longFilter = null;
            Aggregator.SubAggCollectionMode cm = this.collectMode;
            if (cm == null) {
                cm = this.factories != AggregatorFactories.EMPTY ? TermsAggregatorFactory.subAggCollectionMode(bucketCountThresholds.getShardSize(), -1L) : Aggregator.SubAggCollectionMode.DEPTH_FIRST;
            }
            if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                if (this.includeExclude != null) {
                    longFilter = this.includeExclude.convertToDoubleFilter();
                }
                return new DoubleTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), this.order, bucketCountThresholds, searchContext, parent, cm, this.showTermDocCountError, longFilter, pipelineAggregators, metaData);
            }
            if (this.includeExclude != null) {
                longFilter = this.includeExclude.convertToLongFilter(this.config.format());
            }
            return new LongTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), this.order, bucketCountThresholds, searchContext, parent, cm, this.showTermDocCountError, longFilter, pipelineAggregators, metaData);
        }
        throw new AggregationExecutionException("terms aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    static Aggregator.SubAggCollectionMode subAggCollectionMode(int expectedSize, long maxOrd) {
        if (expectedSize == Integer.MAX_VALUE) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (maxOrd == -1L || maxOrd > (long)expectedSize) {
            return Aggregator.SubAggCollectionMode.BREADTH_FIRST;
        }
        return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
    }

    static long getMaxOrd(ValuesSource source, IndexSearcher searcher) throws IOException {
        if (source instanceof ValuesSource.Bytes.WithOrdinals) {
            ValuesSource.Bytes.WithOrdinals valueSourceWithOrdinals = (ValuesSource.Bytes.WithOrdinals)source;
            return valueSourceWithOrdinals.globalMaxOrd(searcher);
        }
        return -1L;
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new StringTermsAggregator(name, factories, valuesSource, order, format, bucketCountThresholds, filter, context, parent, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                boolean remapGlobalOrds;
                IncludeExclude.OrdinalsFilter filter;
                long maxOrd = TermsAggregatorFactory.getMaxOrd(valuesSource, context.searcher());
                assert (maxOrd != -1L);
                double ratio = (double)maxOrd / (double)context.searcher().getIndexReader().numDocs();
                assert (valuesSource instanceof ValuesSource.Bytes.WithOrdinals);
                ValuesSource.Bytes.WithOrdinals ordinalsValuesSource = (ValuesSource.Bytes.WithOrdinals)valuesSource;
                if (factories == AggregatorFactories.EMPTY && includeExclude == null && !Aggregator.descendsFromBucketAggregator(parent) && ordinalsValuesSource.supportsGlobalOrdinalsMapping() && (COLLECT_SEGMENT_ORDS != null ? COLLECT_SEGMENT_ORDS != false : ratio <= 0.5 && maxOrd <= 2048L)) {
                    return new GlobalOrdinalsStringTermsAggregator.LowCardinality(name, factories, ordinalsValuesSource, order, format, bucketCountThresholds, context, parent, false, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
                }
                IncludeExclude.OrdinalsFilter ordinalsFilter = filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                if (REMAP_GLOBAL_ORDS != null) {
                    remapGlobalOrds = REMAP_GLOBAL_ORDS;
                } else {
                    remapGlobalOrds = true;
                    if (includeExclude == null && !Aggregator.descendsFromBucketAggregator(parent) && (factories == AggregatorFactories.EMPTY || !TermsAggregatorFactory.isAggregationSort(order) && subAggCollectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST)) {
                        remapGlobalOrds = false;
                    }
                }
                return new GlobalOrdinalsStringTermsAggregator(name, factories, ordinalsValuesSource, order, format, bucketCountThresholds, filter, context, parent, remapGlobalOrds, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            switch (value) {
                case "global_ordinals": {
                    return GLOBAL_ORDINALS;
                }
                case "map": {
                    return MAP;
                }
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, BucketOrder var4, DocValueFormat var5, TermsAggregator.BucketCountThresholds var6, IncludeExclude var7, SearchContext var8, Aggregator var9, Aggregator.SubAggCollectionMode var10, boolean var11, List<PipelineAggregator> var12, Map<String, Object> var13) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

