/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.MinDocQuery;
import org.apache.lucene.queries.SearchAfterSortedDocQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.concurrent.QueueResizingEsThreadPoolExecutor;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.profile.SearchProfileShardResults;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.query.EarlyTerminatingCollector;
import org.elasticsearch.search.query.QueryCollectorContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.TopDocsCollectorContext;
import org.elasticsearch.search.rescore.RescorePhase;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestPhase;
import org.elasticsearch.tasks.TaskCancelledException;

public class QueryPhase
implements SearchPhase {
    private static final Logger LOGGER = LogManager.getLogger(QueryPhase.class);
    private final AggregationPhase aggregationPhase = new AggregationPhase();
    private final SuggestPhase suggestPhase = new SuggestPhase();
    private final RescorePhase rescorePhase = new RescorePhase();

    @Override
    public void preProcess(SearchContext context) {
        context.preProcess(true);
    }

    @Override
    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.hasOnlySuggest()) {
            this.suggestPhase.execute(searchContext);
            searchContext.queryResult().topDocs(new TopDocsAndMaxScore(new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN), new DocValueFormat[0]);
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchPhase.SearchContextSourcePrinter(searchContext));
        }
        this.aggregationPhase.preProcess(searchContext);
        ContextIndexSearcher searcher = searchContext.searcher();
        boolean rescore = QueryPhase.execute(searchContext, searchContext.searcher(), searcher::setCheckCancelled);
        if (rescore) {
            this.rescorePhase.execute(searchContext);
        }
        this.suggestPhase.execute(searchContext);
        this.aggregationPhase.execute(searchContext);
        if (searchContext.getProfilers() != null) {
            ProfileShardResult shardResults = SearchProfileShardResults.buildShardResults(searchContext.getProfilers());
            searchContext.queryResult().profileResults(shardResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean execute(SearchContext searchContext, IndexSearcher searcher, Consumer<Runnable> checkCancellationSetter) throws QueryPhaseExecutionException {
        IndexReader reader = searcher.getIndexReader();
        QuerySearchResult queryResult = searchContext.queryResult();
        queryResult.searchTimedOut(false);
        try {
            Collector queryCollector;
            Runnable cancellationRunnable;
            Runnable timeoutRunnable;
            boolean timeoutSet;
            queryResult.from(searchContext.from());
            queryResult.size(searchContext.size());
            Query query = searchContext.query();
            assert (query == searcher.rewrite(query));
            ScrollContext scrollContext = searchContext.scrollContext();
            if (scrollContext != null) {
                if (scrollContext.totalHits == null) {
                    assert (scrollContext.lastEmittedDoc == null);
                } else {
                    ScoreDoc after = scrollContext.lastEmittedDoc;
                    if (QueryPhase.returnsDocsInOrder(query, searchContext.sort())) {
                        if (after != null) {
                            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new MinDocQuery(after.doc + 1), BooleanClause.Occur.FILTER).build();
                        }
                        searchContext.terminateAfter(searchContext.size());
                    } else if (QueryPhase.canEarlyTerminate(reader, searchContext.sort()) && after != null) {
                        query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new SearchAfterSortedDocQuery(searchContext.sort().sort, (FieldDoc)after), BooleanClause.Occur.FILTER).build();
                    }
                }
            }
            LinkedList<QueryCollectorContext> collectors = new LinkedList<QueryCollectorContext>();
            boolean hasFilterCollector = false;
            if (searchContext.terminateAfter() != 0) {
                collectors.add(QueryCollectorContext.createEarlyTerminationCollectorContext(searchContext.terminateAfter()));
                hasFilterCollector = true;
            }
            if (searchContext.parsedPostFilter() != null) {
                collectors.add(QueryCollectorContext.createFilteredCollectorContext(searcher, searchContext.parsedPostFilter().query()));
                hasFilterCollector = true;
            }
            if (!searchContext.queryCollectors().isEmpty()) {
                collectors.add(QueryCollectorContext.createMultiCollectorContext(searchContext.queryCollectors().values()));
            }
            if (searchContext.minimumScore() != null) {
                collectors.add(QueryCollectorContext.createMinScoreCollectorContext(searchContext.minimumScore().floatValue()));
                hasFilterCollector = true;
            }
            boolean bl = timeoutSet = scrollContext == null && searchContext.timeout() != null && !searchContext.timeout().equals((Object)SearchService.NO_TIMEOUT);
            if (timeoutSet) {
                long startTime = searchContext.getRelativeTimeInMillis();
                long timeout = searchContext.timeout().millis();
                long maxTime = startTime + timeout;
                timeoutRunnable = () -> {
                    long time = searchContext.getRelativeTimeInMillis();
                    if (time > maxTime) {
                        throw new TimeExceededException();
                    }
                };
            } else {
                timeoutRunnable = null;
            }
            if (searchContext.lowLevelCancellation()) {
                SearchTask task = searchContext.getTask();
                cancellationRunnable = () -> {
                    if (task.isCancelled()) {
                        throw new TaskCancelledException("cancelled");
                    }
                };
            } else {
                cancellationRunnable = null;
            }
            Runnable checkCancelled = timeoutRunnable != null && cancellationRunnable != null ? () -> {
                timeoutRunnable.run();
                cancellationRunnable.run();
            } : (timeoutRunnable != null ? timeoutRunnable : (cancellationRunnable != null ? cancellationRunnable : null));
            checkCancellationSetter.accept(checkCancelled);
            collectors.add(QueryCollectorContext.createCancellableCollectorContext(searchContext.getTask()::isCancelled));
            boolean doProfile = searchContext.getProfilers() != null;
            TopDocsCollectorContext topDocsFactory = TopDocsCollectorContext.createTopDocsCollectorContext(searchContext, reader, hasFilterCollector);
            collectors.addFirst(topDocsFactory);
            if (doProfile) {
                InternalProfileCollector profileCollector = QueryCollectorContext.createQueryCollectorWithProfiler(collectors);
                searchContext.getProfilers().getCurrentQueryProfiler().setCollector(profileCollector);
                queryCollector = profileCollector;
            } else {
                queryCollector = QueryCollectorContext.createQueryCollector(collectors);
            }
            try {
                searcher.search(query, queryCollector);
            }
            catch (EarlyTerminatingCollector.EarlyTerminationException e) {
                queryResult.terminatedEarly(true);
            }
            catch (TimeExceededException e) {
                assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
                if (!searchContext.request().allowPartialSearchResults()) {
                    throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
                }
                queryResult.searchTimedOut(true);
            }
            finally {
                searchContext.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
            if (searchContext.terminateAfter() != 0 && queryResult.terminatedEarly() == null) {
                queryResult.terminatedEarly(false);
            }
            QuerySearchResult result = searchContext.queryResult();
            for (QueryCollectorContext ctx : collectors) {
                ctx.postProcess(result);
            }
            ExecutorService executor = searchContext.indexShard().getThreadPool().executor("search");
            if (executor instanceof QueueResizingEsThreadPoolExecutor) {
                QueueResizingEsThreadPoolExecutor rExecutor = (QueueResizingEsThreadPoolExecutor)executor;
                queryResult.nodeQueueSize(rExecutor.getCurrentQueueSize());
                queryResult.serviceTimeEWMA((long)rExecutor.getTaskExecutionEWMA());
            }
            if (searchContext.getProfilers() != null) {
                ProfileShardResult shardResults = SearchProfileShardResults.buildShardResults(searchContext.getProfilers());
                result.profileResults(shardResults);
            }
            return topDocsFactory.shouldRescore();
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Failed to execute main query", e);
        }
    }

    private static boolean returnsDocsInOrder(Query query, SortAndFormats sf) {
        if (sf == null || Sort.RELEVANCE.equals((Object)sf.sort)) {
            return query.getClass() == ConstantScoreQuery.class || query.getClass() == MatchAllDocsQuery.class;
        }
        return Sort.INDEXORDER.equals((Object)sf.sort);
    }

    private static boolean canEarlyTerminate(IndexReader reader, SortAndFormats sortAndFormats) {
        if (sortAndFormats == null || sortAndFormats.sort == null) {
            return false;
        }
        Sort sort = sortAndFormats.sort;
        for (LeafReaderContext ctx : reader.leaves()) {
            Sort indexSort = ctx.reader().getMetaData().getSort();
            if (indexSort != null && Lucene.canEarlyTerminate(sort, indexSort)) continue;
            return false;
        }
        return true;
    }

    private static class TimeExceededException
    extends RuntimeException {
        private TimeExceededException() {
        }
    }
}

