/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public abstract class ObjectCountMetric<E>
extends IntegerValuedMetric {
    public ObjectCountMetric(@Nonnull OWLOntology o) {
        super(o);
    }

    @Nonnull
    protected abstract String getObjectTypeName();

    @Override
    @Nonnull
    public String getName() {
        return this.getObjectTypeName() + " count";
    }

    @Nonnull
    protected abstract Set<? extends E> getObjects(@Nonnull OWLOntology var1);

    @Override
    public Integer recomputeMetric() {
        return this.getObjects().size();
    }

    @Nonnull
    protected Set<? extends E> getObjects() {
        HashSet<E> objects = new HashSet<E>();
        for (OWLOntology ont : this.getOntologies()) {
            assert (ont != null);
            objects.addAll(this.getObjects(ont));
        }
        return objects;
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        return true;
    }

    @Override
    protected void disposeMetric() {
    }
}

