/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_so extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Waqtiga Caadiga Ah ee Moskow",
               "",
               "Waqtiga Xagaaga ee Moskow",
               "",
               "Waqtiga Moskow",
               "",
            };
        final String[] Pakistan = new String[] {
               "Waqtiga Caadiga Ah ee Bakistaan",
               "",
               "Waqtiga Xagaaga ee Bakistaan",
               "",
               "Waqtiga Bakistaan",
               "",
            };
        final String[] Magadan = new String[] {
               "Waqtiga Caadiga Ah ee Magedan",
               "",
               "Waqtiga Xagaaga ee Magedan",
               "",
               "Watiga Magedan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Yurub",
               "",
               "Waqtiga Xagaaga ee Bartamaha Yurub",
               "",
               "Waqtiga Bartamaha Yurub",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Waqtiga Caadiga Ah ee Bariga Waqooyiga Ameerika",
               "",
               "Waqtiga Dharaarta ee Bariga Waqooyiga Ameerika",
               "",
               "Waqtiga Bariga ee Waqooyiga Ameerika",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Waqtiga Caadiga Ah ee Lod How",
               "",
               "Waqtiga Dharaarta ee Lod How",
               "",
               "Waqtiga Lod How",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Waqtiga Caadiga Ah ee Niyuu Si\u2019laan",
               "",
               "Waqtiga Dharaarta ee Niyuu Si\u2019laan",
               "",
               "Waqtiga Niyuu Si\u2019laan",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Waqtiga Badweynta Hindiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Waqtiga Caadiga Ah ee Yakut",
               "",
               "Waqtiga Xagaaga ee Yakut",
               "",
               "Waqtiyada Yakut",
               "",
            };
        final String[] East_Timor = new String[] {
               "Waqtiga Iist Timoor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Waqtiga Kosriy",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Waqtiga Caadiga Ah ee Bariga Yurub",
               "",
               "Waqtiga Xagaaga ee Bariga Yurub",
               "",
               "Waqtiga Bariga Yurub",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Arjentiina",
               "",
               "Waqtiga Xagaaga ee Galbeedka Arjentiina",
               "",
               "Waqtiga Galbeedka Arjentiina",
               "",
            };
        final String[] Ponape = new String[] {
               "Waqtiga Bonabe",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Waqtiga Boliifiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Waqtiga Caadiga Ah St. Beere & Mikiwelon",
               "",
               "Waqtiga Dharaarta ee St. Beere & Mikiwelon",
               "",
               "Waqtiga St. Beere & Mikiwelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Waqtiga Indoshiina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Waqtiga Caadiga Ah ee Yekaterinbaag",
               "",
               "Waqtiga Xagaaga ee Yekaterinbaag",
               "",
               "Waqtiga Yekaterinbaag",
               "",
            };
        final String[] Maldives = new String[] {
               "Waqtiga Maldifis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Waqtiga Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Waqtiga Walis & Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Waqtiyada Caadiga Ah ee Koonfur Afrika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Waqtiga Siyowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Waqtiga Leyn Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Waqtiga Caadiga Ah ee Usbekistan",
               "",
               "Waqtiga Xagaaga ee Usbekistan",
               "",
               "Waqtiga Usbekistan",
               "",
            };
        final String[] Mongolia = new String[] {
               "Waqtiga Caadiga Ah ee Ulaanbaataar",
               "",
               "Waqtiga Xagaaga ee Ulaanbaataar",
               "",
               "Waqtiga Ulaanbaataar",
               "",
            };
        final String[] America_Central = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Waqooyiga Ameerika",
               "",
               "Waqtiga Dharaarta ee Bartamaha Waqooyiga Ameerika",
               "",
               "Waqtiga Bartamaha Waqooyiga Ameerika",
               "",
            };
        final String[] Niue = new String[] {
               "Waqtiga Niyuu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Waqtiga Wayk Iylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Waqtiga Caadiga Ah ee Faalklaan Aylaanis",
               "",
               "Waqtiga Xagaaga ee Faalklaan Aylaanis",
               "",
               "Waqtiga Faalklaan Aylaanis",
               "",
            };
        final String[] Apia = new String[] {
               "Waqtiga Caadiga Ah ee Abiya",
               "",
               "Waqtiga Dharaarta ee Abiya",
               "",
               "Waqtiga Abiya",
               "",
            };
        final String[] Bhutan = new String[] {
               "Waqtiga Butaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Waqtiga Nawroo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Waqtiga Koonfurta Kasakhistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Waqtiga Kirismas Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Waqtiga Riyuuniyon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Waqtiga Kokos Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Waqtiga Caadiga Ah ee Jaatam",
               "",
               "Waqtiga Dharaarta ee Jaatam",
               "",
               "Waqtiga Jaatam",
               "",
            };
        final String[] Vostok = new String[] {
               "Waqtiga Fostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Waqtiga Caadiga Ah ee Arjentiina",
               "",
               "Waqtiga Xagaaga ee Arjentiina",
               "",
               "Waqtia Arjentiina",
               "",
            };
        final String[] Gambier = new String[] {
               "Waqtiga Gambiyar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Waqtiga Galabagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Waqtiga Fenezuweela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Waqtiga Foonikis Aylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Waqtiga Caadiga Ah ee Keyb Faarde",
               "",
               "Waqtiga Xagaaga ee Keyb Faarde",
               "",
               "Waqtiga Keyb Faarde",
               "",
            };
        final String[] Norfolk = new String[] {
               "Waqtiga Noorfek Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Waqtiga Caadiga Ah ee Samoa",
               "",
               "Waqtiga Dharaarta ee Samoa",
               "",
               "Waqtiga Samoa",
               "",
            };
        final String[] Davis = new String[] {
               "Waqtiga Dafis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Waqtiga Caadiga Ah ee Kuuba",
               "",
               "Waqtiga Dharaarta ee Kuuba",
               "",
               "Waqtiga Kuuba",
               "",
            };
        final String[] GMT = new String[] {
               "Waqtiga Celceliska Giriinwij",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Waqtiga Caadiga Ah ee Filibiin",
               "",
               "Waqtiga Xagaaga ee Filibiin",
               "",
               "Waqtiga Filibiin",
               "",
            };
        final String[] French_Southern = new String[] {
               "Waqtiga Koonfurta Faransiiska & Antaarktik",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Waqtiga Caadiga Ah ee Niyuu Kaledoniya",
               "",
               "Waqtiga Xagaaga ee Niyuu Kaledoniya",
               "",
               "Waqtiga Niyuu Kaledonya",
               "",
            };
        final String[] Brunei = new String[] {
               "Waqtiga Buruney Daarusalaam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Waqtiga Caadiga Ah ee Iiraan",
               "",
               "Waqtiga Dharaarta ee Iiraan",
               "",
               "Waqtiga Iiraan",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Waqtiga Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Waqtiga Caadiga Ah ee Tonga",
               "",
               "Waqtiga Xagaaga ee Tonga",
               "",
               "Waqtiga Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Waqtiga Caadiga Ah ee Bangledeesh",
               "",
               "Waqtiga Xagaaga ee Bangledeesh",
               "",
               "Waqtiga Bangledeesh",
               "",
            };
        final String[] Peru = new String[] {
               "Waqtiga Caadiga Ah ee Beeru",
               "",
               "Waqtiga Xagaaga ee Beeru",
               "",
               "Waqtiga Beeru",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Waqtiga Caadiga ah ee Bariga Giriinlaan",
               "",
               "Waqtiga Xagaaga ee Bariga Giriinlaan",
               "",
               "Waqtiga Bariga ee Giriinlaan",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Waqtiga Indoneeysiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Waqtiga Kiyrigistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Waqtiyada Caadiga ah ee Bariga Astaraaliya",
               "",
               "Waqtiga Dharaarta ee Bariga Astaraaliya",
               "",
               "Waqtiga Bariga Astaraaliya",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Waqtiga Ferenj Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Waqtiga Caadiga Ah ee Kolambiya",
               "",
               "Waqtiga Xagaaga ee Kolambiya",
               "",
               "Waqtiga Kolambiya",
               "",
            };
        final String[] Chile = new String[] {
               "Waqtiga Caadiga Ah ee Jili",
               "",
               "Waqtiga Xagaaga ee Jili",
               "",
               "Waqtiga Jili",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Waqtiga Jilbeert Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Waqtiga Caadiga Ah ee Irkutsik",
               "",
               "Waqtiga Xagaaga ee Irkutsik",
               "",
               "Waqtiga Irkutsik",
               "",
            };
        final String[] Georgia = new String[] {
               "Waqtiga Caadiga Ah ee Joorjiya",
               "",
               "Waqtiga Xagaaga ee Joorjiya",
               "",
               "Waqtiga Joorjiya",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Waqtiga Caadiga Ah ee Joybalsan",
               "",
               "Waqtiga Xagaaga ee Joybalsan",
               "",
               "Waqtiga Joybalsan",
               "",
            };
        final String[] China = new String[] {
               "Waqtiga Caadiga Ah ee Shiinaha",
               "",
               "Waqtiga Dharaarta ee Shiinaha",
               "",
               "Waqtiga Shiinaha",
               "",
            };
        final String[] Armenia = new String[] {
               "Waqtiga Caadiga Ah ee Armeeniya",
               "",
               "Waqtiga Xagaaga ee Armeeniya",
               "",
               "Waqtiga Armeeniya",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Waqtiga Bartamaha Afrika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Waqtiga Caadiga Ah ee Jabaan",
               "",
               "Waqtiga Dharaarta ee Jabaan",
               "",
               "Waqtiga Jabaan",
               "",
            };
        final String[] Taipei = new String[] {
               "Waqtiga Caadiga Ah ee Teybey",
               "",
               "Waqtiga Dharaarta ee Teybey",
               "",
               "Waqtiga Teybey",
               "",
            };
        final String[] Hovd = new String[] {
               "Waqtiga Caadiga Ah ee Hofud",
               "",
               "Waqtiga Xagaaga ee Hofud",
               "",
               "Waqtiga Hofud",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Galbeedka Astaraaliya",
               "",
               "Waqtiga Dharaarta Bartamaha Galbeedka Australiya",
               "",
               "Waqtiga Bartamaha Galbeedka Astaraaliya",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Waqtiga Caadiga Ah ee Sakhalin",
               "",
               "Waqtiga Xagaaga ee Sakhalin",
               "",
               "Waqtiga Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Waqtiga Caadiga Ah ee Baragwaay",
               "",
               "Waqtiga Xagaaga ee Baragwaay",
               "",
               "Waqtiga Baragwaay",
               "",
            };
        final String[] Malaysia = new String[] {
               "Waqtiga Maleyshiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Waqtiga Caadiga Ah ee Morishiyaas",
               "",
               "Waqtiga Xagaaga ee Morishiyaas",
               "",
               "Waqtiga Morishiyaas",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Waqtiga Bariga Afrika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Waqtiga Solomon Aylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Waqtiga Maarshaal Aylaanis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Waqtiga Caadiga Ah ee Niyuufoonlaan",
               "",
               "Waqtiga Dharaarta ee Niyuufoonlaan",
               "",
               "Waqtiga Niyuufoonlaan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Waqtiga Afggaanistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Waqtiga Caadiga Ah ee Hoong Koong",
               "",
               "Waqtiga Xagaaga ee Hoong Koong",
               "",
               "Waqtiga Hoong Koong",
               "",
            };
        final String[] Atlantic = new String[] {
               "Waqtiga Caadiga Ah ee Atlantika Waqooyiga Ameerika",
               "",
               "Waqtiga Dharaarta ee Atlantika Waqooyiga Ameerika",
               "",
               "Waqtiga Atlantika ee Waqooyiga Ameerika",
               "",
            };
        final String[] Israel = new String[] {
               "Waqtiga Caadiga Ah ee Israaiil",
               "",
               "Waqtiga Dharaarta ee Israaiil",
               "",
               "Waqtiga Israaiil",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Waqtiga Bartamaha Indoneeysiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Waqtiga Caadiga Ah ee Omsk",
               "",
               "Waqtiga Xagaaga ee Omsk",
               "",
               "Waqtiga Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Waqtiga Siishalis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Waqtiga Caadiga Ah ee Urugwaay",
               "",
               "Waqtiga Xagaaga ee Urugwaay",
               "",
               "Waqtiga Urugwaay",
               "",
            };
        final String[] Nepal = new String[] {
               "Waqtiga Neebaal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Waqtiga Juuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Waqtiga Caadiga Ah ee Fanuutu",
               "",
               "Waqtiga Xagaaga ee Fanuutu",
               "",
               "Waqtiga Fanuutu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Waqtiga Caadiga Ah ee Nofosibirsik",
               "",
               "Waqtiga Xagaaga ee Nofosibirsik",
               "",
               "Waqtiga Nofosibirsik",
               "",
            };
        final String[] Singapore = new String[] {
               "Waqtiga Singabuur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Waqtiga Caadiga Ah ee Asores",
               "",
               "Waqtiga Xagaaga ee Asores",
               "",
               "Waqtiga Asores",
               "",
            };
        final String[] Suriname = new String[] {
               "Waqtiga Surineym",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Waqtiga Caadiga Ah ee Karasnoyarsik",
               "",
               "Waqtiga Xagaaga ee Karasnoyarsik",
               "",
               "Waqtiga Karasnoyarsik",
               "",
            };
        final String[] Myanmar = new String[] {
               "Waqtiga Mayanmaar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Waqtiga Caadiga Ah ee Amason",
               "",
               "Waqtiga Xagaaga ee Amason",
               "",
               "Waqtiga Amason",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Waqtiga Bariga Kasakhistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Waqtiga Caadiga Ah ee Fiji",
               "",
               "Waqtiga Xagaaga ee Fiji",
               "",
               "Waqtiga Fiji",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Waqtiga Tufalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Waqtiga Makquwariy Aylaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Waqtiga Caadiga Ah ee Hawaay-Alutiyaan",
               "",
               "Waqtiga Dharaarta ee Hawaay-Alutiyaan",
               "",
               "Waqtiga Hawaay-Alutiyaan",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Waqtiga Caadiga Ah ee Bartamaha Astaraaliya",
               "",
               "Waqtiga Dharaarta ee Bartamaha Astaraaliya",
               "",
               "Waqtiga Bartamaha Astaraaliya",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Waqtiga Caadiga ah ee Basifika Waqooyiga Ameerika",
               "",
               "Waqtiga Dharaarta ee Basifika Waqooyiga Ameerika",
               "",
               "Waqtiga Basifika ee Waqooyiga Ameerika",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Waqtiga Caadiga Ah ee Turkmenistan",
               "",
               "Waqtiga Xagaaga ee Turkmenistan",
               "",
               "Waqtiga Turkmenistaan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Yurub",
               "",
               "Waqtiga Xagaaga ee Galbeedka Yurub",
               "",
               "Waqtiga Galbeedka Yurub",
               "",
            };
        final String[] Guyana = new String[] {
               "Waqtiga Guyaana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Waqtiga Bitkeen",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Waqtiga Rotera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Waqtiga Balaw",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Waqtiga Caadiga Ah ee Asarbeyjan",
               "",
               "Waqtiga Xagaaga ee Asarbeyjan",
               "",
               "Waqtiga Asarbeyjan",
               "",
            };
        final String[] Mawson = new String[] {
               "Waqtiga Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Waqtiga Caadiga Ah ee Baasifikada Meksiko",
               "",
               "Waqtiga Dharaarta ee Baasifikada Meksiko",
               "",
               "Waqtiga Baasifikada Meksiko",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Afrika",
               "",
               "Waqtiga Xagaaga ee Galbeedka Afrika",
               "",
               "Waqtiga Galbeedka Afrika",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Waqtiga Sowt Joorjiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Waqtiga Caadiga Ah ee Folgograd",
               "",
               "Waqtiga Xagaaga ee Folgograd",
               "",
               "Waqtiga Folgograd",
               "",
            };
        final String[] Easter = new String[] {
               "Waqtiga Caadiga Ah ee Iistar Aylaan",
               "",
               "Waqtiga Xagaaga ee Iistar Aylaan",
               "",
               "Waqtiga Iistar Aylaan",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Waqtiga Caadiga Ah ee Waqooyi-Galbeed Meksiko",
               "",
               "Waqtiga Dharaarta ee Waqooyi-Galbeed Meksiko",
               "",
               "Waqtiga Waqooyi-Galbeed Meksiko",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Waqtiga Dumont - d\u2019urfille",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Giriinlaan",
               "",
               "Waqtiga Xagaaga ee Galbeedka Giriinlaan",
               "",
               "Waqtiga Galbeedka Giriinlaan",
               "",
            };
        final String[] Ecuador = new String[] {
               "Waqtiga Ekuwadoor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Waqtiga Gacanka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Waqtiga Caadiga Ah ee Kuuriya",
               "",
               "Waqtiga Dharaarta ee Kuuriya",
               "",
               "Waqtiga Kuuriya",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Waqtiga Caadiga Ah ee Galbeedka Astaraaliya",
               "",
               "Waqtiga Dharaarta ee Galbeedka Astaraaliya",
               "",
               "Waqtiga Galbeedka Astaraaliya",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Waqtiga Galbeedka Indoneeysiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Waqtiga Caadiga ah ee Buuraleyda Waqooyiga Ameerika",
               "",
               "Waqtiga Dharaarta ee Buurleyda Waqooyiga Ameerika",
               "",
               "Waqtiga Buuraleyda ee Waqooyiga Ameerika",
               "",
            };
        final String[] Marquesas = new String[] {
               "Waqtiga Marquwesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Waqtiga Caadiga Ah ee Carabta",
               "",
               "Waqtiga Dharaarta ee Carabta",
               "",
               "Waqtiga Carabta",
               "",
            };
        final String[] Alaska = new String[] {
               "Waqtiga Caadiga Ah ee Alaska",
               "",
               "Waqtiga Dharaarta ee Alaska",
               "",
               "Waqtiga Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Waqtiga Caadiga Ah ee Faladifostok",
               "",
               "Waqtiga Xagaaga ee Faladifostok",
               "",
               "Waqtiga Faladifostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Waqtiga Jamoro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Waqtiga Tokeluu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Waqtiga Babuw Niyuu Giniya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Waqtiga Caadiga Ah ee Farnaando de Nooronha",
               "",
               "Waqtiga Xagaaga ee Farnaando de Nooronha",
               "",
               "Waqtiga Farnaando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Waqtiga Caadiga ah ee Baraasiliya",
               "",
               "Waqtiga Xagaaga ee Baraasiliya",
               "",
               "Waqtiga Baraasiliya",
               "",
            };
        final String[] India = new String[] {
               "Waqtiga Caadiga Ah ee Hindiya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Waqtiga Caadiga Ah ee Kuuk Aylaanis",
               "",
               "Waqtiga Nus Xagaaga ah ee Kuuk Aylaanis",
               "",
               "Waqtiga Kuuk Aylaanis",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Foonikis" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.America/Antigua", "Antiguwa" },
            { "timezone.excity.Europe/Ljubljana", "Lubalaana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquwesas" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buwenos Ayris" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Daanmaakshaan" },
            { "timezone.excity.America/Anchorage", "Anjorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Waqtiga Celceliska Giriinwij",
                    "",
                    "Waqtiga Xagaaga ee Biritishka",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Fostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Biyuulah, Waqooyiga Dakoota" },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Librefil" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ababa" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Taalin" },
            { "timezone.excity.Pacific/Truk", "Juuk" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guwam" },
            { "timezone.excity.Europe/Vaduz", "Faduus" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.Asia/Barnaul", "Barnaauul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseero" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Landan" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Bitkayrn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Karasnoyarska" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Noom" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Fankuufar" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Joybalsan" },
            { "timezone.excity.America/Inuvik", "Inuufik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "St. Lusiya" },
            { "timezone.excity.Asia/Novokuznetsk", "Nofokusnetsik" },
            { "timezone.excity.Europe/Berlin", "Barliin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Maartiniikuyuu" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Bert" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Lonjirbyeen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalba" },
            { "timezone.excity.Africa/Windhoek", "Windhook" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majro" },
            { "timezone.excity.America/Lower_Princes", "Loowa Birinses Kuwaata" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miiquulon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaay" },
            { "timezone.excity.America/North_Dakota/Center", "Bartamaha, Waqooyiga Dakoota" },
            { "timezone.excity.America/Cayenne", "Kayeen" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Beliise" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkook" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Moontafiidiyo" },
            { "timezone.excity.Pacific/Johnston", "Joonston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jaarsey" },
            { "timezone.excity.America/Pangnirtung", "Bangnirtuung" },
            { "timezone.excity.Atlantic/South_Georgia", "Sowt Joorjiya" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Hafaana" },
            { "timezone.excity.Europe/Madrid", "Maadriid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detoroyt" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Garenaada" },
            { "timezone.excity.Asia/Phnom_Penh", "Benom Ben" },
            { "timezone.excity.Europe/Rome", "Rooma" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karaaji" },
            { "timezone.excity.America/Resolute", "Resoluut" },
            { "timezone.excity.Africa/Nouakchott", "Nookjot" },
            { "timezone.excity.Africa/Bamako", "Bamaako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Ceyuun" },
            { "timezone.excity.Australia/Hobart", "Hubaart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Liima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Niyuu Saalem, Waqooyiga Dakoota" },
            { "timezone.excity.Asia/Atyrau", "Atiyraw" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Baramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaaga" },
            { "timezone.excity.Europe/Zurich", "Surij" },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "Saaw Boolo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "timezone.excity.America/New_York", "Niyuu Yook" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Etc/Unknown", "Magaalo Aan La Garanayn" },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.America/Thule", "Tuul" },
            { "timezone.excity.America/Grand_Turk", "Garaan Turk" },
            { "America/Yakutat", Alaska },
            { "timezone.excity.America/Indiana/Petersburg", "Betesbaag, Indiyaana" },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winibeg" },
            { "timezone.excity.Antarctica/Macquarie", "Makquwariy" },
            { "timezone.excity.Europe/Uzhgorod", "Usgorod" },
            { "timezone.excity.America/Caracas", "Karakaas" },
            { "timezone.excity.America/Dawson_Creek", "Doosan Kireek" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hofud" },
            { "timezone.excity.Africa/Harare", "Haraare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Balank-Sablon" },
            { "timezone.excity.Africa/Algiers", "Aljeeris" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartuum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandiyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galabagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuumaan" },
            { "timezone.excity.America/Rio_Branco", "Riyo Baraanko" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanofisk" },
            { "timezone.excity.Africa/Niamey", "Nijame" },
            { "timezone.excity.Indian/Mayotte", "Mayoote" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Waqtiga Celceliska Giriinwij",
                    "",
                    "Waqtiga Caadiga Ah ee Ayrishka",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakri" },
            { "timezone.excity.Asia/Jakarta", "Jakaarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratoof" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Ouagadougou", GMT },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luksembaag" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Baxreyn" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Ayle of Maan" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Kurakoow" },
            { "timezone.excity.Pacific/Nauru", "Nawroo" },
            { "timezone.excity.Pacific/Pago_Pago", "Bago Bago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyaana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Baariis" },
            { "timezone.excity.Europe/Zagreb", "Sagreb" },
            { "timezone.excity.America/Scoresbysund", "Itoqortoomiit" },
            { "timezone.excity.America/Indiana/Vevay", "Feefaay, Indiyaana" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Iswift Karent" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortoola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budabest" },
            { "timezone.excity.America/Catamarca", "Katamaarka" },
            { "timezone.excity.America/Port_of_Spain", "Boort of Isbayn" },
            { "timezone.excity.Asia/Chita", "Jiita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Raankin Inleet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santareem" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Heleniski" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutaat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadiyr" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.America/Costa_Rica", "Kosta Riika" },
            { "timezone.excity.Africa/Lagos", "Laagoos" },
            { "timezone.excity.Africa/Bissau", "Bisaaw" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douaala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Muqdisho" },
            { "timezone.excity.America/Bahia_Banderas", "Bahiya Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayabura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Cuadalkanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Loom" },
            { "timezone.excity.America/Nassau", "Nasaaw" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuweyt" },
            { "timezone.excity.America/Santo_Domingo", "Saanto Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskow" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Teybey" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Waqtiga Celceliska Giriinwij",
                    "",
                    "Waqtiga Xagaaga ee Biritishka",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dhaaka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Foot Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Maarigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.America/Kentucky/Monticello", "Montiseelo, Kentaki" },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbaashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Antarctica/McMurdo", "MakMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Nofosibirsik" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Sarednokoleymisk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nayroobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "timezone.excity.America/Indiana/Marengo", "Mareengo, Indiyaana" },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "fakofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johansbaag" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dhaablin" },
            { "timezone.excity.Antarctica/Casey", "Kaysee" },
            { "timezone.excity.Atlantic/Cape_Verde", "Keyb Faarde" },
            { "timezone.excity.Africa/Maputo", "Mabuuto" },
            { "timezone.excity.Africa/Luanda", "Luwaanda" },
            { "timezone.excity.America/Goose_Bay", "Guus Baay" },
            { "timezone.excity.America/Eirunepe", "Iiruneeb" },
            { "timezone.excity.America/Los_Angeles", "Loos Anjalis" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Kuyaaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "Asores" },
            { "timezone.excity.Australia/Melbourne", "Melboon" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguwila" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Birisban" },
            { "timezone.excity.Indian/Antananarivo", "Antananarifo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaauus" },
            { "timezone.excity.Asia/Vientiane", "Fiyaantiyaan" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Kiristmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktaw" },
            { "timezone.excity.America/Regina", "Rejiina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Tanda Baay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Luusfile" },
            { "timezone.excity.America/Cancun", "Kaankuun" },
            { "timezone.excity.Australia/Broken_Hill", "Boroken Hil" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimaati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tiraane" },
            { "timezone.excity.Europe/Prague", "Baraag" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunkiyon" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Waqtiga Isku-xiran ee Caalamka",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Jisinaaw" },
            { "timezone.excity.America/Moncton", "Moonktoon" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guwatemaala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Finiyuus" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Jikaago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Mariino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Pacific/Ponape", "Bonbey" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsik" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Iskoobje" },
            { "timezone.excity.America/Chihuahua", "Jiwaahuu" },
            { "America/Belize", America_Central },
            { "timezone.excity.America/Indiana/Winamac", "Winaamak, Indiyaana" },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjafik" },
            { "timezone.excity.Asia/Kamchatka", "Kamkatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakut" },
            { "timezone.excity.Africa/Djibouti", "Jibuuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Receyf" },
            { "timezone.excity.Pacific/Wallis", "Walis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Boorto-Noofo" },
            { "timezone.excity.Antarctica/Palmer", "Baamar" },
            { "timezone.excity.Asia/Tashkent", "Toshkeent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juwaan" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Shanghai", "Shanghaay" },
            { "timezone.excity.America/Juneau", "Juniyuu" },
            { "timezone.excity.Pacific/Bougainville", "Boogaynfil" },
            { "timezone.excity.Pacific/Apia", "Abiya" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salfadoor" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Iistar" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niyuu" },
            { "timezone.excity.America/Menominee", "Menoominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lod How" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magedan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Galeys Baay" },
            { "timezone.excity.Africa/Casablanca", "Kasabalaanka" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kiraalendik" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Yerefan" },
            { "timezone.excity.Europe/Kirov", "Kiroof" },
            { "timezone.excity.America/Creston", "Karestoon" },
            { "timezone.excity.Africa/Cairo", "Qaahira" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Warsaw" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/Indiana/Tell_City", "Tel Siti, Indiyaana" },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Saw Toom" },
            { "timezone.excity.America/Dawson", "Doosan" },
            { "timezone.excity.Africa/Abidjan", "Abidjaan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guwadeluub" },
            { "timezone.excity.Africa/Freetown", "Firiitawn" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Footalesa" },
            { "timezone.excity.Europe/Vatican", "Fatikaan" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Tbilisi", "Tibilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andoora" },
            { "timezone.excity.Europe/Minsk", "Minisk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrofiya" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mababaane" },
            { "timezone.excity.America/Rainy_River", "Reyni Rifer" },
            { "timezone.excity.America/Coral_Harbour", "Atikokaan" },
            { "timezone.excity.Asia/Beirut", "Beyruud" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Botiyaanak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Baqdaad" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont d\u2019urfile" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlaakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Maasiiyo" },
            { "timezone.excity.America/Guayaquil", "Guwayaquwil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "St. Finsent" },
            { "timezone.excity.America/Panama", "Banaama" },
            { "timezone.excity.Europe/Simferopol", "Simferobol" },
            { "timezone.excity.Indian/Kerguelen", "Kergalen" },
            { "timezone.excity.Europe/Volgograd", "Folgograd" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "Laa Baas" },
            { "timezone.excity.Africa/Tripoli", "Tiribooli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderburi" },
            { "timezone.excity.Asia/Pyongyang", "Boyongyang" },
            { "timezone.excity.Europe/Bucharest", "Bujarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Atens" },
            { "Africa/Djibouti", Africa_Eastern },
            { "timezone.excity.America/Indiana/Knox", "Nokis, Indiyaana" },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Boorto Felho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Manaaguwa" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Moontseraat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kobenhaagan" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jeerusaalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riyaad" },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Baagi" },
            { "timezone.excity.Africa/Lusaka", "Lusaaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Dimishiq" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrii" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Barasafil" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Riyo Jalejos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Baahiya" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Tehraan" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.America/St_Kitts", "St. Kitis" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daresalaam" },
            { "timezone.excity.America/Monterrey", "Moonteerey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belem" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Hoo Ji Mih Siti" },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinbaag" },
            { "timezone.excity.Europe/Sofia", "Sofiya" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astarakhaan" },
            { "timezone.excity.America/Yellowknife", "Yelowneyf" },
            { "timezone.excity.Europe/Belgrade", "Bilgaraydh" },
            { "timezone.excity.America/Puerto_Rico", "Boorta Riiko" },
            { "timezone.excity.America/Denver", "Denfar" },
            { "timezone.excity.Asia/Calcutta", "Kolkaata" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Qasa" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Torool" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hoong Koong" },
            { "timezone.excity.America/Port-au-Prince", "Boort-aw-Biriins" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Yukla" },
            { "timezone.excity.America/Mexico_City", "Meksiko Siti" },
            { "timezone.excity.Pacific/Kwajalein", "Kuwajaleyn" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisbon" },
            { "timezone.excity.Pacific/Gambier", "Gambiyr" },
            { "timezone.excity.America/Boise", "Boyse" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Saborosey" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominiika" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kambaala" },
            { "timezone.excity.Pacific/Chatham", "Jatam" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Boort Moresbi" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Meendoosa" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noroonha" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nibiigoon" },
            { "timezone.excity.Europe/Guernsey", "Geernisi" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luwis" },
            { "timezone.excity.Europe/Riga", "Riija" },
            { "timezone.excity.America/Araguaina", "Araguwayna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "Kordooba" },
            { "timezone.excity.America/Cambridge_Bay", "Kambiriij Baay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Kaambo Garandi" },
            { "timezone.excity.Africa/Blantyre", "Balantire" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sidney" },
            { "timezone.excity.Asia/Qatar", "Qaddar" },
            { "timezone.excity.America/Sitka", "Siitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Dafis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Qiyslorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Morishiyaas" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Riyoja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Maarihaam" },
            { "timezone.excity.America/St_Johns", "St. Joon" },
            { "timezone.excity.America/St_Barthelemy", "St. Baartelemi" },
            { "timezone.excity.America/Santiago", "Santiyaago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Maniila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indiyaanabolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "St. Toomas" },
            { "timezone.excity.Europe/Busingen", "Busingeen" },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbuul" },
            { "timezone.excity.Europe/Sarajevo", "Sarayeefo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Injamina" },
            { "timezone.excity.America/Punta_Arenas", "Bunta Arinaas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Faladifostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tuunis" },
            { "timezone.excity.Asia/Macau", "Makow" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "timezone.excity.Asia/Samarkand", "Samarkaan" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelayde" },
            { "timezone.excity.Asia/Singapore", "Singabuur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Fiyaana" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Keymaan" },
            { "timezone.excity.Europe/Bratislava", "Baratislafa" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nikosiya" },
            { "timezone.excity.Europe/Kiev", "Kiyf" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazaatlan" },
            { "timezone.excity.Asia/Brunei", "Buruney" },
            { "timezone.excity.Atlantic/Faeroe", "Farow" },
            { "timezone.excity.America/Whitehorse", "Waythoras" },
            { "timezone.excity.Asia/Kuching", "Kujing" },
            { "timezone.excity.America/Halifax", "Halifakas" },
            { "timezone.excity.America/Merida", "Meriida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Balaw" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Owklaan" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Noorfek" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatabu" },
            { "timezone.excity.Antarctica/Syowa", "Siyowa" },
            { "timezone.excity.America/Jamaica", "Jamayka" },
            { "timezone.excity.America/Hermosillo", "Harmosilo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Bodgorika" },
            { "timezone.excity.Indian/Reunion", "Riyuuniyon" },
            { "timezone.excity.Pacific/Noumea", "Noomiya" },
            { "timezone.excity.Asia/Aden", "Cadan" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Istaanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Thimphu", "Timbu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Dubay" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lambuur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.Africa/Gaborone", "Gabroon" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Indian/Chagos", "Jagos" },
            { "timezone.excity.Asia/Kabul", "Kaabuul" },
            { "timezone.excity.America/Iqaluit", "Iqaaluut" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdaam" },
            { "timezone.excity.Atlantic/Bermuda", "Barmuuda" },
            { "timezone.excity.Pacific/Saipan", "Seyban" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Australia/Currie", "Kuriy" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Ammaan" },
            { "timezone.excity.America/Indiana/Vincennes", "Finseenes, Indiyaana" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Barasalis" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeera" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "timezone.excity.America/Boa_Vista", "Bow Fista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Istokhoom" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuwaana" },
            { "timezone.excity.Indian/Maldives", "Maldifis" },
        };
        return data;
    }
}
