'''OpenGL extension QCOM.shader_framebuffer_fetch_noncoherent

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.shader_framebuffer_fetch_noncoherent to provide a more 
Python-friendly API

Overview (from the spec)
	
	Existing extensions such as EXT_shader_framebuffer_fetch and 
	ARM_shader_framebuffer_fetch_depth_stencil allow fragment
	shaders to read existing framebuffer color or depth/stencil data as input.
	This extension adds support for reading those same inputs with 
	relaxed coherency requirements.  This mode can avoid expensive
	per-primitive flushes of the pixel pipeline and may offer performance
	improvements in some implementations.
	
	When the relaxed coherency mode is enabled, reads of the framebuffer data
	by the fragment shader will guarantee defined results only if each sample
	is touched no more than once in any single rendering pass.  The command
	FramebufferFetchBarrierQCOM() is provided to indicate a boundary between
	passes.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/shader_framebuffer_fetch_noncoherent.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.shader_framebuffer_fetch_noncoherent import *
from OpenGL.raw.GLES2.QCOM.shader_framebuffer_fetch_noncoherent import _EXTENSION_NAME

def glInitShaderFramebufferFetchNoncoherentQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION