/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import org.apache.tomcat.util.compat.JreCompat;

class Jre7Compat
extends JreCompat {
    private static final int RUNTIME_MAJOR_VERSION = 7;
    private static final Method forLanguageTagMethod;
    private static final Constructor<GZIPOutputStream> gzipOutputStreamConstructor;

    Jre7Compat() {
    }

    static boolean isSupported() {
        return forLanguageTagMethod != null;
    }

    @Override
    public Locale forLanguageTag(String languageTag) {
        try {
            return (Locale)forLanguageTagMethod.invoke(null, languageTag);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public GZIPOutputStream getFlushableGZipOutputStream(OutputStream os) {
        try {
            return gzipOutputStreamConstructor.newInstance(os, Boolean.TRUE);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 7;
    }

    static {
        Method m = null;
        Constructor c = null;
        try {
            m = Locale.class.getMethod("forLanguageTag", String.class);
            c = GZIPOutputStream.class.getConstructor(OutputStream.class, Boolean.TYPE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        forLanguageTagMethod = m;
        gzipOutputStreamConstructor = c;
    }
}

