/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.util.NbBundle;

final class FixedModule
extends Module {
    private Properties localizedProps;
    private final Manifest manifest;

    public FixedModule(ModuleManager moduleManager, Events events, Manifest manifest, Object object, ClassLoader classLoader, boolean bl, boolean bl2) throws InvalidException {
        super(moduleManager, events, object, classLoader, bl, bl2);
        this.manifest = manifest;
        this.loadLocalizedPropsClasspath();
        this.parseManifest();
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    public Object getLocalizedAttribute(String string) {
        int n;
        Object object;
        String string2 = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean bl = false;
        if (string2 != null) {
            String string3;
            if (this.classloader != null) {
                if (string2.endsWith(".properties")) {
                    bl = true;
                    string3 = string2.substring(0, string2.length() - 11).replace('/', '.');
                    try {
                        object = NbBundle.getBundle((String)string3, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return ((ResourceBundle)object).getString(string);
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        Util.err.log(Level.WARNING, null, missingResourceException);
                    }
                } else {
                    Util.err.warning("cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + string2);
                }
            }
            if (!bl && this.localizedProps != null && (string3 = this.localizedProps.getProperty(string)) != null) {
                return string3;
            }
        }
        if ((n = string.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(string));
        }
        object = string.substring(0, n);
        String string4 = string.substring(n + 1);
        Attributes attributes = this.getManifest().getAttributes((String)object);
        if (attributes != null) {
            return NbBundle.getLocalizedValue((Attributes)attributes, (Attributes.Name)new Attributes.Name(string4));
        }
        return null;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    private void loadLocalizedPropsClasspath() throws InvalidException {
        Attributes attributes = this.manifest.getMainAttributes();
        String string = attributes.getValue("OpenIDE-Module-Localizing-Bundle");
        if (string != null) {
            Util.err.fine("Localized props in " + string + " for " + attributes.getValue("OpenIDE-Module"));
            try {
                String string2;
                String string3;
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    string3 = string;
                    string2 = "";
                } else {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n);
                }
                ArrayList arrayList = new ArrayList(10);
                Iterator iterator = NbBundle.getLocalizingSuffixes();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                Collections.reverse(arrayList);
                for (String string4 : arrayList) {
                    String string5 = string3 + string4 + string2;
                    InputStream inputStream = this.classloader.getResourceAsStream(string5);
                    if (inputStream == null) continue;
                    Util.err.fine("Found " + string5);
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    this.localizedProps.load(inputStream);
                }
                if (this.localizedProps == null) {
                    throw new IOException("Could not find localizing bundle: " + string);
                }
            }
            catch (IOException iOException) {
                throw (InvalidException)new InvalidException(iOException.toString()).initCause(iOException);
            }
        }
    }

    @Override
    public List<File> getAllJars() {
        return Collections.emptyList();
    }

    @Override
    public void setReloadable(boolean bl) {
        throw new IllegalStateException();
    }

    @Override
    public void reload() throws IOException {
        throw new IOException("Fixed module cannot be reloaded!");
    }

    protected void classLoaderUp(Set set) throws IOException {
    }

    @Override
    protected void classLoaderDown() {
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void destroy() {
    }

    @Override
    public String toString() {
        String string = "FixedModule:" + this.getCodeNameBase();
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    @Override
    void refineDependencies(Set<Dependency> set) {
    }
}

