/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.scheduler;

import com.sun.tools.visualvm.core.scheduler.Quantum;
import com.sun.tools.visualvm.core.scheduler.ScheduledTask;
import com.sun.tools.visualvm.core.scheduler.SchedulerTask;
import com.sun.tools.visualvm.core.scheduler.SchedulingPipe;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class DefaultScheduledTask
implements ScheduledTask,
SchedulerTask {
    private static final Map<Quantum, WeakReference<SchedulingPipe>> pipeMap = new HashMap<Quantum, WeakReference<SchedulingPipe>>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ReadWriteLock intervalLock = new ReentrantReadWriteLock();
    private Quantum interval;
    private SchedulerTask delegateTask;
    private Quantum suspendedFrom = Quantum.SUSPENDED;
    private SchedulingPipe pipe = null;

    public DefaultScheduledTask(Quantum interval, SchedulerTask task) {
        this.delegateTask = task;
        this.setInterval(interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(Quantum interval) {
        this.intervalLock.writeLock().lock();
        Quantum oldInterval = interval;
        try {
            oldInterval = this.interval;
            Map<Quantum, WeakReference<SchedulingPipe>> map = pipeMap;
            synchronized (map) {
                SchedulingPipe newPipe;
                WeakReference<SchedulingPipe> oldPipeRef = pipeMap.get(oldInterval);
                WeakReference<SchedulingPipe> newPipeRef = pipeMap.get(interval);
                SchedulingPipe oldPipe = oldPipeRef != null ? (SchedulingPipe)oldPipeRef.get() : null;
                SchedulingPipe schedulingPipe = newPipe = newPipeRef != null ? (SchedulingPipe)newPipeRef.get() : null;
                if (oldPipe != null) {
                    oldPipe.removeTask(this);
                }
                if (newPipe == null && interval != Quantum.SUSPENDED) {
                    newPipe = new SchedulingPipe(interval);
                    pipeMap.put(interval, new WeakReference<SchedulingPipe>(newPipe));
                }
                if (newPipe != null) {
                    newPipe.addTask(this);
                }
            }
            this.interval = interval;
        }
        finally {
            this.intervalLock.writeLock().unlock();
        }
        this.pcs.firePropertyChange("Task.Interval", oldInterval, interval);
    }

    @Override
    public Quantum getInterval() {
        this.intervalLock.readLock().lock();
        try {
            Quantum quantum = this.interval;
            return quantum;
        }
        finally {
            this.intervalLock.readLock().unlock();
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void suspend() {
        if (this.suspendedFrom.equals(Quantum.SUSPENDED)) {
            this.suspendedFrom = this.getInterval();
        }
        this.setInterval(Quantum.SUSPENDED);
    }

    @Override
    public void resume() {
        this.setInterval(this.suspendedFrom);
        this.suspendedFrom = Quantum.SUSPENDED;
    }

    @Override
    public boolean isSuspended() {
        return this.interval.equals(Quantum.SUSPENDED);
    }

    @Override
    public void onSchedule(long timeStamp) {
        this.delegateTask.onSchedule(timeStamp);
    }

    void setPipe(SchedulingPipe pipe) {
        this.pipe = pipe;
    }

    SchedulingPipe getPipe() {
        return this.pipe;
    }
}

