/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaFieldsProvider;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.model.TextNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewPlugin;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.icons.Icons;

class JavaFieldsPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private Object selected;
    private final TreeTableView objectsView;

    public JavaFieldsPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.JavaFieldsPlugin_Name(), Bundle.JavaFieldsPlugin_Description(), Icons.getIcon((String)"ProfilerIcons.NodeForward"));
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("java_objects_fields", context, actions, TreeTableViewColumn.instancesMinimal(this.heap, false)){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                if (JavaFieldsPlugin.this.selected != null) {
                    HeapViewerNode[] heapViewerNodeArray;
                    List<Object> fields = null;
                    if (JavaFieldsPlugin.this.selected instanceof Instance) {
                        fields = new ArrayList<FieldValue>(((Instance)JavaFieldsPlugin.this.selected).getFieldValues());
                        fields.addAll(((Instance)JavaFieldsPlugin.this.selected).getStaticFieldValues());
                    } else if (JavaFieldsPlugin.this.selected instanceof JavaClass) {
                        fields = ((JavaClass)JavaFieldsPlugin.this.selected).getStaticFieldValues();
                    }
                    HeapViewerNode[] nodes = JavaFieldsProvider.getNodes(fields, root, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
                    if (nodes == null || nodes.length == 0) {
                        HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
                        heapViewerNodeArray = heapViewerNodeArray2;
                        heapViewerNodeArray2[0] = new TextNode(Bundle.JavaFieldsPlugin_NoFields());
                    } else {
                        heapViewerNodeArray = nodes;
                    }
                    return heapViewerNodeArray;
                }
                return new HeapViewerNode[]{new TextNode(Bundle.JavaFieldsPlugin_NoSelection())};
            }
        };
    }

    @Override
    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        Instance selectedInstance;
        Instance instance = selectedInstance = node == null ? null : HeapViewerNode.getValue(node, DataType.INSTANCE, this.heap);
        if (selectedInstance != null) {
            if (Objects.equals(this.selected, selectedInstance)) {
                return;
            }
            this.selected = selectedInstance;
        } else {
            JavaClass selectedClass;
            JavaClass javaClass = selectedClass = node == null ? null : HeapViewerNode.getValue(node, DataType.CLASS, this.heap);
            if (Objects.equals(this.selected, selectedClass)) {
                return;
            }
            this.selected = selectedClass;
        }
        this.objectsView.reloadView();
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context)) {
                return new JavaFieldsPlugin(context, actions);
            }
            return null;
        }
    }
}

