/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.profiler.Bundle;
import com.sun.tools.visualvm.profiler.ProfilingResultsSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.LiveMemoryView;
import org.netbeans.lib.profiler.ui.memory.LiveMemoryViewUpdater;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

class MemoryLivePanel
extends ProfilingResultsSupport.ResultsView {
    private ProfilerToolbar toolbar;
    private LiveMemoryView memoryView;
    private LiveMemoryViewUpdater updater;
    private ProfilingResultsSupport.ResultsResetter resetter;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private JButton pdResetResultsButton;
    private boolean popupPause;

    MemoryLivePanel(Application application) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.initUI(application);
        this.add((Component)this.toolbar.getComponent(), "North");
        this.add((Component)this.memoryView, "Center");
    }

    void refreshResults() {
        this.refreshResults(false);
    }

    void resetResults() {
        if (this.lrDeltasButton != null) {
            this.lrDeltasButton.setSelected(false);
            this.lrDeltasButton.setToolTipText(Bundle.ObjectsFeatureUI_showDeltas());
        }
        if (this.memoryView != null) {
            this.memoryView.resetData();
            this.memoryView.setDiffView(false);
        }
    }

    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    private void refreshResults(final boolean forceRefresh) {
        RESULTS_PROCESSOR.post(new Runnable(){

            public void run() {
                block5: {
                    try {
                        if (MemoryLivePanel.this.updater != null) {
                            if (forceRefresh) {
                                MemoryLivePanel.this.updater.setForceRefresh(true);
                            }
                            MemoryLivePanel.this.updater.update();
                        }
                    }
                    catch (Throwable t) {
                        if (MemoryLivePanel.this.updater != null) {
                            MemoryLivePanel.this.updater.cleanup();
                            MemoryLivePanel.this.updater = null;
                        }
                        if (MemoryLivePanel.this.resetter == null) break block5;
                        MemoryLivePanel.this.resetter.unregisterView(MemoryLivePanel.this);
                        MemoryLivePanel.this.resetter = null;
                    }
                }
            }
        });
    }

    private void initUI(Application application) {
        assert (SwingUtilities.isEventDispatchThread());
        this.memoryView = new LiveMemoryView(null){

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected boolean profileClassSupported() {
                return false;
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                Lookup.Provider project = null;
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource(project, (String)className, (String)methodName, (String)methodSig);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
            }

            protected void popupShowing() {
                if (MemoryLivePanel.this.lrPauseButton.isEnabled() && !MemoryLivePanel.this.lrRefreshButton.isEnabled()) {
                    MemoryLivePanel.this.popupPause = true;
                    MemoryLivePanel.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (MemoryLivePanel.this.lrPauseButton.isEnabled() && MemoryLivePanel.this.popupPause) {
                    MemoryLivePanel.this.popupPause = false;
                    MemoryLivePanel.this.lrPauseButton.setSelected(false);
                }
            }
        };
        this.memoryView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileObjects.HelpCtx");
        this.memoryView.putClientProperty((Object)"profiled_application", (Object)application);
        this.updater = new LiveMemoryViewUpdater(this.memoryView, Profiler.getDefault().getTargetAppRunner().getProfilerClient());
        this.resetter = ProfilingResultsSupport.ResultsResetter.registerView(this);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Action action = MemoryLivePanel.this.memoryView.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Action action = MemoryLivePanel.this.memoryView.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
        this.lrLabel = new GrayLabel(Bundle.ObjectsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                MemoryLivePanel.this.updater.setPaused(paused);
                MemoryLivePanel.this.lrRefreshButton.setEnabled(paused && !MemoryLivePanel.this.popupPause);
                if (!paused) {
                    MemoryLivePanel.this.refreshResults(true);
                }
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.ObjectsFeatureUI_pauseResults());
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            protected void fireActionPerformed(ActionEvent e) {
                MemoryLivePanel.this.refreshResults(true);
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.ObjectsFeatureUI_updateResults());
        this.lrRefreshButton.setEnabled(false);
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            protected void fireActionPerformed(ActionEvent e) {
                if (!MemoryLivePanel.this.memoryView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.ObjectsFeatureUI_showAbsolute() : Bundle.ObjectsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.ObjectsFeatureUI_showDeltas());
        this.pdLabel = new GrayLabel(Bundle.ObjectsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)TakeSnapshotAction.getInstance());
        this.pdSnapshotButton.setText(Bundle.ObjectsFeatureUI_snapshot());
        this.pdResetResultsButton = new JButton((Action)ResetResultsAction.getInstance());
        this.pdResetResultsButton.setHideActionText(true);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)this.pdResetResultsButton);
    }

    private void refreshToolbar(final int state) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean running = state == 4;
                    MemoryLivePanel.this.lrPauseButton.setEnabled(running);
                    MemoryLivePanel.this.lrRefreshButton.setEnabled(!MemoryLivePanel.this.popupPause && running && MemoryLivePanel.this.lrPauseButton.isSelected());
                    MemoryLivePanel.this.lrDeltasButton.setEnabled(running);
                }
            });
        }
    }
}

