/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.documentgroup;

import java.awt.Dialog;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.documentgroup.GroupsManager;
import org.netbeans.core.windows.documentgroup.GroupsMenuAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class NewGroupPanel
extends JPanel {
    private static final String DEFAULT_NAME = NbBundle.getMessage(NewGroupPanel.class, (String)"Txt_NEW_GROUP_NAME");
    private JCheckBox cbKeepOpenedDocuments;
    private JLabel lblName;
    private JTextField txtName;

    public NewGroupPanel() {
        this.initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.txtName.selectAll();
        this.txtName.requestFocusInWindow();
    }

    void showDialog() {
        boolean bl;
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(NewGroupPanel.class, (String)"Dlg_NEW_GROUP"), true, 2, null, null);
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.core.windows.documentgroup.NewGroupAction"));
        boolean bl2 = bl = WindowManagerImpl.getInstance().getEditorTopComponents().length > 0;
        if (!bl) {
            this.cbKeepOpenedDocuments.setSelected(false);
            this.cbKeepOpenedDocuments.setEnabled(false);
        }
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                NewGroupPanel.this.validate(dialogDescriptor);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                NewGroupPanel.this.validate(dialogDescriptor);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                NewGroupPanel.this.validate(dialogDescriptor);
            }
        });
        this.txtName.setText(DEFAULT_NAME);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION == dialogDescriptor.getValue()) {
            if (!this.cbKeepOpenedDocuments.isSelected() && !GroupsManager.closeAllDocuments()) {
                return;
            }
            String string = this.txtName.getText().trim();
            GroupsManager.getDefault().addGroup(string);
            GroupsMenuAction.refreshMenu();
        }
    }

    private void validate(DialogDescriptor dialogDescriptor) {
        String string = this.txtName.getText();
        if (null == string) {
            string = "";
        }
        dialogDescriptor.setValid(!(string = string.trim()).isEmpty() && !DEFAULT_NAME.equals(string));
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.cbKeepOpenedDocuments = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.lblName.text"));
        this.cbKeepOpenedDocuments.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbKeepOpenedDocuments, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.cbKeepOpenedDocuments.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtName)).addGroup(groupLayout.createSequentialGroup().addComponent(this.cbKeepOpenedDocuments).addGap(0, 102, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblName).addComponent(this.txtName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbKeepOpenedDocuments).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

