/* THIS FILE IS GENERATED - DO NOT EDIT (scripts/vk_validation_stats.py) */
/* Vulkan specification version: 1.2.132 */
/*
 * Vulkan
 *
 * Copyright (c) 2016-2020 Google Inc.
 * Copyright (c) 2016-2020 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Tobin Ehlis <tobine@google.com>
 * Author: Dave Houlton <daveh@lunarg.com>
 */

#pragma once

// Disable auto-formatting for generated file
// clang-format off

// Mapping from VUID string to the corresponding spec text
typedef struct _vuid_spec_text_pair {
    const char * vuid;
    const char * spec_text;
} vuid_spec_text_pair;

static const vuid_spec_text_pair vuid_spec_text[] = {
    {"VUID-VkAccelerationStructureCreateInfoNV-compactedSize-02421", "If compactedSize is not 0 then both info.geometryCount and info.instanceCount must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureCreateInfoNV-compactedSize-02421)"},
    {"VUID-VkAccelerationStructureCreateInfoNV-info-parameter", "info must be a valid VkAccelerationStructureInfoNV structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureCreateInfoNV-info-parameter)"},
    {"VUID-VkAccelerationStructureCreateInfoNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureCreateInfoNV-pNext-pNext)"},
    {"VUID-VkAccelerationStructureCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureCreateInfoNV-sType-sType)"},
    {"VUID-VkAccelerationStructureInfoNV-flags-02592", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-flags-02592)"},
    {"VUID-VkAccelerationStructureInfoNV-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsNV values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-flags-parameter)"},
    {"VUID-VkAccelerationStructureInfoNV-geometryCount-02422", "geometryCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxGeometryCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-geometryCount-02422)"},
    {"VUID-VkAccelerationStructureInfoNV-instanceCount-02423", "instanceCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxInstanceCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-instanceCount-02423)"},
    {"VUID-VkAccelerationStructureInfoNV-instanceData-02782", "If instanceData is not VK_NULL_HANDLE, instanceData must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-instanceData-02782)"},
    {"VUID-VkAccelerationStructureInfoNV-maxTriangleCount-02424", "The total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxTriangleCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-maxTriangleCount-02424)"},
    {"VUID-VkAccelerationStructureInfoNV-pGeometries-parameter", "If geometryCount is not 0, pGeometries must be a valid pointer to an array of geometryCount valid VkGeometryNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-pGeometries-parameter)"},
    {"VUID-VkAccelerationStructureInfoNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-pNext-pNext)"},
    {"VUID-VkAccelerationStructureInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-sType-sType)"},
    {"VUID-VkAccelerationStructureInfoNV-scratch-02781", "scratch must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-scratch-02781)"},
    {"VUID-VkAccelerationStructureInfoNV-type-02425", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV then geometryCount must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-type-02425)"},
    {"VUID-VkAccelerationStructureInfoNV-type-02426", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then instanceCount must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-type-02426)"},
    {"VUID-VkAccelerationStructureInfoNV-type-02786", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then the geometryType member of each geometry in pGeometries must be the same (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-type-02786)"},
    {"VUID-VkAccelerationStructureInfoNV-type-parameter", "type must be a valid VkAccelerationStructureTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureInfoNV-type-parameter)"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureMemoryRequirementsInfoNV-accelerationStructure-parameter)"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureMemoryRequirementsInfoNV-pNext-pNext)"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureMemoryRequirementsInfoNV-sType-sType)"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-type-parameter", "type must be a valid VkAccelerationStructureMemoryRequirementsTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAccelerationStructureMemoryRequirementsInfoNV-type-parameter)"},
    {"VUID-VkAcquireNextImageInfoKHR-commonparent", "Each of fence, semaphore, and swapchain that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkInstance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-commonparent)"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01290", "deviceMask must be a valid device mask (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-deviceMask-01290)"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01291", "deviceMask must not be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-deviceMask-01291)"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-01289", "If fence is not VK_NULL_HANDLE it must be unsignaled and must not be associated with any other queue command that has not yet completed execution on that queue (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-fence-01289)"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-parameter", "If fence is not VK_NULL_HANDLE, fence must be a valid VkFence handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-fence-parameter)"},
    {"VUID-VkAcquireNextImageInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-pNext-pNext)"},
    {"VUID-VkAcquireNextImageInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-sType-sType)"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01288", "If semaphore is not VK_NULL_HANDLE it must be unsignaled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-semaphore-01288)"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01781", "If semaphore is not VK_NULL_HANDLE it must not have any uncompleted signal or wait operations pending (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-semaphore-01781)"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01782", "semaphore and fence must not both be equal to VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-semaphore-01782)"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-03266", "semaphore must have a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-semaphore-03266)"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-parameter", "If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-semaphore-parameter)"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-01675", "swapchain must not be in the retired state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-swapchain-01675)"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireNextImageInfoKHR-swapchain-parameter)"},
    {"VUID-VkAcquireProfilingLockInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireProfilingLockInfoKHR-flags-zerobitmask)"},
    {"VUID-VkAcquireProfilingLockInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireProfilingLockInfoKHR-pNext-pNext)"},
    {"VUID-VkAcquireProfilingLockInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAcquireProfilingLockInfoKHR-sType-sType)"},
    {"VUID-VkAllocationCallbacks-pfnAllocation-00632", "pfnAllocation must be a valid pointer to a valid user-defined PFN_vkAllocationFunction (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAllocationCallbacks-pfnAllocation-00632)"},
    {"VUID-VkAllocationCallbacks-pfnFree-00634", "pfnFree must be a valid pointer to a valid user-defined PFN_vkFreeFunction (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAllocationCallbacks-pfnFree-00634)"},
    {"VUID-VkAllocationCallbacks-pfnInternalAllocation-00635", "If either of pfnInternalAllocation or pfnInternalFree is not NULL, both must be valid callbacks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAllocationCallbacks-pfnInternalAllocation-00635)"},
    {"VUID-VkAllocationCallbacks-pfnReallocation-00633", "pfnReallocation must be a valid pointer to a valid user-defined PFN_vkReallocationFunction (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAllocationCallbacks-pfnReallocation-00633)"},
    {"VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType)"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAndroidHardwareBufferFormatPropertiesANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidHardwareBufferPropertiesANDROID-pNext-pNext)"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-sType)"},
    {"VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType)"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidSurfaceCreateInfoKHR-flags-zerobitmask)"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidSurfaceCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidSurfaceCreateInfoKHR-sType-sType)"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-window-01248", "window must point to a valid Android ANativeWindow. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAndroidSurfaceCreateInfoKHR-window-01248)"},
    {"VUID-VkApplicationInfo-pApplicationName-parameter", "If pApplicationName is not NULL, pApplicationName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkApplicationInfo-pApplicationName-parameter)"},
    {"VUID-VkApplicationInfo-pEngineName-parameter", "If pEngineName is not NULL, pEngineName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkApplicationInfo-pEngineName-parameter)"},
    {"VUID-VkApplicationInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkApplicationInfo-pNext-pNext)"},
    {"VUID-VkApplicationInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_APPLICATION_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkApplicationInfo-sType-sType)"},
    {"VUID-VkAttachmentDescription-finalLayout-00843", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-finalLayout-00843)"},
    {"VUID-VkAttachmentDescription-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-finalLayout-parameter)"},
    {"VUID-VkAttachmentDescription-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-flags-parameter)"},
    {"VUID-VkAttachmentDescription-format-03280", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03280)"},
    {"VUID-VkAttachmentDescription-format-03281", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03281)"},
    {"VUID-VkAttachmentDescription-format-03282", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03282)"},
    {"VUID-VkAttachmentDescription-format-03283", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03283)"},
    {"VUID-VkAttachmentDescription-format-03286", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03286)"},
    {"VUID-VkAttachmentDescription-format-03287", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03287)"},
    {"VUID-VkAttachmentDescription-format-03288", "If format is a depth/stencil format which includes both depth and stencil aspects, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03288)"},
    {"VUID-VkAttachmentDescription-format-03289", "If format is a depth/stencil format which includes both depth and stencil aspects, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03289)"},
    {"VUID-VkAttachmentDescription-format-03290", "If format is a depth/stencil format which includes only the depth aspect, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03290)"},
    {"VUID-VkAttachmentDescription-format-03291", "If format is a depth/stencil format which includes only the depth aspect, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03291)"},
    {"VUID-VkAttachmentDescription-format-03292", "If format is a depth/stencil format which includes only the stencil aspect, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03292)"},
    {"VUID-VkAttachmentDescription-format-03293", "If format is a depth/stencil format which includes only the stencil aspect, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-03293)"},
    {"VUID-VkAttachmentDescription-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-format-parameter)"},
    {"VUID-VkAttachmentDescription-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-initialLayout-parameter)"},
    {"VUID-VkAttachmentDescription-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-loadOp-parameter)"},
    {"VUID-VkAttachmentDescription-samples-parameter", "samples must be a valid VkSampleCountFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-samples-parameter)"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03284", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-separateDepthStencilLayouts-03284)"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03285", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-separateDepthStencilLayouts-03285)"},
    {"VUID-VkAttachmentDescription-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-stencilLoadOp-parameter)"},
    {"VUID-VkAttachmentDescription-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-stencilStoreOp-parameter)"},
    {"VUID-VkAttachmentDescription-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription-storeOp-parameter)"},
    {"VUID-VkAttachmentDescription2-finalLayout-03061", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-finalLayout-03061)"},
    {"VUID-VkAttachmentDescription2-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-finalLayout-parameter)"},
    {"VUID-VkAttachmentDescription2-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-flags-parameter)"},
    {"VUID-VkAttachmentDescription2-format-03294", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03294)"},
    {"VUID-VkAttachmentDescription2-format-03295", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03295)"},
    {"VUID-VkAttachmentDescription2-format-03296", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03296)"},
    {"VUID-VkAttachmentDescription2-format-03297", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03297)"},
    {"VUID-VkAttachmentDescription2-format-03300", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03300)"},
    {"VUID-VkAttachmentDescription2-format-03301", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03301)"},
    {"VUID-VkAttachmentDescription2-format-03302", "If format is a depth/stencil format which includes both depth and stencil aspects, and initialLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03302)"},
    {"VUID-VkAttachmentDescription2-format-03303", "If format is a depth/stencil format which includes both depth and stencil aspects, and finalLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03303)"},
    {"VUID-VkAttachmentDescription2-format-03304", "If format is a depth/stencil format which includes only the depth aspect, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03304)"},
    {"VUID-VkAttachmentDescription2-format-03305", "If format is a depth/stencil format which includes only the depth aspect, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03305)"},
    {"VUID-VkAttachmentDescription2-format-03306", "If format is a depth/stencil format which includes only the stencil aspect, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03306)"},
    {"VUID-VkAttachmentDescription2-format-03307", "If format is a depth/stencil format which includes only the stencil aspect, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-03307)"},
    {"VUID-VkAttachmentDescription2-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-format-parameter)"},
    {"VUID-VkAttachmentDescription2-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-initialLayout-parameter)"},
    {"VUID-VkAttachmentDescription2-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-loadOp-parameter)"},
    {"VUID-VkAttachmentDescription2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-sType-sType)"},
    {"VUID-VkAttachmentDescription2-samples-parameter", "samples must be a valid VkSampleCountFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-samples-parameter)"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03298", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03298)"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03299", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03299)"},
    {"VUID-VkAttachmentDescription2-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-stencilLoadOp-parameter)"},
    {"VUID-VkAttachmentDescription2-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-stencilStoreOp-parameter)"},
    {"VUID-VkAttachmentDescription2-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescription2-storeOp-parameter)"},
    {"VUID-VkAttachmentDescriptionStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescriptionStencilLayout-sType-sType)"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03309", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03309)"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03310", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03310)"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter", "stencilFinalLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter)"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-03308", "stencilInitialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-03308)"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter", "stencilInitialLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter)"},
    {"VUID-VkAttachmentReference-layout-00857", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_PRESENT_SRC_KHR, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference-layout-00857)"},
    {"VUID-VkAttachmentReference-layout-parameter", "layout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference-layout-parameter)"},
    {"VUID-VkAttachmentReference2-attachment-03311", "If attachment is not VK_ATTACHMENT_UNUSED, and aspectMask does not include VK_IMAGE_ASPECT_STENCIL_BIT or VK_IMAGE_ASPECT_DEPTH_BIT, layout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-attachment-03311)"},
    {"VUID-VkAttachmentReference2-attachment-03312", "If attachment is not VK_ATTACHMENT_UNUSED, and aspectMask does not include VK_IMAGE_ASPECT_COLOR_BIT, layout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-attachment-03312)"},
    {"VUID-VkAttachmentReference2-attachment-03314", "If attachment is not VK_ATTACHMENT_UNUSED, and aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL, (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-attachment-03314)"},
    {"VUID-VkAttachmentReference2-attachment-03315", "If attachment is not VK_ATTACHMENT_UNUSED, and aspectMask includes both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT, and layout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentReferenceStencilLayout structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-attachment-03315)"},
    {"VUID-VkAttachmentReference2-attachment-03316", "If attachment is not VK_ATTACHMENT_UNUSED, and aspectMask includes only VK_IMAGE_ASPECT_DEPTH_BIT then layout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-attachment-03316)"},
    {"VUID-VkAttachmentReference2-attachment-03317", "If attachment is not VK_ATTACHMENT_UNUSED, and aspectMask includes only VK_IMAGE_ASPECT_STENCIL_BIT then layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-attachment-03317)"},
    {"VUID-VkAttachmentReference2-layout-03077", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-layout-03077)"},
    {"VUID-VkAttachmentReference2-layout-parameter", "layout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-layout-parameter)"},
    {"VUID-VkAttachmentReference2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-sType-sType)"},
    {"VUID-VkAttachmentReference2-separateDepthStencilLayouts-03313", "If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL, (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReference2-separateDepthStencilLayouts-03313)"},
    {"VUID-VkAttachmentReferenceStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReferenceStencilLayout-sType-sType)"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-03318", "stencilLayout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReferenceStencilLayout-stencilLayout-03318)"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter", "stencilLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter)"},
    {"VUID-VkAttachmentSampleLocationsEXT-attachmentIndex-01531", "attachmentIndex must be less than the attachmentCount specified in VkRenderPassCreateInfo the render pass specified by VkRenderPassBeginInfo::renderPass was created with (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentSampleLocationsEXT-attachmentIndex-01531)"},
    {"VUID-VkAttachmentSampleLocationsEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkAttachmentSampleLocationsEXT-sampleLocationsInfo-parameter)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-02450", "accelerationStructure must not already be backed by a memory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-02450)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-parameter)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-commonparent", "Both of accelerationStructure, and memory must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-commonparent)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-02593", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-memory-02593)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-memory-parameter)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-02451", "memoryOffset must be less than the size of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-02451)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-02594", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-02594)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-pDeviceIndices-parameter)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-pNext-pNext)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-sType-sType)"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-size-02595", "The size member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV must be less than or equal to the size of memory minus memoryOffset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindAccelerationStructureMemoryInfoNV-size-02595)"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-deviceIndexCount-01606", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryDeviceGroupInfo-deviceIndexCount-01606)"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-01607", "All elements of pDeviceIndices must be valid device indices (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-01607)"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter)"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType)"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01593", "buffer must not already be backed by a memory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-buffer-01593)"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01594", "buffer must not have been created with any sparse memory binding flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-buffer-01594)"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01602", "If buffer requires a dedicated allocation(as reported by vkGetBufferMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for buffer), memory must have been created with VkMemoryDedicatedAllocateInfo::buffer equal to buffer and memoryOffset must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-buffer-01602)"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01603", "If buffer was created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::buffer equal to buffer and memoryOffset must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-buffer-01603)"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01604", "If buffer was not created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkBindBufferMemoryInfo-buffer-01604)"},
    {"VUID-VkBindBufferMemoryInfo-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-buffer-parameter)"},
    {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddress-02838", "If the VkPhysicalDeviceBufferDeviceAddressFeaturesKHR::bufferDeviceAddress feature is enabled and buffer was created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_KHR bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT_KHR bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-bufferDeviceAddress-02838)"},
    {"VUID-VkBindBufferMemoryInfo-commonparent", "Both of buffer, and memory must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-commonparent)"},
    {"VUID-VkBindBufferMemoryInfo-handleTypes-02791", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-handleTypes-02791)"},
    {"VUID-VkBindBufferMemoryInfo-memory-01599", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-memory-01599)"},
    {"VUID-VkBindBufferMemoryInfo-memory-01900", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::buffer was not VK_NULL_HANDLE, then buffer must equal VkMemoryDedicatedAllocateInfo::buffer and memoryOffset must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-memory-01900)"},
    {"VUID-VkBindBufferMemoryInfo-memory-02792", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-memory-02792)"},
    {"VUID-VkBindBufferMemoryInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-memory-parameter)"},
    {"VUID-VkBindBufferMemoryInfo-memoryOffset-01595", "memoryOffset must be less than the size of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-memoryOffset-01595)"},
    {"VUID-VkBindBufferMemoryInfo-memoryOffset-01600", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-memoryOffset-01600)"},
    {"VUID-VkBindBufferMemoryInfo-pNext-01605", "If the pNext chain includes a VkBindBufferMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindBufferMemoryDeviceGroupInfo::pDeviceIndices must have been allocated (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-pNext-01605)"},
    {"VUID-VkBindBufferMemoryInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkBindBufferMemoryDeviceGroupInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-pNext-pNext)"},
    {"VUID-VkBindBufferMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-sType-sType)"},
    {"VUID-VkBindBufferMemoryInfo-size-01601", "The size member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindBufferMemoryInfo-size-01601)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01633", "At least one of deviceIndexCount and splitInstanceBindRegionCount must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01633)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01634", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01634)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01640", "The extent.width member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block width of all non-metadata aspects of the image, or else extent.width + offset.x must equal the width of the image subresource (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-extent-01640)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01641", "The extent.height member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block height of all non-metadata aspects of the image, or else extent.height + offset.y must equal the width of the image subresource (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-extent-01641)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01638", "The offset.x member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block width (VkSparseImageFormatProperties::imageGranularity.width) of all non-metadata aspects of the image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-offset-01638)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01639", "The offset.y member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block height (VkSparseImageFormatProperties::imageGranularity.height) of all non-metadata aspects of the image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-offset-01639)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-01635", "All elements of pDeviceIndices must be valid device indices. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-01635)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-01637", "Elements of pSplitInstanceBindRegions that correspond to the same instance of an image must not overlap. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-01637)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter", "If splitInstanceBindRegionCount is not 0, pSplitInstanceBindRegions must be a valid pointer to an array of splitInstanceBindRegionCount VkRect2D structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType)"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-splitInstanceBindRegionCount-01636", "splitInstanceBindRegionCount must either be zero or equal to the number of physical devices in the logical device squared (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryDeviceGroupInfo-splitInstanceBindRegionCount-01636)"},
    {"VUID-VkBindImageMemoryInfo-commonparent", "Both of image, and memory that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-commonparent)"},
    {"VUID-VkBindImageMemoryInfo-handleTypes-02793", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryImageCreateInfo::handleTypes when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-handleTypes-02793)"},
    {"VUID-VkBindImageMemoryInfo-image-01609", "image must not already be backed by a memory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-image-01609)"},
    {"VUID-VkBindImageMemoryInfo-image-01610", "image must not have been created with any sparse memory binding flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-image-01610)"},
    {"VUID-VkBindImageMemoryInfo-image-01622", "If image requires a dedicated allocation (as reported by vkGetImageMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for image), memory must have been created with VkMemoryDedicatedAllocateInfo::image equal to image and memoryOffset must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-image-01622)"},
    {"VUID-VkBindImageMemoryInfo-image-01623", "If image was created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::image equal to image and memoryOffset must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-image-01623)"},
    {"VUID-VkBindImageMemoryInfo-image-01624", "If image was not created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkBindImageMemoryInfo-image-01624)"},
    {"VUID-VkBindImageMemoryInfo-image-01630", "If image was created with a valid swapchain handle in VkImageSwapchainCreateInfoKHR::swapchain, then the pNext chain must include a VkBindImageMemorySwapchainInfoKHR structure containing the same swapchain handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-image-01630)"},
    {"VUID-VkBindImageMemoryInfo-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-image-parameter)"},
    {"VUID-VkBindImageMemoryInfo-memory-01612", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with image (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkBindImageMemoryInfo-memory-01612)"},
    {"VUID-VkBindImageMemoryInfo-memory-01614", "The difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with the same image (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkBindImageMemoryInfo-memory-01614)"},
    {"VUID-VkBindImageMemoryInfo-memory-01625", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1/html/vkspec.html#VUID-VkBindImageMemoryInfo-memory-01625)"},
    {"VUID-VkBindImageMemoryInfo-memory-01903", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-memory-01903)"},
    {"VUID-VkBindImageMemoryInfo-memory-02630", "If the dedicated allocation image aliasing feature is not enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-memory-02630)"},
    {"VUID-VkBindImageMemoryInfo-memory-02631", "If the dedicated allocation image aliasing feature is enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then memoryOffset must be zero, and image must be either equal to VkMemoryDedicatedAllocateInfo::image or an image that was created using the same parameters in VkImageCreateInfo, with the exception that extent and arrayLayers may differ subject to the following restrictions: every dimension in the extent parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created; and the arrayLayers parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-memory-02631)"},
    {"VUID-VkBindImageMemoryInfo-memory-02794", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-memory-02794)"},
    {"VUID-VkBindImageMemoryInfo-memoryOffset-01611", "memoryOffset must be less than the size of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-memoryOffset-01611)"},
    {"VUID-VkBindImageMemoryInfo-memoryOffset-01613", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with image (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkBindImageMemoryInfo-memoryOffset-01613)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01615", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01615)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01616", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01616)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01617", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01617)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01618", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, image must have been created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01618)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01619", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and the correct planeAspect for this plane in the VkImagePlaneMemoryRequirementsInfo structure included in the VkImageMemoryRequirementsInfo2 structure's pNext chain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01619)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01620", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and the correct planeAspect for this plane in the VkImagePlaneMemoryRequirementsInfo structure included in the VkImageMemoryRequirementsInfo2 structure's pNext chain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01620)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01621", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image and the correct planeAspect for this plane in the VkImagePlaneMemoryRequirementsInfo structure included in the VkImageMemoryRequirementsInfo2 structure's pNext chain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01621)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01626", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindImageMemoryDeviceGroupInfo::pDeviceIndices must have been allocated (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01626)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01627", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, and VkBindImageMemoryDeviceGroupInfo::splitInstanceBindRegionCount is not zero, then image must have been created with the VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01627)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01628", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions must be valid rectangles contained within the dimensions of image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01628)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01629", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, the union of the areas of all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions that correspond to the same instance of image must cover the entire image. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01629)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01631", "If the pNext chain includes a VkBindImageMemorySwapchainInfoKHR structure, memory must be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01631)"},
    {"VUID-VkBindImageMemoryInfo-pNext-01632", "If the pNext chain does not include a VkBindImageMemorySwapchainInfoKHR structure, memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-01632)"},
    {"VUID-VkBindImageMemoryInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindImageMemoryDeviceGroupInfo, VkBindImageMemorySwapchainInfoKHR, or VkBindImagePlaneMemoryInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-pNext-pNext)"},
    {"VUID-VkBindImageMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-sType-sType)"},
    {"VUID-VkBindImageMemoryInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemoryInfo-sType-unique)"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-imageIndex-01644", "imageIndex must be less than the number of images in swapchain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemorySwapchainInfoKHR-imageIndex-01644)"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType)"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-parameter)"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02283", "If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid format plane for the image. (That is, planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT for '_2PLANE' formats and planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT for '_3PLANE' formats.) (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImagePlaneMemoryInfo-planeAspect-02283)"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02284", "If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT,  then planeAspect must be a single valid memory plane for the  image.  (That is, aspectMask must specify a plane index that is less than  the  drmFormatModifierPlaneCount  associated with the image's format and drmFormatModifier.) (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImagePlaneMemoryInfo-planeAspect-02284)"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter", "planeAspect must be a valid VkImageAspectFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter)"},
    {"VUID-VkBindImagePlaneMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindImagePlaneMemoryInfo-sType-sType)"},
    {"VUID-VkBindSparseInfo-commonparent", "Both of the elements of pSignalSemaphores, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-commonparent)"},
    {"VUID-VkBindSparseInfo-pBufferBinds-parameter", "If bufferBindCount is not 0, pBufferBinds must be a valid pointer to an array of bufferBindCount valid VkSparseBufferMemoryBindInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pBufferBinds-parameter)"},
    {"VUID-VkBindSparseInfo-pImageBinds-parameter", "If imageBindCount is not 0, pImageBinds must be a valid pointer to an array of imageBindCount valid VkSparseImageMemoryBindInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pImageBinds-parameter)"},
    {"VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter", "If imageOpaqueBindCount is not 0, pImageOpaqueBinds must be a valid pointer to an array of imageOpaqueBindCount valid VkSparseImageOpaqueMemoryBindInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter)"},
    {"VUID-VkBindSparseInfo-pNext-03247", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pWaitSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its waitSemaphoreValueCount member must equal waitSemaphoreCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pNext-03247)"},
    {"VUID-VkBindSparseInfo-pNext-03248", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its signalSemaphoreValueCount member must equal signalSemaphoreCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pNext-03248)"},
    {"VUID-VkBindSparseInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupBindSparseInfo or VkTimelineSemaphoreSubmitInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pNext-pNext)"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03249", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value greater than the current value of the semaphore when the semaphore signal operation is executed (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pSignalSemaphores-03249)"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03251", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pSignalSemaphores-03251)"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphores must be a valid pointer to an array of signalSemaphoreCount valid VkSemaphore handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pSignalSemaphores-parameter)"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03246", "If any element of pWaitSemaphores or pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then the pNext chain must include a VkTimelineSemaphoreSubmitInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pWaitSemaphores-03246)"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03250", "For each element of pWaitSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pWaitSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pWaitSemaphores-03250)"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-pWaitSemaphores-parameter)"},
    {"VUID-VkBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_SPARSE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-sType-sType)"},
    {"VUID-VkBindSparseInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBindSparseInfo-sType-unique)"},
    {"VUID-VkBufferCopy-size-01988", "The size must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCopy-size-01988)"},
    {"VUID-VkBufferCreateInfo-None-01888", "If any of the bits VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT are set, VK_BUFFER_CREATE_PROTECTED_BIT must not also be set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-None-01888)"},
    {"VUID-VkBufferCreateInfo-deviceAddress-02604", "If VkBufferDeviceAddressCreateInfoEXT::deviceAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-deviceAddress-02604)"},
    {"VUID-VkBufferCreateInfo-flags-00915", "If the sparse bindings feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-flags-00915)"},
    {"VUID-VkBufferCreateInfo-flags-00916", "If the sparse buffer residency feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-flags-00916)"},
    {"VUID-VkBufferCreateInfo-flags-00917", "If the sparse aliased residency feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_ALIASED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-flags-00917)"},
    {"VUID-VkBufferCreateInfo-flags-00918", "If flags contains VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-flags-00918)"},
    {"VUID-VkBufferCreateInfo-flags-01887", "If the protected memory feature is not enabled, flags must not contain VK_BUFFER_CREATE_PROTECTED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-flags-01887)"},
    {"VUID-VkBufferCreateInfo-flags-03338", "If flags includes VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the bufferDeviceAddressCaptureReplay or VkPhysicalDeviceBufferDeviceAddressFeaturesEXT::bufferDeviceAddressCaptureReplay feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-flags-03338)"},
    {"VUID-VkBufferCreateInfo-flags-parameter", "flags must be a valid combination of VkBufferCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-flags-parameter)"},
    {"VUID-VkBufferCreateInfo-opaqueCaptureAddress-03337", "If VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-opaqueCaptureAddress-03337)"},
    {"VUID-VkBufferCreateInfo-pNext-00920", "If the pNext chain includes a VkExternalMemoryBufferCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalBufferProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalBufferProperties with pExternalBufferInfo->handleType equal to any one of the handle types specified in VkExternalMemoryBufferCreateInfo::handleTypes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-pNext-00920)"},
    {"VUID-VkBufferCreateInfo-pNext-01571", "If the pNext chain includes a VkDedicatedAllocationBufferCreateInfoNV structure, and the dedicatedAllocation member of the chained structure is VK_TRUE, then flags must not include VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-pNext-01571)"},
    {"VUID-VkBufferCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferDeviceAddressCreateInfoEXT, VkBufferOpaqueCaptureAddressCreateInfo, VkDedicatedAllocationBufferCreateInfoNV, or VkExternalMemoryBufferCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-pNext-pNext)"},
    {"VUID-VkBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-sType-sType)"},
    {"VUID-VkBufferCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-sType-unique)"},
    {"VUID-VkBufferCreateInfo-sharingMode-00913", "If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-sharingMode-00913)"},
    {"VUID-VkBufferCreateInfo-sharingMode-00914", "If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-sharingMode-00914)"},
    {"VUID-VkBufferCreateInfo-sharingMode-01391", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferCreateInfo-sharingMode-01391)"},
    {"VUID-VkBufferCreateInfo-sharingMode-01419", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties or vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-sharingMode-01419)"},
    {"VUID-VkBufferCreateInfo-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-sharingMode-parameter)"},
    {"VUID-VkBufferCreateInfo-size-00912", "size must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-size-00912)"},
    {"VUID-VkBufferCreateInfo-usage-parameter", "usage must be a valid combination of VkBufferUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-usage-parameter)"},
    {"VUID-VkBufferCreateInfo-usage-requiredbitmask", "usage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferCreateInfo-usage-requiredbitmask)"},
    {"VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType)"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-02600", "If buffer is non-sparse and was not created with the VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT flag, then it must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferDeviceAddressInfo-buffer-02600)"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-02601", "buffer must have been created with VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferDeviceAddressInfo-buffer-02601)"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferDeviceAddressInfo-buffer-parameter)"},
    {"VUID-VkBufferDeviceAddressInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferDeviceAddressInfo-pNext-pNext)"},
    {"VUID-VkBufferDeviceAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferDeviceAddressInfo-sType-sType)"},
    {"VUID-VkBufferImageCopy-None-00214", "When copying to the depth aspect of an image subresource, the data in the source buffer must be in the range [0,1] (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-00214)"},
    {"VUID-VkBufferImageCopy-None-01735", "If the calling command's VkImage parameter is a compressed image, or a single-plane, '_422' image format, bufferRowLength must be a multiple of the compressed texel block width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-01735)"},
    {"VUID-VkBufferImageCopy-None-01736", "If the calling command's VkImage parameter is a compressed image, or a single-plane, '_422' image format, bufferImageHeight must be a multiple of the compressed texel block height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-01736)"},
    {"VUID-VkBufferImageCopy-None-01737", "If the calling command's VkImage parameter is a compressed image, or a single-plane, '_422' image format, all members of imageOffset must be a multiple of the corresponding dimensions of the compressed texel block (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-01737)"},
    {"VUID-VkBufferImageCopy-None-01738", "If the calling command's VkImage parameter is a compressed image, or a single-plane, '_422' image format, bufferOffset must be a multiple of the compressed texel block size in bytes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-01738)"},
    {"VUID-VkBufferImageCopy-None-01739", "If the calling command's VkImage parameter is a compressed image, or a single-plane, '_422' image format, imageExtent.width must be a multiple of the compressed texel block width or (imageExtent.width + imageOffset.x) must equal the image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-01739)"},
    {"VUID-VkBufferImageCopy-None-01740", "If the calling command's VkImage parameter is a compressed image, or a single-plane, '_422' image format, imageExtent.height must be a multiple of the compressed texel block height or (imageExtent.height + imageOffset.y) must equal the image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-01740)"},
    {"VUID-VkBufferImageCopy-None-01741", "If the calling command's VkImage parameter is a compressed image, or a single-plane, '_422' image format, imageExtent.depth must be a multiple of the compressed texel block depth or (imageExtent.depth + imageOffset.z) must equal the image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-None-01741)"},
    {"VUID-VkBufferImageCopy-aspectMask-00211", "The aspectMask member of imageSubresource must specify aspects present in the calling command's VkImage parameter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-aspectMask-00211)"},
    {"VUID-VkBufferImageCopy-aspectMask-00212", "The aspectMask member of imageSubresource must only have a single bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-aspectMask-00212)"},
    {"VUID-VkBufferImageCopy-aspectMask-01560", "If the calling command's VkImage parameter's format is a multi-planar format, then the aspectMask member of imageSubresource must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT (with VK_IMAGE_ASPECT_PLANE_2_BIT valid only for image formats with three planes) (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-aspectMask-01560)"},
    {"VUID-VkBufferImageCopy-baseArrayLayer-00213", "If the calling command's VkImage parameter is of VkImageType VK_IMAGE_TYPE_3D, the baseArrayLayer and layerCount members of imageSubresource must be 0 and 1, respectively (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-baseArrayLayer-00213)"},
    {"VUID-VkBufferImageCopy-bufferImageHeight-00196", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-bufferImageHeight-00196)"},
    {"VUID-VkBufferImageCopy-bufferImageHeight-00204", "If the calling command's VkImage parameter is a compressed image, bufferImageHeight must be a multiple of the compressed texel block height (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-bufferImageHeight-00204)"},
    {"VUID-VkBufferImageCopy-bufferOffset-00193", "If the calling command's VkImage parameter's format is not a depth/stencil format, then bufferOffset must be a multiple of the format's texel block size. (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-bufferOffset-00193)"},
    {"VUID-VkBufferImageCopy-bufferOffset-00194", "bufferOffset must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-bufferOffset-00194)"},
    {"VUID-VkBufferImageCopy-bufferOffset-00206", "If the calling command's VkImage parameter is a compressed image, bufferOffset must be a multiple of the compressed texel block size in bytes (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-bufferOffset-00206)"},
    {"VUID-VkBufferImageCopy-bufferOffset-01558", "If the calling command's VkImage parameter's format is not a depth/stencil format or a multi-planar format, then bufferOffset must be a multiple of the format's texel block size. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-bufferOffset-01558)"},
    {"VUID-VkBufferImageCopy-bufferOffset-01559", "If the calling command's VkImage parameter's format is a multi-planar format, then bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible formats of planes of multi-planar formats (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-bufferOffset-01559)"},
    {"VUID-VkBufferImageCopy-bufferRowLength-00195", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-bufferRowLength-00195)"},
    {"VUID-VkBufferImageCopy-bufferRowLength-00203", "If the calling command's VkImage parameter is a compressed image, bufferRowLength must be a multiple of the compressed texel block width (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-bufferRowLength-00203)"},
    {"VUID-VkBufferImageCopy-imageExtent-00207", "If the calling command's VkImage parameter is a compressed image, imageExtent.width must be a multiple of the compressed texel block width or (imageExtent.width + imageOffset.x) must equal the image subresource width (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-imageExtent-00207)"},
    {"VUID-VkBufferImageCopy-imageExtent-00208", "If the calling command's VkImage parameter is a compressed image, imageExtent.height must be a multiple of the compressed texel block height or (imageExtent.height + imageOffset.y) must equal the image subresource height (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-imageExtent-00208)"},
    {"VUID-VkBufferImageCopy-imageExtent-00209", "If the calling command's VkImage parameter is a compressed image, imageExtent.depth must be a multiple of the compressed texel block depth or (imageExtent.depth + imageOffset.z) must equal the image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-imageExtent-00209)"},
    {"VUID-VkBufferImageCopy-imageOffset-00197", "imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-imageOffset-00197)"},
    {"VUID-VkBufferImageCopy-imageOffset-00198", "imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-imageOffset-00198)"},
    {"VUID-VkBufferImageCopy-imageOffset-00200", "imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-imageOffset-00200)"},
    {"VUID-VkBufferImageCopy-imageOffset-00205", "If the calling command's VkImage parameter is a compressed image, all members of imageOffset must be a multiple of the corresponding dimensions of the compressed texel block (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferImageCopy-imageOffset-00205)"},
    {"VUID-VkBufferImageCopy-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-imageSubresource-parameter)"},
    {"VUID-VkBufferImageCopy-srcImage-00199", "If the calling command's srcImage (vkCmdCopyImageToBuffer) or dstImage (vkCmdCopyBufferToImage) is of type VK_IMAGE_TYPE_1D, then imageOffset.y must be 0 and imageExtent.height must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-srcImage-00199)"},
    {"VUID-VkBufferImageCopy-srcImage-00201", "If the calling command's srcImage (vkCmdCopyImageToBuffer) or dstImage (vkCmdCopyBufferToImage) is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then imageOffset.z must be 0 and imageExtent.depth must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferImageCopy-srcImage-00201)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01190", "If buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex must both be VK_QUEUE_FAMILY_IGNORED (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01190)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01191", "If buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01191)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01192", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, srcQueueFamilyIndex and dstQueueFamilyIndex must either both be VK_QUEUE_FAMILY_IGNORED, or both be a valid queue family (see Queue Family Properties) (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01192)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01193", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE and srcQueueFamilyIndex is VK_QUEUE_FAMILY_IGNORED, dstQueueFamilyIndex must also be VK_QUEUE_FAMILY_IGNORED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01193)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01196", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not VK_QUEUE_FAMILY_IGNORED, at least one of them must be the same as the family of the queue that will execute this barrier (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01196)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01763", "If buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, and one of srcQueueFamilyIndex and dstQueueFamilyIndex is VK_QUEUE_FAMILY_IGNORED, the other must be VK_QUEUE_FAMILY_IGNORED or a special queue family reserved for external memory ownership transfers, as described in Queue Family Ownership Transfer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01763)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01764", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE and srcQueueFamilyIndex is not VK_QUEUE_FAMILY_IGNORED, it must be a valid queue family or a special queue family reserved for external memory transfers, as described in Queue Family Ownership Transfer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01764)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01765", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE and dstQueueFamilyIndex is not VK_QUEUE_FAMILY_IGNORED, it must be a valid queue family or a special queue family reserved for external memory transfers, as described in Queue Family Ownership Transfer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01765)"},
    {"VUID-VkBufferMemoryBarrier-buffer-01931", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-01931)"},
    {"VUID-VkBufferMemoryBarrier-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-buffer-parameter)"},
    {"VUID-VkBufferMemoryBarrier-offset-01187", "offset must be less than the size of buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-offset-01187)"},
    {"VUID-VkBufferMemoryBarrier-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-pNext-pNext)"},
    {"VUID-VkBufferMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-sType-sType)"},
    {"VUID-VkBufferMemoryBarrier-size-01188", "If size is not equal to VK_WHOLE_SIZE, size must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-size-01188)"},
    {"VUID-VkBufferMemoryBarrier-size-01189", "If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryBarrier-size-01189)"},
    {"VUID-VkBufferMemoryRequirementsInfo2-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryRequirementsInfo2-buffer-parameter)"},
    {"VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext)"},
    {"VUID-VkBufferMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferMemoryRequirementsInfo2-sType-sType)"},
    {"VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType)"},
    {"VUID-VkBufferViewCreateInfo-buffer-00932", "buffer must have been created with a usage value containing at least one of VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT or VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-buffer-00932)"},
    {"VUID-VkBufferViewCreateInfo-buffer-00933", "If buffer was created with usage containing VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, format must be supported for uniform texel buffers, as specified by the VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT flag in VkFormatProperties::bufferFeatures returned by vkGetPhysicalDeviceFormatProperties (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-buffer-00933)"},
    {"VUID-VkBufferViewCreateInfo-buffer-00934", "If buffer was created with usage containing VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, format must be supported for storage texel buffers, as specified by the VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT flag in VkFormatProperties::bufferFeatures returned by vkGetPhysicalDeviceFormatProperties (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-buffer-00934)"},
    {"VUID-VkBufferViewCreateInfo-buffer-00935", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-buffer-00935)"},
    {"VUID-VkBufferViewCreateInfo-buffer-02750", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::storageTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::storageTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-buffer-02750)"},
    {"VUID-VkBufferViewCreateInfo-buffer-02751", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::uniformTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT::uniformTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-buffer-02751)"},
    {"VUID-VkBufferViewCreateInfo-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-buffer-parameter)"},
    {"VUID-VkBufferViewCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-flags-zerobitmask)"},
    {"VUID-VkBufferViewCreateInfo-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-format-parameter)"},
    {"VUID-VkBufferViewCreateInfo-offset-00925", "offset must be less than the size of buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-offset-00925)"},
    {"VUID-VkBufferViewCreateInfo-offset-00926", "offset must be a multiple of VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-offset-00926)"},
    {"VUID-VkBufferViewCreateInfo-offset-00931", "If range is not equal to VK_WHOLE_SIZE, the sum of offset and range must be less than or equal to the size of buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-offset-00931)"},
    {"VUID-VkBufferViewCreateInfo-offset-02749", "If the texelBufferAlignment feature is not enabled, offset must be a multiple of VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-offset-02749)"},
    {"VUID-VkBufferViewCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-pNext-pNext)"},
    {"VUID-VkBufferViewCreateInfo-range-00928", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-range-00928)"},
    {"VUID-VkBufferViewCreateInfo-range-00929", "If range is not equal to VK_WHOLE_SIZE, range must be an integer multiple of the texel block size of format (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-range-00929)"},
    {"VUID-VkBufferViewCreateInfo-range-00930", "If range is not equal to VK_WHOLE_SIZE, range divided by the texel block size of format, multiplied by the number of texels per texel block for that format (as defined in the Compatible Formats table), must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-range-00930)"},
    {"VUID-VkBufferViewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkBufferViewCreateInfo-sType-sType)"},
    {"VUID-VkCalibratedTimestampInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCalibratedTimestampInfoEXT-pNext-pNext)"},
    {"VUID-VkCalibratedTimestampInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCalibratedTimestampInfoEXT-sType-sType)"},
    {"VUID-VkCalibratedTimestampInfoEXT-timeDomain-02354", "timeDomain must be one of the VkTimeDomainEXT values returned by vkGetPhysicalDeviceCalibrateableTimeDomainsEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCalibratedTimestampInfoEXT-timeDomain-02354)"},
    {"VUID-VkCalibratedTimestampInfoEXT-timeDomain-parameter", "timeDomain must be a valid VkTimeDomainEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCalibratedTimestampInfoEXT-timeDomain-parameter)"},
    {"VUID-VkCheckpointDataNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCheckpointDataNV-pNext-pNext)"},
    {"VUID-VkCheckpointDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCheckpointDataNV-sType-sType)"},
    {"VUID-VkClearAttachment-aspectMask-00019", "If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, it must not include VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkClearAttachment-aspectMask-00019)"},
    {"VUID-VkClearAttachment-aspectMask-00020", "aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkClearAttachment-aspectMask-00020)"},
    {"VUID-VkClearAttachment-aspectMask-02246", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkClearAttachment-aspectMask-02246)"},
    {"VUID-VkClearAttachment-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkClearAttachment-aspectMask-parameter)"},
    {"VUID-VkClearAttachment-aspectMask-requiredbitmask", "aspectMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkClearAttachment-aspectMask-requiredbitmask)"},
    {"VUID-VkClearAttachment-clearValue-00021", "clearValue must be a valid VkClearValue union (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkClearAttachment-clearValue-00021)"},
    {"VUID-VkClearDepthStencilValue-depth-00022", "Unless the VK_EXT_depth_range_unrestricted extension is enabled depth must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkClearDepthStencilValue-depth-00022)"},
    {"VUID-VkClearDepthStencilValue-depth-02506", "depth must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkClearDepthStencilValue-depth-02506)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-commonparent", "Each of indirectCommandsLayout, objectTable, sequencesCountBuffer, sequencesIndexBuffer, and targetCommandBuffer that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-commonparent)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNVX handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-indirectCommandsLayout-parameter)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-indirectCommandsTokenCount-01332", "indirectCommandsTokenCount must match the indirectCommandsLayout's tokenCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-indirectCommandsTokenCount-01332)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-indirectCommandsTokenCount-arraylength", "indirectCommandsTokenCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-indirectCommandsTokenCount-arraylength)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-objectTable-01331", "The provided objectTable must include all objects referenced by the generation process (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-objectTable-01331)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-objectTable-parameter", "objectTable must be a valid VkObjectTableNVX handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-objectTable-parameter)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-pIndirectCommandsTokens-parameter", "pIndirectCommandsTokens must be a valid pointer to an array of indirectCommandsTokenCount valid VkIndirectCommandsTokenNVX structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-pIndirectCommandsTokens-parameter)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-pNext-pNext)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CMD_PROCESS_COMMANDS_INFO_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-sType-sType)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-sequencesCountBuffer-01338", "If sequencesCountBuffer is used, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-sequencesCountBuffer-01338)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-sequencesCountBuffer-01339", "If sequencesCountBuffer is used, sequencesCountOffset must be aligned to VkDeviceGeneratedCommandsLimitsNVX::minSequenceCountBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-sequencesCountBuffer-01339)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-sequencesCountBuffer-parameter", "If sequencesCountBuffer is not VK_NULL_HANDLE, sequencesCountBuffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-sequencesCountBuffer-parameter)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-sequencesIndexBuffer-01340", "If sequencesIndexBuffer is used, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-sequencesIndexBuffer-01340)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-sequencesIndexBuffer-01341", "If sequencesIndexBuffer is used, sequencesIndexOffset must be aligned to VkDeviceGeneratedCommandsLimitsNVX::minSequenceIndexBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-sequencesIndexBuffer-01341)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-sequencesIndexBuffer-parameter", "If sequencesIndexBuffer is not VK_NULL_HANDLE, sequencesIndexBuffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-sequencesIndexBuffer-parameter)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01334", "If targetCommandBuffer is provided, it must have reserved command space (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01334)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01335", "If targetCommandBuffer is provided, the objectTable must match the reservation's objectTable and must have had all referenced objects registered at reservation time (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01335)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01336", "If targetCommandBuffer is provided, the indirectCommandsLayout must match the reservation's indirectCommandsLayout (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01336)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01337", "If targetCommandBuffer is provided, the maxSequencesCount must not exceed the reservation's maxSequencesCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-01337)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-parameter", "If targetCommandBuffer is not NULL, targetCommandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-targetCommandBuffer-parameter)"},
    {"VUID-VkCmdProcessCommandsInfoNVX-tokenType-01333", "The tokenType member of each entry in the pIndirectCommandsTokens array must match the values used at creation time of indirectCommandsLayout (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdProcessCommandsInfoNVX-tokenType-01333)"},
    {"VUID-VkCmdReserveSpaceForCommandsInfoNVX-commonparent", "Both of indirectCommandsLayout, and objectTable must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdReserveSpaceForCommandsInfoNVX-commonparent)"},
    {"VUID-VkCmdReserveSpaceForCommandsInfoNVX-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNVX handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdReserveSpaceForCommandsInfoNVX-indirectCommandsLayout-parameter)"},
    {"VUID-VkCmdReserveSpaceForCommandsInfoNVX-objectTable-parameter", "objectTable must be a valid VkObjectTableNVX handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdReserveSpaceForCommandsInfoNVX-objectTable-parameter)"},
    {"VUID-VkCmdReserveSpaceForCommandsInfoNVX-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdReserveSpaceForCommandsInfoNVX-pNext-pNext)"},
    {"VUID-VkCmdReserveSpaceForCommandsInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CMD_RESERVE_SPACE_FOR_COMMANDS_INFO_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCmdReserveSpaceForCommandsInfoNVX-sType-sType)"},
    {"VUID-VkCoarseSampleLocationNV-pixelX-02078", "pixelX must be less than the width (in pixels) of the fragment. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleLocationNV-pixelX-02078)"},
    {"VUID-VkCoarseSampleLocationNV-pixelY-02079", "pixelY must be less than the height (in pixels) of the fragment. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleLocationNV-pixelY-02079)"},
    {"VUID-VkCoarseSampleLocationNV-sample-02080", "sample must be less than the number of coverage samples in each pixel belonging to the fragment. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleLocationNV-sample-02080)"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-02077", "The array pSampleLocations must contain exactly one entry for every combination of valid values for pixelX, pixelY, and sample in the structure VkCoarseSampleOrderCustomNV. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-02077)"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter", "pSampleLocations must be a valid pointer to an array of sampleLocationCount VkCoarseSampleLocationNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter)"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleCount-02074", "sampleCount must correspond to a sample count enumerated in VkSampleCountFlags whose corresponding bit is set in VkPhysicalDeviceLimits::framebufferNoAttachmentsSampleCounts. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-sampleCount-02074)"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02075", "sampleLocationCount must be equal to the product of sampleCount, the fragment width for shadingRate, and the fragment height for shadingRate. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02075)"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02076", "sampleLocationCount must be less than or equal to the value of VkPhysicalDeviceShadingRateImagePropertiesNV::shadingRateMaxCoarseSamples. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02076)"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength", "sampleLocationCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength)"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-02073", "shadingRate must be a shading rate that generates fragments with more than one pixel. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-shadingRate-02073)"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter", "shadingRate must be a valid VkShadingRatePaletteEntryNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter)"},
    {"VUID-VkCommandBufferAllocateInfo-commandBufferCount-00044", "commandBufferCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferAllocateInfo-commandBufferCount-00044)"},
    {"VUID-VkCommandBufferAllocateInfo-commandPool-parameter", "commandPool must be a valid VkCommandPool handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferAllocateInfo-commandPool-parameter)"},
    {"VUID-VkCommandBufferAllocateInfo-level-parameter", "level must be a valid VkCommandBufferLevel value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferAllocateInfo-level-parameter)"},
    {"VUID-VkCommandBufferAllocateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferAllocateInfo-pNext-pNext)"},
    {"VUID-VkCommandBufferAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferAllocateInfo-sType-sType)"},
    {"VUID-VkCommandBufferBeginInfo-flags-00053", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the renderPass member of pInheritanceInfo must be a valid VkRenderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferBeginInfo-flags-00053)"},
    {"VUID-VkCommandBufferBeginInfo-flags-00054", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the subpass member of pInheritanceInfo must be a valid subpass index within the renderPass member of pInheritanceInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferBeginInfo-flags-00054)"},
    {"VUID-VkCommandBufferBeginInfo-flags-00055", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the framebuffer member of pInheritanceInfo must be either VK_NULL_HANDLE, or a valid VkFramebuffer that is compatible with the renderPass member of pInheritanceInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferBeginInfo-flags-00055)"},
    {"VUID-VkCommandBufferBeginInfo-flags-parameter", "flags must be a valid combination of VkCommandBufferUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferBeginInfo-flags-parameter)"},
    {"VUID-VkCommandBufferBeginInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceGroupCommandBufferBeginInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferBeginInfo-pNext-pNext)"},
    {"VUID-VkCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferBeginInfo-sType-sType)"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-conditionalRenderingEnable-01977", "If the inherited conditional rendering feature is not enabled, conditionalRenderingEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-conditionalRenderingEnable-01977)"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType)"},
    {"VUID-VkCommandBufferInheritanceInfo-commonparent", "Both of framebuffer, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-commonparent)"},
    {"VUID-VkCommandBufferInheritanceInfo-occlusionQueryEnable-00056", "If the inherited queries feature is not enabled, occlusionQueryEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-occlusionQueryEnable-00056)"},
    {"VUID-VkCommandBufferInheritanceInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCommandBufferInheritanceConditionalRenderingInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-pNext-pNext)"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-00058", "If the pipeline statistics queries feature is not enabled, pipelineStatistics must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-00058)"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-02789", "If the pipeline statistics queries feature is enabled, pipelineStatistics must be a valid combination of VkQueryPipelineStatisticFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-02789)"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-00057", "If the inherited queries feature is enabled, queryFlags must be a valid combination of VkQueryControlFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-queryFlags-00057)"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-02788", "If the inherited queries feature is not enabled, queryFlags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-queryFlags-02788)"},
    {"VUID-VkCommandBufferInheritanceInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandBufferInheritanceInfo-sType-sType)"},
    {"VUID-VkCommandPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkCommandPoolCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandPoolCreateInfo-flags-parameter)"},
    {"VUID-VkCommandPoolCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandPoolCreateInfo-pNext-pNext)"},
    {"VUID-VkCommandPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCommandPoolCreateInfo-sType-sType)"},
    {"VUID-VkComponentMapping-a-parameter", "a must be a valid VkComponentSwizzle value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComponentMapping-a-parameter)"},
    {"VUID-VkComponentMapping-b-parameter", "b must be a valid VkComponentSwizzle value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComponentMapping-b-parameter)"},
    {"VUID-VkComponentMapping-g-parameter", "g must be a valid VkComponentSwizzle value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComponentMapping-g-parameter)"},
    {"VUID-VkComponentMapping-r-parameter", "r must be a valid VkComponentSwizzle value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComponentMapping-r-parameter)"},
    {"VUID-VkComputePipelineCreateInfo-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-commonparent)"},
    {"VUID-VkComputePipelineCreateInfo-flags-00697", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid handle to a compute VkPipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-flags-00697)"},
    {"VUID-VkComputePipelineCreateInfo-flags-00698", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-flags-00698)"},
    {"VUID-VkComputePipelineCreateInfo-flags-00699", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is not -1, basePipelineHandle must be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-flags-00699)"},
    {"VUID-VkComputePipelineCreateInfo-flags-00700", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is not VK_NULL_HANDLE, basePipelineIndex must be -1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-flags-00700)"},
    {"VUID-VkComputePipelineCreateInfo-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-flags-parameter)"},
    {"VUID-VkComputePipelineCreateInfo-layout-00703", "layout must be consistent with the layout of the compute shader specified in stage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-layout-00703)"},
    {"VUID-VkComputePipelineCreateInfo-layout-01687", "The number of resources in layout accessible to the compute shader stage must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-layout-01687)"},
    {"VUID-VkComputePipelineCreateInfo-layout-parameter", "layout must be a valid VkPipelineLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-layout-parameter)"},
    {"VUID-VkComputePipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCompilerControlCreateInfoAMD or VkPipelineCreationFeedbackCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-pNext-pNext)"},
    {"VUID-VkComputePipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-sType-sType)"},
    {"VUID-VkComputePipelineCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-sType-unique)"},
    {"VUID-VkComputePipelineCreateInfo-stage-00701", "The stage member of stage must be VK_SHADER_STAGE_COMPUTE_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-stage-00701)"},
    {"VUID-VkComputePipelineCreateInfo-stage-00702", "The shader code for the entry point identified by stage and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-stage-00702)"},
    {"VUID-VkComputePipelineCreateInfo-stage-parameter", "stage must be a valid VkPipelineShaderStageCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkComputePipelineCreateInfo-stage-parameter)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01981", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-buffer-01981)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01982", "buffer must have been created with the VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-buffer-01982)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-buffer-parameter)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-flags-parameter", "flags must be a valid combination of VkConditionalRenderingFlagBitsEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-flags-parameter)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01983", "offset must be less than the size of buffer by at least 32 bits. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-offset-01983)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01984", "offset must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-offset-01984)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-pNext-pNext)"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkConditionalRenderingBeginInfoEXT-sType-sType)"},
    {"VUID-VkCooperativeMatrixPropertiesNV-AType-parameter", "AType must be a valid VkComponentTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCooperativeMatrixPropertiesNV-AType-parameter)"},
    {"VUID-VkCooperativeMatrixPropertiesNV-BType-parameter", "BType must be a valid VkComponentTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCooperativeMatrixPropertiesNV-BType-parameter)"},
    {"VUID-VkCooperativeMatrixPropertiesNV-CType-parameter", "CType must be a valid VkComponentTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCooperativeMatrixPropertiesNV-CType-parameter)"},
    {"VUID-VkCooperativeMatrixPropertiesNV-DType-parameter", "DType must be a valid VkComponentTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCooperativeMatrixPropertiesNV-DType-parameter)"},
    {"VUID-VkCooperativeMatrixPropertiesNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCooperativeMatrixPropertiesNV-pNext-pNext)"},
    {"VUID-VkCooperativeMatrixPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCooperativeMatrixPropertiesNV-sType-sType)"},
    {"VUID-VkCooperativeMatrixPropertiesNV-scope-parameter", "scope must be a valid VkScopeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCooperativeMatrixPropertiesNV-scope-parameter)"},
    {"VUID-VkCopyDescriptorSet-commonparent", "Both of dstSet, and srcSet must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-commonparent)"},
    {"VUID-VkCopyDescriptorSet-dstArrayElement-00348", "The sum of dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by dstBinding, and all applicable consecutive bindings, as described by consecutive binding updates (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-dstArrayElement-00348)"},
    {"VUID-VkCopyDescriptorSet-dstBinding-00347", "dstBinding must be a valid binding within dstSet (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-dstBinding-00347)"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02224", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, dstArrayElement must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-dstBinding-02224)"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02632", "The type of dstBinding within dstSet must be equal to the type of srcBinding within srcSet (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-dstBinding-02632)"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02753", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_SAMPLER, then dstSet must not have been allocated with a layout that included immutable samplers for dstBinding (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-dstBinding-02753)"},
    {"VUID-VkCopyDescriptorSet-dstSet-parameter", "dstSet must be a valid VkDescriptorSet handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-dstSet-parameter)"},
    {"VUID-VkCopyDescriptorSet-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-pNext-pNext)"},
    {"VUID-VkCopyDescriptorSet-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-sType-sType)"},
    {"VUID-VkCopyDescriptorSet-srcArrayElement-00346", "The sum of srcArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by srcBinding, and all applicable consecutive bindings, as described by consecutive binding updates (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcArrayElement-00346)"},
    {"VUID-VkCopyDescriptorSet-srcBinding-00345", "srcBinding must be a valid binding within srcSet (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcBinding-00345)"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02223", "If the descriptor type of the descriptor set binding specified by srcBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, srcArrayElement must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcBinding-02223)"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02225", "If the descriptor type of the descriptor set binding specified by either srcBinding or dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, descriptorCount must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcBinding-02225)"},
    {"VUID-VkCopyDescriptorSet-srcSet-00349", "If srcSet is equal to dstSet, then the source and destination ranges of descriptors must not overlap, where the ranges may include array elements from consecutive bindings as described by consecutive binding updates (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcSet-00349)"},
    {"VUID-VkCopyDescriptorSet-srcSet-01918", "If srcSet's layout was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must also have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcSet-01918)"},
    {"VUID-VkCopyDescriptorSet-srcSet-01919", "If srcSet's layout was created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must also have been created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcSet-01919)"},
    {"VUID-VkCopyDescriptorSet-srcSet-01920", "If the descriptor pool from which srcSet was allocated was created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must also have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcSet-01920)"},
    {"VUID-VkCopyDescriptorSet-srcSet-01921", "If the descriptor pool from which srcSet was allocated was created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must also have been created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcSet-01921)"},
    {"VUID-VkCopyDescriptorSet-srcSet-parameter", "srcSet must be a valid VkDescriptorSet handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkCopyDescriptorSet-srcSet-parameter)"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pSignalSemaphoreValues-parameter", "If signalSemaphoreValuesCount is not 0, and pSignalSemaphoreValues is not NULL, pSignalSemaphoreValues must be a valid pointer to an array of signalSemaphoreValuesCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkD3D12FenceSubmitInfoKHR-pSignalSemaphoreValues-parameter)"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pWaitSemaphoreValues-parameter", "If waitSemaphoreValuesCount is not 0, and pWaitSemaphoreValues is not NULL, pWaitSemaphoreValues must be a valid pointer to an array of waitSemaphoreValuesCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkD3D12FenceSubmitInfoKHR-pWaitSemaphoreValues-parameter)"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkD3D12FenceSubmitInfoKHR-sType-sType)"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-signalSemaphoreValuesCount-00080", "signalSemaphoreValuesCount must be the same value as VkSubmitInfo::signalSemaphoreCount, where VkSubmitInfo is in the pNext chain of this VkD3D12FenceSubmitInfoKHR structure. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkD3D12FenceSubmitInfoKHR-signalSemaphoreValuesCount-00080)"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-waitSemaphoreValuesCount-00079", "waitSemaphoreValuesCount must be the same value as VkSubmitInfo::waitSemaphoreCount, where VkSubmitInfo is in the pNext chain of this VkD3D12FenceSubmitInfoKHR structure. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkD3D12FenceSubmitInfoKHR-waitSemaphoreValuesCount-00079)"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pMarkerName-parameter", "pMarkerName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerMarkerInfoEXT-pMarkerName-parameter)"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerMarkerInfoEXT-pNext-pNext)"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerMarkerInfoEXT-sType-sType)"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01491", "object must not be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectNameInfoEXT-object-01491)"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01492", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectNameInfoEXT-object-01492)"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-01490", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectNameInfoEXT-objectType-01490)"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectNameInfoEXT-objectType-parameter)"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectNameInfoEXT-pNext-pNext)"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pObjectName-parameter", "pObjectName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectNameInfoEXT-pObjectName-parameter)"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectNameInfoEXT-sType-sType)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01494", "object must not be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-object-01494)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01495", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-object-01495)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-01493", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-objectType-01493)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-objectType-parameter)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-pNext-pNext)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-pTag-parameter)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-sType-sType)"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugMarkerObjectTagInfoEXT-tagSize-arraylength)"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter", "flags must be a valid combination of VkDebugReportFlagBitsEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter)"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter", "pfnCallback must be a valid PFN_vkDebugReportCallbackEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter)"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType)"},
    {"VUID-VkDebugUtilsLabelEXT-pLabelName-parameter", "pLabelName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsLabelEXT-pLabelName-parameter)"},
    {"VUID-VkDebugUtilsLabelEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsLabelEXT-pNext-pNext)"},
    {"VUID-VkDebugUtilsLabelEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsLabelEXT-sType-sType)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-flags-zerobitmask)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pCmdBufLabels-parameter", "If cmdBufLabelCount is not 0, pCmdBufLabels must be a valid pointer to an array of cmdBufLabelCount valid VkDebugUtilsLabelEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-pCmdBufLabels-parameter)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessage-parameter", "pMessage must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessage-parameter)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessageIdName-parameter", "If pMessageIdName is not NULL, pMessageIdName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessageIdName-parameter)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-pNext-pNext)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pObjects-parameter", "If objectCount is not 0, pObjects must be a valid pointer to an array of objectCount valid VkDebugUtilsObjectNameInfoEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-pObjects-parameter)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pQueueLabels-parameter", "If queueLabelCount is not 0, pQueueLabels must be a valid pointer to an array of queueLabelCount valid VkDebugUtilsLabelEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-pQueueLabels-parameter)"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-sType)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter", "messageSeverity must be a valid combination of VkDebugUtilsMessageSeverityFlagBitsEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask", "messageSeverity must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter", "messageType must be a valid combination of VkDebugUtilsMessageTypeFlagBitsEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask", "messageType must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-01914", "pfnUserCallback must be a valid PFN_vkDebugUtilsMessengerCallbackEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-01914)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter", "pfnUserCallback must be a valid PFN_vkDebugUtilsMessengerCallbackEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter)"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType)"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02589", "If objectType is VK_OBJECT_TYPE_UNKNOWN, objectHandle must not be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02589)"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02590", "If objectType is not VK_OBJECT_TYPE_UNKNOWN, objectHandle must be VK_NULL_HANDLE or a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02590)"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter)"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectNameInfoEXT-pNext-pNext)"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-pObjectName-parameter", "If pObjectName is not NULL, pObjectName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectNameInfoEXT-pObjectName-parameter)"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType)"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectHandle-01910", "objectHandle must be a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectTagInfoEXT-objectHandle-01910)"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-01908", "objectType must not be VK_OBJECT_TYPE_UNKNOWN (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectTagInfoEXT-objectType-01908)"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectTagInfoEXT-objectType-parameter)"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectTagInfoEXT-pNext-pNext)"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectTagInfoEXT-pTag-parameter)"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectTagInfoEXT-sType-sType)"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDebugUtilsObjectTagInfoEXT-tagSize-arraylength)"},
    {"VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType)"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-dedicatedAllocation-00994", "If dedicatedAllocation is VK_TRUE, VkImageCreateInfo::flags must not include VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationImageCreateInfoNV-dedicatedAllocation-00994)"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00651", "If buffer is not VK_NULL_HANDLE, the buffer must have been created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00651)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00653", "If buffer is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00653)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00655", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00655)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-parameter)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-commonparent", "Both of buffer, and image that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-commonparent)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00649", "At least one of image and buffer must be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00649)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00650", "If image is not VK_NULL_HANDLE, the image must have been created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00650)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00652", "If image is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00652)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00654", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00654)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-parameter)"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType)"},
    {"VUID-VkDescriptorBufferInfo-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorBufferInfo-buffer-parameter)"},
    {"VUID-VkDescriptorBufferInfo-offset-00340", "offset must be less than the size of buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorBufferInfo-offset-00340)"},
    {"VUID-VkDescriptorBufferInfo-range-00341", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorBufferInfo-range-00341)"},
    {"VUID-VkDescriptorBufferInfo-range-00342", "If range is not equal to VK_WHOLE_SIZE, range must be less than or equal to the size of buffer minus offset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorBufferInfo-range-00342)"},
    {"VUID-VkDescriptorImageInfo-commonparent", "Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorImageInfo-commonparent)"},
    {"VUID-VkDescriptorImageInfo-imageLayout-00344", "imageLayout must match the actual VkImageLayout of each subresource accessible from imageView at the time this descriptor is accessed as defined by the image layout matching rules (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorImageInfo-imageLayout-00344)"},
    {"VUID-VkDescriptorImageInfo-imageView-00343", "imageView must not be 2D or 2D array image view created from a 3D image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorImageInfo-imageView-00343)"},
    {"VUID-VkDescriptorImageInfo-imageView-01976", "If imageView is created from a depth/stencil image, the aspectMask used to create the imageView must include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT but not both. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorImageInfo-imageView-01976)"},
    {"VUID-VkDescriptorImageInfo-sampler-01564", "If sampler is used and the VkFormat of the image is a multi-planar format, the image must have been created with VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, and the aspectMask of the imageView must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT or (for three-plane formats only) VK_IMAGE_ASPECT_PLANE_2_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorImageInfo-sampler-01564)"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorPoolCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolCreateInfo-flags-parameter)"},
    {"VUID-VkDescriptorPoolCreateInfo-maxSets-00301", "maxSets must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolCreateInfo-maxSets-00301)"},
    {"VUID-VkDescriptorPoolCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorPoolInlineUniformBlockCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolCreateInfo-pNext-pNext)"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter", "pPoolSizes must be a valid pointer to an array of poolSizeCount valid VkDescriptorPoolSize structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter)"},
    {"VUID-VkDescriptorPoolCreateInfo-poolSizeCount-arraylength", "poolSizeCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolCreateInfo-poolSizeCount-arraylength)"},
    {"VUID-VkDescriptorPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolCreateInfo-sType-sType)"},
    {"VUID-VkDescriptorPoolInlineUniformBlockCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolInlineUniformBlockCreateInfoEXT-sType-sType)"},
    {"VUID-VkDescriptorPoolSize-descriptorCount-00302", "descriptorCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolSize-descriptorCount-00302)"},
    {"VUID-VkDescriptorPoolSize-type-02218", "If type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT then descriptorCount must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolSize-type-02218)"},
    {"VUID-VkDescriptorPoolSize-type-parameter", "type must be a valid VkDescriptorType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorPoolSize-type-parameter)"},
    {"VUID-VkDescriptorSetAllocateInfo-commonparent", "Both of descriptorPool, and the elements of pSetLayouts must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-commonparent)"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorPool-00307", "descriptorPool must have enough free descriptor capacity remaining to allocate the descriptor sets of the specified layouts (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-descriptorPool-00307)"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorPool-parameter", "descriptorPool must be a valid VkDescriptorPool handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-descriptorPool-parameter)"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-00306", "descriptorSetCount must not be greater than the number of sets that are currently available for allocation in descriptorPool (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-00306)"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-arraylength", "descriptorSetCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-arraylength)"},
    {"VUID-VkDescriptorSetAllocateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountAllocateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-pNext-pNext)"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-00308", "Each element of pSetLayouts must not have been created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-pSetLayouts-00308)"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-03044", "If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-pSetLayouts-03044)"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-parameter", "pSetLayouts must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSetLayout handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-pSetLayouts-parameter)"},
    {"VUID-VkDescriptorSetAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetAllocateInfo-sType-sType)"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorCount-00283", "If descriptorCount is not 0, stageFlags must be a valid combination of VkShaderStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBinding-descriptorCount-00283)"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-00282", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and descriptorCount is not 0 and pImmutableSamplers is not NULL, pImmutableSamplers must be a valid pointer to an array of descriptorCount valid VkSampler handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBinding-descriptorType-00282)"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-01510", "If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT and descriptorCount is not 0, then stageFlags must be 0 or VK_SHADER_STAGE_FRAGMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBinding-descriptorType-01510)"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-02209", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT then descriptorCount must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBinding-descriptorType-02209)"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-02210", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT then descriptorCount must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxInlineUniformBlockSize (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBinding-descriptorType-02210)"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-None-03011", "All bindings with descriptor type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-None-03011)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-bindingCount-03002", "If bindingCount is not zero, bindingCount must equal VkDescriptorSetLayoutCreateInfo::bindingCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-bindingCount-03002)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingInlineUniformBlockUpdateAfterBind-02211", "If VkPhysicalDeviceInlineUniformBlockFeaturesEXT::descriptorBindingInlineUniformBlockUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingInlineUniformBlockUpdateAfterBind-02211)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingPartiallyBound-03013", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingPartiallyBound is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingPartiallyBound-03013)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingSampledImageUpdateAfterBind-03006", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingSampledImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_SAMPLER, VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, or VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingSampledImageUpdateAfterBind-03006)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageBufferUpdateAfterBind-03008", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageBufferUpdateAfterBind-03008)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageImageUpdateAfterBind-03007", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageImageUpdateAfterBind-03007)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTexelBufferUpdateAfterBind-03010", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTexelBufferUpdateAfterBind-03010)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformBufferUpdateAfterBind-03005", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformBufferUpdateAfterBind-03005)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformTexelBufferUpdateAfterBind-03009", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformTexelBufferUpdateAfterBind-03009)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUpdateUnusedWhilePending-03012", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUpdateUnusedWhilePending is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUpdateUnusedWhilePending-03012)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingVariableDescriptorCount-03014", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingVariableDescriptorCount is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingVariableDescriptorCount-03014)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-flags-03003", "If VkDescriptorSetLayoutCreateInfo::flags includes VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT, VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT, or VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-flags-03003)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03004", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, then all other elements of VkDescriptorSetLayoutCreateInfo::pBindings must have a smaller value of binding (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03004)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03015", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, that element's descriptorType must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03015)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-parameter", "If bindingCount is not 0, and pBindingFlags is not NULL, pBindingFlags must be a valid pointer to an array of bindingCount valid combinations of VkDescriptorBindingFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-parameter)"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-binding-00279", "The VkDescriptorSetLayoutBinding::binding members of the elements of the pBindings array must each have different values. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-binding-00279)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-03001", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, then all bindings must not have descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-03001)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00280", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-flags-00280)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00281", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then the total number of elements of all bindings must be less than or equal to VkPhysicalDevicePushDescriptorPropertiesKHR::maxPushDescriptors (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-flags-00281)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-02208", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-flags-02208)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-03000", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, flags must include VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-flags-03000)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorSetLayoutCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter", "If bindingCount is not 0, pBindings must be a valid pointer to an array of bindingCount valid VkDescriptorSetLayoutBinding structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetLayoutBindingFlagsCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext)"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutCreateInfo-sType-sType)"},
    {"VUID-VkDescriptorSetLayoutSupport-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountLayoutSupport (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutSupport-pNext-pNext)"},
    {"VUID-VkDescriptorSetLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetLayoutSupport-sType-sType)"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-descriptorSetCount-03045", "If descriptorSetCount is not zero, descriptorSetCount must equal VkDescriptorSetAllocateInfo::descriptorSetCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-descriptorSetCount-03045)"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter", "If descriptorSetCount is not 0, pDescriptorCounts must be a valid pointer to an array of descriptorSetCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter)"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pSetLayouts-03046", "If VkDescriptorSetAllocateInfo::pSetLayouts[i] has a variable descriptor count binding, then pDescriptorCounts[i] must be less than or equal to the descriptor count specified for that binding when the descriptor set layout was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pSetLayouts-03046)"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType)"},
    {"VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-commonparent", "Both of descriptorSetLayout, and pipelineLayout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-commonparent)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength", "descriptorUpdateEntryCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter", "pDescriptorUpdateEntries must be a valid pointer to an array of descriptorUpdateEntryCount valid VkDescriptorUpdateTemplateEntry structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00350", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must be a valid VkDescriptorSetLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00350)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00351", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, pipelineBindPoint must be a valid VkPipelineBindPoint value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00351)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00352", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, pipelineLayout must be a valid VkPipelineLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00352)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00353", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR, set must be the unique set number in the pipeline layout that uses a descriptor set layout that was created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00353)"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter", "templateType must be a valid VkDescriptorUpdateTemplateType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter)"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02226", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, dstArrayElement must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateEntry-descriptor-02226)"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02227", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, descriptorCount must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateEntry-descriptor-02227)"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter)"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstArrayElement-00355", "dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding implicitly specified when using a descriptor update template to update descriptors, and all applicable consecutive bindings, as described by consecutive binding updates (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateEntry-dstArrayElement-00355)"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstBinding-00354", "dstBinding must be a valid binding in the descriptor set layout implicitly specified when using a descriptor update template to update descriptors. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDescriptorUpdateTemplateEntry-dstBinding-00354)"},
    {"VUID-VkDeviceCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-flags-zerobitmask)"},
    {"VUID-VkDeviceCreateInfo-pEnabledFeatures-parameter", "If pEnabledFeatures is not NULL, pEnabledFeatures must be a valid pointer to a valid VkPhysicalDeviceFeatures structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-pEnabledFeatures-parameter)"},
    {"VUID-VkDeviceCreateInfo-pNext-00373", "If the pNext chain includes a VkPhysicalDeviceFeatures2 structure, then pEnabledFeatures must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-pNext-00373)"},
    {"VUID-VkDeviceCreateInfo-pNext-02829", "If the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then it must not include a VkPhysicalDevice16BitStorageFeatures, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceSamplerYcbcrConversionFeatures, or VkPhysicalDeviceShaderDrawParametersFeatures structure (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkDeviceCreateInfo-pNext-02829)"},
    {"VUID-VkDeviceCreateInfo-pNext-02830", "If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then it must not include a VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceBufferDeviceAddressFeatures, or VkPhysicalDeviceVulkanMemoryModelFeatures structure (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkDeviceCreateInfo-pNext-02830)"},
    {"VUID-VkDeviceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupDeviceCreateInfo, VkDeviceMemoryOverallocationCreateInfoAMD, VkPhysicalDevice16BitStorageFeatures, VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceASTCDecodeFeaturesEXT, VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT, VkPhysicalDeviceBufferDeviceAddressFeatures, VkPhysicalDeviceBufferDeviceAddressFeaturesEXT, VkPhysicalDeviceCoherentMemoryFeaturesAMD, VkPhysicalDeviceComputeShaderDerivativesFeaturesNV, VkPhysicalDeviceConditionalRenderingFeaturesEXT, VkPhysicalDeviceCooperativeMatrixFeaturesNV, VkPhysicalDeviceCornerSampledImageFeaturesNV, VkPhysicalDeviceCoverageReductionModeFeaturesNV, VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV, VkPhysicalDeviceDepthClipEnableFeaturesEXT, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceExclusiveScissorFeaturesNV, VkPhysicalDeviceFeatures2, VkPhysicalDeviceFragmentDensityMapFeaturesEXT, VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceIndexTypeUint8FeaturesEXT, VkPhysicalDeviceInlineUniformBlockFeaturesEXT, VkPhysicalDeviceLineRasterizationFeaturesEXT, VkPhysicalDeviceMemoryPriorityFeaturesEXT, VkPhysicalDeviceMeshShaderFeaturesNV, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDevicePerformanceQueryFeaturesKHR, VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV, VkPhysicalDeviceSamplerYcbcrConversionFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderClockFeaturesKHR, VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT, VkPhysicalDeviceShaderDrawParametersFeatures, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceShaderImageFootprintFeaturesNV, VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL, VkPhysicalDeviceShaderSMBuiltinsFeaturesNV, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceShadingRateImageFeaturesNV, VkPhysicalDeviceSubgroupSizeControlFeaturesEXT, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT, VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceTransformFeedbackFeaturesEXT, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT, VkPhysicalDeviceVulkan11Features, VkPhysicalDeviceVulkan12Features, VkPhysicalDeviceVulkanMemoryModelFeatures, or VkPhysicalDeviceYcbcrImageArraysFeaturesEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-pNext-pNext)"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter", "pQueueCreateInfos must be a valid pointer to an array of queueCreateInfoCount valid VkDeviceQueueCreateInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-00374", "ppEnabledExtensionNames must not contain both VK_KHR_maintenance1 and VK_AMD_negative_viewport_height (https://www.khronos.org/registry/vulkan/specs/1.0-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-00374)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-01840", "ppEnabledExtensionNames must not contain VK_AMD_negative_viewport_height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-01840)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-03328", "ppEnabledExtensionNames must not contain both VK_KHR_buffer_device_address and VK_EXT_buffer_device_address (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-03328)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter", "If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02831", "If ppEnabledExtensions contains VK_KHR_draw_indirect_count and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::drawIndirectCount must be VK_TRUE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkDeviceCreateInfo-ppEnabledExtensions-02831)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02832", "If ppEnabledExtensions contains VK_KHR_sampler_mirror_clamp_to_edge and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerMirrorClampToEdge must be VK_TRUE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkDeviceCreateInfo-ppEnabledExtensions-02832)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02833", "If ppEnabledExtensions contains VK_EXT_descriptor_indexing and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::descriptorIndexing must be VK_TRUE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkDeviceCreateInfo-ppEnabledExtensions-02833)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02834", "If ppEnabledExtensions contains VK_EXT_sampler_filter_minmax and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerFilterMinmax must be VK_TRUE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkDeviceCreateInfo-ppEnabledExtensions-02834)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensions-02835", "If ppEnabledExtensions contains VK_EXT_shader_viewport_index_layer and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::shaderOutputViewportIndex and VkPhysicalDeviceVulkan12Features::shaderOutputLayer must both be VK_TRUE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkDeviceCreateInfo-ppEnabledExtensions-02835)"},
    {"VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter", "If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter)"},
    {"VUID-VkDeviceCreateInfo-queueCreateInfoCount-arraylength", "queueCreateInfoCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-queueCreateInfoCount-arraylength)"},
    {"VUID-VkDeviceCreateInfo-queueFamilyIndex-00372", "The queueFamilyIndex member of each element of pQueueCreateInfos must be unique within pQueueCreateInfos (https://www.khronos.org/registry/vulkan/specs/1.0-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-queueFamilyIndex-00372)"},
    {"VUID-VkDeviceCreateInfo-queueFamilyIndex-02802", "The queueFamilyIndex member of each element of pQueueCreateInfos must be unique within pQueueCreateInfos, except that two members can share the same queueFamilyIndex if one is a protected-capable queue and one is not a protected-capable queue (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-queueFamilyIndex-02802)"},
    {"VUID-VkDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-sType-sType)"},
    {"VUID-VkDeviceCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceCreateInfo-sType-unique)"},
    {"VUID-VkDeviceEventInfoEXT-deviceEvent-parameter", "deviceEvent must be a valid VkDeviceEventTypeEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceEventInfoEXT-deviceEvent-parameter)"},
    {"VUID-VkDeviceEventInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceEventInfoEXT-pNext-pNext)"},
    {"VUID-VkDeviceEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceEventInfoEXT-sType-sType)"},
    {"VUID-VkDeviceGeneratedCommandsFeaturesNVX-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGeneratedCommandsFeaturesNVX-pNext-pNext)"},
    {"VUID-VkDeviceGeneratedCommandsFeaturesNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_FEATURES_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGeneratedCommandsFeaturesNVX-sType-sType)"},
    {"VUID-VkDeviceGeneratedCommandsLimitsNVX-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGeneratedCommandsLimitsNVX-pNext-pNext)"},
    {"VUID-VkDeviceGeneratedCommandsLimitsNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GENERATED_COMMANDS_LIMITS_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGeneratedCommandsLimitsNVX-sType-sType)"},
    {"VUID-VkDeviceGroupBindSparseInfo-memoryDeviceIndex-01119", "Each memory allocation bound in this batch must have allocated an instance for memoryDeviceIndex. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupBindSparseInfo-memoryDeviceIndex-01119)"},
    {"VUID-VkDeviceGroupBindSparseInfo-resourceDeviceIndex-01118", "resourceDeviceIndex and memoryDeviceIndex must both be valid device indices. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupBindSparseInfo-resourceDeviceIndex-01118)"},
    {"VUID-VkDeviceGroupBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupBindSparseInfo-sType-sType)"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00106", "deviceMask must be a valid device mask value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00106)"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00107", "deviceMask must not be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00107)"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType)"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00375", "Each element of pPhysicalDevices must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00375)"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00376", "All elements of pPhysicalDevices must be in the same device group as enumerated by vkEnumeratePhysicalDeviceGroups (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00376)"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter", "If physicalDeviceCount is not 0, pPhysicalDevices must be a valid pointer to an array of physicalDeviceCount valid VkPhysicalDevice handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter)"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-physicalDeviceCount-00377", "If physicalDeviceCount is not 0, the physicalDevice parameter of vkCreateDevice must be an element of pPhysicalDevices. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupDeviceCreateInfo-physicalDeviceCount-00377)"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupDeviceCreateInfo-sType-sType)"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentCapabilitiesKHR-pNext-pNext)"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentCapabilitiesKHR-sType-sType)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01298", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-mode-01298)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01299", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and some physical device in the logical device must include that bit in its VkDeviceGroupPresentCapabilitiesKHR::presentMask. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-mode-01299)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01300", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, then each element of pDeviceMasks must have a value for which all set bits are set in one of the elements of VkDeviceGroupPresentCapabilitiesKHR::presentMask (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-mode-01300)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01301", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, then for each bit set in each element of pDeviceMasks, the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-mode-01301)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01303", "mode must have exactly one bit set, and that bit must have been included in VkDeviceGroupSwapchainCreateInfoKHR::modes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-mode-01303)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-parameter", "mode must be a valid VkDeviceGroupPresentModeFlagBitsKHR value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-mode-parameter)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-01302", "The value of each element of pDeviceMasks must be equal to the device mask passed in VkAcquireNextImageInfoKHR::deviceMask when the image index was last acquired (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-01302)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter", "If swapchainCount is not 0, pDeviceMasks must be a valid pointer to an array of swapchainCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-sType-sType)"},
    {"VUID-VkDeviceGroupPresentInfoKHR-swapchainCount-01297", "swapchainCount must equal 0 or VkPresentInfoKHR::swapchainCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupPresentInfoKHR-swapchainCount-01297)"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00905", "deviceMask must be a valid device mask value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00905)"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00906", "deviceMask must not be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00906)"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00907", "deviceMask must be a subset of the command buffer's initial device mask (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00907)"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceRenderAreaCount-00908", "deviceRenderAreaCount must either be zero or equal to the number of physical devices in the logical device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupRenderPassBeginInfo-deviceRenderAreaCount-00908)"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter", "If deviceRenderAreaCount is not 0, pDeviceRenderAreas must be a valid pointer to an array of deviceRenderAreaCount VkRect2D structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter)"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType)"},
    {"VUID-VkDeviceGroupSubmitInfo-commandBufferCount-00083", "commandBufferCount must equal VkSubmitInfo::commandBufferCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-commandBufferCount-00083)"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-00086", "All elements of pCommandBufferDeviceMasks must be valid device masks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-00086)"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter", "If commandBufferCount is not 0, pCommandBufferDeviceMasks must be a valid pointer to an array of commandBufferCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter)"},
    {"VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphoreDeviceIndices must be a valid pointer to an array of signalSemaphoreCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter)"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-00085", "All elements of pWaitSemaphoreDeviceIndices and pSignalSemaphoreDeviceIndices must be valid device indices (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-00085)"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphoreDeviceIndices must be a valid pointer to an array of waitSemaphoreCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter)"},
    {"VUID-VkDeviceGroupSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-sType-sType)"},
    {"VUID-VkDeviceGroupSubmitInfo-signalSemaphoreCount-00084", "signalSemaphoreCount must equal VkSubmitInfo::signalSemaphoreCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-signalSemaphoreCount-00084)"},
    {"VUID-VkDeviceGroupSubmitInfo-waitSemaphoreCount-00082", "waitSemaphoreCount must equal VkSubmitInfo::waitSemaphoreCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSubmitInfo-waitSemaphoreCount-00082)"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter", "modes must be a valid combination of VkDeviceGroupPresentModeFlagBitsKHR values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter)"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask", "modes must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask)"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType)"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-03336", "memory must have been allocated with VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-03336)"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-parameter)"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext)"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType)"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter", "overallocationBehavior must be a valid VkMemoryOverallocationBehaviorAMD value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter)"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType)"},
    {"VUID-VkDeviceQueueCreateInfo-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-flags-parameter)"},
    {"VUID-VkDeviceQueueCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceQueueGlobalPriorityCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-pNext-pNext)"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-00383", "Each element of pQueuePriorities must be between 0.0 and 1.0 inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-pQueuePriorities-00383)"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter", "pQueuePriorities must be a valid pointer to an array of queueCount float values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter)"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-00382", "queueCount must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-queueCount-00382)"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-arraylength", "queueCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-queueCount-arraylength)"},
    {"VUID-VkDeviceQueueCreateInfo-queueFamilyIndex-00381", "queueFamilyIndex must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-queueFamilyIndex-00381)"},
    {"VUID-VkDeviceQueueCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueCreateInfo-sType-sType)"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfoEXT-globalPriority-parameter", "globalPriority must be a valid VkQueueGlobalPriorityEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueGlobalPriorityCreateInfoEXT-globalPriority-parameter)"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueGlobalPriorityCreateInfoEXT-sType-sType)"},
    {"VUID-VkDeviceQueueInfo2-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueInfo2-flags-parameter)"},
    {"VUID-VkDeviceQueueInfo2-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueInfo2-pNext-pNext)"},
    {"VUID-VkDeviceQueueInfo2-queueFamilyIndex-01842", "queueFamilyIndex must be one of the queue family indices specified when device was created, via the VkDeviceQueueCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueInfo2-queueFamilyIndex-01842)"},
    {"VUID-VkDeviceQueueInfo2-queueIndex-01843", "queueIndex must be less than the number of queues created for the specified queue family index and VkDeviceQueueCreateFlags member flags equal to this flags value when device was created, via the queueCount member of the VkDeviceQueueCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueInfo2-queueIndex-01843)"},
    {"VUID-VkDeviceQueueInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDeviceQueueInfo2-sType-sType)"},
    {"VUID-VkDispatchIndirectCommand-x-00417", "x must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDispatchIndirectCommand-x-00417)"},
    {"VUID-VkDispatchIndirectCommand-y-00418", "y must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDispatchIndirectCommand-y-00418)"},
    {"VUID-VkDispatchIndirectCommand-z-00419", "z must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDispatchIndirectCommand-z-00419)"},
    {"VUID-VkDisplayEventInfoEXT-displayEvent-parameter", "displayEvent must be a valid VkDisplayEventTypeEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayEventInfoEXT-displayEvent-parameter)"},
    {"VUID-VkDisplayEventInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayEventInfoEXT-pNext-pNext)"},
    {"VUID-VkDisplayEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayEventInfoEXT-sType-sType)"},
    {"VUID-VkDisplayModeCreateInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeCreateInfoKHR-flags-zerobitmask)"},
    {"VUID-VkDisplayModeCreateInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkDisplayModeCreateInfoKHR-parameters-parameter", "parameters must be a valid VkDisplayModeParametersKHR structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeCreateInfoKHR-parameters-parameter)"},
    {"VUID-VkDisplayModeCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeCreateInfoKHR-sType-sType)"},
    {"VUID-VkDisplayModeParametersKHR-height-01991", "The height member of visibleRegion must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeParametersKHR-height-01991)"},
    {"VUID-VkDisplayModeParametersKHR-refreshRate-01992", "refreshRate must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeParametersKHR-refreshRate-01992)"},
    {"VUID-VkDisplayModeParametersKHR-width-01990", "The width member of visibleRegion must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeParametersKHR-width-01990)"},
    {"VUID-VkDisplayModeProperties2KHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeProperties2KHR-pNext-pNext)"},
    {"VUID-VkDisplayModeProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayModeProperties2KHR-sType-sType)"},
    {"VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType)"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPlaneCapabilities2KHR-pNext-pNext)"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPlaneCapabilities2KHR-sType-sType)"},
    {"VUID-VkDisplayPlaneInfo2KHR-mode-parameter", "mode must be a valid VkDisplayModeKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPlaneInfo2KHR-mode-parameter)"},
    {"VUID-VkDisplayPlaneInfo2KHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPlaneInfo2KHR-pNext-pNext)"},
    {"VUID-VkDisplayPlaneInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPlaneInfo2KHR-sType-sType)"},
    {"VUID-VkDisplayPlaneProperties2KHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPlaneProperties2KHR-pNext-pNext)"},
    {"VUID-VkDisplayPlaneProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPlaneProperties2KHR-sType-sType)"},
    {"VUID-VkDisplayPowerInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPowerInfoEXT-pNext-pNext)"},
    {"VUID-VkDisplayPowerInfoEXT-powerState-parameter", "powerState must be a valid VkDisplayPowerStateEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPowerInfoEXT-powerState-parameter)"},
    {"VUID-VkDisplayPowerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPowerInfoEXT-sType-sType)"},
    {"VUID-VkDisplayPresentInfoKHR-dstRect-01258", "dstRect must specify a rectangular region that is a subset of the visibleRegion parameter of the display mode the swapchain being presented uses (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPresentInfoKHR-dstRect-01258)"},
    {"VUID-VkDisplayPresentInfoKHR-persistentContent-01259", "If the persistentContent member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display the present operation targets then persistent must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPresentInfoKHR-persistentContent-01259)"},
    {"VUID-VkDisplayPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPresentInfoKHR-sType-sType)"},
    {"VUID-VkDisplayPresentInfoKHR-srcRect-01257", "srcRect must specify a rectangular region that is a subset of the image being presented (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayPresentInfoKHR-srcRect-01257)"},
    {"VUID-VkDisplayProperties2KHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayProperties2KHR-pNext-pNext)"},
    {"VUID-VkDisplayProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplayProperties2KHR-sType-sType)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01254", "If alphaMode is VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR then globalAlpha must be between 0 and 1, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01254)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01255", "alphaMode must be 0 or one of the bits present in the supportedAlpha member of VkDisplayPlaneCapabilitiesKHR returned by vkGetDisplayPlaneCapabilitiesKHR for the display plane corresponding to displayMode (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01255)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter", "alphaMode must be a valid VkDisplayPlaneAlphaFlagBitsKHR value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-displayMode-parameter", "displayMode must be a valid VkDisplayModeKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-displayMode-parameter)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-flags-zerobitmask)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeIndex-01252", "planeIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-planeIndex-01252)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeReorderPossible-01253", "If the planeReorderPossible member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display corresponding to displayMode is VK_TRUE then planeStackIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR; otherwise planeStackIndex must equal the currentStackIndex member of VkDisplayPlanePropertiesKHR returned by vkGetPhysicalDeviceDisplayPlanePropertiesKHR for the display plane corresponding to displayMode (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-planeReorderPossible-01253)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-sType-sType)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter", "transform must be a valid VkSurfaceTransformFlagBitsKHR value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter)"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-width-01256", "The width and height members of imageExtent must be less than the maxImageDimensions2D member of VkPhysicalDeviceLimits (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDisplaySurfaceCreateInfoKHR-width-01256)"},
    {"VUID-VkDrawIndexedIndirectCommand-None-00552", "For a given vertex buffer binding, any attribute data fetched must be entirely contained within the corresponding vertex buffer binding, as described in Vertex Input Description (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDrawIndexedIndirectCommand-None-00552)"},
    {"VUID-VkDrawIndexedIndirectCommand-firstInstance-00554", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDrawIndexedIndirectCommand-firstInstance-00554)"},
    {"VUID-VkDrawIndexedIndirectCommand-indexSize-00553", "(indexSize * (firstIndex + indexCount) + offset) must be less than or equal to the size of the bound index buffer, with indexSize being based on the type specified by indexType, where the index buffer, indexType, and offset are specified via vkCmdBindIndexBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDrawIndexedIndirectCommand-indexSize-00553)"},
    {"VUID-VkDrawIndirectCommand-None-00500", "For a given vertex buffer binding, any attribute data fetched must be entirely contained within the corresponding vertex buffer binding, as described in Vertex Input Description (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDrawIndirectCommand-None-00500)"},
    {"VUID-VkDrawIndirectCommand-firstInstance-00501", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDrawIndirectCommand-firstInstance-00501)"},
    {"VUID-VkDrawMeshTasksIndirectCommandNV-taskCount-02175", "taskCount must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxDrawMeshTasksCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDrawMeshTasksIndirectCommandNV-taskCount-02175)"},
    {"VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType)"},
    {"VUID-VkEventCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkEventCreateInfo-flags-zerobitmask)"},
    {"VUID-VkEventCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkEventCreateInfo-pNext-pNext)"},
    {"VUID-VkEventCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EVENT_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkEventCreateInfo-sType-sType)"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-01446", "The bits in handleTypes must be supported and compatible, as reported by VkExternalFenceProperties. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportFenceCreateInfo-handleTypes-01446)"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalFenceHandleTypeFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportFenceCreateInfo-handleTypes-parameter)"},
    {"VUID-VkExportFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportFenceCreateInfo-sType-sType)"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-handleTypes-01447", "If VkExportFenceCreateInfo::handleTypes does not include VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportFenceWin32HandleInfoKHR structure must not be included in the pNext chain of VkFenceCreateInfo. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportFenceWin32HandleInfoKHR-handleTypes-01447)"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportFenceWin32HandleInfoKHR-pAttributes-parameter)"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportFenceWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-00656", "The bits in handleTypes must be supported and compatible, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryAllocateInfo-handleTypes-00656)"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryAllocateInfo-handleTypes-parameter)"},
    {"VUID-VkExportMemoryAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryAllocateInfo-sType-sType)"},
    {"VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter)"},
    {"VUID-VkExportMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryAllocateInfoNV-sType-sType)"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-handleTypes-00657", "If VkExportMemoryAllocateInfo::handleTypes does not include VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, a VkExportMemoryWin32HandleInfoKHR structure must not be included in the pNext chain of VkMemoryAllocateInfo. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryWin32HandleInfoKHR-handleTypes-00657)"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryWin32HandleInfoKHR-pAttributes-parameter)"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryWin32HandleInfoNV-pAttributes-parameter)"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportMemoryWin32HandleInfoNV-sType-sType)"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-01124", "The bits in handleTypes must be supported and compatible, as reported by VkExternalSemaphoreProperties. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportSemaphoreCreateInfo-handleTypes-01124)"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalSemaphoreHandleTypeFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter)"},
    {"VUID-VkExportSemaphoreCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportSemaphoreCreateInfo-sType-sType)"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-handleTypes-01125", "If VkExportSemaphoreCreateInfo::handleTypes does not include VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, VkExportSemaphoreWin32HandleInfoKHR must not be included in the pNext chain of VkSemaphoreCreateInfo. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportSemaphoreWin32HandleInfoKHR-handleTypes-01125)"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportSemaphoreWin32HandleInfoKHR-pAttributes-parameter)"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkExternalBufferProperties-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalBufferProperties-pNext-pNext)"},
    {"VUID-VkExternalBufferProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalBufferProperties-sType-sType)"},
    {"VUID-VkExternalFenceProperties-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalFenceProperties-pNext-pNext)"},
    {"VUID-VkExternalFenceProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalFenceProperties-sType-sType)"},
    {"VUID-VkExternalFormatANDROID-externalFormat-01894", "externalFormat must be 0 or a value returned in the externalFormat member of VkAndroidHardwareBufferFormatPropertiesANDROID by an earlier call to vkGetAndroidHardwareBufferPropertiesANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalFormatANDROID-externalFormat-01894)"},
    {"VUID-VkExternalFormatANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalFormatANDROID-sType-sType)"},
    {"VUID-VkExternalImageFormatProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalImageFormatProperties-sType-sType)"},
    {"VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter)"},
    {"VUID-VkExternalMemoryBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalMemoryBufferCreateInfo-sType-sType)"},
    {"VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter)"},
    {"VUID-VkExternalMemoryImageCreateInfo-handleTypes-requiredbitmask", "handleTypes must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalMemoryImageCreateInfo-handleTypes-requiredbitmask)"},
    {"VUID-VkExternalMemoryImageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalMemoryImageCreateInfo-sType-sType)"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter)"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalMemoryImageCreateInfoNV-sType-sType)"},
    {"VUID-VkExternalSemaphoreProperties-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalSemaphoreProperties-pNext-pNext)"},
    {"VUID-VkExternalSemaphoreProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkExternalSemaphoreProperties-sType-sType)"},
    {"VUID-VkFenceCreateInfo-flags-parameter", "flags must be a valid combination of VkFenceCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceCreateInfo-flags-parameter)"},
    {"VUID-VkFenceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportFenceCreateInfo or VkExportFenceWin32HandleInfoKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceCreateInfo-pNext-pNext)"},
    {"VUID-VkFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceCreateInfo-sType-sType)"},
    {"VUID-VkFenceCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceCreateInfo-sType-unique)"},
    {"VUID-VkFenceGetFdInfoKHR-fence-01455", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-fence-01455)"},
    {"VUID-VkFenceGetFdInfoKHR-fence-parameter", "fence must be a valid VkFence handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-fence-parameter)"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01453", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when fence's current payload was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-handleType-01453)"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01454", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-handleType-01454)"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01456", "handleType must be defined as a POSIX file descriptor handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-handleType-01456)"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-handleType-parameter)"},
    {"VUID-VkFenceGetFdInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-pNext-pNext)"},
    {"VUID-VkFenceGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetFdInfoKHR-sType-sType)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-01450", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-fence-01450)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-parameter", "fence must be a valid VkFence handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-fence-parameter)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01448", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when the fence's current payload was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-handleType-01448)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01449", "If handleType is defined as an NT handle, vkGetFenceWin32HandleKHR must be called no more than once for each valid unique combination of fence and handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-handleType-01449)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01451", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-handleType-01451)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01452", "handleType must be defined as an NT handle or a global share handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-handleType-01452)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-handleType-parameter)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-pNext-pNext)"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFenceGetWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-pNext-02627", "If the pNext chain of the VkImageFormatProperties2 structure includes a VkFilterCubicImageViewImageFormatPropertiesEXT structure, the pNext chain of the VkPhysicalDeviceImageFormatInfo2 structure must include a VkPhysicalDeviceImageViewImageFormatInfoEXT structure with an imageViewType that is compatible with imageType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-pNext-02627)"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType)"},
    {"VUID-VkFormatProperties2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDrmFormatModifierPropertiesListEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFormatProperties2-pNext-pNext)"},
    {"VUID-VkFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFormatProperties2-sType-sType)"},
    {"VUID-VkFramebufferAttachmentImageInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentImageInfo-flags-parameter)"},
    {"VUID-VkFramebufferAttachmentImageInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentImageInfo-pNext-pNext)"},
    {"VUID-VkFramebufferAttachmentImageInfo-pViewFormats-parameter", "If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentImageInfo-pViewFormats-parameter)"},
    {"VUID-VkFramebufferAttachmentImageInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentImageInfo-sType-sType)"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentImageInfo-usage-parameter)"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask", "usage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask)"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter", "If attachmentImageInfoCount is not 0, pAttachmentImageInfos must be a valid pointer to an array of attachmentImageInfoCount valid VkFramebufferAttachmentImageInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter)"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferAttachmentsCreateInfo-sType-sType)"},
    {"VUID-VkFramebufferCreateInfo-attachmentCount-00876", "attachmentCount must be equal to the attachment count specified in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-attachmentCount-00876)"},
    {"VUID-VkFramebufferCreateInfo-commonparent", "Both of renderPass, and the elements of pAttachments that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-commonparent)"},
    {"VUID-VkFramebufferCreateInfo-flags-02778", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-02778)"},
    {"VUID-VkFramebufferCreateInfo-flags-03188", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03188)"},
    {"VUID-VkFramebufferCreateInfo-flags-03189", "If the imageless framebuffer feature is not enabled, flags must not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03189)"},
    {"VUID-VkFramebufferCreateInfo-flags-03190", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the pNext chain must include a VkFramebufferAttachmentsCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03190)"},
    {"VUID-VkFramebufferCreateInfo-flags-03191", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the attachmentImageInfoCount member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be equal to either zero or attachmentCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03191)"},
    {"VUID-VkFramebufferCreateInfo-flags-03192", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be greater than or equal to width (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03192)"},
    {"VUID-VkFramebufferCreateInfo-flags-03193", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be greater than or equal to height (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03193)"},
    {"VUID-VkFramebufferCreateInfo-flags-03194", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be greater than or equal to width, except for any element that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03194)"},
    {"VUID-VkFramebufferCreateInfo-flags-03195", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be greater than or equal to height, except for any element that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03195)"},
    {"VUID-VkFramebufferCreateInfo-flags-03196", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of width/maxFragmentDensityTexelSize.width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03196)"},
    {"VUID-VkFramebufferCreateInfo-flags-03197", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of height/maxFragmentDensityTexelSize.height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03197)"},
    {"VUID-VkFramebufferCreateInfo-flags-03200", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be greater than or equal to layers (https://www.khronos.org/registry/vulkan/specs/1.0-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03200)"},
    {"VUID-VkFramebufferCreateInfo-flags-03201", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a color attachment or resolve attachment by renderPass must include VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03201)"},
    {"VUID-VkFramebufferCreateInfo-flags-03202", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03202)"},
    {"VUID-VkFramebufferCreateInfo-flags-03203", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil resolve attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03203)"},
    {"VUID-VkFramebufferCreateInfo-flags-03204", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as an input attachment by renderPass must include VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03204)"},
    {"VUID-VkFramebufferCreateInfo-flags-03205", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, at least one element of the pViewFormats member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be equal to the corresponding value of VkAttachmentDescription::format used to create renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-03205)"},
    {"VUID-VkFramebufferCreateInfo-flags-parameter", "flags must be a valid combination of VkFramebufferCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-flags-parameter)"},
    {"VUID-VkFramebufferCreateInfo-height-00887", "height must be greater than 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-height-00887)"},
    {"VUID-VkFramebufferCreateInfo-height-00888", "height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-height-00888)"},
    {"VUID-VkFramebufferCreateInfo-layers-00889", "layers must be greater than 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-layers-00889)"},
    {"VUID-VkFramebufferCreateInfo-layers-00890", "layers must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferLayers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-layers-00890)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00877", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a color attachment or resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00877)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00879", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00879)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00880", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a VkFormat value that matches the VkFormat specified by the corresponding VkAttachmentDescription in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00880)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00881", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a samples value that matches the samples value specified by the corresponding VkAttachmentDescription in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00881)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00882", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have dimensions at least as large as the corresponding framebuffer dimension (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00882)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00883", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must only specify a single mip level (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00883)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00884", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with the identity swizzle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00884)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00891", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is a 2D or 2D array image view taken from a 3D image must not be a depth/stencil format (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-00891)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02552", "Each element of pAttachments that is used as a fragment density map attachment by renderPass must not have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-02552)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02554", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have dimensions at least as large as the corresponding framebuffer dimension except for any element that is referenced by fragmentDensityMapAttachment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-02554)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02555", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a width at least as large as the ceiling of width/maxFragmentDensityTexelSize.width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-02555)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02556", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a height at least as large as the ceiling of height/maxFragmentDensityTexelSize.height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-02556)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02633", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-02633)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02634", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pAttachments-02634)"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02744", "An element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1 (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkFramebufferCreateInfo-pAttachments-02744)"},
    {"VUID-VkFramebufferCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkFramebufferAttachmentsCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-pNext-pNext)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02531", "If renderPass was specified with non-zero view masks, layers must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-02531)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02553", "If renderPass has a fragment density map attachment and non-subsample image feature is not enabled, each element of pAttachments must have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT unless that element is the fragment density map attachment. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-02553)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02743", "If renderPass was specified with non-zero view masks, each element of pAttachments must have a layerCount greater than the index of the most significant bit set in any of those view masks (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-02743)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02745", "If renderPass was specified with non-zero view masks, each element of pAttachments that is not referenced by fragmentDensityMapAttachment must have a layerCount greater than the index of the most significant bit set in any of those view masks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-02745)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02746", "If renderPass was specified with non-zero view masks, each element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1 or greater than the index of the most significant bit set in any of those view masks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-02746)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02747", "If renderPass was not specified with non-zero view masks, each element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-02747)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-03198", "If multiview is enabled for renderPass, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be greater than the maximum bit index set in the view mask in the subpasses in which it is used in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-03198)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-03199", "If multiview is not enabled for renderPass, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be greater than or equal to layers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-03199)"},
    {"VUID-VkFramebufferCreateInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-renderPass-parameter)"},
    {"VUID-VkFramebufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-sType-sType)"},
    {"VUID-VkFramebufferCreateInfo-width-00885", "width must be greater than 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-width-00885)"},
    {"VUID-VkFramebufferCreateInfo-width-00886", "width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferCreateInfo-width-00886)"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferMixedSamplesCombinationNV-pNext-pNext)"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkFramebufferMixedSamplesCombinationNV-sType-sType)"},
    {"VUID-VkGeometryAABBNV-aabbData-parameter", "If aabbData is not VK_NULL_HANDLE, aabbData must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryAABBNV-aabbData-parameter)"},
    {"VUID-VkGeometryAABBNV-offset-02439", "offset must be less than the size of aabbData (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryAABBNV-offset-02439)"},
    {"VUID-VkGeometryAABBNV-offset-02440", "offset must be a multiple of 8 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryAABBNV-offset-02440)"},
    {"VUID-VkGeometryAABBNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryAABBNV-pNext-pNext)"},
    {"VUID-VkGeometryAABBNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryAABBNV-sType-sType)"},
    {"VUID-VkGeometryAABBNV-stride-02441", "stride must be a multiple of 8 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryAABBNV-stride-02441)"},
    {"VUID-VkGeometryDataNV-aabbs-parameter", "aabbs must be a valid VkGeometryAABBNV structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryDataNV-aabbs-parameter)"},
    {"VUID-VkGeometryDataNV-triangles-parameter", "triangles must be a valid VkGeometryTrianglesNV structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryDataNV-triangles-parameter)"},
    {"VUID-VkGeometryNV-flags-parameter", "flags must be a valid combination of VkGeometryFlagBitsNV values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryNV-flags-parameter)"},
    {"VUID-VkGeometryNV-geometry-parameter", "geometry must be a valid VkGeometryDataNV structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryNV-geometry-parameter)"},
    {"VUID-VkGeometryNV-geometryType-parameter", "geometryType must be a valid VkGeometryTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryNV-geometryType-parameter)"},
    {"VUID-VkGeometryNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryNV-pNext-pNext)"},
    {"VUID-VkGeometryNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryNV-sType-sType)"},
    {"VUID-VkGeometryTrianglesNV-commonparent", "Each of indexData, transformData, and vertexData that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-commonparent)"},
    {"VUID-VkGeometryTrianglesNV-indexCount-02436", "indexCount must be 0 if indexType is VK_INDEX_TYPE_NONE_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexCount-02436)"},
    {"VUID-VkGeometryTrianglesNV-indexData-02434", "indexData must be VK_NULL_HANDLE if indexType is VK_INDEX_TYPE_NONE_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexData-02434)"},
    {"VUID-VkGeometryTrianglesNV-indexData-02435", "indexData must be a valid VkBuffer handle if indexType is not VK_INDEX_TYPE_NONE_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexData-02435)"},
    {"VUID-VkGeometryTrianglesNV-indexData-parameter", "If indexData is not VK_NULL_HANDLE, indexData must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexData-parameter)"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02431", "indexOffset must be less than the size of indexData (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexOffset-02431)"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02432", "indexOffset must be a multiple of the element size of indexType (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexOffset-02432)"},
    {"VUID-VkGeometryTrianglesNV-indexType-02433", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexType-02433)"},
    {"VUID-VkGeometryTrianglesNV-indexType-parameter", "indexType must be a valid VkIndexType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-indexType-parameter)"},
    {"VUID-VkGeometryTrianglesNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-pNext-pNext)"},
    {"VUID-VkGeometryTrianglesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-sType-sType)"},
    {"VUID-VkGeometryTrianglesNV-transformData-parameter", "If transformData is not VK_NULL_HANDLE, transformData must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-transformData-parameter)"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02437", "transformOffset must be less than the size of transformData (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-transformOffset-02437)"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02438", "transformOffset must be a multiple of 16 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-transformOffset-02438)"},
    {"VUID-VkGeometryTrianglesNV-vertexData-parameter", "If vertexData is not VK_NULL_HANDLE, vertexData must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-vertexData-parameter)"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-02430", "vertexFormat must be one of VK_FORMAT_R32G32B32_SFLOAT, VK_FORMAT_R32G32_SFLOAT, VK_FORMAT_R16G16B16_SFLOAT, VK_FORMAT_R16G16_SFLOAT, VK_FORMAT_R16G16_SNORM, or VK_FORMAT_R16G16B16_SNORM (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-vertexFormat-02430)"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-vertexFormat-parameter)"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02428", "vertexOffset must be less than the size of vertexData (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-vertexOffset-02428)"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02429", "vertexOffset must be a multiple of the component size of vertexFormat (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGeometryTrianglesNV-vertexOffset-02429)"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-02322", "If there are any mesh shader stages in the pipeline there must not be any shader stage in the pipeline with a Xfb execution mode. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-None-02322)"},
    {"VUID-VkGraphicsPipelineCreateInfo-attachmentCount-00746", "If rasterization is not disabled and the subpass uses color attachments, the attachmentCount member of pColorBlendState must be equal to the colorAttachmentCount used to create subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-attachmentCount-00746)"},
    {"VUID-VkGraphicsPipelineCreateInfo-blendEnable-02023", "If rasterization is not disabled and the subpass uses color attachments, then for each color attachment in the subpass the blendEnable member of the corresponding element of the pAttachment member of pColorBlendState must be VK_FALSE if the attached image's format features does not contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-blendEnable-02023)"},
    {"VUID-VkGraphicsPipelineCreateInfo-commonparent", "Each of basePipelineHandle, layout, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-commonparent)"},
    {"VUID-VkGraphicsPipelineCreateInfo-coverageReductionMode-02722", "If the VK_NV_coverage_reduction_mode extension is enabled, the coverage reduction mode specified by VkPipelineCoverageReductionStateCreateInfoNV::coverageReductionMode, the rasterizationSamples member of pMultisampleState and the sample counts for the color and depth/stencil attachments (if the subpass has them) must be a valid combination returned by vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-coverageReductionMode-02722)"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00722", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid handle to a graphics VkPipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-flags-00722)"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00723", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-flags-00723)"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00724", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is not -1, basePipelineHandle must be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-flags-00724)"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00725", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is not VK_NULL_HANDLE, basePipelineIndex must be -1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-flags-00725)"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00764", "flags must not contain the VK_PIPELINE_CREATE_DISPATCH_BASE flag. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-flags-00764)"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-flags-parameter)"},
    {"VUID-VkGraphicsPipelineCreateInfo-geometryStreams-02321", "If the last vertex processing stage is a geometry shader, and that geometry shader uses the GeometryStreams capability, then VkPhysicalDeviceTransformFeedbackFeaturesEXT::geometryStreams feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-geometryStreams-02321)"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-00756", "layout must be consistent with all shaders specified in pStages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-layout-00756)"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-01688", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-layout-01688)"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-parameter", "layout must be a valid VkPipelineLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-layout-parameter)"},
    {"VUID-VkGraphicsPipelineCreateInfo-lineRasterizationMode-02766", "If the lineRasterizationMode member of a VkPipelineRasterizationLineStateCreateInfoEXT structure included in the pNext chain of pRasterizationState is VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT or VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT and if rasterization is enabled, then the alphaToCoverageEnable, alphaToOneEnable, and sampleShadingEnable members of pMultisampleState must all be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-lineRasterizationMode-02766)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-parameter", "If pDynamicState is not NULL, pDynamicState must be a valid pointer to a valid VkPipelineDynamicStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicState-parameter)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00747", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT, the pViewports member of pViewportState must be a valid pointer to an array of pViewportState->viewportCount valid VkViewport structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00747)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00748", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SCISSOR, the pScissors member of pViewportState must be a valid pointer to an array of pViewportState->scissorCount VkRect2D structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00748)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00749", "If the wide lines feature is not enabled, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_WIDTH, the lineWidth member of pRasterizationState must be 1.0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00749)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00754", "If the depth bias clamping feature is not enabled, no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BIAS, and the depthBiasEnable member of pRasterizationState is VK_TRUE, the depthBiasClamp member of pRasterizationState must be 0.0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00754)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00755", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BOUNDS, and the depthBoundsTestEnable member of pDepthStencilState is VK_TRUE, the minDepthBounds and maxDepthBounds members of pDepthStencilState must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00755)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01521", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationGridSize.width must evenly divide VkMultisamplePropertiesEXT::sampleLocationGridSize.width as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01521)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01522", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationGridSize.height must evenly divide VkMultisamplePropertiesEXT::sampleLocationGridSize.height as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01522)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01523", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationsPerPixel must equal rasterizationSamples (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01523)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01715", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV, and the viewportWScalingEnable member of a VkPipelineViewportWScalingStateCreateInfoNV structure, included in the pNext chain of pViewportState, is VK_TRUE, the pViewportWScalings member of the VkPipelineViewportWScalingStateCreateInfoNV must be a pointer to an array of VkPipelineViewportWScalingStateCreateInfoNV::viewportCount valid VkViewportWScalingNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01715)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-02510", "If the VK_EXT_depth_range_unrestricted extension is not enabled and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BOUNDS, and the depthBoundsTestEnable member of pDepthStencilState is VK_TRUE, the minDepthBounds and maxDepthBounds members of pDepthStencilState must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-02510)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreationFeedbackCreateInfoEXT, VkPipelineDiscardRectangleStateCreateInfoEXT, or VkPipelineRepresentativeFragmentTestStateCreateInfoNV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pNext-pNext)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-parameter", "pRasterizationState must be a valid pointer to a valid VkPipelineRasterizationStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-parameter)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00729", "If pStages includes a tessellation control shader stage, it must include a tessellation evaluation shader stage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00729)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00730", "If pStages includes a tessellation evaluation shader stage, it must include a tessellation control shader stage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00730)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00731", "If pStages includes a tessellation control shader stage and a tessellation evaluation shader stage, pTessellationState must be a valid pointer to a valid VkPipelineTessellationStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00731)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00732", "If pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction that specifies the type of subdivision in the pipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00732)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00733", "If pStages includes tessellation shader stages, and the shader code of both stages contain an OpExecutionMode instruction that specifies the type of subdivision in the pipeline, they must both specify the same subdivision mode (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00733)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00734", "If pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction that specifies the output patch size in the pipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00734)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00735", "If pStages includes tessellation shader stages, and the shader code of both contain an OpExecutionMode instruction that specifies the out patch size in the pipeline, they must both specify the same patch size (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00735)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00736", "If pStages includes tessellation shader stages, the topology member of pInputAssembly must be VK_PRIMITIVE_TOPOLOGY_PATCH_LIST (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00736)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00738", "If pStages includes a geometry shader stage, and does not include any tessellation shader stages, its shader code must contain an OpExecutionMode instruction that specifies an input primitive type that is compatible with the primitive topology specified in pInputAssembly (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00738)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00739", "If pStages includes a geometry shader stage, and also includes tessellation shader stages, its shader code must contain an OpExecutionMode instruction that specifies an input primitive type that is compatible with the primitive topology that is output by the tessellation stages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00739)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00740", "If pStages includes a fragment shader stage and a geometry shader stage, and the fragment shader code reads from an input variable that is decorated with PrimitiveID, then the geometry shader code must write to a matching output variable, decorated with PrimitiveID, in all execution paths (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00740)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00741", "If pStages includes a fragment shader stage, its shader code must not read from any input attachment that is defined as VK_ATTACHMENT_UNUSED in subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00741)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00742", "The shader code for the entry points identified by pStages, and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-00742)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-01565", "If pStages includes a fragment shader stage and an input attachment was referenced by the VkRenderPassInputAttachmentAspectCreateInfo at renderPass create time, its shader code must not read from any aspect that was not specified in the aspectMask of the corresponding VkInputAttachmentAspectReference structure. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-01565)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02095", "The geometric shader stages provided in pStages must be either from the mesh shading pipeline (stage is VK_SHADER_STAGE_TASK_BIT_NV or VK_SHADER_STAGE_MESH_BIT_NV) or from the primitive shading pipeline (stage is VK_SHADER_STAGE_VERTEX_BIT, VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, or VK_SHADER_STAGE_GEOMETRY_BIT). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-02095)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02097", "If pStages includes a vertex shader stage, pVertexInputState must be a valid pointer to a valid VkPipelineVertexInputStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-02097)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02098", "If pStages includes a vertex shader stage, pInputAssemblyState must be a valid pointer to a valid VkPipelineInputAssemblyStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-02098)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02317", "The Xfb execution mode can be specified by only one shader stage in pStages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-02317)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02318", "If any shader stage in pStages specifies Xfb execution mode it must be the last vertex processing stage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-02318)"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-parameter", "pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-pStages-parameter)"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02319", "If a VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream value other than zero is specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must all be decorated with identical Stream values that match the rasterizationStream (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02319)"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02320", "If VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream is zero, or not specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must all be decorated with a Stream value of zero, or must not specify the Stream decoration (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02320)"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00750", "If the rasterizerDiscardEnable member of pRasterizationState is VK_FALSE, pViewportState must be a valid pointer to a valid VkPipelineViewportStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00750)"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00751", "If the rasterizerDiscardEnable member of pRasterizationState is VK_FALSE, pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00751)"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00752", "If the rasterizerDiscardEnable member of pRasterizationState is VK_FALSE, and subpass uses a depth/stencil attachment, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00752)"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00753", "If the rasterizerDiscardEnable member of pRasterizationState is VK_FALSE, and subpass uses color attachments, pColorBlendState must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-00753)"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00760", "If the renderPass has multiview enabled and subpass has more than one bit set in the view mask and multiviewTessellationShader is not enabled, then pStages must not include tessellation shaders. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-renderPass-00760)"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00761", "If the renderPass has multiview enabled and subpass has more than one bit set in the view mask and multiviewGeometryShader is not enabled, then pStages must not include a geometry shader. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-renderPass-00761)"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00762", "If the renderPass has multiview enabled and subpass has more than one bit set in the view mask, shaders in the pipeline must not write to the Layer built-in output (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-renderPass-00762)"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-00763", "If the renderPass has multiview enabled, then all shaders must not include variables decorated with the Layer built-in decoration in their interfaces. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-renderPass-00763)"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-renderPass-parameter)"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-sType-sType)"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-sType-unique)"},
    {"VUID-VkGraphicsPipelineCreateInfo-sampleLocationsEnable-01524", "If the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, the fragment shader code must not statically use the extended instruction InterpolateAtSample (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-sampleLocationsEnable-01524)"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-00726", "The stage member of each element of pStages must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-stage-00726)"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-00727", "The stage member of one element of pStages must be VK_SHADER_STAGE_VERTEX_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-stage-00727)"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-00728", "The stage member of each element of pStages must not be VK_SHADER_STAGE_COMPUTE_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-stage-00728)"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-02096", "The stage member of one element of pStages must be either VK_SHADER_STAGE_VERTEX_BIT or VK_SHADER_STAGE_MESH_BIT_NV. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-stage-02096)"},
    {"VUID-VkGraphicsPipelineCreateInfo-stageCount-arraylength", "stageCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-stageCount-arraylength)"},
    {"VUID-VkGraphicsPipelineCreateInfo-stippledLineEnable-02767", "If the stippledLineEnable member of VkPipelineRasterizationLineStateCreateInfoEXT is VK_TRUE and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_STIPPLE_EXT, then the lineStippleFactor member of VkPipelineRasterizationLineStateCreateInfoEXT must be in the range [1,256] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-stippledLineEnable-02767)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00743", "If rasterization is not disabled and subpass uses a depth/stencil attachment in renderPass that has a layout of VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL in the VkAttachmentReference defined by subpass, the depthWriteEnable member of pDepthStencilState must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-00743)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00744", "If rasterization is not disabled and subpass uses a depth/stencil attachment in renderPass that has a layout of VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL in the VkAttachmentReference defined by subpass, the failOp, passOp and depthFailOp members of each of the front and back members of pDepthStencilState must be VK_STENCIL_OP_KEEP (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-00744)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00757", "If neither the VK_AMD_mixed_attachment_samples nor the VK_NV_framebuffer_mixed_samples extensions are enabled, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must be the same as the sample count for those subpass attachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-00757)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00758", "If subpass does not use any color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must follow the rules for a zero-attachment subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-00758)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00759", "subpass must be a valid subpass within renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-00759)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01411", "If the VK_NV_framebuffer_mixed_samples extension is enabled, and if subpass has a depth/stencil attachment and depth test, stencil test, or depth bounds test are enabled, then the rasterizationSamples member of pMultisampleState must be the same as the sample count of the depth/stencil attachment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-01411)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01412", "If the VK_NV_framebuffer_mixed_samples extension is enabled, and if subpass has any color attachments, then the rasterizationSamples member of pMultisampleState must be greater than or equal to the sample count for those subpass attachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-01412)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01505", "If the VK_AMD_mixed_attachment_samples extension is enabled, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must equal the maximum of the sample counts of those subpass attachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-01505)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01756", "If rasterization is not disabled and subpass uses a depth/stencil attachment in renderPass that has a layout of VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL in the VkAttachmentReference defined by subpass, the depthWriteEnable member of pDepthStencilState must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-01756)"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01757", "If rasterization is not disabled and subpass uses a depth/stencil attachment in renderPass that has a layout of VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL in the VkAttachmentReference defined by subpass, the failOp, passOp and depthFailOp members of each of the front and back members of pDepthStencilState must be VK_STENCIL_OP_KEEP (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-subpass-01757)"},
    {"VUID-VkGraphicsPipelineCreateInfo-topology-00737", "If the topology member of pInputAssembly is VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, pStages must include tessellation shader stages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkGraphicsPipelineCreateInfo-topology-00737)"},
    {"VUID-VkHdrMetadataEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkHdrMetadataEXT-pNext-pNext)"},
    {"VUID-VkHdrMetadataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HDR_METADATA_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkHdrMetadataEXT-sType-sType)"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkHeadlessSurfaceCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkHeadlessSurfaceCreateInfoEXT-pNext-pNext)"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkHeadlessSurfaceCreateInfoEXT-sType-sType)"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIOSSurfaceCreateInfoMVK-flags-zerobitmask)"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIOSSurfaceCreateInfoMVK-pNext-pNext)"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pView-01316", "pView must be a valid UIView and must be backed by a CALayer instance of type CAMetalLayer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIOSSurfaceCreateInfoMVK-pView-01316)"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-sType-sType", "sType must be VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIOSSurfaceCreateInfoMVK-sType-sType)"},
    {"VUID-VkImageBlit-aspectMask-00238", "The aspectMask member of srcSubresource and dstSubresource must match (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-aspectMask-00238)"},
    {"VUID-VkImageBlit-aspectMask-00241", "The aspectMask member of srcSubresource must specify aspects present in the calling command's srcImage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-aspectMask-00241)"},
    {"VUID-VkImageBlit-aspectMask-00242", "The aspectMask member of dstSubresource must specify aspects present in the calling command's dstImage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-aspectMask-00242)"},
    {"VUID-VkImageBlit-dstImage-00250", "If the calling command's dstImage is of type VK_IMAGE_TYPE_1D, then dstOffset[0].y must be 0 and dstOffset[1].y must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-dstImage-00250)"},
    {"VUID-VkImageBlit-dstImage-00252", "If the calling command's dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then dstOffset[0].z must be 0 and dstOffset[1].z must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-dstImage-00252)"},
    {"VUID-VkImageBlit-dstOffset-00248", "dstOffset[0].x and dstOffset[1].x must both be greater than or equal to 0 and less than or equal to the destination image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-dstOffset-00248)"},
    {"VUID-VkImageBlit-dstOffset-00249", "dstOffset[0].y and dstOffset[1].y must both be greater than or equal to 0 and less than or equal to the destination image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-dstOffset-00249)"},
    {"VUID-VkImageBlit-dstOffset-00251", "dstOffset[0].z and dstOffset[1].z must both be greater than or equal to 0 and less than or equal to the destination image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-dstOffset-00251)"},
    {"VUID-VkImageBlit-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-dstSubresource-parameter)"},
    {"VUID-VkImageBlit-layerCount-00239", "The layerCount member of srcSubresource and dstSubresource must match (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-layerCount-00239)"},
    {"VUID-VkImageBlit-srcImage-00240", "If either of the calling command's srcImage or dstImage parameters are of VkImageType VK_IMAGE_TYPE_3D, the baseArrayLayer and layerCount members of both srcSubresource and dstSubresource must be 0 and 1, respectively (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-srcImage-00240)"},
    {"VUID-VkImageBlit-srcImage-00245", "If the calling command's srcImage is of type VK_IMAGE_TYPE_1D, then srcOffset[0].y must be 0 and srcOffset[1].y must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-srcImage-00245)"},
    {"VUID-VkImageBlit-srcImage-00247", "If the calling command's srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then srcOffset[0].z must be 0 and srcOffset[1].z must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-srcImage-00247)"},
    {"VUID-VkImageBlit-srcOffset-00243", "srcOffset[0].x and srcOffset[1].x must both be greater than or equal to 0 and less than or equal to the source image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-srcOffset-00243)"},
    {"VUID-VkImageBlit-srcOffset-00244", "srcOffset[0].y and srcOffset[1].y must both be greater than or equal to 0 and less than or equal to the source image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-srcOffset-00244)"},
    {"VUID-VkImageBlit-srcOffset-00246", "srcOffset[0].z and srcOffset[1].z must both be greater than or equal to 0 and less than or equal to the source image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-srcOffset-00246)"},
    {"VUID-VkImageBlit-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageBlit-srcSubresource-parameter)"},
    {"VUID-VkImageCopy-aspectMask-00137", "The aspectMask member of srcSubresource and dstSubresource must match (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-aspectMask-00137)"},
    {"VUID-VkImageCopy-aspectMask-00142", "The aspectMask member of srcSubresource must specify aspects present in the calling command's srcImage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-aspectMask-00142)"},
    {"VUID-VkImageCopy-aspectMask-00143", "The aspectMask member of dstSubresource must specify aspects present in the calling command's dstImage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-aspectMask-00143)"},
    {"VUID-VkImageCopy-dstImage-00152", "If the calling command's dstImage is of type VK_IMAGE_TYPE_1D, then dstOffset.y must be 0 and extent.height must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-00152)"},
    {"VUID-VkImageCopy-dstImage-01554", "If the calling command's dstImage has a VkFormat with two planes then the dstSubresource aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01554)"},
    {"VUID-VkImageCopy-dstImage-01555", "If the calling command's dstImage has a VkFormat with three planes then the dstSubresource aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01555)"},
    {"VUID-VkImageCopy-dstImage-01557", "If the calling command's dstImage has a multi-planar image format and the srcImage does not have a multi-planar image format, the srcSubresource aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01557)"},
    {"VUID-VkImageCopy-dstImage-01731", "If the calling command's dstImage is a compressed format image, or a single-plane, '_422' image format, all members of dstOffset must be a multiple of the corresponding dimensions of the compressed texel block (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01731)"},
    {"VUID-VkImageCopy-dstImage-01732", "If the calling command's dstImage is a compressed format image, or a single-plane, '_422' image format, extent.width must be a multiple of the compressed texel block width or (extent.width + dstOffset.x) must equal the destination image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01732)"},
    {"VUID-VkImageCopy-dstImage-01733", "If the calling command's dstImage is a compressed format image, or a single-plane, '_422' image format, extent.height must be a multiple of the compressed texel block height or (extent.height + dstOffset.y) must equal the destination image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01733)"},
    {"VUID-VkImageCopy-dstImage-01734", "If the calling command's dstImage is a compressed format image, or a single-plane, '_422' image format, extent.depth must be a multiple of the compressed texel block depth or (extent.depth + dstOffset.z) must equal the destination image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01734)"},
    {"VUID-VkImageCopy-dstImage-01786", "If the calling command's dstImage is of type VK_IMAGE_TYPE_1D, then dstOffset.z must be 0 and extent.depth must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01786)"},
    {"VUID-VkImageCopy-dstImage-01788", "If the calling command's dstImage is of type VK_IMAGE_TYPE_2D, then dstOffset.z must be 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01788)"},
    {"VUID-VkImageCopy-dstImage-01792", "If the calling command's dstImage is of type VK_IMAGE_TYPE_2D, and the srcImage is of type VK_IMAGE_TYPE_3D, then extent.depth must equal to the layerCount member of dstSubresource. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstImage-01792)"},
    {"VUID-VkImageCopy-dstOffset-00150", "dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the destination image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstOffset-00150)"},
    {"VUID-VkImageCopy-dstOffset-00151", "dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the destination image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstOffset-00151)"},
    {"VUID-VkImageCopy-dstOffset-00153", "dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the destination image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstOffset-00153)"},
    {"VUID-VkImageCopy-dstOffset-00162", "If the calling command's dstImage is a compressed format image, all members of dstOffset must be a multiple of the corresponding dimensions of the compressed texel block (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-dstOffset-00162)"},
    {"VUID-VkImageCopy-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-dstSubresource-parameter)"},
    {"VUID-VkImageCopy-extent-00140", "The number of slices of the extent (for 3D) or layers of the srcSubresource (for non-3D) must match the number of slices of the extent (for 3D) or layers of the dstSubresource (for non-3D) (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-extent-00140)"},
    {"VUID-VkImageCopy-extent-00158", "If the calling command's srcImage is a compressed image, extent.width must be a multiple of the compressed texel block width or (extent.width + srcOffset.x) must equal the source image subresource width (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-extent-00158)"},
    {"VUID-VkImageCopy-extent-00159", "If the calling command's srcImage is a compressed image, extent.height must be a multiple of the compressed texel block height or (extent.height + srcOffset.y) must equal the source image subresource height (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-extent-00159)"},
    {"VUID-VkImageCopy-extent-00160", "If the calling command's srcImage is a compressed image, extent.depth must be a multiple of the compressed texel block depth or (extent.depth + srcOffset.z) must equal the source image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-extent-00160)"},
    {"VUID-VkImageCopy-extent-00163", "If the calling command's dstImage is a compressed format image, extent.width must be a multiple of the compressed texel block width or (extent.width + dstOffset.x) must equal the destination image subresource width (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-extent-00163)"},
    {"VUID-VkImageCopy-extent-00164", "If the calling command's dstImage is a compressed format image, extent.height must be a multiple of the compressed texel block height or (extent.height + dstOffset.y) must equal the destination image subresource height (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-extent-00164)"},
    {"VUID-VkImageCopy-extent-00165", "If the calling command's dstImage is a compressed format image, extent.depth must be a multiple of the compressed texel block depth or (extent.depth + dstOffset.z) must equal the destination image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-extent-00165)"},
    {"VUID-VkImageCopy-layerCount-00138", "The layerCount member of srcSubresource and dstSubresource must match (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-layerCount-00138)"},
    {"VUID-VkImageCopy-srcImage-00139", "If either of the calling command's srcImage or dstImage parameters are of VkImageType VK_IMAGE_TYPE_3D, the baseArrayLayer and layerCount members of both srcSubresource and dstSubresource must be 0 and 1, respectively (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-srcImage-00139)"},
    {"VUID-VkImageCopy-srcImage-00141", "If either of the calling command's srcImage or dstImage parameters are of VkImageType VK_IMAGE_TYPE_3D, the baseArrayLayer and layerCount members of the corresponding subresource must be 0 and 1, respectively (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-00141)"},
    {"VUID-VkImageCopy-srcImage-00146", "If the calling command's srcImage is of type VK_IMAGE_TYPE_1D, then srcOffset.y must be 0 and extent.height must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-00146)"},
    {"VUID-VkImageCopy-srcImage-01551", "If neither the calling command's srcImage nor the calling command's dstImage has a multi-planar image format then the aspectMask member of srcSubresource and dstSubresource must match (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01551)"},
    {"VUID-VkImageCopy-srcImage-01552", "If the calling command's srcImage has a VkFormat with two planes then the srcSubresource aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01552)"},
    {"VUID-VkImageCopy-srcImage-01553", "If the calling command's srcImage has a VkFormat with three planes then the srcSubresource aspectMask must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01553)"},
    {"VUID-VkImageCopy-srcImage-01556", "If the calling command's srcImage has a multi-planar image format and the dstImage does not have a multi-planar image format, the dstSubresource aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01556)"},
    {"VUID-VkImageCopy-srcImage-01727", "If the calling command's srcImage is a compressed image, or a single-plane, '_422' image format, all members of srcOffset must be a multiple of the corresponding dimensions of the compressed texel block (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01727)"},
    {"VUID-VkImageCopy-srcImage-01728", "If the calling command's srcImage is a compressed image, or a single-plane, '_422' image format, extent.width must be a multiple of the compressed texel block width or (extent.width + srcOffset.x) must equal the source image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01728)"},
    {"VUID-VkImageCopy-srcImage-01729", "If the calling command's srcImage is a compressed image, or a single-plane, '_422' image format, extent.height must be a multiple of the compressed texel block height or (extent.height + srcOffset.y) must equal the source image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01729)"},
    {"VUID-VkImageCopy-srcImage-01730", "If the calling command's srcImage is a compressed image, or a single-plane, '_422' image format, extent.depth must be a multiple of the compressed texel block depth or (extent.depth + srcOffset.z) must equal the source image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01730)"},
    {"VUID-VkImageCopy-srcImage-01785", "If the calling command's srcImage is of type VK_IMAGE_TYPE_1D, then srcOffset.z must be 0 and extent.depth must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01785)"},
    {"VUID-VkImageCopy-srcImage-01787", "If the calling command's srcImage is of type VK_IMAGE_TYPE_2D, then srcOffset.z must be 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01787)"},
    {"VUID-VkImageCopy-srcImage-01789", "If the calling command's srcImage or dstImage is of type VK_IMAGE_TYPE_2D, then extent.depth must be 1. (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-srcImage-01789)"},
    {"VUID-VkImageCopy-srcImage-01790", "If both srcImage and dstImage are of type VK_IMAGE_TYPE_2D then extent.depth must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01790)"},
    {"VUID-VkImageCopy-srcImage-01791", "If the calling command's srcImage is of type VK_IMAGE_TYPE_2D, and the dstImage is of type VK_IMAGE_TYPE_3D, then extent.depth must equal to the layerCount member of srcSubresource. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcImage-01791)"},
    {"VUID-VkImageCopy-srcOffset-00144", "srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the source image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcOffset-00144)"},
    {"VUID-VkImageCopy-srcOffset-00145", "srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the source image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcOffset-00145)"},
    {"VUID-VkImageCopy-srcOffset-00147", "srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the source image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcOffset-00147)"},
    {"VUID-VkImageCopy-srcOffset-00157", "If the calling command's srcImage is a compressed image, all members of srcOffset must be a multiple of the corresponding dimensions of the compressed texel block (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCopy-srcOffset-00157)"},
    {"VUID-VkImageCopy-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCopy-srcSubresource-parameter)"},
    {"VUID-VkImageCreateInfo-Format-02536", "If Format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-Format-02536)"},
    {"VUID-VkImageCreateInfo-None-01891", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_CREATE_PROTECTED_BIT must not also be set. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-None-01891)"},
    {"VUID-VkImageCreateInfo-None-01925", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT must not also be set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-None-01925)"},
    {"VUID-VkImageCreateInfo-arrayLayers-00948", "arrayLayers must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-arrayLayers-00948)"},
    {"VUID-VkImageCreateInfo-arrayLayers-02256", "arrayLayers must be less than or equal to imageCreateMaxArrayLayers (as defined in Image Creation Limits). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-arrayLayers-02256)"},
    {"VUID-VkImageCreateInfo-extent-00944", "extent.width must be greater than 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-extent-00944)"},
    {"VUID-VkImageCreateInfo-extent-00945", "extent.height must be greater than 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-extent-00945)"},
    {"VUID-VkImageCreateInfo-extent-00946", "extent.depth must be greater than 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-extent-00946)"},
    {"VUID-VkImageCreateInfo-extent-02252", "extent.width must be less than or equal to imageCreateMaxExtent.width (as defined in Image Creation Limits). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-extent-02252)"},
    {"VUID-VkImageCreateInfo-extent-02253", "extent.height must be less than or equal to imageCreateMaxExtent.height (as defined in Image Creation Limits). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-extent-02253)"},
    {"VUID-VkImageCreateInfo-extent-02254", "extent.depth must be less than or equal to imageCreateMaxExtent.depth (as defined in Image Creation Limits). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-extent-02254)"},
    {"VUID-VkImageCreateInfo-flags-00949", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_2D (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-00949)"},
    {"VUID-VkImageCreateInfo-flags-00950", "If flags contains VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_3D (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-00950)"},
    {"VUID-VkImageCreateInfo-flags-00969", "If the sparse bindings feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-00969)"},
    {"VUID-VkImageCreateInfo-flags-00987", "If flags contains VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-00987)"},
    {"VUID-VkImageCreateInfo-flags-01533", "If flags contains VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT format must be a depth or depth/stencil format (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-01533)"},
    {"VUID-VkImageCreateInfo-flags-01572", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then format must be a block-compressed image format, an ETC compressed image format, or an ASTC compressed image format. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-01572)"},
    {"VUID-VkImageCreateInfo-flags-01573", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then flags must also contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-01573)"},
    {"VUID-VkImageCreateInfo-flags-01890", "If the protected memory feature is not enabled, flags must not contain VK_IMAGE_CREATE_PROTECTED_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-01890)"},
    {"VUID-VkImageCreateInfo-flags-01924", "If the sparse aliased residency feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_ALIASED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-01924)"},
    {"VUID-VkImageCreateInfo-flags-02050", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, imageType must be VK_IMAGE_TYPE_2D or VK_IMAGE_TYPE_3D (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02050)"},
    {"VUID-VkImageCreateInfo-flags-02051", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, it must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT and the format must not be a depth/stencil format (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02051)"},
    {"VUID-VkImageCreateInfo-flags-02052", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_2D, extent.width and extent.height must be greater than 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02052)"},
    {"VUID-VkImageCreateInfo-flags-02053", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_3D, extent.width, extent.height, and extent.depth must be greater than 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02053)"},
    {"VUID-VkImageCreateInfo-flags-02259", "If flags contains VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT, then mipLevels must be one, arrayLayers must be one, imageType must be VK_IMAGE_TYPE_2D. and imageCreateMaybeLinear (as defined in Image Creation Limits) must be false. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02259)"},
    {"VUID-VkImageCreateInfo-flags-02557", "If flags contains VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02557)"},
    {"VUID-VkImageCreateInfo-flags-02565", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, tiling must be VK_IMAGE_TILING_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02565)"},
    {"VUID-VkImageCreateInfo-flags-02566", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02566)"},
    {"VUID-VkImageCreateInfo-flags-02567", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, flags must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02567)"},
    {"VUID-VkImageCreateInfo-flags-02568", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, mipLevels must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-02568)"},
    {"VUID-VkImageCreateInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-flags-parameter)"},
    {"VUID-VkImageCreateInfo-format-00943", "format must not be VK_FORMAT_UNDEFINED (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-00943)"},
    {"VUID-VkImageCreateInfo-format-01577", "If format is not a multi-planar format, and flags does not include VK_IMAGE_CREATE_ALIAS_BIT, flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-01577)"},
    {"VUID-VkImageCreateInfo-format-02537", "If format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02537)"},
    {"VUID-VkImageCreateInfo-format-02538", "If the multisampled storage images feature is not enabled, format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage including VK_IMAGE_USAGE_STORAGE_BIT, samples must be VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02538)"},
    {"VUID-VkImageCreateInfo-format-02561", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, then mipLevels must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02561)"},
    {"VUID-VkImageCreateInfo-format-02562", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, samples must be VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02562)"},
    {"VUID-VkImageCreateInfo-format-02563", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, imageType must be VK_IMAGE_TYPE_2D (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02563)"},
    {"VUID-VkImageCreateInfo-format-02564", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, arrayLayers must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02564)"},
    {"VUID-VkImageCreateInfo-format-02653", "If the image format is one of those listed in Formats requiring sampler Y'CBCR conversion for VK_IMAGE_ASPECT_COLOR_BIT image views, and the ycbcrImageArrays feature is not enabled, arrayLayers must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02653)"},
    {"VUID-VkImageCreateInfo-format-02795", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02795)"},
    {"VUID-VkImageCreateInfo-format-02796", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02796)"},
    {"VUID-VkImageCreateInfo-format-02797", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02797)"},
    {"VUID-VkImageCreateInfo-format-02798", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-02798)"},
    {"VUID-VkImageCreateInfo-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-format-parameter)"},
    {"VUID-VkImageCreateInfo-imageCreateFormatFeatures-02260", "If format is a multi-planar format, and if imageCreateFormatFeatures (as defined in Image Creation Limits) does not contain VK_FORMAT_FEATURE_DISJOINT_BIT, then flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageCreateFormatFeatures-02260)"},
    {"VUID-VkImageCreateInfo-imageCreateMaxMipLevels-02251", "Each of the following values (as described in Image Creation Limits) must not be undefined imageCreateMaxMipLevels, imageCreateMaxArrayLayers, imageCreateMaxExtent, and imageCreateSampleCounts. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageCreateMaxMipLevels-02251)"},
    {"VUID-VkImageCreateInfo-imageType-00954", "If imageType is VK_IMAGE_TYPE_2D and flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, extent.width and extent.height must be equal and arrayLayers must be greater than or equal to 6 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00954)"},
    {"VUID-VkImageCreateInfo-imageType-00956", "If imageType is VK_IMAGE_TYPE_1D, both extent.height and extent.depth must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00956)"},
    {"VUID-VkImageCreateInfo-imageType-00957", "If imageType is VK_IMAGE_TYPE_2D, extent.depth must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00957)"},
    {"VUID-VkImageCreateInfo-imageType-00961", "If imageType is VK_IMAGE_TYPE_3D, arrayLayers must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00961)"},
    {"VUID-VkImageCreateInfo-imageType-00970", "If imageType is VK_IMAGE_TYPE_1D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00970)"},
    {"VUID-VkImageCreateInfo-imageType-00971", "If the sparse residency for 2D images feature is not enabled, and imageType is VK_IMAGE_TYPE_2D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00971)"},
    {"VUID-VkImageCreateInfo-imageType-00972", "If the sparse residency for 3D images feature is not enabled, and imageType is VK_IMAGE_TYPE_3D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00972)"},
    {"VUID-VkImageCreateInfo-imageType-00973", "If the sparse residency for images with 2 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_2_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00973)"},
    {"VUID-VkImageCreateInfo-imageType-00974", "If the sparse residency for images with 4 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_4_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00974)"},
    {"VUID-VkImageCreateInfo-imageType-00975", "If the sparse residency for images with 8 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_8_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00975)"},
    {"VUID-VkImageCreateInfo-imageType-00976", "If the sparse residency for images with 16 samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_16_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-00976)"},
    {"VUID-VkImageCreateInfo-imageType-02082", "If usage includes VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, imageType must be VK_IMAGE_TYPE_2D. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-02082)"},
    {"VUID-VkImageCreateInfo-imageType-parameter", "imageType must be a valid VkImageType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-imageType-parameter)"},
    {"VUID-VkImageCreateInfo-initialLayout-00993", "initialLayout must be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-initialLayout-00993)"},
    {"VUID-VkImageCreateInfo-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-initialLayout-parameter)"},
    {"VUID-VkImageCreateInfo-mipLevels-00947", "mipLevels must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-mipLevels-00947)"},
    {"VUID-VkImageCreateInfo-mipLevels-00958", "mipLevels must be less than or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-mipLevels-00958)"},
    {"VUID-VkImageCreateInfo-mipLevels-02255", "mipLevels must be less than or equal to imageCreateMaxMipLevels (as defined in Image Creation Limits). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-mipLevels-02255)"},
    {"VUID-VkImageCreateInfo-pNext-00988", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, it must not contain a VkExternalMemoryImageCreateInfo structure. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-00988)"},
    {"VUID-VkImageCreateInfo-pNext-00990", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceImageFormatProperties2 with format, imageType, tiling, usage, and flags equal to those in this structure, and with a VkPhysicalDeviceExternalImageFormatInfo structure included in the pNext chain, with a handleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfo::handleTypes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-00990)"},
    {"VUID-VkImageCreateInfo-pNext-00991", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatPropertiesNV::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalImageFormatPropertiesNV with format, imageType, tiling, usage, and flags equal to those in this structure, and with externalHandleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfoNV::handleTypes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-00991)"},
    {"VUID-VkImageCreateInfo-pNext-01443", "If the pNext chain includes a ifdef::VK_VERSION_1_1,VK_KHR_external_memory[VkExternalMemoryImageCreateInfo] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-01443)"},
    {"VUID-VkImageCreateInfo-pNext-01974", "If the pNext chain includes a VkExternalFormatANDROID structure, and its externalFormat member is non-zero the format must be VK_FORMAT_UNDEFINED. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-01974)"},
    {"VUID-VkImageCreateInfo-pNext-01975", "If the pNext chain does not include a VkExternalFormatANDROID structure, or does and its externalFormat member is 0, the format must not be VK_FORMAT_UNDEFINED. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-01975)"},
    {"VUID-VkImageCreateInfo-pNext-02262", "If the pNext chain includes a VkImageDrmFormatModifierListCreateInfoEXT or VkImageDrmFormatModifierExplicitCreateInfoEXT structure, then tiling must be VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-02262)"},
    {"VUID-VkImageCreateInfo-pNext-02393", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, imageType must be VK_IMAGE_TYPE_2D. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-02393)"},
    {"VUID-VkImageCreateInfo-pNext-02394", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, mipLevels must either be 1 or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-02394)"},
    {"VUID-VkImageCreateInfo-pNext-02396", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, flags must not include VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-02396)"},
    {"VUID-VkImageCreateInfo-pNext-02397", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, usage must not include any usages except VK_IMAGE_USAGE_SAMPLED_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-02397)"},
    {"VUID-VkImageCreateInfo-pNext-02398", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, tiling must be VK_IMAGE_TILING_OPTIMAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-02398)"},
    {"VUID-VkImageCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDedicatedAllocationImageCreateInfoNV, VkExternalFormatANDROID, VkExternalMemoryImageCreateInfo, VkExternalMemoryImageCreateInfoNV, VkImageDrmFormatModifierExplicitCreateInfoEXT, VkImageDrmFormatModifierListCreateInfoEXT, VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, or VkImageSwapchainCreateInfoKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-pNext-pNext)"},
    {"VUID-VkImageCreateInfo-physicalDeviceCount-01421", "If the logical device was created with VkDeviceGroupDeviceCreateInfo::physicalDeviceCount equal to 1, flags must not contain VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-physicalDeviceCount-01421)"},
    {"VUID-VkImageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-sType-sType)"},
    {"VUID-VkImageCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-sType-unique)"},
    {"VUID-VkImageCreateInfo-samples-02083", "If usage includes VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, samples must be VK_SAMPLE_COUNT_1_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-samples-02083)"},
    {"VUID-VkImageCreateInfo-samples-02257", "If samples is not VK_SAMPLE_COUNT_1_BIT, then imageType must be VK_IMAGE_TYPE_2D, flags must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, mipLevels must be equal to 1, and imageCreateMaybeLinear (as defined in Image Creation Limits) must be false, (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-samples-02257)"},
    {"VUID-VkImageCreateInfo-samples-02258", "samples must be a bit value that is set in imageCreateSampleCounts (as defined in Image Creation Limits). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-samples-02258)"},
    {"VUID-VkImageCreateInfo-samples-02558", "If samples is not VK_SAMPLE_COUNT_1_BIT, usage must not contain VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-samples-02558)"},
    {"VUID-VkImageCreateInfo-samples-parameter", "samples must be a valid VkSampleCountFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-samples-parameter)"},
    {"VUID-VkImageCreateInfo-sharingMode-00941", "If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-sharingMode-00941)"},
    {"VUID-VkImageCreateInfo-sharingMode-00942", "If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-sharingMode-00942)"},
    {"VUID-VkImageCreateInfo-sharingMode-01392", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageCreateInfo-sharingMode-01392)"},
    {"VUID-VkImageCreateInfo-sharingMode-01420", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties or vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-sharingMode-01420)"},
    {"VUID-VkImageCreateInfo-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-sharingMode-parameter)"},
    {"VUID-VkImageCreateInfo-tiling-02084", "If usage includes VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, tiling must be VK_IMAGE_TILING_OPTIMAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-tiling-02084)"},
    {"VUID-VkImageCreateInfo-tiling-02261", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then the pNext chain must include exactly one of VkImageDrmFormatModifierListCreateInfoEXT or VkImageDrmFormatModifierExplicitCreateInfoEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-tiling-02261)"},
    {"VUID-VkImageCreateInfo-tiling-02353", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT and flags contains VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, then the pNext chain must include a VkImageFormatListCreateInfo structure with non-zero viewFormatCount. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-tiling-02353)"},
    {"VUID-VkImageCreateInfo-tiling-parameter", "tiling must be a valid VkImageTiling value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-tiling-parameter)"},
    {"VUID-VkImageCreateInfo-usage-00963", "If usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, then bits other than VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT must not be set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-00963)"},
    {"VUID-VkImageCreateInfo-usage-00964", "If usage includes VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-00964)"},
    {"VUID-VkImageCreateInfo-usage-00965", "If usage includes VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-00965)"},
    {"VUID-VkImageCreateInfo-usage-00966", "If usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, usage must also contain at least one of VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-00966)"},
    {"VUID-VkImageCreateInfo-usage-00968", "If the multisampled storage images feature is not enabled, and usage contains VK_IMAGE_USAGE_STORAGE_BIT, samples must be VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-00968)"},
    {"VUID-VkImageCreateInfo-usage-02559", "If usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.width must be less than or equal to the ceiling of maxFramebufferWidth/minFragmentDensityTexelSize.width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-02559)"},
    {"VUID-VkImageCreateInfo-usage-02560", "If usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.height must be less than or equal to the ceiling of maxFramebufferHeight/minFragmentDensityTexelSize.height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-02560)"},
    {"VUID-VkImageCreateInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-parameter)"},
    {"VUID-VkImageCreateInfo-usage-requiredbitmask", "usage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageCreateInfo-usage-requiredbitmask)"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-arrayPitch-02268", "For each element of pPlaneLayouts, arrayPitch must be 0 if VkImageCreateInfo::arrayLayers is 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-arrayPitch-02268)"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-depthPitch-02269", "For each element of pPlaneLayouts, depthPitch must be 0 if VkImageCreateInfo::extent.depth is 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-depthPitch-02269)"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifier-02264", "drmFormatModifier must be compatible with the parameters in VkImageCreateInfo and its pNext chain, as determined by querying VkPhysicalDeviceImageFormatInfo2 extended with VkPhysicalDeviceImageDrmFormatModifierInfoEXT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifier-02264)"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifierPlaneCount-02265", "drmFormatModifierPlaneCount must be equal to the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with VkImageCreateInfo::format and drmFormatModifier, as found by querying VkDrmFormatModifierPropertiesListEXT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-drmFormatModifierPlaneCount-02265)"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-pPlaneLayouts-parameter", "If drmFormatModifierPlaneCount is not 0, pPlaneLayouts must be a valid pointer to an array of drmFormatModifierPlaneCount VkSubresourceLayout structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-pPlaneLayouts-parameter)"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-sType-sType)"},
    {"VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-size-02267", "For each element of pPlaneLayouts, size must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierExplicitCreateInfoEXT-size-02267)"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-drmFormatModifierCount-arraylength", "drmFormatModifierCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierListCreateInfoEXT-drmFormatModifierCount-arraylength)"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-02263", "Each modifier in pDrmFormatModifiers must be compatible with the parameters in VkImageCreateInfo and its pNext chain, as determined by querying VkPhysicalDeviceImageFormatInfo2 extended with VkPhysicalDeviceImageDrmFormatModifierInfoEXT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-02263)"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-parameter", "pDrmFormatModifiers must be a valid pointer to an array of drmFormatModifierCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierListCreateInfoEXT-pDrmFormatModifiers-parameter)"},
    {"VUID-VkImageDrmFormatModifierListCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierListCreateInfoEXT-sType-sType)"},
    {"VUID-VkImageDrmFormatModifierPropertiesEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierPropertiesEXT-pNext-pNext)"},
    {"VUID-VkImageDrmFormatModifierPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageDrmFormatModifierPropertiesEXT-sType-sType)"},
    {"VUID-VkImageFormatListCreateInfo-flags-01579", "If VkImageCreateInfo::flags does not contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, viewFormatCount must be 0 or 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatListCreateInfo-flags-01579)"},
    {"VUID-VkImageFormatListCreateInfo-pViewFormats-parameter", "If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatListCreateInfo-pViewFormats-parameter)"},
    {"VUID-VkImageFormatListCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatListCreateInfo-sType-sType)"},
    {"VUID-VkImageFormatListCreateInfo-viewFormatCount-01578", "If viewFormatCount is not 0, all of the formats in the pViewFormats array must be compatible with the format specified in the format field of VkImageCreateInfo, as described in the compatibility table. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatListCreateInfo-viewFormatCount-01578)"},
    {"VUID-VkImageFormatListCreateInfo-viewFormatCount-01580", "If viewFormatCount is not 0, VkImageCreateInfo::format must be in pViewFormats. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatListCreateInfo-viewFormatCount-01580)"},
    {"VUID-VkImageFormatProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAndroidHardwareBufferUsageANDROID, VkExternalImageFormatProperties, VkFilterCubicImageViewImageFormatPropertiesEXT, VkSamplerYcbcrConversionImageFormatProperties, or VkTextureLODGatherFormatPropertiesAMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatProperties2-pNext-pNext)"},
    {"VUID-VkImageFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatProperties2-sType-sType)"},
    {"VUID-VkImageFormatProperties2-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageFormatProperties2-sType-unique)"},
    {"VUID-VkImageMemoryBarrier-image-01199", "If image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex and dstQueueFamilyIndex must both be VK_QUEUE_FAMILY_IGNORED (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01199)"},
    {"VUID-VkImageMemoryBarrier-image-01200", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, srcQueueFamilyIndex and dstQueueFamilyIndex must either both be VK_QUEUE_FAMILY_IGNORED, or both be a valid queue family (see Queue Family Properties). (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01200)"},
    {"VUID-VkImageMemoryBarrier-image-01201", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE and srcQueueFamilyIndex is VK_QUEUE_FAMILY_IGNORED, dstQueueFamilyIndex must also be VK_QUEUE_FAMILY_IGNORED. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01201)"},
    {"VUID-VkImageMemoryBarrier-image-01205", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not VK_QUEUE_FAMILY_IGNORED, at least one of them must be the same as the family of the queue that will execute this barrier (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01205)"},
    {"VUID-VkImageMemoryBarrier-image-01207", "If image has a depth/stencil format with both depth and stencil components, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01207)"},
    {"VUID-VkImageMemoryBarrier-image-01381", "If image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01381)"},
    {"VUID-VkImageMemoryBarrier-image-01671", "If image has a single-plane color format or is not disjoint, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01671)"},
    {"VUID-VkImageMemoryBarrier-image-01672", "If image has a multi-planar format and the image is disjoint, then the aspectMask member of subresourceRange must include either at least one of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, and VK_IMAGE_ASPECT_PLANE_2_BIT; or must include VK_IMAGE_ASPECT_COLOR_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01672)"},
    {"VUID-VkImageMemoryBarrier-image-01673", "If image has a multi-planar format with only two planes, then the aspectMask member of subresourceRange must not include VK_IMAGE_ASPECT_PLANE_2_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01673)"},
    {"VUID-VkImageMemoryBarrier-image-01766", "If image was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, and one of srcQueueFamilyIndex and dstQueueFamilyIndex is VK_QUEUE_FAMILY_IGNORED, the other must be VK_QUEUE_FAMILY_IGNORED or a special queue family reserved for external memory transfers, as described in Queue Family Ownership Transfer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01766)"},
    {"VUID-VkImageMemoryBarrier-image-01767", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE and srcQueueFamilyIndex is not VK_QUEUE_FAMILY_IGNORED, it must be a valid queue family or a special queue family reserved for external memory transfers, as described in Queue Family Ownership Transfer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01767)"},
    {"VUID-VkImageMemoryBarrier-image-01768", "If image was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE and dstQueueFamilyIndex is not VK_QUEUE_FAMILY_IGNORED, it must be a valid queue family or a special queue family reserved for external memory transfers, as described in Queue Family Ownership Transfer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01768)"},
    {"VUID-VkImageMemoryBarrier-image-01932", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-01932)"},
    {"VUID-VkImageMemoryBarrier-image-03319", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is enabled, then the aspectMask member of subresourceRange must include either or both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-03319)"},
    {"VUID-VkImageMemoryBarrier-image-03320", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is not enabled, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-03320)"},
    {"VUID-VkImageMemoryBarrier-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-image-parameter)"},
    {"VUID-VkImageMemoryBarrier-newLayout-01198", "newLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_PREINITIALIZED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-newLayout-01198)"},
    {"VUID-VkImageMemoryBarrier-newLayout-parameter", "newLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-newLayout-parameter)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01197", "oldLayout must be VK_IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources affected by the barrier (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01197)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01208", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01208)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01209", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01209)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01210", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01210)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01211", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_SAMPLED_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01211)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01212", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01212)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01213", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then image must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01213)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01658", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01658)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-01659", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL then image must have been created with VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-01659)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-02088", "If either oldLayout or newLayout is VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV then image must have been created with VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-02088)"},
    {"VUID-VkImageMemoryBarrier-oldLayout-parameter", "oldLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-oldLayout-parameter)"},
    {"VUID-VkImageMemoryBarrier-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkSampleLocationsInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-pNext-pNext)"},
    {"VUID-VkImageMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-sType-sType)"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01486", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-subresourceRange-01486)"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01488", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-subresourceRange-01488)"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01724", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-subresourceRange-01724)"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-01725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-subresourceRange-01725)"},
    {"VUID-VkImageMemoryBarrier-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryBarrier-subresourceRange-parameter)"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01589", "If image was created with a multi-planar format and the VK_IMAGE_CREATE_DISJOINT_BIT flag, there must be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-image-01589)"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01590", "If image was not created with the VK_IMAGE_CREATE_DISJOINT_BIT flag, there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-image-01590)"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01591", "If image was created with a single-plane format, there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-image-01591)"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-01897", "If image was created with the VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID external memory handle type, then image must be bound to memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-image-01897)"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-02279", "If image was created with VK_IMAGE_CREATE_DISJOINT_BIT and with VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then there must be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-image-02279)"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-02280", "If image was created with a single-plane format and with any tiling other than VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then there must not be a VkImagePlaneMemoryRequirementsInfo included in the pNext chain of the VkImageMemoryRequirementsInfo2 structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-image-02280)"},
    {"VUID-VkImageMemoryRequirementsInfo2-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-image-parameter)"},
    {"VUID-VkImageMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkImagePlaneMemoryRequirementsInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-pNext-pNext)"},
    {"VUID-VkImageMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageMemoryRequirementsInfo2-sType-sType)"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-flags-zerobitmask)"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-imagePipeHandle-00000", "imagePipeHandle must be a valid zx_handle_t (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-imagePipeHandle-00000)"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-pNext-pNext)"},
    {"VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePipeSurfaceCreateInfoFUCHSIA-sType-sType)"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02281", "If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid format plane for the image. (That is, for a two-plane image planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT or VK_IMAGE_ASPECT_PLANE_1_BIT, and for a three-plane image planeAspect must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT or VK_IMAGE_ASPECT_PLANE_2_BIT). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02281)"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02282", "If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT,  then planeAspect must be a single valid memory plane for the  image.  (That is, aspectMask must specify a plane index that is less than  the  drmFormatModifierPlaneCount  associated with the image's format and drmFormatModifier.) (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-02282)"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter", "planeAspect must be a valid VkImageAspectFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePlaneMemoryRequirementsInfo-planeAspect-parameter)"},
    {"VUID-VkImagePlaneMemoryRequirementsInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImagePlaneMemoryRequirementsInfo-sType-sType)"},
    {"VUID-VkImageResolve-aspectMask-00266", "The aspectMask member of srcSubresource and dstSubresource must only contain VK_IMAGE_ASPECT_COLOR_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-aspectMask-00266)"},
    {"VUID-VkImageResolve-dstImage-00276", "If the calling command's dstImage is of type VK_IMAGE_TYPE_1D, then dstOffset.y must be 0 and extent.height must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-dstImage-00276)"},
    {"VUID-VkImageResolve-dstImage-00278", "If the calling command's dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then dstOffset.z must be 0 and extent.depth must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-dstImage-00278)"},
    {"VUID-VkImageResolve-dstOffset-00274", "dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the destination image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-dstOffset-00274)"},
    {"VUID-VkImageResolve-dstOffset-00275", "dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the destination image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-dstOffset-00275)"},
    {"VUID-VkImageResolve-dstOffset-00277", "dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the destination image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-dstOffset-00277)"},
    {"VUID-VkImageResolve-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-dstSubresource-parameter)"},
    {"VUID-VkImageResolve-layerCount-00267", "The layerCount member of srcSubresource and dstSubresource must match (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-layerCount-00267)"},
    {"VUID-VkImageResolve-srcImage-00268", "If either of the calling command's srcImage or dstImage parameters are of VkImageType VK_IMAGE_TYPE_3D, the baseArrayLayer and layerCount members of both srcSubresource and dstSubresource must be 0 and 1, respectively (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-srcImage-00268)"},
    {"VUID-VkImageResolve-srcImage-00271", "If the calling command's srcImage is of type VK_IMAGE_TYPE_1D, then srcOffset.y must be 0 and extent.height must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-srcImage-00271)"},
    {"VUID-VkImageResolve-srcImage-00273", "If the calling command's srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then srcOffset.z must be 0 and extent.depth must be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-srcImage-00273)"},
    {"VUID-VkImageResolve-srcOffset-00269", "srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the source image subresource width (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-srcOffset-00269)"},
    {"VUID-VkImageResolve-srcOffset-00270", "srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the source image subresource height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-srcOffset-00270)"},
    {"VUID-VkImageResolve-srcOffset-00272", "srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the source image subresource depth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-srcOffset-00272)"},
    {"VUID-VkImageResolve-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageResolve-srcSubresource-parameter)"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSparseMemoryRequirementsInfo2-image-parameter)"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSparseMemoryRequirementsInfo2-pNext-pNext)"},
    {"VUID-VkImageSparseMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSparseMemoryRequirementsInfo2-sType-sType)"},
    {"VUID-VkImageStencilUsageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageStencilUsageCreateInfo-sType-sType)"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-02539", "If stencilUsage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, it must not include bits other than VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageStencilUsageCreateInfo-stencilUsage-02539)"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-parameter", "stencilUsage must be a valid combination of VkImageUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageStencilUsageCreateInfo-stencilUsage-parameter)"},
    {"VUID-VkImageStencilUsageCreateInfo-stencilUsage-requiredbitmask", "stencilUsage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageStencilUsageCreateInfo-stencilUsage-requiredbitmask)"},
    {"VUID-VkImageSubresource-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresource-aspectMask-parameter)"},
    {"VUID-VkImageSubresource-aspectMask-requiredbitmask", "aspectMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresource-aspectMask-requiredbitmask)"},
    {"VUID-VkImageSubresourceLayers-aspectMask-00167", "If aspectMask contains VK_IMAGE_ASPECT_COLOR_BIT, it must not contain either of VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceLayers-aspectMask-00167)"},
    {"VUID-VkImageSubresourceLayers-aspectMask-00168", "aspectMask must not contain VK_IMAGE_ASPECT_METADATA_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceLayers-aspectMask-00168)"},
    {"VUID-VkImageSubresourceLayers-aspectMask-02247", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceLayers-aspectMask-02247)"},
    {"VUID-VkImageSubresourceLayers-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceLayers-aspectMask-parameter)"},
    {"VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask", "aspectMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceLayers-aspectMask-requiredbitmask)"},
    {"VUID-VkImageSubresourceLayers-layerCount-01700", "layerCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceLayers-layerCount-01700)"},
    {"VUID-VkImageSubresourceRange-aspectMask-01670", "If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, then it must not include any of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceRange-aspectMask-01670)"},
    {"VUID-VkImageSubresourceRange-aspectMask-02278", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceRange-aspectMask-02278)"},
    {"VUID-VkImageSubresourceRange-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceRange-aspectMask-parameter)"},
    {"VUID-VkImageSubresourceRange-aspectMask-requiredbitmask", "aspectMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceRange-aspectMask-requiredbitmask)"},
    {"VUID-VkImageSubresourceRange-layerCount-01721", "If layerCount is not VK_REMAINING_ARRAY_LAYERS, it must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceRange-layerCount-01721)"},
    {"VUID-VkImageSubresourceRange-levelCount-01720", "If levelCount is not VK_REMAINING_MIP_LEVELS, it must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSubresourceRange-levelCount-01720)"},
    {"VUID-VkImageSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSwapchainCreateInfoKHR-sType-sType)"},
    {"VUID-VkImageSwapchainCreateInfoKHR-swapchain-00995", "If swapchain is not VK_NULL_HANDLE, the fields of VkImageCreateInfo must match the implied image creation parameters of the swapchain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSwapchainCreateInfoKHR-swapchain-00995)"},
    {"VUID-VkImageSwapchainCreateInfoKHR-swapchain-parameter", "If swapchain is not VK_NULL_HANDLE, swapchain must be a valid VkSwapchainKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageSwapchainCreateInfoKHR-swapchain-parameter)"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02230", "decodeMode must be one of VK_FORMAT_R16G16B16A16_SFLOAT, VK_FORMAT_R8G8B8A8_UNORM, or VK_FORMAT_E5B9G9R9_UFLOAT_PACK32 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02230)"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02231", "If the decodeModeSharedExponent feature is not enabled, decodeMode must not be VK_FORMAT_E5B9G9R9_UFLOAT_PACK32 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02231)"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02232", "If decodeMode is VK_FORMAT_R8G8B8A8_UNORM the image view must not include blocks using any of the ASTC HDR modes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewASTCDecodeModeEXT-decodeMode-02232)"},
    {"VUID-VkImageViewASTCDecodeModeEXT-decodeMode-parameter", "decodeMode must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewASTCDecodeModeEXT-decodeMode-parameter)"},
    {"VUID-VkImageViewASTCDecodeModeEXT-format-02233", "format of the image view must be one of VK_FORMAT_ASTC_4x4_UNORM_BLOCK, VK_FORMAT_ASTC_4x4_SRGB_BLOCK, VK_FORMAT_ASTC_5x4_UNORM_BLOCK, VK_FORMAT_ASTC_5x4_SRGB_BLOCK, VK_FORMAT_ASTC_5x5_UNORM_BLOCK, VK_FORMAT_ASTC_5x5_SRGB_BLOCK, VK_FORMAT_ASTC_6x5_UNORM_BLOCK, VK_FORMAT_ASTC_6x5_SRGB_BLOCK, VK_FORMAT_ASTC_6x6_UNORM_BLOCK, VK_FORMAT_ASTC_6x6_SRGB_BLOCK, VK_FORMAT_ASTC_8x5_UNORM_BLOCK, VK_FORMAT_ASTC_8x5_SRGB_BLOCK, VK_FORMAT_ASTC_8x6_UNORM_BLOCK, VK_FORMAT_ASTC_8x6_SRGB_BLOCK, VK_FORMAT_ASTC_8x8_UNORM_BLOCK, VK_FORMAT_ASTC_8x8_SRGB_BLOCK, VK_FORMAT_ASTC_10x5_UNORM_BLOCK, VK_FORMAT_ASTC_10x5_SRGB_BLOCK, VK_FORMAT_ASTC_10x6_UNORM_BLOCK, VK_FORMAT_ASTC_10x6_SRGB_BLOCK, VK_FORMAT_ASTC_10x8_UNORM_BLOCK, VK_FORMAT_ASTC_10x8_SRGB_BLOCK, VK_FORMAT_ASTC_10x10_UNORM_BLOCK, VK_FORMAT_ASTC_10x10_SRGB_BLOCK, VK_FORMAT_ASTC_12x10_UNORM_BLOCK, VK_FORMAT_ASTC_12x10_SRGB_BLOCK, VK_FORMAT_ASTC_12x12_UNORM_BLOCK, or VK_FORMAT_ASTC_12x12_SRGB_BLOCK (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewASTCDecodeModeEXT-format-02233)"},
    {"VUID-VkImageViewASTCDecodeModeEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewASTCDecodeModeEXT-sType-sType)"},
    {"VUID-VkImageViewCreateInfo-None-02273", "The format features of the resultant image view must contain at least one bit. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-None-02273)"},
    {"VUID-VkImageViewCreateInfo-components-parameter", "components must be a valid VkComponentMapping structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-components-parameter)"},
    {"VUID-VkImageViewCreateInfo-flags-02572", "If dynamic fragment density map feature is not enabled, flags must not contain VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-flags-02572)"},
    {"VUID-VkImageViewCreateInfo-flags-parameter", "flags must be a valid combination of VkImageViewCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-flags-parameter)"},
    {"VUID-VkImageViewCreateInfo-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-format-parameter)"},
    {"VUID-VkImageViewCreateInfo-image-01003", "If image was not created with VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT then viewType must not be VK_IMAGE_VIEW_TYPE_CUBE or VK_IMAGE_VIEW_TYPE_CUBE_ARRAY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01003)"},
    {"VUID-VkImageViewCreateInfo-image-01005", "If image was created with VK_IMAGE_TYPE_3D but without VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set then viewType must not be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01005)"},
    {"VUID-VkImageViewCreateInfo-image-01007", "image must have been created with a usage value containing at least one of VK_IMAGE_USAGE_SAMPLED_BIT, VK_IMAGE_USAGE_STORAGE_BIT, VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01007)"},
    {"VUID-VkImageViewCreateInfo-image-01018", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, format must be compatible with the format used to create image, as defined in Format Compatibility Classes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01018)"},
    {"VUID-VkImageViewCreateInfo-image-01019", "If image was not created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, format must be identical to the format used to create image (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01019)"},
    {"VUID-VkImageViewCreateInfo-image-01020", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01020)"},
    {"VUID-VkImageViewCreateInfo-image-01482", "If image is not a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, or viewType is not VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01482)"},
    {"VUID-VkImageViewCreateInfo-image-01583", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, format must be compatible with, or must be an uncompressed format that is size-compatible with, the format used to create image. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01583)"},
    {"VUID-VkImageViewCreateInfo-image-01584", "If image was created with the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, the levelCount and layerCount members of subresourceRange must both be 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01584)"},
    {"VUID-VkImageViewCreateInfo-image-01586", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, if the format of the image is a multi-planar format, and if subresourceRange.aspectMask is one of VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT, then format must be compatible with the VkFormat for the plane of the image format indicated by subresourceRange.aspectMask, as defined in Compatible formats of planes of multi-planar formats (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01586)"},
    {"VUID-VkImageViewCreateInfo-image-01759", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, but without the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, format must be compatible with the format used to create image, as defined in Format Compatibility Classes (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkImageViewCreateInfo-image-01759)"},
    {"VUID-VkImageViewCreateInfo-image-01760", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, and if the format of the image is not a multi-planar format, format must be compatible with the format used to create image, as defined in Format Compatibility Classes (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkImageViewCreateInfo-image-01760)"},
    {"VUID-VkImageViewCreateInfo-image-01761", "If image was created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, but without the VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT flag, and if the format of the image is not a multi-planar format, format must be compatible with the format used to create image, as defined in Format Compatibility Classes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01761)"},
    {"VUID-VkImageViewCreateInfo-image-01762", "If image was not created with the VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT flag, or if the format of the image is a multi-planar format and if subresourceRange.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, format must be identical to the format used to create image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-01762)"},
    {"VUID-VkImageViewCreateInfo-image-02085", "image must have been created with a usage value containing at least one of VK_IMAGE_USAGE_SAMPLED_BIT, VK_IMAGE_USAGE_STORAGE_BIT, VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkImageViewCreateInfo-image-02085)"},
    {"VUID-VkImageViewCreateInfo-image-02086", "If image was created with usage containing VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, viewType must be VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02086)"},
    {"VUID-VkImageViewCreateInfo-image-02087", "If image was created with usage containing VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, format must be VK_FORMAT_R8_UINT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02087)"},
    {"VUID-VkImageViewCreateInfo-image-02399", "If image has an external format, format must be VK_FORMAT_UNDEFINED. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02399)"},
    {"VUID-VkImageViewCreateInfo-image-02400", "If image has an external format, the pNext chain must include a VkSamplerYcbcrConversionInfo structure with a conversion object created with the same external format as image. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02400)"},
    {"VUID-VkImageViewCreateInfo-image-02401", "If image has an external format, all members of components must be VK_COMPONENT_SWIZZLE_IDENTITY. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02401)"},
    {"VUID-VkImageViewCreateInfo-image-02569", "image must have been created with a usage value containing at least one of VK_IMAGE_USAGE_SAMPLED_BIT, VK_IMAGE_USAGE_STORAGE_BIT, VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, or VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkImageViewCreateInfo-image-02569)"},
    {"VUID-VkImageViewCreateInfo-image-02570", "image must have been created with a usage value containing at least one of VK_IMAGE_USAGE_SAMPLED_BIT, VK_IMAGE_USAGE_STORAGE_BIT, VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV, or VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02570)"},
    {"VUID-VkImageViewCreateInfo-image-02571", "If image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, subresourceRange.levelCount must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02571)"},
    {"VUID-VkImageViewCreateInfo-image-02573", "If dynamic fragment density map feature is not enabled and image was created with usage containing VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, flags must not contain any of VK_IMAGE_CREATE_PROTECTED_BIT, VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02573)"},
    {"VUID-VkImageViewCreateInfo-image-02724", "If image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.baseArrayLayer must be less than the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Miplevel Sizing. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-02724)"},
    {"VUID-VkImageViewCreateInfo-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-image-parameter)"},
    {"VUID-VkImageViewCreateInfo-pNext-01585", "If a VkImageFormatListCreateInfo structure was included in the pNext chain of the VkImageCreateInfo structure used when creating image and the viewFormatCount field of VkImageFormatListCreateInfo is not zero then format must be one of the formats in VkImageFormatListCreateInfo::pViewFormats. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-pNext-01585)"},
    {"VUID-VkImageViewCreateInfo-pNext-01970", "If the pNext chain includes a VkSamplerYcbcrConversionInfo structure with a conversion value other than VK_NULL_HANDLE, all members of components must have the value VK_COMPONENT_SWIZZLE_IDENTITY. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-pNext-01970)"},
    {"VUID-VkImageViewCreateInfo-pNext-02661", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, its usage member must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image. (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-pNext-02661)"},
    {"VUID-VkImageViewCreateInfo-pNext-02662", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, and image was not created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, its usage member must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-pNext-02662)"},
    {"VUID-VkImageViewCreateInfo-pNext-02663", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, image was created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, and subResourceRange.aspectMask includes VK_IMAGE_ASPECT_STENCIL_BIT, the usage member of the VkImageViewUsageCreateInfo instance must not include any bits that were not set in the usage member of the VkImageStencilUsageCreateInfo structure used to create image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-pNext-02663)"},
    {"VUID-VkImageViewCreateInfo-pNext-02664", "If the pNext chain includes a VkImageViewUsageCreateInfo structure, image was created with a VkImageStencilUsageCreateInfo structure included in the pNext chain of VkImageCreateInfo, and subResourceRange.aspectMask includes bits other than VK_IMAGE_ASPECT_STENCIL_BIT, the usage member of the VkImageViewUsageCreateInfo structure must not include any bits that were not set in the usage member of the VkImageCreateInfo structure used to create image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-pNext-02664)"},
    {"VUID-VkImageViewCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkImageViewASTCDecodeModeEXT, VkImageViewUsageCreateInfo, or VkSamplerYcbcrConversionInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-pNext-pNext)"},
    {"VUID-VkImageViewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-sType-sType)"},
    {"VUID-VkImageViewCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-sType-unique)"},
    {"VUID-VkImageViewCreateInfo-subResourceRange-01021", "subresourceRange and viewType must be compatible with the image, as described in the compatibility table (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-subResourceRange-01021)"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01478", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-subresourceRange-01478)"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01480", "subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageViewCreateInfo-subresourceRange-01480)"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01483", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, image is not a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, or viewType is not VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.layerCount must be non-zero and subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-subresourceRange-01483)"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01718", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-subresourceRange-01718)"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-01719", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkImageViewCreateInfo-subresourceRange-01719)"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-02725", "If subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, and viewType is VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY, subresourceRange.layerCount must be non-zero and subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Miplevel Sizing. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-subresourceRange-02725)"},
    {"VUID-VkImageViewCreateInfo-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-subresourceRange-parameter)"},
    {"VUID-VkImageViewCreateInfo-usage-02274", "If usage contains VK_IMAGE_USAGE_SAMPLED_BIT, then the format features of the resultant image view must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-usage-02274)"},
    {"VUID-VkImageViewCreateInfo-usage-02275", "If usage contains VK_IMAGE_USAGE_STORAGE_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-usage-02275)"},
    {"VUID-VkImageViewCreateInfo-usage-02276", "If usage contains VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-usage-02276)"},
    {"VUID-VkImageViewCreateInfo-usage-02277", "If usage contains VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, then the image view's format features must contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-usage-02277)"},
    {"VUID-VkImageViewCreateInfo-usage-02652", "If usage contains VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, then the image view's format features must contain at least one of VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-usage-02652)"},
    {"VUID-VkImageViewCreateInfo-viewType-01004", "If the image cubemap arrays feature is not enabled, viewType must not be VK_IMAGE_VIEW_TYPE_CUBE_ARRAY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-viewType-01004)"},
    {"VUID-VkImageViewCreateInfo-viewType-parameter", "viewType must be a valid VkImageViewType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewCreateInfo-viewType-parameter)"},
    {"VUID-VkImageViewHandleInfoNVX-commonparent", "Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-commonparent)"},
    {"VUID-VkImageViewHandleInfoNVX-descriptorType-02654", "descriptorType must be VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-descriptorType-02654)"},
    {"VUID-VkImageViewHandleInfoNVX-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-descriptorType-parameter)"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-02656", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the image that imageView was created from must have been created with the VK_IMAGE_USAGE_SAMPLED_BIT usage bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-imageView-02656)"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-02657", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, the image that imageView was created from must have been created with the VK_IMAGE_USAGE_STORAGE_BIT usage bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-imageView-02657)"},
    {"VUID-VkImageViewHandleInfoNVX-imageView-parameter", "imageView must be a valid VkImageView handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-imageView-parameter)"},
    {"VUID-VkImageViewHandleInfoNVX-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-pNext-pNext)"},
    {"VUID-VkImageViewHandleInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-sType-sType)"},
    {"VUID-VkImageViewHandleInfoNVX-sampler-02655", "sampler must be a valid VkSampler if descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-sampler-02655)"},
    {"VUID-VkImageViewHandleInfoNVX-sampler-parameter", "If sampler is not VK_NULL_HANDLE, sampler must be a valid VkSampler handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewHandleInfoNVX-sampler-parameter)"},
    {"VUID-VkImageViewUsageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewUsageCreateInfo-sType-sType)"},
    {"VUID-VkImageViewUsageCreateInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewUsageCreateInfo-usage-parameter)"},
    {"VUID-VkImageViewUsageCreateInfo-usage-requiredbitmask", "usage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImageViewUsageCreateInfo-usage-requiredbitmask)"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01880", "If buffer is not NULL, Android hardware buffers must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01880)"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01881", "If buffer is not NULL, it must be a valid Android hardware buffer object with AHardwareBuffer_Desc::format and AHardwareBuffer_Desc::usage compatible with Vulkan as described in Android Hardware Buffers. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-01881)"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-parameter", "buffer must be a valid pointer to an AHardwareBuffer value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportAndroidHardwareBufferInfoANDROID-buffer-parameter)"},
    {"VUID-VkImportAndroidHardwareBufferInfoANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportAndroidHardwareBufferInfoANDROID-sType-sType)"},
    {"VUID-VkImportFenceFdInfoKHR-fd-01541", "fd must obey any requirements listed for handleType in external fence handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceFdInfoKHR-fd-01541)"},
    {"VUID-VkImportFenceFdInfoKHR-fence-parameter", "fence must be a valid VkFence handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceFdInfoKHR-fence-parameter)"},
    {"VUID-VkImportFenceFdInfoKHR-flags-parameter", "flags must be a valid combination of VkFenceImportFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceFdInfoKHR-flags-parameter)"},
    {"VUID-VkImportFenceFdInfoKHR-handleType-01464", "handleType must be a value included in the Handle Types Supported by VkImportFenceFdInfoKHR table. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceFdInfoKHR-handleType-01464)"},
    {"VUID-VkImportFenceFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceFdInfoKHR-handleType-parameter)"},
    {"VUID-VkImportFenceFdInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceFdInfoKHR-pNext-pNext)"},
    {"VUID-VkImportFenceFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceFdInfoKHR-sType-sType)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-fence-parameter", "fence must be a valid VkFence handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-fence-parameter)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-flags-parameter", "flags must be a valid combination of VkFenceImportFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-flags-parameter)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handle-01462", "If handle is not NULL, name must be NULL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-handle-01462)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handle-01539", "If handle is not NULL, it must obey any requirements listed for handleType in external fence handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-handle-01539)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01457", "handleType must be a value included in the Handle Types Supported by VkImportFenceWin32HandleInfoKHR table. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-handleType-01457)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01459", "If handleType is not VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, name must be NULL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-handleType-01459)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01460", "If handleType is not 0 and handle is NULL, name must name a valid synchronization primitive of the type specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-handleType-01460)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-01461", "If handleType is not 0 and name is NULL, handle must be a valid handle of the type specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-handleType-01461)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalFenceHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-handleType-parameter)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-name-01540", "If name is not NULL, it must obey any requirements listed for handleType in external fence handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-name-01540)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-pNext-pNext)"},
    {"VUID-VkImportFenceWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportFenceWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-00668", "The memory from which fd was exported must have been created on the same underlying physical device as device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-fd-00668)"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-01520", "fd must obey any requirements listed for handleType in external memory handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-fd-01520)"},
    {"VUID-VkImportMemoryFdInfoKHR-fd-01746", "The memory represented by fd must have been created from a physical device and driver that is compatible with device and handleType, as described in External memory handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-fd-01746)"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00667", "If handleType is not 0, it must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-handleType-00667)"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00669", "If handleType is not 0, it must be defined as a POSIX file descriptor handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-handleType-00669)"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-00670", "If handleType is not 0, fd must be a valid handle of the type specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-handleType-00670)"},
    {"VUID-VkImportMemoryFdInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-handleType-parameter)"},
    {"VUID-VkImportMemoryFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryFdInfoKHR-sType-sType)"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01747", "If handleType is not 0, it must be supported for import, as reported in VkExternalMemoryProperties (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryHostPointerInfoEXT-handleType-01747)"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01748", "If handleType is not 0, it must be VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT or VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryHostPointerInfoEXT-handleType-01748)"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01750", "If handleType is VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT, pHostPointer must be a pointer to allocationSize number of bytes of host memory, where allocationSize is the member of the VkMemoryAllocateInfo structure this structure is chained to (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryHostPointerInfoEXT-handleType-01750)"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-01751", "If handleType is VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT, pHostPointer must be a pointer to allocationSize number of bytes of host mapped foreign memory, where allocationSize is the member of the VkMemoryAllocateInfo structure this structure is chained to (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryHostPointerInfoEXT-handleType-01751)"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryHostPointerInfoEXT-handleType-parameter)"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-pHostPointer-01749", "pHostPointer must be a pointer aligned to an integer multiple of VkPhysicalDeviceExternalMemoryHostPropertiesEXT::minImportedHostPointerAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryHostPointerInfoEXT-pHostPointer-01749)"},
    {"VUID-VkImportMemoryHostPointerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryHostPointerInfoEXT-sType-sType)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-00659", "The memory from which handle was exported, or the memory named by name must have been created on the same underlying physical device as device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handle-00659)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-01441", "if handle is not NULL, name must be NULL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handle-01441)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handle-01518", "If handle is not NULL, it must obey any requirements listed for handleType in external memory handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handle-01518)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00658", "If handleType is not 0, it must be supported for import, as reported by VkExternalImageFormatProperties or VkExternalBufferProperties. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00658)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00660", "If handleType is not 0, it must be defined as an NT handle or a global share handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00660)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00661", "If handleType is not 0 and name is NULL, handle must be a valid handle of the type specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handleType-00661)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01439", "If handleType is not VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, name must be NULL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01439)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01440", "If handleType is not 0 and handle is NULL, name must name a valid memory resource of the type specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handleType-01440)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-handleType-parameter)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-name-01519", "If name is not NULL, it must obey any requirements listed for handleType in external memory handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-name-01519)"},
    {"VUID-VkImportMemoryWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handle-01328", "handle must be a valid handle to memory, obtained as specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoNV-handle-01328)"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handleType-01327", "handleType must not have more than one bit set. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoNV-handleType-01327)"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-handleType-parameter", "handleType must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoNV-handleType-parameter)"},
    {"VUID-VkImportMemoryWin32HandleInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportMemoryWin32HandleInfoNV-sType-sType)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-fd-01544", "fd must obey any requirements listed for handleType in external semaphore handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-fd-01544)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-flags-03323", "If flags contains VK_SEMAPHORE_IMPORT_TEMPORARY_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field of the semaphore from which fd was exported must not be VK_SEMAPHORE_TYPE_TIMELINE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-flags-03323)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-flags-parameter)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-01143", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreFdInfoKHR table. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-handleType-01143)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-03263", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the VkSemaphoreCreateInfo::flags field must match that of the semaphore from which fd was exported. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-handleType-03263)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-03264", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field must match that of the semaphore from which fd was exported. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-handleType-03264)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-handleType-parameter)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-pNext-pNext)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-sType-sType)"},
    {"VUID-VkImportSemaphoreFdInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreFdInfoKHR-semaphore-parameter)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-03322", "If flags contains VK_SEMAPHORE_IMPORT_TEMPORARY_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field of the semaphore from which handle or name was exported must not be VK_SEMAPHORE_TYPE_TIMELINE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-03322)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-parameter", "flags must be a valid combination of VkSemaphoreImportFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-flags-parameter)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01469", "If handle is not NULL, name must be NULL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01469)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01542", "If handle is not NULL, it must obey any requirements listed for handleType in external semaphore handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handle-01542)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01140", "handleType must be a value included in the Handle Types Supported by VkImportSemaphoreWin32HandleInfoKHR table. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01140)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01466", "If handleType is not VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, name must be NULL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01466)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01467", "If handleType is not 0 and handle is NULL, name must name a valid synchronization primitive of the type specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01467)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01468", "If handleType is not 0 and name is NULL, handle must be a valid handle of the type specified by handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-01468)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03261", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the VkSemaphoreCreateInfo::flags field must match that of the semaphore from which handle or name was exported. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03261)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03262", "If handleType is VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, the VkSemaphoreTypeCreateInfo::semaphoreType field must match that of the semaphore from which handle or name was exported. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-03262)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-handleType-parameter)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-name-01543", "If name is not NULL, it must obey any requirements listed for handleType in external semaphore handle types compatibility. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-name-01543)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-pNext-pNext)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkImportSemaphoreWin32HandleInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkImportSemaphoreWin32HandleInfoKHR-semaphore-parameter)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-computeBindingPointSupport-01348", "If the VkDeviceGeneratedCommandsFeaturesNVX::computeBindingPointSupport feature is not enabled, then pipelineBindPoint must not be VK_PIPELINE_BIND_POINT_COMPUTE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-computeBindingPointSupport-01348)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-flags-parameter", "flags must be a valid combination of VkIndirectCommandsLayoutUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-flags-parameter)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-flags-requiredbitmask", "flags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-flags-requiredbitmask)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-pNext-pNext)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-01349", "If pTokens contains an entry of VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NVX it must be the first element of the array and there must be only a single element of such token type. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-01349)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-01350", "All state binding tokens in pTokens must occur prior work provoking tokens (VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NVX, VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NVX, VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_NVX). (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-01350)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-01351", "The content of pTokens must include one single work provoking token that is compatible with the pipelineBindPoint. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-01351)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-parameter", "pTokens must be a valid pointer to an array of tokenCount valid VkIndirectCommandsLayoutTokenNVX structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-pTokens-parameter)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-pipelineBindPoint-parameter)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-sType-sType)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-tokenCount-01347", "tokenCount must be greater than 0 and below VkDeviceGeneratedCommandsLimitsNVX::maxIndirectCommandsLayoutTokenCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-tokenCount-01347)"},
    {"VUID-VkIndirectCommandsLayoutCreateInfoNVX-tokenCount-arraylength", "tokenCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutCreateInfoNVX-tokenCount-arraylength)"},
    {"VUID-VkIndirectCommandsLayoutTokenNVX-bindingUnit-01342", "bindingUnit must stay within device supported limits for the appropriate commands. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutTokenNVX-bindingUnit-01342)"},
    {"VUID-VkIndirectCommandsLayoutTokenNVX-divisor-01344", "divisor must be greater than 0 and a power of two. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutTokenNVX-divisor-01344)"},
    {"VUID-VkIndirectCommandsLayoutTokenNVX-dynamicCount-01343", "dynamicCount must stay within device supported limits for the appropriate commands. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutTokenNVX-dynamicCount-01343)"},
    {"VUID-VkIndirectCommandsLayoutTokenNVX-tokenType-parameter", "tokenType must be a valid VkIndirectCommandsTokenTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsLayoutTokenNVX-tokenType-parameter)"},
    {"VUID-VkIndirectCommandsTokenNVX-buffer-01345", "The buffer's usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsTokenNVX-buffer-01345)"},
    {"VUID-VkIndirectCommandsTokenNVX-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsTokenNVX-buffer-parameter)"},
    {"VUID-VkIndirectCommandsTokenNVX-offset-01346", "The offset must be aligned to VkDeviceGeneratedCommandsLimitsNVX::minCommandsTokenBufferOffsetAlignment. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsTokenNVX-offset-01346)"},
    {"VUID-VkIndirectCommandsTokenNVX-tokenType-parameter", "tokenType must be a valid VkIndirectCommandsTokenTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkIndirectCommandsTokenNVX-tokenType-parameter)"},
    {"VUID-VkInitializePerformanceApiInfoINTEL-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInitializePerformanceApiInfoINTEL-pNext-pNext)"},
    {"VUID-VkInitializePerformanceApiInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInitializePerformanceApiInfoINTEL-sType-sType)"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-01964", "aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInputAttachmentAspectReference-aspectMask-01964)"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-02250", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInputAttachmentAspectReference-aspectMask-02250)"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInputAttachmentAspectReference-aspectMask-parameter)"},
    {"VUID-VkInputAttachmentAspectReference-aspectMask-requiredbitmask", "aspectMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInputAttachmentAspectReference-aspectMask-requiredbitmask)"},
    {"VUID-VkInstanceCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInstanceCreateInfo-flags-zerobitmask)"},
    {"VUID-VkInstanceCreateInfo-pApplicationInfo-parameter", "If pApplicationInfo is not NULL, pApplicationInfo must be a valid pointer to a valid VkApplicationInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInstanceCreateInfo-pApplicationInfo-parameter)"},
    {"VUID-VkInstanceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDebugReportCallbackCreateInfoEXT, VkDebugUtilsMessengerCreateInfoEXT, VkValidationFeaturesEXT, or VkValidationFlagsEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInstanceCreateInfo-pNext-pNext)"},
    {"VUID-VkInstanceCreateInfo-ppEnabledExtensionNames-parameter", "If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInstanceCreateInfo-ppEnabledExtensionNames-parameter)"},
    {"VUID-VkInstanceCreateInfo-ppEnabledLayerNames-parameter", "If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInstanceCreateInfo-ppEnabledLayerNames-parameter)"},
    {"VUID-VkInstanceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInstanceCreateInfo-sType-sType)"},
    {"VUID-VkInstanceCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkInstanceCreateInfo-sType-unique)"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMacOSSurfaceCreateInfoMVK-flags-zerobitmask)"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMacOSSurfaceCreateInfoMVK-pNext-pNext)"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-pView-01317", "pView must be a valid NSView and must be backed by a CALayer instance of type CAMetalLayer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMacOSSurfaceCreateInfoMVK-pView-01317)"},
    {"VUID-VkMacOSSurfaceCreateInfoMVK-sType-sType", "sType must be VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMacOSSurfaceCreateInfoMVK-sType-sType)"},
    {"VUID-VkMappedMemoryRange-memory-00684", "memory must be currently host mapped (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-memory-00684)"},
    {"VUID-VkMappedMemoryRange-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-memory-parameter)"},
    {"VUID-VkMappedMemoryRange-offset-00687", "offset must be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-offset-00687)"},
    {"VUID-VkMappedMemoryRange-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-pNext-pNext)"},
    {"VUID-VkMappedMemoryRange-sType-sType", "sType must be VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-sType-sType)"},
    {"VUID-VkMappedMemoryRange-size-00685", "If size is not equal to VK_WHOLE_SIZE, offset and size must specify a range contained within the currently mapped range of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-size-00685)"},
    {"VUID-VkMappedMemoryRange-size-00686", "If size is equal to VK_WHOLE_SIZE, offset must be within the currently mapped range of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-size-00686)"},
    {"VUID-VkMappedMemoryRange-size-01389", "If size is equal to VK_WHOLE_SIZE, the end of the current mapping of memory must be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize bytes from the beginning of the memory object. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-size-01389)"},
    {"VUID-VkMappedMemoryRange-size-01390", "If size is not equal to VK_WHOLE_SIZE, size must either be a multiple of VkPhysicalDeviceLimits::nonCoherentAtomSize, or offset plus size must equal the size of memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMappedMemoryRange-size-01390)"},
    {"VUID-VkMemoryAllocateFlagsInfo-deviceMask-00675", "If VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT is set, deviceMask must be a valid device mask. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateFlagsInfo-deviceMask-00675)"},
    {"VUID-VkMemoryAllocateFlagsInfo-deviceMask-00676", "If VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT is set, deviceMask must not be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateFlagsInfo-deviceMask-00676)"},
    {"VUID-VkMemoryAllocateFlagsInfo-flags-parameter", "flags must be a valid combination of VkMemoryAllocateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateFlagsInfo-flags-parameter)"},
    {"VUID-VkMemoryAllocateFlagsInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateFlagsInfo-sType-sType)"},
    {"VUID-VkMemoryAllocateInfo-None-00643", "If the parameters define an import operation and the external handle specified was created by the Vulkan API, the device mask specified by VkMemoryAllocateFlagsInfo must match that specified when the memory object being imported was allocated. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-None-00643)"},
    {"VUID-VkMemoryAllocateInfo-None-00644", "If the parameters define an import operation and the external handle specified was created by the Vulkan API, the list of physical devices that comprise the logical device passed to vkAllocateMemory must match the list of physical devices that comprise the logical device on which the memory was originally allocated. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-None-00644)"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-00638", "allocationSize must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-allocationSize-00638)"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-00646", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, allocationSize must match the size reported in the memory requirements of the image or buffer member of the VkDedicatedAllocationMemoryAllocateInfoNV structure included in the pNext chain. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-allocationSize-00646)"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-00647", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, allocationSize must match the size specified when creating the Direct3D 12 heap from which the external handle was extracted. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-allocationSize-00647)"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01742", "If the parameters define an import operation, the external handle specified was created by the Vulkan API, and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR, then the values of allocationSize and memoryTypeIndex must match those specified when the memory object being imported was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-allocationSize-01742)"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01743", "If the parameters define an import operation, the external handle was created by the Vulkan API, and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR or VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR, then the values of allocationSize and memoryTypeIndex must match those specified when the memory object being imported was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-allocationSize-01743)"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-01745", "If the parameters define an import operation and the external handle is a host pointer, allocationSize must be an integer multiple of VkPhysicalDeviceExternalMemoryHostPropertiesEXT::minImportedHostPointerAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-allocationSize-01745)"},
    {"VUID-VkMemoryAllocateInfo-allocationSize-02383", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, allocationSize must be the size returned by vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-allocationSize-02383)"},
    {"VUID-VkMemoryAllocateInfo-flags-03330", "If VkMemoryAllocateFlagsInfo::flags includes VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the bufferDeviceAddressCaptureReplay feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-flags-03330)"},
    {"VUID-VkMemoryAllocateInfo-flags-03331", "If VkMemoryAllocateFlagsInfo::flags includes VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT, the bufferDeviceAddress feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-flags-03331)"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-00645", "If the parameters define an import operation and the external handle is an NT handle or a global share handle created outside of the Vulkan API, the value of memoryTypeIndex must be one of those returned by vkGetMemoryWin32HandlePropertiesKHR. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-memoryTypeIndex-00645)"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-00648", "If the parameters define an import operation and the external handle is a POSIX file descriptor created outside of the Vulkan API, the value of memoryTypeIndex must be one of those returned by vkGetMemoryFdPropertiesKHR. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-memoryTypeIndex-00648)"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-01744", "If the parameters define an import operation and the external handle is a host pointer, the value of memoryTypeIndex must be one of those returned by vkGetMemoryHostPointerPropertiesEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-memoryTypeIndex-01744)"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-01872", "If the protected memory feature is not enabled, the VkMemoryAllocateInfo::memoryTypeIndex must not indicate a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-memoryTypeIndex-01872)"},
    {"VUID-VkMemoryAllocateInfo-memoryTypeIndex-02385", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, memoryTypeIndex must be one of those returned by vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-memoryTypeIndex-02385)"},
    {"VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03329", "If VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress is not zero, VkMemoryAllocateFlagsInfo::flags must include VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03329)"},
    {"VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03333", "If the parameters define an import operation, VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-opaqueCaptureAddress-03333)"},
    {"VUID-VkMemoryAllocateInfo-pNext-00639", "If the pNext chain includes a VkExportMemoryAllocateInfo     structure, and any of the handle types specified in     VkExportMemoryAllocateInfo::handleTypes require a dedicated     allocation, as reported by     vkGetPhysicalDeviceImageFormatProperties2 in     VkExternalImageFormatProperties::externalMemoryProperties.externalMemoryFeatures     or     VkExternalBufferProperties::externalMemoryProperties.externalMemoryFeatures,     the pNext chain must include a ifdef::VK_KHR_dedicated_allocation[VkMemoryDedicatedAllocateInfo] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-00639)"},
    {"VUID-VkMemoryAllocateInfo-pNext-00640", "If the pNext chain includes a VkExportMemoryAllocateInfo structure, it must not include a VkExportMemoryAllocateInfoNV or VkExportMemoryWin32HandleInfoNV structure. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-00640)"},
    {"VUID-VkMemoryAllocateInfo-pNext-00641", "If the pNext chain includes a VkImportMemoryWin32HandleInfoKHR structure, it must not include a VkImportMemoryWin32HandleInfoNV structure. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-00641)"},
    {"VUID-VkMemoryAllocateInfo-pNext-01874", "If the parameters do not define an import operation, and the pNext chain includes a VkExportMemoryAllocateInfo structure with VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID included in its handleTypes member, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image not equal to VK_NULL_HANDLE, then allocationSize must be 0, otherwise allocationSize must be greater than 0. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-01874)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02384", "If the parameters define an import operation and the external handle type is VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, and the pNext chain does not include a VkMemoryDedicatedAllocateInfo structure or VkMemoryDedicatedAllocateInfo::image is VK_NULL_HANDLE, the Android hardware buffer must have a AHardwareBuffer_Desc::format of AHARDWAREBUFFER_FORMAT_BLOB and a AHardwareBuffer_Desc::usage that includes AHARDWAREBUFFER_USAGE_GPU_DATA_BUFFER. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02384)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02386", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the Android hardware buffer's AHardwareBuffer::usage must include at least one of AHARDWAREBUFFER_USAGE_GPU_COLOR_OUTPUT or AHARDWAREBUFFER_USAGE_GPU_SAMPLED_IMAGE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02386)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02387", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo with image that is not VK_NULL_HANDLE, the format of image must be VK_FORMAT_UNDEFINED or the format returned by vkGetAndroidHardwareBufferPropertiesANDROID in VkAndroidHardwareBufferFormatPropertiesANDROID::format for the Android hardware buffer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02387)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02388", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, the width, height, and array layer dimensions of image and the Android hardware buffer's AHardwareBuffer_Desc must be identical. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02388)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02389", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, and the Android hardware buffer's AHardwareBuffer::usage includes AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE, the image must have a complete mipmap chain. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02389)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02390", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, each bit set in the usage of image must be listed in AHardwareBuffer Usage Equivalence, and if there is a corresponding AHARDWAREBUFFER_USAGE bit listed that bit must be included in the Android hardware buffer's AHardwareBuffer_Desc::usage. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02390)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02586", "If the parameters define an import operation, the external handle is an Android hardware buffer, and the pNext chain includes a VkMemoryDedicatedAllocateInfo structure with image that is not VK_NULL_HANDLE, and the Android hardware buffer's AHardwareBuffer::usage does not include AHARDWAREBUFFER_USAGE_GPU_MIPMAP_COMPLETE, the image must have exactly one mipmap level. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02586)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02805", "If the parameters define an import operation and the external handle is a host pointer, the pNext chain must not include a VkDedicatedAllocationMemoryAllocateInfoNV structure with either its image or buffer field set to a value other than VK_NULL_HANDLE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02805)"},
    {"VUID-VkMemoryAllocateInfo-pNext-02806", "If the parameters define an import operation and the external handle is a host pointer, the pNext chain must not include a VkMemoryDedicatedAllocateInfo structure with either its image or buffer field set to a value other than VK_NULL_HANDLE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-02806)"},
    {"VUID-VkMemoryAllocateInfo-pNext-03332", "If the pNext chain includes a VkImportMemoryHostPointerInfoEXT structure, VkMemoryOpaqueCaptureAddressAllocateInfo::opaqueCaptureAddress must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-03332)"},
    {"VUID-VkMemoryAllocateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDedicatedAllocationMemoryAllocateInfoNV, VkExportMemoryAllocateInfo, VkExportMemoryAllocateInfoNV, VkExportMemoryWin32HandleInfoKHR, VkExportMemoryWin32HandleInfoNV, VkImportAndroidHardwareBufferInfoANDROID, VkImportMemoryFdInfoKHR, VkImportMemoryHostPointerInfoEXT, VkImportMemoryWin32HandleInfoKHR, VkImportMemoryWin32HandleInfoNV, VkMemoryAllocateFlagsInfo, VkMemoryDedicatedAllocateInfo, VkMemoryOpaqueCaptureAddressAllocateInfo, or VkMemoryPriorityAllocateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-pNext-pNext)"},
    {"VUID-VkMemoryAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-sType-sType)"},
    {"VUID-VkMemoryAllocateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryAllocateInfo-sType-unique)"},
    {"VUID-VkMemoryBarrier-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryBarrier-dstAccessMask-parameter)"},
    {"VUID-VkMemoryBarrier-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryBarrier-pNext-pNext)"},
    {"VUID-VkMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_BARRIER (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryBarrier-sType-sType)"},
    {"VUID-VkMemoryBarrier-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryBarrier-srcAccessMask-parameter)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01435", "If buffer is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-buffer-01435)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01436", "If buffer is not VK_NULL_HANDLE, buffer must have been created without VK_BUFFER_CREATE_SPARSE_BINDING_BIT set in VkBufferCreateInfo::flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-buffer-01436)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01877", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, and the external handle was created by the Vulkan API, then the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-buffer-01877)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-01879", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-buffer-01879)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-buffer-parameter)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-commonparent", "Both of buffer, and image that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-commonparent)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01432", "At least one of image and buffer must be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-image-01432)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01433", "If image is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-image-01433)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01434", "If image is not VK_NULL_HANDLE, image must have been created without VK_IMAGE_CREATE_SPARSE_BINDING_BIT set in VkImageCreateInfo::flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-image-01434)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01797", "If image is not VK_NULL_HANDLE, image must not have been created with VK_IMAGE_CREATE_DISJOINT_BIT set in VkImageCreateInfo::flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-image-01797)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01876", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT, VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT, or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT, and the external handle was created by the Vulkan API, then the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-image-01876)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-01878", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation with handle type VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-image-01878)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-image-parameter)"},
    {"VUID-VkMemoryDedicatedAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedAllocateInfo-sType-sType)"},
    {"VUID-VkMemoryDedicatedRequirements-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryDedicatedRequirements-sType-sType)"},
    {"VUID-VkMemoryFdPropertiesKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryFdPropertiesKHR-pNext-pNext)"},
    {"VUID-VkMemoryFdPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryFdPropertiesKHR-sType-sType)"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-handleTypes-01882", "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must have been included in VkExportMemoryAllocateInfo::handleTypes when memory was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-handleTypes-01882)"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-memory-parameter)"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-pNext-01883", "If the pNext chain of the VkMemoryAllocateInfo used to allocate memory included a VkMemoryDedicatedAllocateInfo with non-NULL image member, then that image must already be bound to memory. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-pNext-01883)"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-pNext-pNext)"},
    {"VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetAndroidHardwareBufferInfoANDROID-sType-sType)"},
    {"VUID-VkMemoryGetFdInfoKHR-handleType-00671", "handleType must have been included in VkExportMemoryAllocateInfo::handleTypes when memory was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetFdInfoKHR-handleType-00671)"},
    {"VUID-VkMemoryGetFdInfoKHR-handleType-00672", "handleType must be defined as a POSIX file descriptor handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetFdInfoKHR-handleType-00672)"},
    {"VUID-VkMemoryGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetFdInfoKHR-handleType-parameter)"},
    {"VUID-VkMemoryGetFdInfoKHR-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetFdInfoKHR-memory-parameter)"},
    {"VUID-VkMemoryGetFdInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetFdInfoKHR-pNext-pNext)"},
    {"VUID-VkMemoryGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetFdInfoKHR-sType-sType)"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00662", "handleType must have been included in VkExportMemoryAllocateInfo::handleTypes when memory was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00662)"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00663", "If handleType is defined as an NT handle, vkGetMemoryWin32HandleKHR must be called no more than once for each valid unique combination of memory and handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00663)"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00664", "handleType must be defined as an NT handle or a global share handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetWin32HandleInfoKHR-handleType-00664)"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetWin32HandleInfoKHR-handleType-parameter)"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetWin32HandleInfoKHR-memory-parameter)"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetWin32HandleInfoKHR-pNext-pNext)"},
    {"VUID-VkMemoryGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryGetWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkMemoryHostPointerPropertiesEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryHostPointerPropertiesEXT-pNext-pNext)"},
    {"VUID-VkMemoryHostPointerPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryHostPointerPropertiesEXT-sType-sType)"},
    {"VUID-VkMemoryOpaqueCaptureAddressAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryOpaqueCaptureAddressAllocateInfo-sType-sType)"},
    {"VUID-VkMemoryPriorityAllocateInfoEXT-priority-02602", "priority must be between 0 and 1, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryPriorityAllocateInfoEXT-priority-02602)"},
    {"VUID-VkMemoryPriorityAllocateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryPriorityAllocateInfoEXT-sType-sType)"},
    {"VUID-VkMemoryRequirements2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkMemoryDedicatedRequirements (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryRequirements2-pNext-pNext)"},
    {"VUID-VkMemoryRequirements2-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryRequirements2-sType-sType)"},
    {"VUID-VkMemoryWin32HandlePropertiesKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryWin32HandlePropertiesKHR-pNext-pNext)"},
    {"VUID-VkMemoryWin32HandlePropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMemoryWin32HandlePropertiesKHR-sType-sType)"},
    {"VUID-VkMetalSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMetalSurfaceCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkMetalSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMetalSurfaceCreateInfoEXT-pNext-pNext)"},
    {"VUID-VkMetalSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMetalSurfaceCreateInfoEXT-sType-sType)"},
    {"VUID-VkMultisamplePropertiesEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMultisamplePropertiesEXT-pNext-pNext)"},
    {"VUID-VkMultisamplePropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkMultisamplePropertiesEXT-sType-sType)"},
    {"VUID-VkObjectTableCreateInfoNVX-computeBindingPointSupport-01355", "If the VkDeviceGeneratedCommandsFeaturesNVX::computeBindingPointSupport feature is not enabled, pObjectEntryUsageFlags must not contain VK_OBJECT_ENTRY_USAGE_COMPUTE_BIT_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-computeBindingPointSupport-01355)"},
    {"VUID-VkObjectTableCreateInfoNVX-maxSampledImagesPerDescriptor-01360", "maxSampledImagesPerDescriptor must be within the limits supported by the device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-maxSampledImagesPerDescriptor-01360)"},
    {"VUID-VkObjectTableCreateInfoNVX-maxStorageBuffersPerDescriptor-01358", "maxStorageBuffersPerDescriptor must be within the limits supported by the device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-maxStorageBuffersPerDescriptor-01358)"},
    {"VUID-VkObjectTableCreateInfoNVX-maxStorageImagesPerDescriptor-01359", "maxStorageImagesPerDescriptor must be within the limits supported by the device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-maxStorageImagesPerDescriptor-01359)"},
    {"VUID-VkObjectTableCreateInfoNVX-maxUniformBuffersPerDescriptor-01357", "maxUniformBuffersPerDescriptor must be within the limits supported by the device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-maxUniformBuffersPerDescriptor-01357)"},
    {"VUID-VkObjectTableCreateInfoNVX-objectCount-arraylength", "objectCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-objectCount-arraylength)"},
    {"VUID-VkObjectTableCreateInfoNVX-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-pNext-pNext)"},
    {"VUID-VkObjectTableCreateInfoNVX-pObjectEntryCounts-01356", "Any value within pObjectEntryCounts must not exceed VkDeviceGeneratedCommandsLimitsNVX::maxObjectEntryCounts (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-pObjectEntryCounts-01356)"},
    {"VUID-VkObjectTableCreateInfoNVX-pObjectEntryCounts-parameter", "pObjectEntryCounts must be a valid pointer to an array of objectCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-pObjectEntryCounts-parameter)"},
    {"VUID-VkObjectTableCreateInfoNVX-pObjectEntryTypes-parameter", "pObjectEntryTypes must be a valid pointer to an array of objectCount valid VkObjectEntryTypeNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-pObjectEntryTypes-parameter)"},
    {"VUID-VkObjectTableCreateInfoNVX-pObjectEntryUsageFlags-parameter", "pObjectEntryUsageFlags must be a valid pointer to an array of objectCount valid combinations of VkObjectEntryUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-pObjectEntryUsageFlags-parameter)"},
    {"VUID-VkObjectTableCreateInfoNVX-pObjectEntryUsageFlags-requiredbitmask", "Each element of pObjectEntryUsageFlags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-pObjectEntryUsageFlags-requiredbitmask)"},
    {"VUID-VkObjectTableCreateInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_OBJECT_TABLE_CREATE_INFO_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableCreateInfoNVX-sType-sType)"},
    {"VUID-VkObjectTableDescriptorSetEntryNVX-commonparent", "Both of descriptorSet, and pipelineLayout must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableDescriptorSetEntryNVX-commonparent)"},
    {"VUID-VkObjectTableDescriptorSetEntryNVX-descriptorSet-parameter", "descriptorSet must be a valid VkDescriptorSet handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableDescriptorSetEntryNVX-descriptorSet-parameter)"},
    {"VUID-VkObjectTableDescriptorSetEntryNVX-flags-parameter", "flags must be a valid combination of VkObjectEntryUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableDescriptorSetEntryNVX-flags-parameter)"},
    {"VUID-VkObjectTableDescriptorSetEntryNVX-flags-requiredbitmask", "flags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableDescriptorSetEntryNVX-flags-requiredbitmask)"},
    {"VUID-VkObjectTableDescriptorSetEntryNVX-pipelineLayout-parameter", "pipelineLayout must be a valid VkPipelineLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableDescriptorSetEntryNVX-pipelineLayout-parameter)"},
    {"VUID-VkObjectTableDescriptorSetEntryNVX-type-01369", "type must be VK_OBJECT_ENTRY_TYPE_DESCRIPTOR_SET_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableDescriptorSetEntryNVX-type-01369)"},
    {"VUID-VkObjectTableDescriptorSetEntryNVX-type-parameter", "type must be a valid VkObjectEntryTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableDescriptorSetEntryNVX-type-parameter)"},
    {"VUID-VkObjectTableEntryNVX-computeBindingPointSupport-01367", "If the VkDeviceGeneratedCommandsFeaturesNVX::computeBindingPointSupport feature is not enabled, flags must not contain VK_OBJECT_ENTRY_USAGE_COMPUTE_BIT_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableEntryNVX-computeBindingPointSupport-01367)"},
    {"VUID-VkObjectTableEntryNVX-flags-parameter", "flags must be a valid combination of VkObjectEntryUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableEntryNVX-flags-parameter)"},
    {"VUID-VkObjectTableEntryNVX-flags-requiredbitmask", "flags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableEntryNVX-flags-requiredbitmask)"},
    {"VUID-VkObjectTableEntryNVX-type-parameter", "type must be a valid VkObjectEntryTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableEntryNVX-type-parameter)"},
    {"VUID-VkObjectTableIndexBufferEntryNVX-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableIndexBufferEntryNVX-buffer-parameter)"},
    {"VUID-VkObjectTableIndexBufferEntryNVX-flags-parameter", "flags must be a valid combination of VkObjectEntryUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableIndexBufferEntryNVX-flags-parameter)"},
    {"VUID-VkObjectTableIndexBufferEntryNVX-flags-requiredbitmask", "flags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableIndexBufferEntryNVX-flags-requiredbitmask)"},
    {"VUID-VkObjectTableIndexBufferEntryNVX-indexType-02783", "indexType must be VK_INDEX_TYPE_UINT16, or VK_INDEX_TYPE_UINT32 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableIndexBufferEntryNVX-indexType-02783)"},
    {"VUID-VkObjectTableIndexBufferEntryNVX-indexType-parameter", "indexType must be a valid VkIndexType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableIndexBufferEntryNVX-indexType-parameter)"},
    {"VUID-VkObjectTableIndexBufferEntryNVX-type-01371", "type must be VK_OBJECT_ENTRY_TYPE_INDEX_BUFFER_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableIndexBufferEntryNVX-type-01371)"},
    {"VUID-VkObjectTableIndexBufferEntryNVX-type-parameter", "type must be a valid VkObjectEntryTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableIndexBufferEntryNVX-type-parameter)"},
    {"VUID-VkObjectTablePipelineEntryNVX-flags-parameter", "flags must be a valid combination of VkObjectEntryUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePipelineEntryNVX-flags-parameter)"},
    {"VUID-VkObjectTablePipelineEntryNVX-flags-requiredbitmask", "flags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePipelineEntryNVX-flags-requiredbitmask)"},
    {"VUID-VkObjectTablePipelineEntryNVX-pipeline-parameter", "pipeline must be a valid VkPipeline handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePipelineEntryNVX-pipeline-parameter)"},
    {"VUID-VkObjectTablePipelineEntryNVX-type-01368", "type must be VK_OBJECT_ENTRY_TYPE_PIPELINE_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePipelineEntryNVX-type-01368)"},
    {"VUID-VkObjectTablePipelineEntryNVX-type-parameter", "type must be a valid VkObjectEntryTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePipelineEntryNVX-type-parameter)"},
    {"VUID-VkObjectTablePushConstantEntryNVX-flags-parameter", "flags must be a valid combination of VkObjectEntryUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePushConstantEntryNVX-flags-parameter)"},
    {"VUID-VkObjectTablePushConstantEntryNVX-flags-requiredbitmask", "flags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePushConstantEntryNVX-flags-requiredbitmask)"},
    {"VUID-VkObjectTablePushConstantEntryNVX-pipelineLayout-parameter", "pipelineLayout must be a valid VkPipelineLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePushConstantEntryNVX-pipelineLayout-parameter)"},
    {"VUID-VkObjectTablePushConstantEntryNVX-stageFlags-parameter", "stageFlags must be a valid combination of VkShaderStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePushConstantEntryNVX-stageFlags-parameter)"},
    {"VUID-VkObjectTablePushConstantEntryNVX-stageFlags-requiredbitmask", "stageFlags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePushConstantEntryNVX-stageFlags-requiredbitmask)"},
    {"VUID-VkObjectTablePushConstantEntryNVX-type-01372", "type must be VK_OBJECT_ENTRY_TYPE_PUSH_CONSTANT_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePushConstantEntryNVX-type-01372)"},
    {"VUID-VkObjectTablePushConstantEntryNVX-type-parameter", "type must be a valid VkObjectEntryTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTablePushConstantEntryNVX-type-parameter)"},
    {"VUID-VkObjectTableVertexBufferEntryNVX-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableVertexBufferEntryNVX-buffer-parameter)"},
    {"VUID-VkObjectTableVertexBufferEntryNVX-flags-parameter", "flags must be a valid combination of VkObjectEntryUsageFlagBitsNVX values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableVertexBufferEntryNVX-flags-parameter)"},
    {"VUID-VkObjectTableVertexBufferEntryNVX-flags-requiredbitmask", "flags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableVertexBufferEntryNVX-flags-requiredbitmask)"},
    {"VUID-VkObjectTableVertexBufferEntryNVX-type-01370", "type must be VK_OBJECT_ENTRY_TYPE_VERTEX_BUFFER_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableVertexBufferEntryNVX-type-01370)"},
    {"VUID-VkObjectTableVertexBufferEntryNVX-type-parameter", "type must be a valid VkObjectEntryTypeNVX value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkObjectTableVertexBufferEntryNVX-type-parameter)"},
    {"VUID-VkPerformanceConfigurationAcquireInfoINTEL-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceConfigurationAcquireInfoINTEL-pNext-pNext)"},
    {"VUID-VkPerformanceConfigurationAcquireInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceConfigurationAcquireInfoINTEL-sType-sType)"},
    {"VUID-VkPerformanceConfigurationAcquireInfoINTEL-type-parameter", "type must be a valid VkPerformanceConfigurationTypeINTEL value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceConfigurationAcquireInfoINTEL-type-parameter)"},
    {"VUID-VkPerformanceCounterDescriptionKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceCounterDescriptionKHR-pNext-pNext)"},
    {"VUID-VkPerformanceCounterDescriptionKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceCounterDescriptionKHR-sType-sType)"},
    {"VUID-VkPerformanceCounterKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceCounterKHR-pNext-pNext)"},
    {"VUID-VkPerformanceCounterKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceCounterKHR-sType-sType)"},
    {"VUID-VkPerformanceMarkerInfoINTEL-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceMarkerInfoINTEL-pNext-pNext)"},
    {"VUID-VkPerformanceMarkerInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceMarkerInfoINTEL-sType-sType)"},
    {"VUID-VkPerformanceOverrideInfoINTEL-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceOverrideInfoINTEL-pNext-pNext)"},
    {"VUID-VkPerformanceOverrideInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceOverrideInfoINTEL-sType-sType)"},
    {"VUID-VkPerformanceOverrideInfoINTEL-type-parameter", "type must be a valid VkPerformanceOverrideTypeINTEL value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceOverrideInfoINTEL-type-parameter)"},
    {"VUID-VkPerformanceQuerySubmitInfoKHR-counterPassIndex-03221", "counterPassIndex must be less than the number of counter passes required by any queries within the batch. The required number of counter passes for a performance query is obtained by calling vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceQuerySubmitInfoKHR-counterPassIndex-03221)"},
    {"VUID-VkPerformanceQuerySubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceQuerySubmitInfoKHR-sType-sType)"},
    {"VUID-VkPerformanceStreamMarkerInfoINTEL-marker-02735", "The value written by the application into marker must only used the valid bits as reported by vkGetPerformanceParameterINTEL with the VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceStreamMarkerInfoINTEL-marker-02735)"},
    {"VUID-VkPerformanceStreamMarkerInfoINTEL-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceStreamMarkerInfoINTEL-pNext-pNext)"},
    {"VUID-VkPerformanceStreamMarkerInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceStreamMarkerInfoINTEL-sType-sType)"},
    {"VUID-VkPerformanceValueDataINTEL-valueString-parameter", "valueString must be a valid pointer to a valid (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceValueDataINTEL-valueString-parameter)"},
    {"VUID-VkPerformanceValueINTEL-data-parameter", "data must be a valid VkPerformanceValueDataINTEL union (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceValueINTEL-data-parameter)"},
    {"VUID-VkPerformanceValueINTEL-type-parameter", "type must be a valid VkPerformanceValueTypeINTEL value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPerformanceValueINTEL-type-parameter)"},
    {"VUID-VkPhysicalDevice16BitStorageFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevice16BitStorageFeatures-sType-sType)"},
    {"VUID-VkPhysicalDevice8BitStorageFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevice8BitStorageFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceASTCDecodeFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceASTCDecodeFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceBufferDeviceAddressFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceBufferDeviceAddressFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceBufferDeviceAddressFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceCoherentMemoryFeaturesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceCoherentMemoryFeaturesAMD-sType-sType)"},
    {"VUID-VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceComputeShaderDerivativesFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceConditionalRenderingFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceConditionalRenderingFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceConservativeRasterizationPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceConservativeRasterizationPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceCooperativeMatrixFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceCooperativeMatrixFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceCooperativeMatrixPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceCooperativeMatrixPropertiesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceCornerSampledImageFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceCornerSampledImageFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceCoverageReductionModeFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceCoverageReductionModeFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceDepthClipEnableFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceDepthClipEnableFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceDepthStencilResolveProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceDepthStencilResolveProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceDescriptorIndexingFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceDescriptorIndexingFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceDescriptorIndexingProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceDescriptorIndexingProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceDiscardRectanglePropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceDiscardRectanglePropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceDriverProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceDriverProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceExclusiveScissorFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExclusiveScissorFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-flags-parameter", "flags must be a valid combination of VkBufferCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalBufferInfo-flags-parameter)"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-handleType-parameter", "handleType must be a valid VkExternalMemoryHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalBufferInfo-handleType-parameter)"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalBufferInfo-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalBufferInfo-sType-sType)"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-usage-parameter", "usage must be a valid combination of VkBufferUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalBufferInfo-usage-parameter)"},
    {"VUID-VkPhysicalDeviceExternalBufferInfo-usage-requiredbitmask", "usage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalBufferInfo-usage-requiredbitmask)"},
    {"VUID-VkPhysicalDeviceExternalFenceInfo-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalFenceInfo-handleType-parameter)"},
    {"VUID-VkPhysicalDeviceExternalFenceInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalFenceInfo-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceExternalFenceInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalFenceInfo-sType-sType)"},
    {"VUID-VkPhysicalDeviceExternalImageFormatInfo-handleType-parameter", "If handleType is not 0, handleType must be a valid VkExternalMemoryHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalImageFormatInfo-handleType-parameter)"},
    {"VUID-VkPhysicalDeviceExternalImageFormatInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalImageFormatInfo-sType-sType)"},
    {"VUID-VkPhysicalDeviceExternalMemoryHostPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalMemoryHostPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceExternalSemaphoreInfo-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalSemaphoreInfo-handleType-parameter)"},
    {"VUID-VkPhysicalDeviceExternalSemaphoreInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkSemaphoreTypeCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalSemaphoreInfo-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceExternalSemaphoreInfo-sType-sType)"},
    {"VUID-VkPhysicalDeviceFeatures2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceFeatures2-sType-sType)"},
    {"VUID-VkPhysicalDeviceFloatControlsProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceFloatControlsProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceFragmentDensityMapFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceFragmentDensityMapFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceFragmentDensityMapPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceFragmentDensityMapPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceGroupProperties-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceGroupProperties-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceGroupProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceGroupProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceHostQueryResetFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceHostQueryResetFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceIDProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceIDProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02314", "If sharingMode is VK_SHARING_MODE_CONCURRENT, then pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02314)"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02315", "If sharingMode is VK_SHARING_MODE_CONCURRENT, then queueFamilyIndexCount must be greater than 1. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02315)"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02316", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than the pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-02316)"},
    {"VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageDrmFormatModifierInfoEXT-sharingMode-parameter)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-flags-parameter)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-format-parameter)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkImageFormatListCreateInfo, VkImageStencilUsageCreateInfo, VkPhysicalDeviceExternalImageFormatInfo, VkPhysicalDeviceImageDrmFormatModifierInfoEXT, or VkPhysicalDeviceImageViewImageFormatInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-sType-sType)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-sType-unique)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-tiling-02249", "tiling must be VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT if and only if the pNext chain includes VkPhysicalDeviceImageDrmFormatModifierInfoEXT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-tiling-02249)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-tiling-02313", "If tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT and flags contains VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, then the pNext chain must include a VkImageFormatListCreateInfo structure with non-zero viewFormatCount. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-tiling-02313)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-tiling-parameter", "tiling must be a valid VkImageTiling value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-tiling-parameter)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-type-parameter", "type must be a valid VkImageType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-type-parameter)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-usage-parameter)"},
    {"VUID-VkPhysicalDeviceImageFormatInfo2-usage-requiredbitmask", "usage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageFormatInfo2-usage-requiredbitmask)"},
    {"VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-imageViewType-parameter", "imageViewType must be a valid VkImageViewType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-imageViewType-parameter)"},
    {"VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImageViewImageFormatInfoEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceImagelessFramebufferFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceImagelessFramebufferFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceIndexTypeUint8FeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceIndexTypeUint8FeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceInlineUniformBlockFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceInlineUniformBlockFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceInlineUniformBlockPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceInlineUniformBlockPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceLineRasterizationFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceLineRasterizationFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceLineRasterizationPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceLineRasterizationPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceMaintenance3Properties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMaintenance3Properties-sType-sType)"},
    {"VUID-VkPhysicalDeviceMemoryBudgetPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMemoryBudgetPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceMemoryPriorityFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMemoryPriorityFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceMemoryProperties2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPhysicalDeviceMemoryBudgetPropertiesEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMemoryProperties2-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceMemoryProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMemoryProperties2-sType-sType)"},
    {"VUID-VkPhysicalDeviceMeshShaderFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMeshShaderFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceMeshShaderPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMeshShaderPropertiesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceMultiviewFeatures-multiviewGeometryShader-00580", "If multiviewGeometryShader is enabled then multiview must also be enabled. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMultiviewFeatures-multiviewGeometryShader-00580)"},
    {"VUID-VkPhysicalDeviceMultiviewFeatures-multiviewTessellationShader-00581", "If multiviewTessellationShader is enabled then multiview must also be enabled. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMultiviewFeatures-multiviewTessellationShader-00581)"},
    {"VUID-VkPhysicalDeviceMultiviewFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMultiviewFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX-sType-sType)"},
    {"VUID-VkPhysicalDeviceMultiviewProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceMultiviewProperties-sType-sType)"},
    {"VUID-VkPhysicalDevicePCIBusInfoPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevicePCIBusInfoPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDevicePerformanceQueryFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevicePerformanceQueryFeaturesKHR-sType-sType)"},
    {"VUID-VkPhysicalDevicePerformanceQueryPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevicePerformanceQueryPropertiesKHR-sType-sType)"},
    {"VUID-VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR-sType-sType)"},
    {"VUID-VkPhysicalDevicePointClippingProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevicePointClippingProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT, VkPhysicalDeviceConservativeRasterizationPropertiesEXT, VkPhysicalDeviceCooperativeMatrixPropertiesNV, VkPhysicalDeviceDepthStencilResolveProperties, VkPhysicalDeviceDescriptorIndexingProperties, VkPhysicalDeviceDiscardRectanglePropertiesEXT, VkPhysicalDeviceDriverProperties, VkPhysicalDeviceExternalMemoryHostPropertiesEXT, VkPhysicalDeviceFloatControlsProperties, VkPhysicalDeviceFragmentDensityMapPropertiesEXT, VkPhysicalDeviceIDProperties, VkPhysicalDeviceInlineUniformBlockPropertiesEXT, VkPhysicalDeviceLineRasterizationPropertiesEXT, VkPhysicalDeviceMaintenance3Properties, VkPhysicalDeviceMeshShaderPropertiesNV, VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX, VkPhysicalDeviceMultiviewProperties, VkPhysicalDevicePCIBusInfoPropertiesEXT, VkPhysicalDevicePerformanceQueryPropertiesKHR, VkPhysicalDevicePointClippingProperties, VkPhysicalDeviceProtectedMemoryProperties, VkPhysicalDevicePushDescriptorPropertiesKHR, VkPhysicalDeviceRayTracingPropertiesNV, VkPhysicalDeviceSampleLocationsPropertiesEXT, VkPhysicalDeviceSamplerFilterMinmaxProperties, VkPhysicalDeviceShaderCoreProperties2AMD, VkPhysicalDeviceShaderCorePropertiesAMD, VkPhysicalDeviceShaderSMBuiltinsPropertiesNV, VkPhysicalDeviceShadingRateImagePropertiesNV, VkPhysicalDeviceSubgroupProperties, VkPhysicalDeviceSubgroupSizeControlPropertiesEXT, VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT, VkPhysicalDeviceTimelineSemaphoreProperties, VkPhysicalDeviceTransformFeedbackPropertiesEXT, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT, VkPhysicalDeviceVulkan11Properties, or VkPhysicalDeviceVulkan12Properties (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceProperties2-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceProperties2-sType-sType)"},
    {"VUID-VkPhysicalDeviceProperties2-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceProperties2-sType-unique)"},
    {"VUID-VkPhysicalDeviceProtectedMemoryFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceProtectedMemoryFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceProtectedMemoryProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceProtectedMemoryProperties-sType-sType)"},
    {"VUID-VkPhysicalDevicePushDescriptorPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDevicePushDescriptorPropertiesKHR-sType-sType)"},
    {"VUID-VkPhysicalDeviceRayTracingPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceRayTracingPropertiesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceSampleLocationsPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSampleLocationsPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceSamplerFilterMinmaxProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSamplerFilterMinmaxProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceSamplerYcbcrConversionFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSamplerYcbcrConversionFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceScalarBlockLayoutFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceScalarBlockLayoutFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderAtomicInt64Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderAtomicInt64Features-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderClockFeaturesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderClockFeaturesKHR-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderCoreProperties2AMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderCoreProperties2AMD-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderCorePropertiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderCorePropertiesAMD-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderDrawParametersFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderDrawParametersFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderFloat16Int8Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderFloat16Int8Features-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderImageFootprintFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderImageFootprintFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderSMBuiltinsFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderSMBuiltinsPropertiesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceShadingRateImageFeaturesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShadingRateImageFeaturesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceShadingRateImagePropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceShadingRateImagePropertiesNV-sType-sType)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-format-parameter)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-sType-sType)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-01095", "samples must be a bit value that is set in VkImageFormatProperties::sampleCounts returned by vkGetPhysicalDeviceImageFormatProperties with format, type, tiling, and usage equal to those in this command and flags equal to the value that is set in VkImageCreateInfo::flags when the image is created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-01095)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-parameter", "samples must be a valid VkSampleCountFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-samples-parameter)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-tiling-parameter", "tiling must be a valid VkImageTiling value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-tiling-parameter)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-type-parameter", "type must be a valid VkImageType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-type-parameter)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-parameter)"},
    {"VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-requiredbitmask", "usage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSparseImageFormatInfo2-usage-requiredbitmask)"},
    {"VUID-VkPhysicalDeviceSubgroupProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSubgroupProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceSubgroupSizeControlFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSubgroupSizeControlFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSubgroupSizeControlPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-pNext-02672", "If the pNext chain includes a VkSurfaceFullScreenExclusiveInfoEXT structure with its fullScreenExclusive member set to VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT, and surface was created using vkCreateWin32SurfaceKHR, a VkSurfaceFullScreenExclusiveWin32InfoEXT structure must be included in the pNext chain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSurfaceInfo2KHR-pNext-02672)"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkSurfaceFullScreenExclusiveInfoEXT or VkSurfaceFullScreenExclusiveWin32InfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSurfaceInfo2KHR-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSurfaceInfo2KHR-sType-sType)"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSurfaceInfo2KHR-sType-unique)"},
    {"VUID-VkPhysicalDeviceSurfaceInfo2KHR-surface-parameter", "surface must be a valid VkSurfaceKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceSurfaceInfo2KHR-surface-parameter)"},
    {"VUID-VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceTimelineSemaphoreFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceTimelineSemaphoreFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceTimelineSemaphoreProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceTimelineSemaphoreProperties-sType-sType)"},
    {"VUID-VkPhysicalDeviceToolPropertiesEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceToolPropertiesEXT-pNext-pNext)"},
    {"VUID-VkPhysicalDeviceToolPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceToolPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceTransformFeedbackFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceTransformFeedbackFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceTransformFeedbackPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceTransformFeedbackPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceUniformBufferStandardLayoutFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceUniformBufferStandardLayoutFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceVariablePointersFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceVariablePointersFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceVariablePointersFeatures-variablePointers-01431", "If variablePointers is enabled then variablePointersStorageBuffer must also be enabled. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceVariablePointersFeatures-variablePointers-01431)"},
    {"VUID-VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT-sType-sType)"},
    {"VUID-VkPhysicalDeviceVulkan11Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan11Features-sType-sType)"},
    {"VUID-VkPhysicalDeviceVulkan11Properties-pointClippingBehavior-parameter", "pointClippingBehavior must be a valid VkPointClippingBehavior value (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan11Properties-pointClippingBehavior-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan11Properties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan11Properties-sType-sType)"},
    {"VUID-VkPhysicalDeviceVulkan12Features-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Features-sType-sType)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-denormBehaviorIndependence-parameter", "denormBehaviorIndependence must be a valid VkShaderFloatControlsIndependence value (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-denormBehaviorIndependence-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-driverID-parameter", "driverID must be a valid VkDriverId value (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-driverID-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-driverInfo-parameter", "driverInfo must be a null-terminated UTF-8 string whose length is less than or equal to VK_MAX_DRIVER_INFO_SIZE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-driverInfo-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-driverName-parameter", "driverName must be a null-terminated UTF-8 string whose length is less than or equal to VK_MAX_DRIVER_NAME_SIZE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-driverName-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-framebufferIntegerColorSampleCounts-parameter", "framebufferIntegerColorSampleCounts must be a valid combination of VkSampleCountFlagBits values (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-framebufferIntegerColorSampleCounts-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-roundingModeIndependence-parameter", "roundingModeIndependence must be a valid VkShaderFloatControlsIndependence value (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-roundingModeIndependence-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-sType-sType)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-supportedDepthResolveModes-parameter", "supportedDepthResolveModes must be a valid combination of VkResolveModeFlagBits values (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-supportedDepthResolveModes-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-supportedDepthResolveModes-requiredbitmask", "supportedDepthResolveModes must not be 0 (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-supportedDepthResolveModes-requiredbitmask)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-supportedStencilResolveModes-parameter", "supportedStencilResolveModes must be a valid combination of VkResolveModeFlagBits values (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-supportedStencilResolveModes-parameter)"},
    {"VUID-VkPhysicalDeviceVulkan12Properties-supportedStencilResolveModes-requiredbitmask", "supportedStencilResolveModes must not be 0 (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPhysicalDeviceVulkan12Properties-supportedStencilResolveModes-requiredbitmask)"},
    {"VUID-VkPhysicalDeviceVulkanMemoryModelFeatures-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceVulkanMemoryModelFeatures-sType-sType)"},
    {"VUID-VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPhysicalDeviceYcbcrImageArraysFeaturesEXT-sType-sType)"},
    {"VUID-VkPipelineCacheCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCacheCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineCacheCreateInfo-initialDataSize-00768", "If initialDataSize is not 0, it must be equal to the size of pInitialData, as returned by vkGetPipelineCacheData when pInitialData was originally retrieved (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCacheCreateInfo-initialDataSize-00768)"},
    {"VUID-VkPipelineCacheCreateInfo-initialDataSize-00769", "If initialDataSize is not 0, pInitialData must have been retrieved from a previous call to vkGetPipelineCacheData (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCacheCreateInfo-initialDataSize-00769)"},
    {"VUID-VkPipelineCacheCreateInfo-pInitialData-parameter", "If initialDataSize is not 0, pInitialData must be a valid pointer to an array of initialDataSize bytes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCacheCreateInfo-pInitialData-parameter)"},
    {"VUID-VkPipelineCacheCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCacheCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineCacheCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCacheCreateInfo-sType-sType)"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-01426", "If the correlated overlap property is not supported, blendOverlap must be VK_BLEND_OVERLAP_UNCORRELATED_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-01426)"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-parameter", "blendOverlap must be a valid VkBlendOverlapEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-blendOverlap-parameter)"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-dstPremultiplied-01425", "If the non-premultiplied destination color property is not supported, dstPremultiplied must be VK_TRUE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-dstPremultiplied-01425)"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-srcPremultiplied-01424", "If the non-premultiplied source color property is not supported, srcPremultiplied must be VK_TRUE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAdvancedStateCreateInfoEXT-srcPremultiplied-01424)"},
    {"VUID-VkPipelineColorBlendAttachmentState-advancedBlendAllOperations-01409", "If VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendAllOperations is VK_FALSE, then colorBlendOp must not be VK_BLEND_OP_ZERO_EXT, VK_BLEND_OP_SRC_EXT, VK_BLEND_OP_DST_EXT, VK_BLEND_OP_SRC_OVER_EXT, VK_BLEND_OP_DST_OVER_EXT, VK_BLEND_OP_SRC_IN_EXT, VK_BLEND_OP_DST_IN_EXT, VK_BLEND_OP_SRC_OUT_EXT, VK_BLEND_OP_DST_OUT_EXT, VK_BLEND_OP_SRC_ATOP_EXT, VK_BLEND_OP_DST_ATOP_EXT, VK_BLEND_OP_XOR_EXT, VK_BLEND_OP_INVERT_EXT, VK_BLEND_OP_INVERT_RGB_EXT, VK_BLEND_OP_LINEARDODGE_EXT, VK_BLEND_OP_LINEARBURN_EXT, VK_BLEND_OP_VIVIDLIGHT_EXT, VK_BLEND_OP_LINEARLIGHT_EXT, VK_BLEND_OP_PINLIGHT_EXT, VK_BLEND_OP_HARDMIX_EXT, VK_BLEND_OP_PLUS_EXT, VK_BLEND_OP_PLUS_CLAMPED_EXT, VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT, VK_BLEND_OP_PLUS_DARKER_EXT, VK_BLEND_OP_MINUS_EXT, VK_BLEND_OP_MINUS_CLAMPED_EXT, VK_BLEND_OP_CONTRAST_EXT, VK_BLEND_OP_INVERT_OVG_EXT, VK_BLEND_OP_RED_EXT, VK_BLEND_OP_GREEN_EXT, or VK_BLEND_OP_BLUE_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-advancedBlendAllOperations-01409)"},
    {"VUID-VkPipelineColorBlendAttachmentState-advancedBlendIndependentBlend-01407", "If VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendIndependentBlend is VK_FALSE and colorBlendOp is an advanced blend operation, then colorBlendOp must be the same for all attachments. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-advancedBlendIndependentBlend-01407)"},
    {"VUID-VkPipelineColorBlendAttachmentState-advancedBlendIndependentBlend-01408", "If VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendIndependentBlend is VK_FALSE and alphaBlendOp is an advanced blend operation, then alphaBlendOp must be the same for all attachments. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-advancedBlendIndependentBlend-01408)"},
    {"VUID-VkPipelineColorBlendAttachmentState-alphaBlendOp-parameter", "alphaBlendOp must be a valid VkBlendOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-alphaBlendOp-parameter)"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-01406", "If either of colorBlendOp or alphaBlendOp is an advanced blend operation, then colorBlendOp must equal alphaBlendOp (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-01406)"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-01410", "If colorBlendOp or alphaBlendOp is an advanced blend operation, then VkSubpassDescription::colorAttachmentCount of the subpass this pipeline is compiled against must be less than or equal to VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT::advancedBlendMaxColorAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-01410)"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-parameter", "colorBlendOp must be a valid VkBlendOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-colorBlendOp-parameter)"},
    {"VUID-VkPipelineColorBlendAttachmentState-colorWriteMask-parameter", "colorWriteMask must be a valid combination of VkColorComponentFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-colorWriteMask-parameter)"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor-00611", "If the dual source blending feature is not enabled, dstAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor-00611)"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor-parameter", "dstAlphaBlendFactor must be a valid VkBlendFactor value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-dstAlphaBlendFactor-parameter)"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstColorBlendFactor-00609", "If the dual source blending feature is not enabled, dstColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-dstColorBlendFactor-00609)"},
    {"VUID-VkPipelineColorBlendAttachmentState-dstColorBlendFactor-parameter", "dstColorBlendFactor must be a valid VkBlendFactor value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-dstColorBlendFactor-parameter)"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor-00610", "If the dual source blending feature is not enabled, srcAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor-00610)"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor-parameter", "srcAlphaBlendFactor must be a valid VkBlendFactor value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-srcAlphaBlendFactor-parameter)"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcColorBlendFactor-00608", "If the dual source blending feature is not enabled, srcColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-srcColorBlendFactor-00608)"},
    {"VUID-VkPipelineColorBlendAttachmentState-srcColorBlendFactor-parameter", "srcColorBlendFactor must be a valid VkBlendFactor value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendAttachmentState-srcColorBlendFactor-parameter)"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-logicOpEnable-00606", "If the logic operations feature is not enabled, logicOpEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendStateCreateInfo-logicOpEnable-00606)"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-logicOpEnable-00607", "If logicOpEnable is VK_TRUE, logicOp must be a valid VkLogicOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendStateCreateInfo-logicOpEnable-00607)"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-pAttachments-00605", "If the independent blending feature is not enabled, all elements of pAttachments must be identical (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendStateCreateInfo-pAttachments-00605)"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkPipelineColorBlendAttachmentState structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendStateCreateInfo-pAttachments-parameter)"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineColorBlendAdvancedStateCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineColorBlendStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineColorBlendStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineCompilerControlCreateInfoAMD-compilerControlFlags-zerobitmask", "compilerControlFlags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCompilerControlCreateInfoAMD-compilerControlFlags-zerobitmask)"},
    {"VUID-VkPipelineCompilerControlCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCompilerControlCreateInfoAMD-sType-sType)"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationMode-parameter", "coverageModulationMode must be a valid VkCoverageModulationModeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationMode-parameter)"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationTableEnable-01405", "If coverageModulationTableEnable is VK_TRUE, coverageModulationTableCount must be equal to the number of rasterization samples divided by the number of color samples in the subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageModulationStateCreateInfoNV-coverageModulationTableEnable-01405)"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageModulationStateCreateInfoNV-flags-zerobitmask)"},
    {"VUID-VkPipelineCoverageModulationStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageModulationStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineCoverageReductionStateCreateInfoNV-coverageReductionMode-parameter", "coverageReductionMode must be a valid VkCoverageReductionModeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageReductionStateCreateInfoNV-coverageReductionMode-parameter)"},
    {"VUID-VkPipelineCoverageReductionStateCreateInfoNV-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageReductionStateCreateInfoNV-flags-zerobitmask)"},
    {"VUID-VkPipelineCoverageReductionStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageReductionStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineCoverageToColorStateCreateInfoNV-coverageToColorEnable-01404", "If coverageToColorEnable is VK_TRUE, then the render pass subpass indicated by VkGraphicsPipelineCreateInfo::renderPass and VkGraphicsPipelineCreateInfo::subpass must have a color attachment at the location selected by coverageToColorLocation, with a VkFormat of VK_FORMAT_R8_UINT, VK_FORMAT_R8_SINT, VK_FORMAT_R16_UINT, VK_FORMAT_R16_SINT, VK_FORMAT_R32_UINT, or VK_FORMAT_R32_SINT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageToColorStateCreateInfoNV-coverageToColorEnable-01404)"},
    {"VUID-VkPipelineCoverageToColorStateCreateInfoNV-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageToColorStateCreateInfoNV-flags-zerobitmask)"},
    {"VUID-VkPipelineCoverageToColorStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCoverageToColorStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pPipelineCreationFeedback-parameter", "pPipelineCreationFeedback must be a valid pointer to a VkPipelineCreationFeedbackEXT structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCreationFeedbackCreateInfoEXT-pPipelineCreationFeedback-parameter)"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pPipelineStageCreationFeedbacks-parameter", "pPipelineStageCreationFeedbacks must be a valid pointer to an array of pipelineStageCreationFeedbackCount VkPipelineCreationFeedbackEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCreationFeedbackCreateInfoEXT-pPipelineStageCreationFeedbacks-parameter)"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02668", "When chained to VkGraphicsPipelineCreateInfo, VkPipelineCreationFeedbackEXT::pipelineStageCreationFeedbackCount must equal VkGraphicsPipelineCreateInfo::stageCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02668)"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02669", "When chained to VkComputePipelineCreateInfo, VkPipelineCreationFeedbackEXT::pipelineStageCreationFeedbackCount must equal 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02669)"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02670", "When chained to VkRayTracingPipelineCreateInfoNV, VkPipelineCreationFeedbackEXT::pipelineStageCreationFeedbackCount must equal VkRayTracingPipelineCreateInfoNV::stageCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-02670)"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-arraylength", "pipelineStageCreationFeedbackCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCreationFeedbackCreateInfoEXT-pipelineStageCreationFeedbackCount-arraylength)"},
    {"VUID-VkPipelineCreationFeedbackCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineCreationFeedbackCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-back-parameter", "back must be a valid VkStencilOpState structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDepthStencilStateCreateInfo-back-parameter)"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-depthBoundsTestEnable-00598", "If the depth bounds testing feature is not enabled, depthBoundsTestEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDepthStencilStateCreateInfo-depthBoundsTestEnable-00598)"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-depthCompareOp-parameter", "depthCompareOp must be a valid VkCompareOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDepthStencilStateCreateInfo-depthCompareOp-parameter)"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDepthStencilStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-front-parameter", "front must be a valid VkStencilOpState structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDepthStencilStateCreateInfo-front-parameter)"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDepthStencilStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineDepthStencilStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDepthStencilStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleCount-00582", "discardRectangleCount must be between 0 and VkPhysicalDeviceDiscardRectanglePropertiesEXT::maxDiscardRectangles, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleCount-00582)"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleMode-parameter", "discardRectangleMode must be a valid VkDiscardRectangleModeEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-discardRectangleMode-parameter)"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDiscardRectangleStateCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineDynamicStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDynamicStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineDynamicStateCreateInfo-pDynamicStates-01442", "Each element of pDynamicStates must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDynamicStateCreateInfo-pDynamicStates-01442)"},
    {"VUID-VkPipelineDynamicStateCreateInfo-pDynamicStates-parameter", "If dynamicStateCount is not 0, pDynamicStates must be a valid pointer to an array of dynamicStateCount valid VkDynamicState values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDynamicStateCreateInfo-pDynamicStates-parameter)"},
    {"VUID-VkPipelineDynamicStateCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDynamicStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineDynamicStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineDynamicStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineExecutableInfoKHR-executableIndex-03275", "executableIndex must be less than the number of executables associated with pipeline as returned in the pExecutableCount parameter of vkGetPipelineExecutablePropertiesKHR. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableInfoKHR-executableIndex-03275)"},
    {"VUID-VkPipelineExecutableInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableInfoKHR-pNext-pNext)"},
    {"VUID-VkPipelineExecutableInfoKHR-pipeline-parameter", "pipeline must be a valid VkPipeline handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableInfoKHR-pipeline-parameter)"},
    {"VUID-VkPipelineExecutableInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableInfoKHR-sType-sType)"},
    {"VUID-VkPipelineExecutableInternalRepresentationKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableInternalRepresentationKHR-pNext-pNext)"},
    {"VUID-VkPipelineExecutableInternalRepresentationKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableInternalRepresentationKHR-sType-sType)"},
    {"VUID-VkPipelineExecutablePropertiesKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutablePropertiesKHR-pNext-pNext)"},
    {"VUID-VkPipelineExecutablePropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutablePropertiesKHR-sType-sType)"},
    {"VUID-VkPipelineExecutableStatisticKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableStatisticKHR-pNext-pNext)"},
    {"VUID-VkPipelineExecutableStatisticKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineExecutableStatisticKHR-sType-sType)"},
    {"VUID-VkPipelineInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInfoKHR-pNext-pNext)"},
    {"VUID-VkPipelineInfoKHR-pipeline-parameter", "pipeline must be a valid VkPipeline handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInfoKHR-pipeline-parameter)"},
    {"VUID-VkPipelineInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInfoKHR-sType-sType)"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInputAssemblyStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInputAssemblyStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInputAssemblyStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00428", "If topology is VK_PRIMITIVE_TOPOLOGY_POINT_LIST, VK_PRIMITIVE_TOPOLOGY_LINE_LIST, VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST, VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY or VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, primitiveRestartEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00428)"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00429", "If the geometry shaders feature is not enabled, topology must not be any of VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY, VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY, VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY or VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00429)"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00430", "If the tessellation shaders feature is not enabled, topology must not be VK_PRIMITIVE_TOPOLOGY_PATCH_LIST (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInputAssemblyStateCreateInfo-topology-00430)"},
    {"VUID-VkPipelineInputAssemblyStateCreateInfo-topology-parameter", "topology must be a valid VkPrimitiveTopology value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineInputAssemblyStateCreateInfo-topology-parameter)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02212", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxPerStageDescriptorInlineUniformBlocks (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPipelineLayoutCreateInfo-descriptorType-02212)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02213", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxDescriptorSetInlineUniformBlocks (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPipelineLayoutCreateInfo-descriptorType-02213)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02214", "The total number of bindings in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxPerStageDescriptorInlineUniformBlocks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-02214)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02215", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-02215)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02216", "The total number of bindings in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxDescriptorSetInlineUniformBlocks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-02216)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02217", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceInlineUniformBlockPropertiesEXT::maxDescriptorSetUpdateAfterBindInlineUniformBlocks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-02217)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-02381", "The total number of bindings with a descriptorType of VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxDescriptorSetAccelerationStructures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-02381)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03016", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSamplers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03016)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03017", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER and VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorUniformBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03017)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03018", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER and VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03018)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03019", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSampledImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03019)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03020", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03020)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03021", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorInputAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03021)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03022", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindSamplers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03022)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03023", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER and VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindUniformBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03023)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03024", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER and VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindStorageBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03024)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03025", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindSampledImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03025)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03026", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindStorageImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03026)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03027", "The total number of descriptors with a descriptorType of VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxPerStageDescriptorUpdateAfterBindInputAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03027)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03028", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSamplers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03028)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03029", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03029)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03030", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffersDynamic (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03030)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03031", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03031)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03032", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffersDynamic (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03032)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03033", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSampledImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03033)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03034", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03034)"},
    {"VUID-VkPipelineLayoutCreateInfo-descriptorType-03035", "The total number of descriptors in descriptor set layouts created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set with a descriptorType of VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetInputAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-descriptorType-03035)"},
    {"VUID-VkPipelineLayoutCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineLayoutCreateInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-00292", "Any two elements of pPushConstantRanges must not include the same stage in stageFlags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-00292)"},
    {"VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-parameter", "If pushConstantRangeCount is not 0, pPushConstantRanges must be a valid pointer to an array of pushConstantRangeCount valid VkPushConstantRange structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pPushConstantRanges-parameter)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00287", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSamplers (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00287)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00288", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER and VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorUniformBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00288)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00289", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER and VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00289)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00290", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorSampledImages (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00290)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00291", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible to any shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorStorageImages (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00291)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00293", "pSetLayouts must not contain more than one descriptor set layout that was created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-00293)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01676", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible to any given shader stage across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxPerStageDescriptorInputAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01676)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01677", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSamplers (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01677)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01678", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01678)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01679", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffersDynamic (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01679)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01680", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01680)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01681", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffersDynamic (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01681)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01682", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetSampledImages (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01682)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01683", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetStorageImages (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01683)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01684", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceLimits::maxDescriptorSetInputAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-01684)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03036", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_SAMPLER and VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindSamplers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03036)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03037", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindUniformBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03037)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03038", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindUniformBuffersDynamic (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03038)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03039", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindStorageBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03039)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03040", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindStorageBuffersDynamic (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03040)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03041", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindSampledImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03041)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03042", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindStorageImages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03042)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03043", "The total number of descriptors of the type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT accessible across all shader stages and across all elements of pSetLayouts must be less than or equal to VkPhysicalDeviceDescriptorIndexingProperties::maxDescriptorSetUpdateAfterBindInputAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-03043)"},
    {"VUID-VkPipelineLayoutCreateInfo-pSetLayouts-parameter", "If setLayoutCount is not 0, pSetLayouts must be a valid pointer to an array of setLayoutCount valid VkDescriptorSetLayout handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-pSetLayouts-parameter)"},
    {"VUID-VkPipelineLayoutCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-sType-sType)"},
    {"VUID-VkPipelineLayoutCreateInfo-setLayoutCount-00286", "setLayoutCount must be less than or equal to VkPhysicalDeviceLimits::maxBoundDescriptorSets (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineLayoutCreateInfo-setLayoutCount-00286)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-alphaToOneEnable-00785", "If the alpha to one feature is not enabled, alphaToOneEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-alphaToOneEnable-00785)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-minSampleShading-00786", "minSampleShading must be in the range [0,1] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-minSampleShading-00786)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCoverageModulationStateCreateInfoNV, VkPipelineCoverageReductionStateCreateInfoNV, VkPipelineCoverageToColorStateCreateInfoNV, or VkPipelineSampleLocationsStateCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-pSampleMask-parameter", "If pSampleMask is not NULL, pSampleMask must be a valid pointer to an array of (rasterizationSamples/32) VkSampleMask values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-pSampleMask-parameter)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-rasterizationSamples-01415", "If the VK_NV_framebuffer_mixed_samples extension is enabled, and if the subpass has any color attachments and rasterizationSamples is greater than the number of color samples, then sampleShadingEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-rasterizationSamples-01415)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-rasterizationSamples-parameter", "rasterizationSamples must be a valid VkSampleCountFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-rasterizationSamples-parameter)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-sType-unique)"},
    {"VUID-VkPipelineMultisampleStateCreateInfo-sampleShadingEnable-00784", "If the sample rate shading feature is not enabled, sampleShadingEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineMultisampleStateCreateInfo-sampleShadingEnable-00784)"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-conservativeRasterizationMode-parameter", "conservativeRasterizationMode must be a valid VkConservativeRasterizationModeEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-conservativeRasterizationMode-parameter)"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-extraPrimitiveOverestimationSize-01769", "extraPrimitiveOverestimationSize must be in the range of 0.0 to VkPhysicalDeviceConservativeRasterizationPropertiesEXT::maxExtraPrimitiveOverestimationSize inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-extraPrimitiveOverestimationSize-01769)"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationConservativeStateCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationDepthClipStateCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02768", "If lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT, then the rectangularLines feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02768)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02769", "If lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT, then the bresenhamLines feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02769)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02770", "If lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT, then the smoothLines feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-02770)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-parameter", "lineRasterizationMode must be a valid VkLineRasterizationModeEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-lineRasterizationMode-parameter)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02771", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT, then the stippledRectangularLines feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02771)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02772", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT, then the stippledBresenhamLines feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02772)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02773", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT, then the stippledSmoothLines feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02773)"},
    {"VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02774", "If stippledLineEnable is VK_TRUE and lineRasterizationMode is VK_LINE_RASTERIZATION_MODE_DEFAULT_EXT, then the stippledRectangularLines feature must be enabled and VkPhysicalDeviceLimits::strictLines must be VK_TRUE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationLineStateCreateInfoEXT-stippledLineEnable-02774)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-cullMode-parameter", "cullMode must be a valid combination of VkCullModeFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-cullMode-parameter)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-depthClampEnable-00782", "If the depth clamping feature is not enabled, depthClampEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-depthClampEnable-00782)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-frontFace-parameter", "frontFace must be a valid VkFrontFace value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-frontFace-parameter)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineRasterizationConservativeStateCreateInfoEXT, VkPipelineRasterizationDepthClipStateCreateInfoEXT, VkPipelineRasterizationLineStateCreateInfoEXT, VkPipelineRasterizationStateRasterizationOrderAMD, or VkPipelineRasterizationStateStreamCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01413", "If the non-solid fill modes feature is not enabled, polygonMode must be VK_POLYGON_MODE_FILL (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01413)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01414", "If the VK_NV_fill_rectangle extension is not enabled, polygonMode must not be VK_POLYGON_MODE_FILL_RECTANGLE_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01414)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01507", "If the non-solid fill modes feature is not enabled, polygonMode must be VK_POLYGON_MODE_FILL or VK_POLYGON_MODE_FILL_RECTANGLE_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-01507)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-parameter", "polygonMode must be a valid VkPolygonMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-polygonMode-parameter)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineRasterizationStateCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateCreateInfo-sType-unique)"},
    {"VUID-VkPipelineRasterizationStateRasterizationOrderAMD-rasterizationOrder-parameter", "rasterizationOrder must be a valid VkRasterizationOrderAMD value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateRasterizationOrderAMD-rasterizationOrder-parameter)"},
    {"VUID-VkPipelineRasterizationStateRasterizationOrderAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateRasterizationOrderAMD-sType-sType)"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-geometryStreams-02324", "VkPhysicalDeviceTransformFeedbackFeaturesEXT::geometryStreams must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-geometryStreams-02324)"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-rasterizationStream-02325", "rasterizationStream must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-rasterizationStream-02325)"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-rasterizationStream-02326", "rasterizationStream must be zero if VkPhysicalDeviceTransformFeedbackPropertiesEXT::transformFeedbackRasterizationStreamSelect is VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-rasterizationStream-02326)"},
    {"VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRasterizationStateStreamCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineRepresentativeFragmentTestStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineRepresentativeFragmentTestStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineSampleLocationsStateCreateInfoEXT-sampleLocationsInfo-parameter)"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02758", "If flags has both the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT and VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flags set, the local workgroup size in the X dimension of the pipeline must be a multiple of maxSubgroupSize. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-flags-02758)"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02759", "If flags has the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag set and flags does not have the VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flag set and no VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, the local workgroup size in the X dimension of the pipeline must be a multiple of subgroupSize. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-flags-02759)"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02784", "If flags has the VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flag set, the subgroupSizeControl feature must be enabled. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-flags-02784)"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-02785", "If flags has the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag set, the computeFullSubgroups feature must be enabled. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-flags-02785)"},
    {"VUID-VkPipelineShaderStageCreateInfo-flags-parameter", "flags must be a valid combination of VkPipelineShaderStageCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-flags-parameter)"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxClipDistances-00708", "If the identified entry point includes any variable in its interface that is declared with the ClipDistance BuiltIn decoration, that variable must not have an array size greater than VkPhysicalDeviceLimits::maxClipDistances (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-maxClipDistances-00708)"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxCombinedClipAndCullDistances-00710", "If the identified entry point includes any variables in its interface that are declared with the ClipDistance or CullDistance BuiltIn decoration, those variables must not have array sizes which sum to more than VkPhysicalDeviceLimits::maxCombinedClipAndCullDistances (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-maxCombinedClipAndCullDistances-00710)"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxCullDistances-00709", "If the identified entry point includes any variable in its interface that is declared with the CullDistance BuiltIn decoration, that variable must not have an array size greater than VkPhysicalDeviceLimits::maxCullDistances (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-maxCullDistances-00709)"},
    {"VUID-VkPipelineShaderStageCreateInfo-maxSampleMaskWords-00711", "If the identified entry point includes any variable in its interface that is declared with the SampleMask BuiltIn decoration, that variable must not have an array size greater than VkPhysicalDeviceLimits::maxSampleMaskWords (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-maxSampleMaskWords-00711)"},
    {"VUID-VkPipelineShaderStageCreateInfo-module-parameter", "module must be a valid VkShaderModule handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-module-parameter)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pName-00707", "pName must be the name of an OpEntryPoint in module with an execution model that matches stage (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pName-00707)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pName-parameter", "pName must be a null-terminated UTF-8 string (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pName-parameter)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02754", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, flags must not have the VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT flag set. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pNext-02754)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02755", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, the subgroupSizeControl feature must be enabled, and stage must be a valid bit specified in requiredSubgroupSizeStages. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pNext-02755)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02756", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain and stage is VK_SHADER_STAGE_COMPUTE_BIT, the local workgroup size of the shader must be less than or equal to the product of VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::requiredSubgroupSize and maxComputeWorkgroupSubgroups. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pNext-02756)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-02757", "If a VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT structure is included in the pNext chain, and flags has the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag set, the local workgroup size in the X dimension of the pipeline must be a multiple of VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT::requiredSubgroupSize. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pNext-02757)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineShaderStageCreateInfo-pSpecializationInfo-parameter", "If pSpecializationInfo is not NULL, pSpecializationInfo must be a valid pointer to a valid VkSpecializationInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-pSpecializationInfo-parameter)"},
    {"VUID-VkPipelineShaderStageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-sType-sType)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00704", "If the geometry shaders feature is not enabled, stage must not be VK_SHADER_STAGE_GEOMETRY_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00704)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00705", "If the tessellation shaders feature is not enabled, stage must not be VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT or VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00705)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00706", "stage must not be VK_SHADER_STAGE_ALL_GRAPHICS, or VK_SHADER_STAGE_ALL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00706)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00712", "If stage is VK_SHADER_STAGE_VERTEX_BIT, the identified entry point must not include any input variable in its interface that is decorated with CullDistance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00712)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00713", "If stage is VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT or VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, and the identified entry point has an OpExecutionMode instruction that specifies a patch size with OutputVertices, the patch size must be greater than 0 and less than or equal to VkPhysicalDeviceLimits::maxTessellationPatchSize (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00713)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00714", "If stage is VK_SHADER_STAGE_GEOMETRY_BIT, the identified entry point must have an OpExecutionMode instruction that specifies a maximum output vertex count that is greater than 0 and less than or equal to VkPhysicalDeviceLimits::maxGeometryOutputVertices (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00714)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00715", "If stage is VK_SHADER_STAGE_GEOMETRY_BIT, the identified entry point must have an OpExecutionMode instruction that specifies an invocation count that is greater than 0 and less than or equal to VkPhysicalDeviceLimits::maxGeometryShaderInvocations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00715)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00718", "If stage is VK_SHADER_STAGE_FRAGMENT_BIT, the identified entry point must not include any output variables in its interface decorated with CullDistance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00718)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-00719", "If stage is VK_SHADER_STAGE_FRAGMENT_BIT, and the identified entry point writes to FragDepth in any execution path, it must write to FragDepth in all execution paths (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-00719)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-01511", "If stage is VK_SHADER_STAGE_FRAGMENT_BIT, and the identified entry point writes to FragStencilRefEXT in any execution path, it must write to FragStencilRefEXT in all execution paths (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-01511)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02091", "If the mesh shader feature is not enabled, stage must not be VK_SHADER_STAGE_MESH_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-02091)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02092", "If the task shader feature is not enabled, stage must not be VK_SHADER_STAGE_TASK_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-02092)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02093", "If stage is VK_SHADER_STAGE_MESH_BIT_NV, the identified entry point must have an OpExecutionMode instruction that specifies a maximum output vertex count, OutputVertices, that is greater than 0 and less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputVertices. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-02093)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02094", "If stage is VK_SHADER_STAGE_MESH_BIT_NV, the identified entry point must have an OpExecutionMode instruction that specifies a maximum output primitive count, OutputPrimitivesNV, that is greater than 0 and less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputPrimitives. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-02094)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02596", "If stage is a vertex processing stage, and the identified entry point writes to Layer for any primitive, it must write the same value to Layer for all vertices of a given primitive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-02596)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-02597", "If stage is a vertex processing stage, and the identified entry point writes to ViewportIndex for any primitive, it must write the same value to ViewportIndex for all vertices of a given primitive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-02597)"},
    {"VUID-VkPipelineShaderStageCreateInfo-stage-parameter", "stage must be a valid VkShaderStageFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageCreateInfo-stage-parameter)"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02760", "requiredSubgroupSize must be a power-of-two integer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02760)"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02761", "requiredSubgroupSize must be greater or equal to minSubgroupSize. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02761)"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02762", "requiredSubgroupSize must be less than or equal to maxSubgroupSize. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-requiredSubgroupSize-02762)"},
    {"VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineTessellationDomainOriginStateCreateInfo-domainOrigin-parameter", "domainOrigin must be a valid VkTessellationDomainOrigin value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineTessellationDomainOriginStateCreateInfo-domainOrigin-parameter)"},
    {"VUID-VkPipelineTessellationDomainOriginStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineTessellationDomainOriginStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineTessellationStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineTessellationStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineTessellationStateCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineTessellationDomainOriginStateCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineTessellationStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineTessellationStateCreateInfo-patchControlPoints-01214", "patchControlPoints must be greater than zero and less than or equal to VkPhysicalDeviceLimits::maxTessellationPatchSize (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineTessellationStateCreateInfo-patchControlPoints-01214)"},
    {"VUID-VkPipelineTessellationStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineTessellationStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-pVertexBindingDivisors-parameter", "pVertexBindingDivisors must be a valid pointer to an array of vertexBindingDivisorCount VkVertexInputBindingDivisorDescriptionEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-pVertexBindingDivisors-parameter)"},
    {"VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-sType-sType)"},
    {"VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-vertexBindingDivisorCount-arraylength", "vertexBindingDivisorCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputDivisorStateCreateInfoEXT-vertexBindingDivisorCount-arraylength)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-binding-00615", "For every binding specified by each element of pVertexAttributeDescriptions, a VkVertexInputBindingDescription must exist in pVertexBindingDescriptions with the same value of binding (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-binding-00615)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineVertexInputDivisorStateCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions-00617", "All elements of pVertexAttributeDescriptions must describe distinct attribute locations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions-00617)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions-parameter", "If vertexAttributeDescriptionCount is not 0, pVertexAttributeDescriptions must be a valid pointer to an array of vertexAttributeDescriptionCount valid VkVertexInputAttributeDescription structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-pVertexAttributeDescriptions-parameter)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions-00616", "All elements of pVertexBindingDescriptions must describe distinct binding numbers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions-00616)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions-parameter", "If vertexBindingDescriptionCount is not 0, pVertexBindingDescriptions must be a valid pointer to an array of vertexBindingDescriptionCount valid VkVertexInputBindingDescription structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-pVertexBindingDescriptions-parameter)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-vertexAttributeDescriptionCount-00614", "vertexAttributeDescriptionCount must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputAttributes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-vertexAttributeDescriptionCount-00614)"},
    {"VUID-VkPipelineVertexInputStateCreateInfo-vertexBindingDescriptionCount-00613", "vertexBindingDescriptionCount must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputBindings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineVertexInputStateCreateInfo-vertexBindingDescriptionCount-00613)"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-02234", "The array pCustomSampleOrders must not contain two structures with matching values for both the shadingRate and sampleCount members. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-02234)"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-parameter", "If customSampleOrderCount is not 0, pCustomSampleOrders must be a valid pointer to an array of customSampleOrderCount valid VkCoarseSampleOrderCustomNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-pCustomSampleOrders-parameter)"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-02072", "If sampleOrderType is not VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV, customSamplerOrderCount must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-02072)"},
    {"VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-parameter", "sampleOrderType must be a valid VkCoarseSampleOrderTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportCoarseSampleOrderStateCreateInfoNV-sampleOrderType-parameter)"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02027", "If the multiple viewports feature is not enabled, exclusiveScissorCount must be 0 or 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02027)"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02028", "exclusiveScissorCount must be less than or equal to VkPhysicalDeviceLimits::maxViewports (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02028)"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02029", "exclusiveScissorCount must be 0 or identical to the viewportCount member of VkPipelineViewportStateCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-exclusiveScissorCount-02029)"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-pDynamicStates-02030", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV and exclusiveScissorCount is not 0, pExclusiveScissors must be a valid pointer to an array of exclusiveScissorCount VkRect2D structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-pDynamicStates-02030)"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-pExclusiveScissors-parameter", "If exclusiveScissorCount is not 0, and pExclusiveScissors is not NULL, pExclusiveScissors must be a valid pointer to an array of exclusiveScissorCount VkRect2D structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-pExclusiveScissors-parameter)"},
    {"VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportExclusiveScissorStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-pDynamicStates-02057", "If no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV, pShadingRatePalettes must be a valid pointer to an array of viewportCount VkShadingRatePaletteNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-pDynamicStates-02057)"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-pShadingRatePalettes-parameter", "If viewportCount is not 0, and pShadingRatePalettes is not NULL, pShadingRatePalettes must be a valid pointer to an array of viewportCount valid VkShadingRatePaletteNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-pShadingRatePalettes-parameter)"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-shadingRateImageEnable-02056", "If shadingRateImageEnable is VK_TRUE, viewportCount must be equal to the viewportCount member of VkPipelineViewportStateCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-shadingRateImageEnable-02056)"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-viewportCount-02054", "If the multiple viewports feature is not enabled, viewportCount must be 0 or 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-viewportCount-02054)"},
    {"VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-viewportCount-02055", "viewportCount must be less than or equal to VkPhysicalDeviceLimits::maxViewports (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportShadingRateImageStateCreateInfoNV-viewportCount-02055)"},
    {"VUID-VkPipelineViewportStateCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-flags-zerobitmask)"},
    {"VUID-VkPipelineViewportStateCreateInfo-offset-02822", "Evaluation of (offset.x + extent.width) must not cause a signed integer addition overflow for any element of pScissors (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-offset-02822)"},
    {"VUID-VkPipelineViewportStateCreateInfo-offset-02823", "Evaluation of (offset.y + extent.height) must not cause a signed integer addition overflow for any element of pScissors (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-offset-02823)"},
    {"VUID-VkPipelineViewportStateCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineViewportCoarseSampleOrderStateCreateInfoNV, VkPipelineViewportExclusiveScissorStateCreateInfoNV, VkPipelineViewportShadingRateImageStateCreateInfoNV, VkPipelineViewportSwizzleStateCreateInfoNV, or VkPipelineViewportWScalingStateCreateInfoNV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-pNext-pNext)"},
    {"VUID-VkPipelineViewportStateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-sType-sType)"},
    {"VUID-VkPipelineViewportStateCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-sType-unique)"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-01217", "If the multiple viewports feature is not enabled, scissorCount must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-scissorCount-01217)"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-01219", "scissorCount must be between 1 and VkPhysicalDeviceLimits::maxViewports, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-scissorCount-01219)"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-01220", "scissorCount and viewportCount must be identical (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-scissorCount-01220)"},
    {"VUID-VkPipelineViewportStateCreateInfo-scissorCount-arraylength", "scissorCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-scissorCount-arraylength)"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportCount-01216", "If the multiple viewports feature is not enabled, viewportCount must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-viewportCount-01216)"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportCount-01218", "viewportCount must be between 1 and VkPhysicalDeviceLimits::maxViewports, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-viewportCount-01218)"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportCount-arraylength", "viewportCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-viewportCount-arraylength)"},
    {"VUID-VkPipelineViewportStateCreateInfo-viewportWScalingEnable-01726", "If the viewportWScalingEnable member of a VkPipelineViewportWScalingStateCreateInfoNV structure included in the pNext chain is VK_TRUE, the viewportCount member of the VkPipelineViewportWScalingStateCreateInfoNV structure must be equal to viewportCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-viewportWScalingEnable-01726)"},
    {"VUID-VkPipelineViewportStateCreateInfo-x-02821", "The x and y members of offset member of any element of pScissors must be greater than or equal to 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportStateCreateInfo-x-02821)"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportSwizzleStateCreateInfoNV-flags-zerobitmask)"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-pViewportSwizzles-parameter", "pViewportSwizzles must be a valid pointer to an array of viewportCount valid VkViewportSwizzleNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportSwizzleStateCreateInfoNV-pViewportSwizzles-parameter)"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportSwizzleStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-01215", "viewportCount must match the viewportCount set in VkPipelineViewportStateCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-01215)"},
    {"VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-arraylength", "viewportCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportSwizzleStateCreateInfoNV-viewportCount-arraylength)"},
    {"VUID-VkPipelineViewportWScalingStateCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportWScalingStateCreateInfoNV-sType-sType)"},
    {"VUID-VkPipelineViewportWScalingStateCreateInfoNV-viewportCount-arraylength", "viewportCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPipelineViewportWScalingStateCreateInfoNV-viewportCount-arraylength)"},
    {"VUID-VkPresentFrameTokenGGP-frameToken-02680", "frameToken must be a valid GgpFrameToken (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentFrameTokenGGP-frameToken-02680)"},
    {"VUID-VkPresentFrameTokenGGP-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentFrameTokenGGP-sType-sType)"},
    {"VUID-VkPresentInfoKHR-commonparent", "Both of the elements of pSwapchains, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkInstance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-commonparent)"},
    {"VUID-VkPresentInfoKHR-pImageIndices-01296", "Each element of pImageIndices must be the index of a presentable image acquired from the swapchain specified by the corresponding element of the pSwapchains array, and the presented image subresource must be in the VK_IMAGE_LAYOUT_PRESENT_SRC_KHR layout at the time the operation is executed on a VkDevice (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkPresentInfoKHR-pImageIndices-01296)"},
    {"VUID-VkPresentInfoKHR-pImageIndices-01430", "Each element of pImageIndices must be the index of a presentable image acquired from the swapchain specified by the corresponding element of the pSwapchains array, and the presented image subresource must be in the VK_IMAGE_LAYOUT_PRESENT_SRC_KHR or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR layout at the time the operation is executed on a VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-pImageIndices-01430)"},
    {"VUID-VkPresentInfoKHR-pImageIndices-parameter", "pImageIndices must be a valid pointer to an array of swapchainCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-pImageIndices-parameter)"},
    {"VUID-VkPresentInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupPresentInfoKHR, VkDisplayPresentInfoKHR, VkPresentFrameTokenGGP, VkPresentRegionsKHR, or VkPresentTimesInfoGOOGLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-pNext-pNext)"},
    {"VUID-VkPresentInfoKHR-pResults-parameter", "If pResults is not NULL, pResults must be a valid pointer to an array of swapchainCount VkResult values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-pResults-parameter)"},
    {"VUID-VkPresentInfoKHR-pSwapchains-parameter", "pSwapchains must be a valid pointer to an array of swapchainCount valid VkSwapchainKHR handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-pSwapchains-parameter)"},
    {"VUID-VkPresentInfoKHR-pWaitSemaphores-03269", "All elements of the pWaitSemaphores must have a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-pWaitSemaphores-03269)"},
    {"VUID-VkPresentInfoKHR-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-pWaitSemaphores-parameter)"},
    {"VUID-VkPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-sType-sType)"},
    {"VUID-VkPresentInfoKHR-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-sType-unique)"},
    {"VUID-VkPresentInfoKHR-swapchainCount-arraylength", "swapchainCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentInfoKHR-swapchainCount-arraylength)"},
    {"VUID-VkPresentRegionKHR-pRectangles-parameter", "If rectangleCount is not 0, and pRectangles is not NULL, pRectangles must be a valid pointer to an array of rectangleCount valid VkRectLayerKHR structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentRegionKHR-pRectangles-parameter)"},
    {"VUID-VkPresentRegionsKHR-pRegions-parameter", "If pRegions is not NULL, pRegions must be a valid pointer to an array of swapchainCount valid VkPresentRegionKHR structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentRegionsKHR-pRegions-parameter)"},
    {"VUID-VkPresentRegionsKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentRegionsKHR-sType-sType)"},
    {"VUID-VkPresentRegionsKHR-swapchainCount-01260", "swapchainCount must be the same value as VkPresentInfoKHR::swapchainCount, where VkPresentInfoKHR is included in the pNext chain of this VkPresentRegionsKHR structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentRegionsKHR-swapchainCount-01260)"},
    {"VUID-VkPresentRegionsKHR-swapchainCount-arraylength", "swapchainCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentRegionsKHR-swapchainCount-arraylength)"},
    {"VUID-VkPresentTimesInfoGOOGLE-pTimes-parameter", "If pTimes is not NULL, pTimes must be a valid pointer to an array of swapchainCount VkPresentTimeGOOGLE structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentTimesInfoGOOGLE-pTimes-parameter)"},
    {"VUID-VkPresentTimesInfoGOOGLE-sType-sType", "sType must be VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentTimesInfoGOOGLE-sType-sType)"},
    {"VUID-VkPresentTimesInfoGOOGLE-swapchainCount-01247", "swapchainCount must be the same value as VkPresentInfoKHR::swapchainCount, where VkPresentInfoKHR is included in the pNext chain of this VkPresentTimesInfoGOOGLE structure. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentTimesInfoGOOGLE-swapchainCount-01247)"},
    {"VUID-VkPresentTimesInfoGOOGLE-swapchainCount-arraylength", "swapchainCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPresentTimesInfoGOOGLE-swapchainCount-arraylength)"},
    {"VUID-VkProtectedSubmitInfo-pNext-01819", "If the VkSubmitInfo::pNext chain does not include a VkProtectedSubmitInfo structure, then each element of the command buffer of the pCommandBuffers array must be an unprotected command buffer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkProtectedSubmitInfo-pNext-01819)"},
    {"VUID-VkProtectedSubmitInfo-protectedSubmit-01816", "If the protected memory feature is not enabled, protectedSubmit must not be VK_TRUE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkProtectedSubmitInfo-protectedSubmit-01816)"},
    {"VUID-VkProtectedSubmitInfo-protectedSubmit-01817", "If protectedSubmit is VK_TRUE, then each element of the pCommandBuffers array must be a protected command buffer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkProtectedSubmitInfo-protectedSubmit-01817)"},
    {"VUID-VkProtectedSubmitInfo-protectedSubmit-01818", "If protectedSubmit is VK_FALSE, then each element of the pCommandBuffers array must be an unprotected command buffer. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkProtectedSubmitInfo-protectedSubmit-01818)"},
    {"VUID-VkProtectedSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkProtectedSubmitInfo-sType-sType)"},
    {"VUID-VkPushConstantRange-offset-00294", "offset must be less than VkPhysicalDeviceLimits::maxPushConstantsSize (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPushConstantRange-offset-00294)"},
    {"VUID-VkPushConstantRange-offset-00295", "offset must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPushConstantRange-offset-00295)"},
    {"VUID-VkPushConstantRange-size-00296", "size must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPushConstantRange-size-00296)"},
    {"VUID-VkPushConstantRange-size-00297", "size must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPushConstantRange-size-00297)"},
    {"VUID-VkPushConstantRange-size-00298", "size must be less than or equal to VkPhysicalDeviceLimits::maxPushConstantsSize minus offset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPushConstantRange-size-00298)"},
    {"VUID-VkPushConstantRange-stageFlags-parameter", "stageFlags must be a valid combination of VkShaderStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPushConstantRange-stageFlags-parameter)"},
    {"VUID-VkPushConstantRange-stageFlags-requiredbitmask", "stageFlags must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkPushConstantRange-stageFlags-requiredbitmask)"},
    {"VUID-VkQueryPoolCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-flags-zerobitmask)"},
    {"VUID-VkQueryPoolCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkQueryPoolPerformanceCreateInfoKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-pNext-pNext)"},
    {"VUID-VkQueryPoolCreateInfo-queryCount-02763", "queryCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-queryCount-02763)"},
    {"VUID-VkQueryPoolCreateInfo-queryType-00791", "If the pipeline statistics queries feature is not enabled, queryType must not be VK_QUERY_TYPE_PIPELINE_STATISTICS (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-queryType-00791)"},
    {"VUID-VkQueryPoolCreateInfo-queryType-00792", "If queryType is VK_QUERY_TYPE_PIPELINE_STATISTICS, pipelineStatistics must be a valid combination of VkQueryPipelineStatisticFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-queryType-00792)"},
    {"VUID-VkQueryPoolCreateInfo-queryType-03222", "If queryType is VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR, the pNext chain must include a structure of type VkQueryPoolPerformanceCreateInfoKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-queryType-03222)"},
    {"VUID-VkQueryPoolCreateInfo-queryType-parameter", "queryType must be a valid VkQueryType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-queryType-parameter)"},
    {"VUID-VkQueryPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfo-sType-sType)"},
    {"VUID-VkQueryPoolCreateInfoINTEL-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfoINTEL-pNext-pNext)"},
    {"VUID-VkQueryPoolCreateInfoINTEL-performanceCountersSampling-parameter", "performanceCountersSampling must be a valid VkQueryPoolSamplingModeINTEL value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfoINTEL-performanceCountersSampling-parameter)"},
    {"VUID-VkQueryPoolCreateInfoINTEL-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolCreateInfoINTEL-sType-sType)"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-counterIndexCount-arraylength", "counterIndexCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolPerformanceCreateInfoKHR-counterIndexCount-arraylength)"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-03321", "Each element of pCounterIndices must be in the range of counters reported by vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR for the queue family specified in queueFamilyIndex (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-03321)"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-parameter", "pCounterIndices must be a valid pointer to an array of counterIndexCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolPerformanceCreateInfoKHR-pCounterIndices-parameter)"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-performanceCounterQueryPools-03237", "The performanceCounterQueryPools feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolPerformanceCreateInfoKHR-performanceCounterQueryPools-03237)"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-queueFamilyIndex-03236", "queueFamilyIndex must be a valid queue family index of the device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolPerformanceCreateInfoKHR-queueFamilyIndex-03236)"},
    {"VUID-VkQueryPoolPerformanceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueryPoolPerformanceCreateInfoKHR-sType-sType)"},
    {"VUID-VkQueueFamilyCheckpointPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueueFamilyCheckpointPropertiesNV-sType-sType)"},
    {"VUID-VkQueueFamilyProperties2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkQueueFamilyCheckpointPropertiesNV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueueFamilyProperties2-pNext-pNext)"},
    {"VUID-VkQueueFamilyProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkQueueFamilyProperties2-sType-sType)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-commonparent)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-02404", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid handle to a ray tracing VkPipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-flags-02404)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-02405", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-flags-02405)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-02406", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is not -1, basePipelineHandle must be VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-flags-02406)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-02407", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is not VK_NULL_HANDLE, basePipelineIndex must be -1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-flags-02407)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-flags-parameter)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-groupCount-arraylength", "groupCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-groupCount-arraylength)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-layout-02410", "layout must be consistent with all shaders specified in pStages (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-layout-02410)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-layout-02411", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-layout-02411)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-layout-parameter", "layout must be a valid VkPipelineLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-layout-parameter)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-maxRecursionDepth-02412", "maxRecursionDepth must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxRecursionDepth (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-maxRecursionDepth-02412)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pGroups-parameter", "pGroups must be a valid pointer to an array of groupCount valid VkRayTracingShaderGroupCreateInfoNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-pGroups-parameter)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineCreationFeedbackCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-pNext-pNext)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pStages-02409", "The shader code for the entry points identified by pStages, and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-pStages-02409)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-pStages-parameter", "pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-pStages-parameter)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-sType-sType)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-stage-02408", "The stage member of one element of pStages must be VK_SHADER_STAGE_RAYGEN_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-stage-02408)"},
    {"VUID-VkRayTracingPipelineCreateInfoNV-stageCount-arraylength", "stageCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingPipelineCreateInfoNV-stageCount-arraylength)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-anyHitShader-02418", "anyHitShader must be either VK_SHADER_UNUSED_NV or a valid index into pStages referring to a shader of VK_SHADER_STAGE_ANY_HIT_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-anyHitShader-02418)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-closestHitShader-02417", "closestHitShader must be either VK_SHADER_UNUSED_NV or a valid index into pStages referring to a shader of VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-closestHitShader-02417)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-pNext-pNext)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-sType-sType)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02413", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV then generalShader must be a valid index into pStages referring to a shader of VK_SHADER_STAGE_RAYGEN_BIT_NV, VK_SHADER_STAGE_MISS_BIT_NV, or VK_SHADER_STAGE_CALLABLE_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-type-02413)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02414", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV then closestHitShader, anyHitShader, and intersectionShader must be VK_SHADER_UNUSED_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-type-02414)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02415", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV then intersectionShader must be a valid index into pStages referring to a shader of VK_SHADER_STAGE_INTERSECTION_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-type-02415)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-02416", "If type is VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV then intersectionShader must be VK_SHADER_UNUSED_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-type-02416)"},
    {"VUID-VkRayTracingShaderGroupCreateInfoNV-type-parameter", "type must be a valid VkRayTracingShaderGroupTypeNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRayTracingShaderGroupCreateInfoNV-type-parameter)"},
    {"VUID-VkRectLayerKHR-layer-01262", "layer must be less than imageArrayLayers member of the VkSwapchainCreateInfoKHR structure given to vkCreateSwapchainKHR. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRectLayerKHR-layer-01262)"},
    {"VUID-VkRectLayerKHR-offset-01261", "The sum of offset and extent must be no greater than the imageExtent member of the VkSwapchainCreateInfoKHR structure given to vkCreateSwapchainKHR. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRectLayerKHR-offset-01261)"},
    {"VUID-VkRenderPassAttachmentBeginInfo-pAttachments-03218", "Each element of pAttachments must only specify a single mip level (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassAttachmentBeginInfo-pAttachments-03218)"},
    {"VUID-VkRenderPassAttachmentBeginInfo-pAttachments-03219", "Each element of pAttachments must have been created with the identity swizzle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassAttachmentBeginInfo-pAttachments-03219)"},
    {"VUID-VkRenderPassAttachmentBeginInfo-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassAttachmentBeginInfo-pAttachments-parameter)"},
    {"VUID-VkRenderPassAttachmentBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassAttachmentBeginInfo-sType-sType)"},
    {"VUID-VkRenderPassBeginInfo-clearValueCount-00902", "clearValueCount must be greater than the largest attachment index in renderPass that specifies a loadOp (or stencilLoadOp, if the attachment has a depth/stencil format) of VK_ATTACHMENT_LOAD_OP_CLEAR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-clearValueCount-00902)"},
    {"VUID-VkRenderPassBeginInfo-commonparent", "Both of framebuffer, and renderPass must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-commonparent)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-02780", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT_KHR, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must have been created on the same VkDevice as framebuffer and renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-02780)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03207", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that did not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and the pNext chain includes a VkRenderPassAttachmentBeginInfo structure, its attachmentCount must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03207)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03208", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the attachmentCount of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be equal to the value of VkFramebufferAttachmentsCreateInfo::attachmentImageInfoCount used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03208)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03209", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageCreateInfo::flags equal to the flags member of the corresponding element of VkFramebufferAttachmentsCreateInfoKHR::pAttachments used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03209)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03210", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageCreateInfo::usage equal to the usage member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachments used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03210)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03211", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView with a width equal to the width member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachments used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03211)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03212", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView with a height equal to the height member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachments used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03212)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03213", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageViewCreateInfo::subresourceRange.layerCount equal to the layerCount member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachments used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03213)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03214", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageFormatListCreateInfo::viewFormatCount equal to the viewFormatCount member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachments used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03214)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03215", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a set of elements in VkImageFormatListCreateInfo::pViewFormats equal to the set of elements in the pViewFormats member of the corresponding element of VkFramebufferAttachmentsCreateInfo::pAttachments used to create framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03215)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03216", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageViewCreateInfo::format equal to the corresponding value of VkAttachmentDescription::format in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03216)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-03217", "If framebuffer was created with a VkFramebufferCreateInfo::flags value that included VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of the pAttachments member of a VkRenderPassAttachmentBeginInfo structure included in the pNext chain must be a VkImageView of an image created with a value of VkImageCreateInfo::samples equal to the corresponding value of VkAttachmentDescription::samples in renderPass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-03217)"},
    {"VUID-VkRenderPassBeginInfo-framebuffer-parameter", "framebuffer must be a valid VkFramebuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-framebuffer-parameter)"},
    {"VUID-VkRenderPassBeginInfo-pClearValues-parameter", "If clearValueCount is not 0, pClearValues must be a valid pointer to an array of clearValueCount VkClearValue unions (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pClearValues-parameter)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02850", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.x must be greater than or equal to 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02850)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02851", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.y must be greater than or equal to 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02851)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02852", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.x + renderArea.offset.width must be less than or equal to VkFramebufferCreateInfo::width the framebuffer was created with (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02852)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02853", "If the pNext chain does not contain VkDeviceGroupRenderPassBeginInfo or its deviceRenderAreaCount member is equal to 0, renderArea.offset.y + renderArea.offset.height must be less than or equal to VkFramebufferCreateInfo::height the framebuffer was created with (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02853)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02854", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, the offset.x member of each element of pDeviceRenderAreas must be greater than or equal to 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02854)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02855", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, the offset.y member of each element of pDeviceRenderAreas must be greater than or equal to 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02855)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02856", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, offset.x + offset.width of each element of pDeviceRenderAreas must be less than or equal to VkFramebufferCreateInfo::width the framebuffer was created with (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02856)"},
    {"VUID-VkRenderPassBeginInfo-pNext-02857", "If the pNext chain contains VkDeviceGroupRenderPassBeginInfo, offset.y + offset.height of each element of pDeviceRenderAreas must be less than or equal to VkFramebufferCreateInfo::height the framebuffer was created with (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-02857)"},
    {"VUID-VkRenderPassBeginInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupRenderPassBeginInfo, VkRenderPassAttachmentBeginInfo, or VkRenderPassSampleLocationsBeginInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-pNext-pNext)"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02846", "renderArea.offset.x must be greater than or equal to 0 (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkRenderPassBeginInfo-renderArea-02846)"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02847", "renderArea.offset.y must be greater than or equal to 0 (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkRenderPassBeginInfo-renderArea-02847)"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02848", "renderArea.offset.x + renderArea.offset.width must be less than or equal to VkFramebufferCreateInfo::width the framebuffer was created with (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkRenderPassBeginInfo-renderArea-02848)"},
    {"VUID-VkRenderPassBeginInfo-renderArea-02849", "renderArea.offset.y + renderArea.offset.height must be less than or equal to VkFramebufferCreateInfo::height the framebuffer was created with (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkRenderPassBeginInfo-renderArea-02849)"},
    {"VUID-VkRenderPassBeginInfo-renderPass-00904", "renderPass must be compatible with the renderPass member of the VkFramebufferCreateInfo structure specified when creating framebuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-renderPass-00904)"},
    {"VUID-VkRenderPassBeginInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-renderPass-parameter)"},
    {"VUID-VkRenderPassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-sType-sType)"},
    {"VUID-VkRenderPassBeginInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassBeginInfo-sType-unique)"},
    {"VUID-VkRenderPassCreateInfo-attachment-00834", "If the attachment member of any element of pInputAttachments, pColorAttachments, pResolveAttachments or pDepthStencilAttachment, or any element of pPreserveAttachments in any element of pSubpasses is not VK_ATTACHMENT_UNUSED, it must be less than attachmentCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-attachment-00834)"},
    {"VUID-VkRenderPassCreateInfo-dstSubpass-02518", "The dstSubpass member of each element of pDependencies must be less than subpassCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-dstSubpass-02518)"},
    {"VUID-VkRenderPassCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-flags-zerobitmask)"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-00836", "For any member of pAttachments with a loadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pAttachments-00836)"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-01566", "For any member of pAttachments with a loadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pAttachments-01566)"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-01567", "For any member of pAttachments with a stencilLoadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pAttachments-01567)"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-02511", "For any member of pAttachments with a stencilLoadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pAttachments-02511)"},
    {"VUID-VkRenderPassCreateInfo-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkAttachmentDescription structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pAttachments-parameter)"},
    {"VUID-VkRenderPassCreateInfo-pDependencies-00837", "For any element of pDependencies, if the srcSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the srcStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the source subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pDependencies-00837)"},
    {"VUID-VkRenderPassCreateInfo-pDependencies-00838", "For any element of pDependencies, if the dstSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the dstStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the destination subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pDependencies-00838)"},
    {"VUID-VkRenderPassCreateInfo-pDependencies-parameter", "If dependencyCount is not 0, pDependencies must be a valid pointer to an array of dependencyCount valid VkSubpassDependency structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pDependencies-parameter)"},
    {"VUID-VkRenderPassCreateInfo-pNext-01926", "If the pNext chain includes a VkRenderPassInputAttachmentAspectCreateInfo structure, the subpass member of each element of its pAspectReferences member must be less than subpassCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-01926)"},
    {"VUID-VkRenderPassCreateInfo-pNext-01927", "If the pNext chain includes a VkRenderPassInputAttachmentAspectCreateInfo structure, the inputAttachmentIndex member of each element of its pAspectReferences member must be less than the value of inputAttachmentCount in the member of pSubpasses identified by its subpass member (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-01927)"},
    {"VUID-VkRenderPassCreateInfo-pNext-01928", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, and its subpassCount member is not zero, that member must be equal to the value of subpassCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-01928)"},
    {"VUID-VkRenderPassCreateInfo-pNext-01929", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, if its dependencyCount member is not zero, it must be equal to dependencyCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-01929)"},
    {"VUID-VkRenderPassCreateInfo-pNext-01930", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, for each non-zero element of pViewOffsets, the srcSubpass and dstSubpass members of pDependencies at the same index must not be equal (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-01930)"},
    {"VUID-VkRenderPassCreateInfo-pNext-01963", "If the pNext chain includes a VkRenderPassInputAttachmentAspectCreateInfo structure, for any element of the pInputAttachments member of any element of pSubpasses where the attachment member is not VK_ATTACHMENT_UNUSED, the aspectMask member of the corresponding element of VkRenderPassInputAttachmentAspectCreateInfo::pAspectReferences must only include aspects that are present in images of the format specified by the element of pAttachments at attachment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-01963)"},
    {"VUID-VkRenderPassCreateInfo-pNext-02512", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, for any element of pDependencies with a dependencyFlags member that does not include VK_DEPENDENCY_VIEW_LOCAL_BIT, the corresponding element of the pViewOffsets member of that VkRenderPassMultiviewCreateInfo instance must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-02512)"},
    {"VUID-VkRenderPassCreateInfo-pNext-02513", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, elements of its pViewMasks member must either all be 0, or all not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-02513)"},
    {"VUID-VkRenderPassCreateInfo-pNext-02514", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, and each element of its pViewMasks member is 0, the dependencyFlags member of each element of pDependencies must not include VK_DEPENDENCY_VIEW_LOCAL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-02514)"},
    {"VUID-VkRenderPassCreateInfo-pNext-02515", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, and each element of its pViewMasks member is 0, correlatedViewMaskCount must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-02515)"},
    {"VUID-VkRenderPassCreateInfo-pNext-02516", "If the pNext chain includes a VkRenderPassMultiviewCreateInfo structure, each element of its pViewMask member must not have a bit set at an index greater than or equal to VkPhysicalDeviceLimits::maxFramebufferLayers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-02516)"},
    {"VUID-VkRenderPassCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkRenderPassFragmentDensityMapCreateInfoEXT, VkRenderPassInputAttachmentAspectCreateInfo, or VkRenderPassMultiviewCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pNext-pNext)"},
    {"VUID-VkRenderPassCreateInfo-pSubpasses-parameter", "pSubpasses must be a valid pointer to an array of subpassCount valid VkSubpassDescription structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-pSubpasses-parameter)"},
    {"VUID-VkRenderPassCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-sType-sType)"},
    {"VUID-VkRenderPassCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-sType-unique)"},
    {"VUID-VkRenderPassCreateInfo-srcSubpass-02517", "The srcSubpass member of each element of pDependencies must be less than subpassCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-srcSubpass-02517)"},
    {"VUID-VkRenderPassCreateInfo-subpassCount-arraylength", "subpassCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo-subpassCount-arraylength)"},
    {"VUID-VkRenderPassCreateInfo2-None-03049", "If any two subpasses operate on attachments with overlapping ranges of the same VkDeviceMemory object, and at least one subpass writes to that area of VkDeviceMemory, a subpass dependency must be included (either directly or via some intermediate subpasses) between them (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-None-03049)"},
    {"VUID-VkRenderPassCreateInfo2-attachment-02525", "If the attachment member of any element of the pInputAttachments member of any element of pSubpasses is not VK_ATTACHMENT_UNUSED, the aspectMask member of that element of pInputAttachments must only include aspects that are present in images of the format specified by the element of pAttachments specified by attachment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-attachment-02525)"},
    {"VUID-VkRenderPassCreateInfo2-attachment-03050", "If the attachment member of any element of pInputAttachments, pColorAttachments, pResolveAttachments or pDepthStencilAttachment, or the attachment indexed by any element of pPreserveAttachments in any given element of pSubpasses is bound to a range of a VkDeviceMemory object that overlaps with any other attachment in any subpass (including the same subpass), the VkAttachmentDescription2 structures describing them must include VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT in flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-attachment-03050)"},
    {"VUID-VkRenderPassCreateInfo2-attachment-03051", "If the attachment member of any element of pInputAttachments, pColorAttachments, pResolveAttachments or pDepthStencilAttachment, or any element of pPreserveAttachments in any given element of pSubpasses is not VK_ATTACHMENT_UNUSED, it must be less than attachmentCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-attachment-03051)"},
    {"VUID-VkRenderPassCreateInfo2-dstSubpass-02527", "The dstSubpass member of each element of pDependencies must be less than subpassCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-dstSubpass-02527)"},
    {"VUID-VkRenderPassCreateInfo2-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-flags-zerobitmask)"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-02522", "For any member of pAttachments with a loadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pAttachments-02522)"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-02523", "For any member of pAttachments with a stencilLoadOp equal to VK_ATTACHMENT_LOAD_OP_CLEAR, the first use of that attachment must not specify a layout equal to VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pAttachments-02523)"},
    {"VUID-VkRenderPassCreateInfo2-pAttachments-parameter", "If attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkAttachmentDescription2 structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pAttachments-parameter)"},
    {"VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-03056", "The set of bits included in any element of pCorrelatedViewMasks must not overlap with the set of bits included in any other element of pCorrelatedViewMasks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-03056)"},
    {"VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-parameter", "If correlatedViewMaskCount is not 0, pCorrelatedViewMasks must be a valid pointer to an array of correlatedViewMaskCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pCorrelatedViewMasks-parameter)"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-03054", "For any element of pDependencies, if the srcSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the srcStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the source subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pDependencies-03054)"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-03055", "For any element of pDependencies, if the dstSubpass is not VK_SUBPASS_EXTERNAL, all stage flags included in the dstStageMask member of that dependency must be a pipeline stage supported by the pipeline identified by the pipelineBindPoint member of the destination subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pDependencies-03055)"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-03060", "For any element of pDependencies where its srcSubpass member equals its dstSubpass member, if the viewMask member of the corresponding element of pSubpasses includes more than one bit, its dependencyFlags member must include VK_DEPENDENCY_VIEW_LOCAL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pDependencies-03060)"},
    {"VUID-VkRenderPassCreateInfo2-pDependencies-parameter", "If dependencyCount is not 0, pDependencies must be a valid pointer to an array of dependencyCount valid VkSubpassDependency2 structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pDependencies-parameter)"},
    {"VUID-VkRenderPassCreateInfo2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkRenderPassFragmentDensityMapCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pNext-pNext)"},
    {"VUID-VkRenderPassCreateInfo2-pSubpasses-parameter", "pSubpasses must be a valid pointer to an array of subpassCount valid VkSubpassDescription2 structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-pSubpasses-parameter)"},
    {"VUID-VkRenderPassCreateInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-sType-sType)"},
    {"VUID-VkRenderPassCreateInfo2-srcSubpass-02526", "The srcSubpass member of each element of pDependencies must be less than subpassCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-srcSubpass-02526)"},
    {"VUID-VkRenderPassCreateInfo2-subpassCount-arraylength", "subpassCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-subpassCount-arraylength)"},
    {"VUID-VkRenderPassCreateInfo2-viewMask-02524", "The viewMask member must not have a bit set at an index greater than or equal to VkPhysicalDeviceLimits::maxFramebufferLayers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-viewMask-02524)"},
    {"VUID-VkRenderPassCreateInfo2-viewMask-03057", "If the VkSubpassDescription2::viewMask member of all elements of pSubpasses is 0, correlatedViewMaskCount must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-viewMask-03057)"},
    {"VUID-VkRenderPassCreateInfo2-viewMask-03058", "The VkSubpassDescription2::viewMask member of all elements of pSubpasses must either all be 0, or all not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-viewMask-03058)"},
    {"VUID-VkRenderPassCreateInfo2-viewMask-03059", "If the VkSubpassDescription2::viewMask member of all elements of pSubpasses is 0, the dependencyFlags member of any element of pDependencies must not include VK_DEPENDENCY_VIEW_LOCAL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassCreateInfo2-viewMask-03059)"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02547", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must be less than VkRenderPassCreateInfo::attachmentCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02547)"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02548", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must not be an element of VkSubpassDescription::pInputAttachments, VkSubpassDescription::pColorAttachments, VkSubpassDescription::pResolveAttachments, VkSubpassDescription::pDepthStencilAttachment, or VkSubpassDescription::pPreserveAttachments for any subpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02548)"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02549", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, layout must be equal to VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT, or VK_IMAGE_LAYOUT_GENERAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02549)"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02550", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must reference an attachment with a loadOp equal to VK_ATTACHMENT_LOAD_OP_LOAD or VK_ATTACHMENT_LOAD_OP_DONT_CARE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02550)"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02551", "If fragmentDensityMapAttachment is not VK_ATTACHMENT_UNUSED, fragmentDensityMapAttachment must reference an attachment with a storeOp equal to VK_ATTACHMENT_STORE_OP_DONT_CARE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-02551)"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-parameter", "fragmentDensityMapAttachment must be a valid VkAttachmentReference structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-fragmentDensityMapAttachment-parameter)"},
    {"VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassFragmentDensityMapCreateInfoEXT-sType-sType)"},
    {"VUID-VkRenderPassInputAttachmentAspectCreateInfo-aspectReferenceCount-arraylength", "aspectReferenceCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassInputAttachmentAspectCreateInfo-aspectReferenceCount-arraylength)"},
    {"VUID-VkRenderPassInputAttachmentAspectCreateInfo-pAspectReferences-parameter", "pAspectReferences must be a valid pointer to an array of aspectReferenceCount valid VkInputAttachmentAspectReference structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassInputAttachmentAspectCreateInfo-pAspectReferences-parameter)"},
    {"VUID-VkRenderPassInputAttachmentAspectCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassInputAttachmentAspectCreateInfo-sType-sType)"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-00841", "Each view index must not be set in more than one element of pCorrelationMasks (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-00841)"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-parameter", "If correlationMaskCount is not 0, pCorrelationMasks must be a valid pointer to an array of correlationMaskCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassMultiviewCreateInfo-pCorrelationMasks-parameter)"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pViewMasks-parameter", "If subpassCount is not 0, pViewMasks must be a valid pointer to an array of subpassCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassMultiviewCreateInfo-pViewMasks-parameter)"},
    {"VUID-VkRenderPassMultiviewCreateInfo-pViewOffsets-parameter", "If dependencyCount is not 0, pViewOffsets must be a valid pointer to an array of dependencyCount int32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassMultiviewCreateInfo-pViewOffsets-parameter)"},
    {"VUID-VkRenderPassMultiviewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassMultiviewCreateInfo-sType-sType)"},
    {"VUID-VkRenderPassSampleLocationsBeginInfoEXT-pAttachmentInitialSampleLocations-parameter", "If attachmentInitialSampleLocationsCount is not 0, pAttachmentInitialSampleLocations must be a valid pointer to an array of attachmentInitialSampleLocationsCount valid VkAttachmentSampleLocationsEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassSampleLocationsBeginInfoEXT-pAttachmentInitialSampleLocations-parameter)"},
    {"VUID-VkRenderPassSampleLocationsBeginInfoEXT-pPostSubpassSampleLocations-parameter", "If postSubpassSampleLocationsCount is not 0, pPostSubpassSampleLocations must be a valid pointer to an array of postSubpassSampleLocationsCount valid VkSubpassSampleLocationsEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassSampleLocationsBeginInfoEXT-pPostSubpassSampleLocations-parameter)"},
    {"VUID-VkRenderPassSampleLocationsBeginInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkRenderPassSampleLocationsBeginInfoEXT-sType-sType)"},
    {"VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter", "If sampleLocationsCount is not 0, pSampleLocations must be a valid pointer to an array of sampleLocationsCount VkSampleLocationEXT structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSampleLocationsInfoEXT-pSampleLocations-parameter)"},
    {"VUID-VkSampleLocationsInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSampleLocationsInfoEXT-sType-sType)"},
    {"VUID-VkSampleLocationsInfoEXT-sampleLocationsCount-01527", "sampleLocationsCount must equal sampleLocationsPerPixel {times} sampleLocationGridSize.width {times} sampleLocationGridSize.height (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSampleLocationsInfoEXT-sampleLocationsCount-01527)"},
    {"VUID-VkSampleLocationsInfoEXT-sampleLocationsPerPixel-01526", "sampleLocationsPerPixel must be a bit value that is set in VkPhysicalDeviceSampleLocationsPropertiesEXT::sampleLocationSampleCounts (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSampleLocationsInfoEXT-sampleLocationsPerPixel-01526)"},
    {"VUID-VkSampleLocationsInfoEXT-sampleLocationsPerPixel-parameter", "If sampleLocationsPerPixel is not 0, sampleLocationsPerPixel must be a valid VkSampleCountFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSampleLocationsInfoEXT-sampleLocationsPerPixel-parameter)"},
    {"VUID-VkSamplerCreateInfo-None-01647", "The sampler reduction mode must be set to VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE if sampler {YCbCr} conversion is enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-None-01647)"},
    {"VUID-VkSamplerCreateInfo-addressModeU-01078", "If any of addressModeU, addressModeV or addressModeW are VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER, borderColor must be a valid VkBorderColor value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-addressModeU-01078)"},
    {"VUID-VkSamplerCreateInfo-addressModeU-01079", "If ifdef::VK_VERSION_1_2[samplerMirrorClampToEdge is not enabled, and if]     the VK_KHR_sampler_mirror_clamp_to_edge extension is not enabled,     addressModeU, addressModeV and addressModeW must not     be VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-addressModeU-01079)"},
    {"VUID-VkSamplerCreateInfo-addressModeU-01646", "If sampler {YCbCr} conversion is enabled, addressModeU, addressModeV, and addressModeW must be VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE, anisotropyEnable must be VK_FALSE, and unnormalizedCoordinates must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-addressModeU-01646)"},
    {"VUID-VkSamplerCreateInfo-addressModeU-parameter", "addressModeU must be a valid VkSamplerAddressMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-addressModeU-parameter)"},
    {"VUID-VkSamplerCreateInfo-addressModeV-parameter", "addressModeV must be a valid VkSamplerAddressMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-addressModeV-parameter)"},
    {"VUID-VkSamplerCreateInfo-addressModeW-parameter", "addressModeW must be a valid VkSamplerAddressMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-addressModeW-parameter)"},
    {"VUID-VkSamplerCreateInfo-anisotropyEnable-01070", "If the anisotropic sampling feature is not enabled, anisotropyEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-anisotropyEnable-01070)"},
    {"VUID-VkSamplerCreateInfo-anisotropyEnable-01071", "If anisotropyEnable is VK_TRUE, maxAnisotropy must be between 1.0 and VkPhysicalDeviceLimits::maxSamplerAnisotropy, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-anisotropyEnable-01071)"},
    {"VUID-VkSamplerCreateInfo-compareEnable-01080", "If compareEnable is VK_TRUE, compareOp must be a valid VkCompareOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-compareEnable-01080)"},
    {"VUID-VkSamplerCreateInfo-compareEnable-01423", "If compareEnable is VK_TRUE, the reductionMode member of VkSamplerReductionModeCreateInfo must be VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-compareEnable-01423)"},
    {"VUID-VkSamplerCreateInfo-flags-02574", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then minFilter and magFilter must be equal. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-02574)"},
    {"VUID-VkSamplerCreateInfo-flags-02575", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then mipmapMode must be VK_SAMPLER_MIPMAP_MODE_NEAREST. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-02575)"},
    {"VUID-VkSamplerCreateInfo-flags-02576", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then minLod and maxLod must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-02576)"},
    {"VUID-VkSamplerCreateInfo-flags-02577", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then addressModeU and addressModeV must each be either VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE or VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-02577)"},
    {"VUID-VkSamplerCreateInfo-flags-02578", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then anisotropyEnable must be VK_FALSE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-02578)"},
    {"VUID-VkSamplerCreateInfo-flags-02579", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then compareEnable must be VK_FALSE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-02579)"},
    {"VUID-VkSamplerCreateInfo-flags-02580", "If flags includes VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT, then unnormalizedCoordinates must be VK_FALSE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-02580)"},
    {"VUID-VkSamplerCreateInfo-flags-parameter", "flags must be a valid combination of VkSamplerCreateFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-flags-parameter)"},
    {"VUID-VkSamplerCreateInfo-magFilter-01081", "If either magFilter or minFilter is VK_FILTER_CUBIC_EXT, anisotropyEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-magFilter-01081)"},
    {"VUID-VkSamplerCreateInfo-magFilter-01422", "If either magFilter or minFilter is VK_FILTER_CUBIC_EXT, the reductionMode member of VkSamplerReductionModeCreateInfo must be VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkSamplerCreateInfo-magFilter-01422)"},
    {"VUID-VkSamplerCreateInfo-magFilter-parameter", "magFilter must be a valid VkFilter value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-magFilter-parameter)"},
    {"VUID-VkSamplerCreateInfo-maxLod-01973", "maxLod must be greater than or equal to minLod (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-maxLod-01973)"},
    {"VUID-VkSamplerCreateInfo-minFilter-01645", "If sampler {YCbCr} conversion is enabled and VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT is not set for the format, minFilter and magFilter must be equal to the sampler {YCbCr} conversion's chromaFilter (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-minFilter-01645)"},
    {"VUID-VkSamplerCreateInfo-minFilter-parameter", "minFilter must be a valid VkFilter value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-minFilter-parameter)"},
    {"VUID-VkSamplerCreateInfo-mipLodBias-01069", "The absolute value of mipLodBias must be less than or equal to VkPhysicalDeviceLimits::maxSamplerLodBias (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-mipLodBias-01069)"},
    {"VUID-VkSamplerCreateInfo-mipmapMode-parameter", "mipmapMode must be a valid VkSamplerMipmapMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-mipmapMode-parameter)"},
    {"VUID-VkSamplerCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkSamplerReductionModeCreateInfo or VkSamplerYcbcrConversionInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-pNext-pNext)"},
    {"VUID-VkSamplerCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-sType-sType)"},
    {"VUID-VkSamplerCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-sType-unique)"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01072", "If unnormalizedCoordinates is VK_TRUE, minFilter and magFilter must be equal (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01072)"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01073", "If unnormalizedCoordinates is VK_TRUE, mipmapMode must be VK_SAMPLER_MIPMAP_MODE_NEAREST (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01073)"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01074", "If unnormalizedCoordinates is VK_TRUE, minLod and maxLod must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01074)"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01075", "If unnormalizedCoordinates is VK_TRUE, addressModeU and addressModeV must each be either VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE or VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01075)"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01076", "If unnormalizedCoordinates is VK_TRUE, anisotropyEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01076)"},
    {"VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01077", "If unnormalizedCoordinates is VK_TRUE, compareEnable must be VK_FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerCreateInfo-unnormalizedCoordinates-01077)"},
    {"VUID-VkSamplerReductionModeCreateInfo-reductionMode-parameter", "reductionMode must be a valid VkSamplerReductionMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerReductionModeCreateInfo-reductionMode-parameter)"},
    {"VUID-VkSamplerReductionModeCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerReductionModeCreateInfo-sType-sType)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-01657", "If the format does not support VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT, chromaFilter must be VK_FILTER_NEAREST (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-01657)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-parameter", "chromaFilter must be a valid VkFilter value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-chromaFilter-parameter)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02581", "If the format has a _422 or _420 suffix, then components.g must be VK_COMPONENT_SWIZZLE_IDENTITY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-components-02581)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02582", "If the format has a _422 or _420 suffix, then components.a must be VK_COMPONENT_SWIZZLE_IDENTITY, VK_COMPONENT_SWIZZLE_ONE, or VK_COMPONENT_SWIZZLE_ZERO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-components-02582)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02583", "If the format has a _422 or _420 suffix, then components.r must be VK_COMPONENT_SWIZZLE_IDENTITY or VK_COMPONENT_SWIZZLE_B (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-components-02583)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02584", "If the format has a _422 or _420 suffix, then components.b must be VK_COMPONENT_SWIZZLE_IDENTITY or VK_COMPONENT_SWIZZLE_R (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-components-02584)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-02585", "If the format has a _422 or _420 suffix, and if either components.r or components.b is VK_COMPONENT_SWIZZLE_IDENTITY, both values must be VK_COMPONENT_SWIZZLE_IDENTITY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-components-02585)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-components-parameter", "components must be a valid VkComponentMapping structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-components-parameter)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-forceExplicitReconstruction-01656", "If the format does not support VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT, forceExplicitReconstruction must be FALSE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-forceExplicitReconstruction-01656)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-01649", "format must not be VK_FORMAT_UNDEFINED (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-format-01649)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-01650", "format must support VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT or VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-format-01650)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-01653", "format must represent unsigned normalized values (i.e. the format must be a UNORM format) (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-format-01653)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-01904", "If an external format conversion is being created, format must be VK_FORMAT_UNDEFINED, otherwise it must not be VK_FORMAT_UNDEFINED. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-format-01904)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-format-parameter)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkExternalFormatANDROID (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-pNext-pNext)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-sType-sType)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-01651", "If the format does not support VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT, xChromaOffset and yChromaOffset must not be VK_CHROMA_LOCATION_COSITED_EVEN (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-01651)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-01652", "If the format does not support VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT, xChromaOffset and yChromaOffset must not be VK_CHROMA_LOCATION_MIDPOINT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-01652)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-parameter", "xChromaOffset must be a valid VkChromaLocation value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-xChromaOffset-parameter)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-yChromaOffset-parameter", "yChromaOffset must be a valid VkChromaLocation value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-yChromaOffset-parameter)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-01655", "If ycbcrModel is not VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY, then components.r, components.g, and components.b must correspond to channels of the format; that is, components.r, components.g, and components.b must not be VK_COMPONENT_SWIZZLE_ZERO or VK_COMPONENT_SWIZZLE_ONE, and must not correspond to a channel which contains zero or one as a consequence of conversion to RGBA (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-01655)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-parameter", "ycbcrModel must be a valid VkSamplerYcbcrModelConversion value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrModel-parameter)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-02748", "If ycbcrRange is VK_SAMPLER_YCBCR_RANGE_ITU_NARROW then the R, G and B channels obtained by applying the component swizzle to format must each have a bit-depth greater than or equal to 8. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-02748)"},
    {"VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-parameter", "ycbcrRange must be a valid VkSamplerYcbcrRange value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionCreateInfo-ycbcrRange-parameter)"},
    {"VUID-VkSamplerYcbcrConversionImageFormatProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionImageFormatProperties-sType-sType)"},
    {"VUID-VkSamplerYcbcrConversionInfo-conversion-parameter", "conversion must be a valid VkSamplerYcbcrConversion handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionInfo-conversion-parameter)"},
    {"VUID-VkSamplerYcbcrConversionInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSamplerYcbcrConversionInfo-sType-sType)"},
    {"VUID-VkSemaphoreCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreCreateInfo-flags-zerobitmask)"},
    {"VUID-VkSemaphoreCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportSemaphoreCreateInfo, VkExportSemaphoreWin32HandleInfoKHR, or VkSemaphoreTypeCreateInfo (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreCreateInfo-pNext-pNext)"},
    {"VUID-VkSemaphoreCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreCreateInfo-sType-sType)"},
    {"VUID-VkSemaphoreCreateInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreCreateInfo-sType-unique)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01132", "handleType must have been included in VkExportSemaphoreCreateInfo::handleTypes when semaphore's current payload was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-handleType-01132)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01134", "If handleType refers to a handle type with copy payload transference semantics, as defined below in Importing Semaphore Payloads, there must be no queue waiting on semaphore. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-handleType-01134)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01135", "If handleType refers to a handle type with copy payload transference semantics, semaphore must be signaled, or have an associated semaphore signal operation pending execution. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-handleType-01135)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-01136", "handleType must be defined as a POSIX file descriptor handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-handleType-01136)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-03253", "If handleType refers to a handle type with copy payload transference semantics, semaphore must have been created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-handleType-03253)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-03254", "If handleType refers to a handle type with copy payload transference semantics, semaphore must have an associated semaphore signal operation that has been submitted for execution and any semaphore signal operations on which it depends (if any) must have also been submitted for execution. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-handleType-03254)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-handleType-parameter)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-pNext-pNext)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-sType-sType)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-semaphore-01133", "semaphore must not currently have its payload replaced by an imported payload as described below in Importing Semaphore Payloads unless that imported payload's handle type was included in VkExternalSemaphoreProperties::exportFromImportedHandleTypes for handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-semaphore-01133)"},
    {"VUID-VkSemaphoreGetFdInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetFdInfoKHR-semaphore-parameter)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01126", "handleType must have been included in VkExportSemaphoreCreateInfo::handleTypes when the semaphore's current payload was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01126)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01127", "If handleType is defined as an NT handle, vkGetSemaphoreWin32HandleKHR must be called no more than once for each valid unique combination of semaphore and handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01127)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01129", "If handleType refers to a handle type with copy payload transference semantics, as defined below in Importing Semaphore Payloads, there must be no queue waiting on semaphore. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01129)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01130", "If handleType refers to a handle type with copy payload transference semantics, semaphore must be signaled, or have an associated semaphore signal operation pending execution. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01130)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01131", "handleType must be defined as an NT handle or a global share handle. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-01131)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalSemaphoreHandleTypeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-handleType-parameter)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-pNext-pNext)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-sType-sType)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-semaphore-01128", "semaphore must not currently have its payload replaced by an imported payload as described below in Importing Semaphore Payloads unless that imported payload's handle type was included in VkExternalSemaphoreProperties::exportFromImportedHandleTypes for handleType. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-semaphore-01128)"},
    {"VUID-VkSemaphoreGetWin32HandleInfoKHR-semaphore-parameter", "semaphore must be a valid VkSemaphore handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreGetWin32HandleInfoKHR-semaphore-parameter)"},
    {"VUID-VkSemaphoreSignalInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreSignalInfo-pNext-pNext)"},
    {"VUID-VkSemaphoreSignalInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreSignalInfo-sType-sType)"},
    {"VUID-VkSemaphoreSignalInfo-semaphore-03257", "semaphore must have been created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreSignalInfo-semaphore-03257)"},
    {"VUID-VkSemaphoreSignalInfo-semaphore-parameter", "semaphore must be a valid VkSemaphore handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreSignalInfo-semaphore-parameter)"},
    {"VUID-VkSemaphoreSignalInfo-value-03258", "value must have a value greater than the current value of the semaphore (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreSignalInfo-value-03258)"},
    {"VUID-VkSemaphoreSignalInfo-value-03259", "value must be less than the value of any pending semaphore signal operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreSignalInfo-value-03259)"},
    {"VUID-VkSemaphoreSignalInfo-value-03260", "value must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on semaphore by more than maxTimelineSemaphoreValueDifference. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreSignalInfo-value-03260)"},
    {"VUID-VkSemaphoreTypeCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreTypeCreateInfo-sType-sType)"},
    {"VUID-VkSemaphoreTypeCreateInfo-semaphoreType-03279", "If semaphoreType is VK_SEMAPHORE_TYPE_BINARY, initialValue must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreTypeCreateInfo-semaphoreType-03279)"},
    {"VUID-VkSemaphoreTypeCreateInfo-semaphoreType-parameter", "semaphoreType must be a valid VkSemaphoreType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreTypeCreateInfo-semaphoreType-parameter)"},
    {"VUID-VkSemaphoreTypeCreateInfo-timelineSemaphore-03252", "If the timelineSemaphore feature is not enabled, semaphoreType must not equal VK_SEMAPHORE_TYPE_TIMELINE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreTypeCreateInfo-timelineSemaphore-03252)"},
    {"VUID-VkSemaphoreWaitInfo-flags-parameter", "flags must be a valid combination of VkSemaphoreWaitFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreWaitInfo-flags-parameter)"},
    {"VUID-VkSemaphoreWaitInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreWaitInfo-pNext-pNext)"},
    {"VUID-VkSemaphoreWaitInfo-pSemaphores-03256", "All of the elements of pSemaphores must reference a semaphore that was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreWaitInfo-pSemaphores-03256)"},
    {"VUID-VkSemaphoreWaitInfo-pSemaphores-parameter", "pSemaphores must be a valid pointer to an array of semaphoreCount valid VkSemaphore handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreWaitInfo-pSemaphores-parameter)"},
    {"VUID-VkSemaphoreWaitInfo-pValues-parameter", "pValues must be a valid pointer to an array of semaphoreCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreWaitInfo-pValues-parameter)"},
    {"VUID-VkSemaphoreWaitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreWaitInfo-sType-sType)"},
    {"VUID-VkSemaphoreWaitInfo-semaphoreCount-arraylength", "semaphoreCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSemaphoreWaitInfo-semaphoreCount-arraylength)"},
    {"VUID-VkShaderModuleCreateInfo-codeSize-01085", "codeSize must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-codeSize-01085)"},
    {"VUID-VkShaderModuleCreateInfo-codeSize-01086", "codeSize must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-codeSize-01086)"},
    {"VUID-VkShaderModuleCreateInfo-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-flags-zerobitmask)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01087", "pCode must point to valid SPIR-V code, formatted and packed as described by the Khronos SPIR-V Specification (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01087)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01088", "pCode must adhere to the validation rules described by the Validation Rules within a Module section of the SPIR-V Environment appendix (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01088)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01089", "pCode must declare the Shader capability for SPIR-V code (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01089)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01090", "pCode must not declare any capability that is not supported by the API, as described by the Capabilities section of the SPIR-V Environment appendix (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01090)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01091", "If pCode declares any of the capabilities listed as optional in the SPIR-V Environment appendix, the corresponding feature(s) must be enabled. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01091)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01376", "If pCode is a pointer to SPIR-V code, codeSize must be a multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01376)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01377", "pCode must point to either valid SPIR-V code, formatted and packed as described by the Khronos SPIR-V Specification or valid GLSL code which must be written to the GL_KHR_vulkan_glsl extension specification (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01377)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01378", "If pCode is a pointer to SPIR-V code, that code must adhere to the validation rules described by the Validation Rules within a Module section of the SPIR-V Environment appendix (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01378)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-01379", "If pCode is a pointer to GLSL code, it must be valid GLSL code written to the GL_KHR_vulkan_glsl GLSL extension specification (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-01379)"},
    {"VUID-VkShaderModuleCreateInfo-pCode-parameter", "pCode must be a valid pointer to an array of (codeSize/4) uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pCode-parameter)"},
    {"VUID-VkShaderModuleCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkShaderModuleValidationCacheCreateInfoEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-pNext-pNext)"},
    {"VUID-VkShaderModuleCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleCreateInfo-sType-sType)"},
    {"VUID-VkShaderModuleValidationCacheCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleValidationCacheCreateInfoEXT-sType-sType)"},
    {"VUID-VkShaderModuleValidationCacheCreateInfoEXT-validationCache-parameter", "validationCache must be a valid VkValidationCacheEXT handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShaderModuleValidationCacheCreateInfoEXT-validationCache-parameter)"},
    {"VUID-VkShadingRatePaletteNV-pShadingRatePaletteEntries-parameter", "pShadingRatePaletteEntries must be a valid pointer to an array of shadingRatePaletteEntryCount valid VkShadingRatePaletteEntryNV values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShadingRatePaletteNV-pShadingRatePaletteEntries-parameter)"},
    {"VUID-VkShadingRatePaletteNV-shadingRatePaletteEntryCount-02071", "shadingRatePaletteEntryCount must be between 1 and VkPhysicalDeviceShadingRateImagePropertiesNV::shadingRatePaletteSize, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShadingRatePaletteNV-shadingRatePaletteEntryCount-02071)"},
    {"VUID-VkShadingRatePaletteNV-shadingRatePaletteEntryCount-arraylength", "shadingRatePaletteEntryCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkShadingRatePaletteNV-shadingRatePaletteEntryCount-arraylength)"},
    {"VUID-VkSharedPresentSurfaceCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSharedPresentSurfaceCapabilitiesKHR-sType-sType)"},
    {"VUID-VkSparseBufferMemoryBindInfo-bindCount-arraylength", "bindCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseBufferMemoryBindInfo-bindCount-arraylength)"},
    {"VUID-VkSparseBufferMemoryBindInfo-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseBufferMemoryBindInfo-buffer-parameter)"},
    {"VUID-VkSparseBufferMemoryBindInfo-pBinds-parameter", "pBinds must be a valid pointer to an array of bindCount valid VkSparseMemoryBind structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseBufferMemoryBindInfo-pBinds-parameter)"},
    {"VUID-VkSparseImageFormatProperties2-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageFormatProperties2-pNext-pNext)"},
    {"VUID-VkSparseImageFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageFormatProperties2-sType-sType)"},
    {"VUID-VkSparseImageMemoryBind-extent-01108", "extent.width must either be a multiple of the sparse image block width of the image, or else (extent.width + offset.x) must equal the width of the image subresource (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-extent-01108)"},
    {"VUID-VkSparseImageMemoryBind-extent-01110", "extent.height must either be a multiple of the sparse image block height of the image, or else (extent.height + offset.y) must equal the height of the image subresource (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-extent-01110)"},
    {"VUID-VkSparseImageMemoryBind-extent-01112", "extent.depth must either be a multiple of the sparse image block depth of the image, or else (extent.depth + offset.z) must equal the depth of the image subresource (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-extent-01112)"},
    {"VUID-VkSparseImageMemoryBind-flags-parameter", "flags must be a valid combination of VkSparseMemoryBindFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-flags-parameter)"},
    {"VUID-VkSparseImageMemoryBind-memory-01104", "If the sparse aliased residency feature is not enabled, and if any other resources are bound to ranges of memory, the range of memory being bound must not overlap with those bound ranges (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-memory-01104)"},
    {"VUID-VkSparseImageMemoryBind-memory-01105", "memory and memoryOffset must match the memory requirements of the calling command's image, as described in section Resource Memory Association (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-memory-01105)"},
    {"VUID-VkSparseImageMemoryBind-memory-02732", "If memory was created with VkExportMemoryAllocateInfo::handleTypes not equal to 0, at least one handle type it contained must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when the image was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-memory-02732)"},
    {"VUID-VkSparseImageMemoryBind-memory-02733", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-memory-02733)"},
    {"VUID-VkSparseImageMemoryBind-memory-parameter", "If memory is not VK_NULL_HANDLE, memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-memory-parameter)"},
    {"VUID-VkSparseImageMemoryBind-offset-01107", "offset.x must be a multiple of the sparse image block width (VkSparseImageFormatProperties::imageGranularity.width) of the image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-offset-01107)"},
    {"VUID-VkSparseImageMemoryBind-offset-01109", "offset.y must be a multiple of the sparse image block height (VkSparseImageFormatProperties::imageGranularity.height) of the image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-offset-01109)"},
    {"VUID-VkSparseImageMemoryBind-offset-01111", "offset.z must be a multiple of the sparse image block depth (VkSparseImageFormatProperties::imageGranularity.depth) of the image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-offset-01111)"},
    {"VUID-VkSparseImageMemoryBind-subresource-01106", "subresource must be a valid image subresource for image (see Image Views) (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-subresource-01106)"},
    {"VUID-VkSparseImageMemoryBind-subresource-parameter", "subresource must be a valid VkImageSubresource structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBind-subresource-parameter)"},
    {"VUID-VkSparseImageMemoryBindInfo-bindCount-arraylength", "bindCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBindInfo-bindCount-arraylength)"},
    {"VUID-VkSparseImageMemoryBindInfo-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBindInfo-image-parameter)"},
    {"VUID-VkSparseImageMemoryBindInfo-pBinds-parameter", "pBinds must be a valid pointer to an array of bindCount valid VkSparseImageMemoryBind structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBindInfo-pBinds-parameter)"},
    {"VUID-VkSparseImageMemoryBindInfo-subresource-01722", "The subresource.mipLevel member of each element of pBinds must be less than the mipLevels specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBindInfo-subresource-01722)"},
    {"VUID-VkSparseImageMemoryBindInfo-subresource-01723", "The subresource.arrayLayer member of each element of pBinds must be less than the arrayLayers specified in VkImageCreateInfo when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryBindInfo-subresource-01723)"},
    {"VUID-VkSparseImageMemoryRequirements2-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryRequirements2-pNext-pNext)"},
    {"VUID-VkSparseImageMemoryRequirements2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageMemoryRequirements2-sType-sType)"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-bindCount-arraylength", "bindCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageOpaqueMemoryBindInfo-bindCount-arraylength)"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageOpaqueMemoryBindInfo-image-parameter)"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-01103", "If the flags member of any element of pBinds contains VK_SPARSE_MEMORY_BIND_METADATA_BIT, the binding range defined must be within the mip tail region of the metadata aspect of image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-01103)"},
    {"VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-parameter", "pBinds must be a valid pointer to an array of bindCount valid VkSparseMemoryBind structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseImageOpaqueMemoryBindInfo-pBinds-parameter)"},
    {"VUID-VkSparseMemoryBind-flags-parameter", "flags must be a valid combination of VkSparseMemoryBindFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-flags-parameter)"},
    {"VUID-VkSparseMemoryBind-memory-01096", "If memory is not VK_NULL_HANDLE, memory and memoryOffset must match the memory requirements of the resource, as described in section Resource Memory Association (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-memory-01096)"},
    {"VUID-VkSparseMemoryBind-memory-01097", "If memory is not VK_NULL_HANDLE, memory must not have been created with a memory type that reports VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-memory-01097)"},
    {"VUID-VkSparseMemoryBind-memory-02730", "If memory was created with VkExportMemoryAllocateInfo::handleTypes not equal to 0, at least one handle type it contained must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes or VkExternalMemoryImageCreateInfo::handleTypes when the resource was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-memory-02730)"},
    {"VUID-VkSparseMemoryBind-memory-02731", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes or VkExternalMemoryImageCreateInfo::handleTypes when the resource was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-memory-02731)"},
    {"VUID-VkSparseMemoryBind-memory-parameter", "If memory is not VK_NULL_HANDLE, memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-memory-parameter)"},
    {"VUID-VkSparseMemoryBind-memoryOffset-01101", "memoryOffset must be less than the size of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-memoryOffset-01101)"},
    {"VUID-VkSparseMemoryBind-resourceOffset-01099", "resourceOffset must be less than the size of the resource (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-resourceOffset-01099)"},
    {"VUID-VkSparseMemoryBind-size-01098", "size must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-size-01098)"},
    {"VUID-VkSparseMemoryBind-size-01100", "size must be less than or equal to the size of the resource minus resourceOffset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-size-01100)"},
    {"VUID-VkSparseMemoryBind-size-01102", "size must be less than or equal to the size of memory minus memoryOffset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSparseMemoryBind-size-01102)"},
    {"VUID-VkSpecializationInfo-offset-00773", "The offset member of each element of pMapEntries must be less than dataSize (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSpecializationInfo-offset-00773)"},
    {"VUID-VkSpecializationInfo-pData-parameter", "If dataSize is not 0, pData must be a valid pointer to an array of dataSize bytes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSpecializationInfo-pData-parameter)"},
    {"VUID-VkSpecializationInfo-pMapEntries-00774", "The size member of each element of pMapEntries must be less than or equal to dataSize minus offset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSpecializationInfo-pMapEntries-00774)"},
    {"VUID-VkSpecializationInfo-pMapEntries-parameter", "If mapEntryCount is not 0, pMapEntries must be a valid pointer to an array of mapEntryCount valid VkSpecializationMapEntry structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSpecializationInfo-pMapEntries-parameter)"},
    {"VUID-VkSpecializationMapEntry-constantID-00776", "For a constantID specialization constant declared in a shader, size must match the byte size of the constantID. If the specialization constant is of type boolean, size must be the byte size of VkBool32 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSpecializationMapEntry-constantID-00776)"},
    {"VUID-VkStencilOpState-compareOp-parameter", "compareOp must be a valid VkCompareOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStencilOpState-compareOp-parameter)"},
    {"VUID-VkStencilOpState-depthFailOp-parameter", "depthFailOp must be a valid VkStencilOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStencilOpState-depthFailOp-parameter)"},
    {"VUID-VkStencilOpState-failOp-parameter", "failOp must be a valid VkStencilOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStencilOpState-failOp-parameter)"},
    {"VUID-VkStencilOpState-passOp-parameter", "passOp must be a valid VkStencilOp value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStencilOpState-passOp-parameter)"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStreamDescriptorSurfaceCreateInfoGGP-flags-zerobitmask)"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStreamDescriptorSurfaceCreateInfoGGP-pNext-pNext)"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-sType-sType", "sType must be VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStreamDescriptorSurfaceCreateInfoGGP-sType-sType)"},
    {"VUID-VkStreamDescriptorSurfaceCreateInfoGGP-streamDescriptor-02681", "streamDescriptor must be a valid GgpStreamDescriptor (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkStreamDescriptorSurfaceCreateInfoGGP-streamDescriptor-02681)"},
    {"VUID-VkSubmitInfo-commonparent", "Each of the elements of pCommandBuffers, the elements of pSignalSemaphores, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-commonparent)"},
    {"VUID-VkSubmitInfo-pCommandBuffers-00075", "Each element of pCommandBuffers must not have been allocated with VK_COMMAND_BUFFER_LEVEL_SECONDARY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pCommandBuffers-00075)"},
    {"VUID-VkSubmitInfo-pCommandBuffers-parameter", "If commandBufferCount is not 0, pCommandBuffers must be a valid pointer to an array of commandBufferCount valid VkCommandBuffer handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pCommandBuffers-parameter)"},
    {"VUID-VkSubmitInfo-pNext-03240", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pWaitSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE, then its waitSemaphoreValueCount member must equal waitSemaphoreCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pNext-03240)"},
    {"VUID-VkSubmitInfo-pNext-03241", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE, then its signalSemaphoreValueCount member must equal signalSemaphoreCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pNext-03241)"},
    {"VUID-VkSubmitInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkD3D12FenceSubmitInfoKHR, VkDeviceGroupSubmitInfo, VkPerformanceQuerySubmitInfoKHR, VkProtectedSubmitInfo, VkTimelineSemaphoreSubmitInfo, VkWin32KeyedMutexAcquireReleaseInfoKHR, or VkWin32KeyedMutexAcquireReleaseInfoNV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pNext-pNext)"},
    {"VUID-VkSubmitInfo-pSignalSemaphores-03242", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value greater than the current value of the semaphore when the semaphore signal operation is executed (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pSignalSemaphores-03242)"},
    {"VUID-VkSubmitInfo-pSignalSemaphores-03244", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pSignalSemaphores-03244)"},
    {"VUID-VkSubmitInfo-pSignalSemaphores-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphores must be a valid pointer to an array of signalSemaphoreCount valid VkSemaphore handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pSignalSemaphores-parameter)"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-00076", "If the geometry shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitDstStageMask-00076)"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-00077", "If the tessellation shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitDstStageMask-00077)"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-00078", "Each element of pWaitDstStageMask must not include VK_PIPELINE_STAGE_HOST_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitDstStageMask-00078)"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-02089", "If the mesh shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitDstStageMask-02089)"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-02090", "If the task shaders feature is not enabled, each element of pWaitDstStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitDstStageMask-02090)"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-parameter", "If waitSemaphoreCount is not 0, pWaitDstStageMask must be a valid pointer to an array of waitSemaphoreCount valid combinations of VkPipelineStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitDstStageMask-parameter)"},
    {"VUID-VkSubmitInfo-pWaitDstStageMask-requiredbitmask", "Each element of pWaitDstStageMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitDstStageMask-requiredbitmask)"},
    {"VUID-VkSubmitInfo-pWaitSemaphores-03239", "If any element of pWaitSemaphores or pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE, then the pNext chain must include a VkTimelineSemaphoreSubmitInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitSemaphores-03239)"},
    {"VUID-VkSubmitInfo-pWaitSemaphores-03243", "For each element of pWaitSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pWaitSemaphoreValues must have a value which does not differ from the current value of the semaphore or the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitSemaphores-03243)"},
    {"VUID-VkSubmitInfo-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-pWaitSemaphores-parameter)"},
    {"VUID-VkSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBMIT_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-sType-sType)"},
    {"VUID-VkSubmitInfo-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubmitInfo-sType-unique)"},
    {"VUID-VkSubpassBeginInfo-contents-parameter", "contents must be a valid VkSubpassContents value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassBeginInfo-contents-parameter)"},
    {"VUID-VkSubpassBeginInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassBeginInfo-pNext-pNext)"},
    {"VUID-VkSubpassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassBeginInfo-sType-sType)"},
    {"VUID-VkSubpassDependency-dependencyFlags-02520", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, srcSubpass must not be equal to VK_SUBPASS_EXTERNAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dependencyFlags-02520)"},
    {"VUID-VkSubpassDependency-dependencyFlags-02521", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, dstSubpass must not be equal to VK_SUBPASS_EXTERNAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dependencyFlags-02521)"},
    {"VUID-VkSubpassDependency-dependencyFlags-parameter", "dependencyFlags must be a valid combination of VkDependencyFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dependencyFlags-parameter)"},
    {"VUID-VkSubpassDependency-dstAccessMask-00869", "Any access flag included in dstAccessMask must be supported by one of the pipeline stages in dstStageMask, as specified in the table of supported access types (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstAccessMask-00869)"},
    {"VUID-VkSubpassDependency-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstAccessMask-parameter)"},
    {"VUID-VkSubpassDependency-dstStageMask-00861", "If the geometry shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstStageMask-00861)"},
    {"VUID-VkSubpassDependency-dstStageMask-00863", "If the tessellation shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstStageMask-00863)"},
    {"VUID-VkSubpassDependency-dstStageMask-02101", "If the mesh shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstStageMask-02101)"},
    {"VUID-VkSubpassDependency-dstStageMask-02102", "If the task shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstStageMask-02102)"},
    {"VUID-VkSubpassDependency-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstStageMask-parameter)"},
    {"VUID-VkSubpassDependency-dstStageMask-requiredbitmask", "dstStageMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-dstStageMask-requiredbitmask)"},
    {"VUID-VkSubpassDependency-srcAccessMask-00868", "Any access flag included in srcAccessMask must be supported by one of the pipeline stages in srcStageMask, as specified in the table of supported access types (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcAccessMask-00868)"},
    {"VUID-VkSubpassDependency-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcAccessMask-parameter)"},
    {"VUID-VkSubpassDependency-srcStageMask-00860", "If the geometry shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcStageMask-00860)"},
    {"VUID-VkSubpassDependency-srcStageMask-00862", "If the tessellation shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcStageMask-00862)"},
    {"VUID-VkSubpassDependency-srcStageMask-02099", "If the mesh shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcStageMask-02099)"},
    {"VUID-VkSubpassDependency-srcStageMask-02100", "If the task shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcStageMask-02100)"},
    {"VUID-VkSubpassDependency-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcStageMask-parameter)"},
    {"VUID-VkSubpassDependency-srcStageMask-requiredbitmask", "srcStageMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcStageMask-requiredbitmask)"},
    {"VUID-VkSubpassDependency-srcSubpass-00864", "srcSubpass must be less than or equal to dstSubpass, unless one of them is VK_SUBPASS_EXTERNAL, to avoid cyclic dependencies and ensure a valid execution order (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcSubpass-00864)"},
    {"VUID-VkSubpassDependency-srcSubpass-00865", "srcSubpass and dstSubpass must not both be equal to VK_SUBPASS_EXTERNAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcSubpass-00865)"},
    {"VUID-VkSubpassDependency-srcSubpass-00867", "If srcSubpass is equal to dstSubpass and not all of the stages in srcStageMask and dstStageMask are framebuffer-space stages, the logically latest pipeline stage in srcStageMask must be logically earlier than or equal to the logically earliest pipeline stage in dstStageMask (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcSubpass-00867)"},
    {"VUID-VkSubpassDependency-srcSubpass-00872", "If srcSubpass equals dstSubpass and that subpass has more than one bit set in the view mask, then dependencyFlags must include VK_DEPENDENCY_VIEW_LOCAL_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcSubpass-00872)"},
    {"VUID-VkSubpassDependency-srcSubpass-02243", "If srcSubpass equals dstSubpass, and srcStageMask and dstStageMask both include a framebuffer-space stage, then dependencyFlags must include VK_DEPENDENCY_BY_REGION_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency-srcSubpass-02243)"},
    {"VUID-VkSubpassDependency2-dependencyFlags-03090", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, srcSubpass must not be equal to VK_SUBPASS_EXTERNAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dependencyFlags-03090)"},
    {"VUID-VkSubpassDependency2-dependencyFlags-03091", "If dependencyFlags includes VK_DEPENDENCY_VIEW_LOCAL_BIT, dstSubpass must not be equal to VK_SUBPASS_EXTERNAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dependencyFlags-03091)"},
    {"VUID-VkSubpassDependency2-dependencyFlags-03092", "If dependencyFlags does not include VK_DEPENDENCY_VIEW_LOCAL_BIT, viewOffset must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dependencyFlags-03092)"},
    {"VUID-VkSubpassDependency2-dependencyFlags-parameter", "dependencyFlags must be a valid combination of VkDependencyFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dependencyFlags-parameter)"},
    {"VUID-VkSubpassDependency2-dstAccessMask-03089", "Any access flag included in dstAccessMask must be supported by one of the pipeline stages in dstStageMask, as specified in the table of supported access types (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstAccessMask-03089)"},
    {"VUID-VkSubpassDependency2-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstAccessMask-parameter)"},
    {"VUID-VkSubpassDependency2-dstStageMask-02105", "If the mesh shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstStageMask-02105)"},
    {"VUID-VkSubpassDependency2-dstStageMask-02106", "If the task shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstStageMask-02106)"},
    {"VUID-VkSubpassDependency2-dstStageMask-03081", "If the geometry shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstStageMask-03081)"},
    {"VUID-VkSubpassDependency2-dstStageMask-03083", "If the tessellation shaders feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstStageMask-03083)"},
    {"VUID-VkSubpassDependency2-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstStageMask-parameter)"},
    {"VUID-VkSubpassDependency2-dstStageMask-requiredbitmask", "dstStageMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-dstStageMask-requiredbitmask)"},
    {"VUID-VkSubpassDependency2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-sType-sType)"},
    {"VUID-VkSubpassDependency2-srcAccessMask-03088", "Any access flag included in srcAccessMask must be supported by one of the pipeline stages in srcStageMask, as specified in the table of supported access types (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcAccessMask-03088)"},
    {"VUID-VkSubpassDependency2-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcAccessMask-parameter)"},
    {"VUID-VkSubpassDependency2-srcStageMask-02103", "If the mesh shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcStageMask-02103)"},
    {"VUID-VkSubpassDependency2-srcStageMask-02104", "If the task shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcStageMask-02104)"},
    {"VUID-VkSubpassDependency2-srcStageMask-03080", "If the geometry shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcStageMask-03080)"},
    {"VUID-VkSubpassDependency2-srcStageMask-03082", "If the tessellation shaders feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcStageMask-03082)"},
    {"VUID-VkSubpassDependency2-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcStageMask-parameter)"},
    {"VUID-VkSubpassDependency2-srcStageMask-requiredbitmask", "srcStageMask must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcStageMask-requiredbitmask)"},
    {"VUID-VkSubpassDependency2-srcSubpass-02245", "If srcSubpass equals dstSubpass, and srcStageMask and dstStageMask both include a framebuffer-space stage, then dependencyFlags must include VK_DEPENDENCY_BY_REGION_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcSubpass-02245)"},
    {"VUID-VkSubpassDependency2-srcSubpass-03084", "srcSubpass must be less than or equal to dstSubpass, unless one of them is VK_SUBPASS_EXTERNAL, to avoid cyclic dependencies and ensure a valid execution order (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcSubpass-03084)"},
    {"VUID-VkSubpassDependency2-srcSubpass-03085", "srcSubpass and dstSubpass must not both be equal to VK_SUBPASS_EXTERNAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcSubpass-03085)"},
    {"VUID-VkSubpassDependency2-srcSubpass-03087", "If srcSubpass is equal to dstSubpass and not all of the stages in srcStageMask and dstStageMask are framebuffer-space stages, the logically latest pipeline stage in srcStageMask must be logically earlier than or equal to the logically earliest pipeline stage in dstStageMask (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-srcSubpass-03087)"},
    {"VUID-VkSubpassDependency2-viewOffset-02530", "If viewOffset is not equal to 0, srcSubpass must not be equal to dstSubpass (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-viewOffset-02530)"},
    {"VUID-VkSubpassDependency2-viewOffset-03093", "If viewOffset is not 0, srcSubpass must not be equal to dstSubpass. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDependency2-viewOffset-03093)"},
    {"VUID-VkSubpassDescription-attachment-00853", "The attachment member of each element of pPreserveAttachments must not be VK_ATTACHMENT_UNUSED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-attachment-00853)"},
    {"VUID-VkSubpassDescription-colorAttachmentCount-00845", "colorAttachmentCount must be less than or equal to VkPhysicalDeviceLimits::maxColorAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-colorAttachmentCount-00845)"},
    {"VUID-VkSubpassDescription-flags-00856", "If flags includes VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX, it must also include VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-flags-00856)"},
    {"VUID-VkSubpassDescription-flags-parameter", "flags must be a valid combination of VkSubpassDescriptionFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-flags-parameter)"},
    {"VUID-VkSubpassDescription-layout-02519", "If any attachment is used by more than one VkAttachmentReference member, then each use must use the same layout (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-layout-02519)"},
    {"VUID-VkSubpassDescription-loadOp-00846", "If the first use of an attachment in this render pass is as an input attachment, and the attachment is not also used as a color or depth/stencil attachment in the same subpass, then loadOp must not be VK_ATTACHMENT_LOAD_OP_CLEAR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-loadOp-00846)"},
    {"VUID-VkSubpassDescription-pColorAttachments-01417", "All attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have the same sample count (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pColorAttachments-01417)"},
    {"VUID-VkSubpassDescription-pColorAttachments-01506", "If the VK_AMD_mixed_attachment_samples extension is enabled, and all attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have a sample count that is smaller than or equal to the sample count of pDepthStencilAttachment if it is not VK_ATTACHMENT_UNUSED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pColorAttachments-01506)"},
    {"VUID-VkSubpassDescription-pColorAttachments-02648", "All attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have formats whose features contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pColorAttachments-02648)"},
    {"VUID-VkSubpassDescription-pColorAttachments-parameter", "If colorAttachmentCount is not 0, pColorAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pColorAttachments-parameter)"},
    {"VUID-VkSubpassDescription-pDepthStencilAttachment-01418", "If neither the VK_AMD_mixed_attachment_samples nor the VK_NV_framebuffer_mixed_samples extensions are enabled, and if pDepthStencilAttachment is not VK_ATTACHMENT_UNUSED and any attachments in pColorAttachments are not VK_ATTACHMENT_UNUSED, they must have the same sample count (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pDepthStencilAttachment-01418)"},
    {"VUID-VkSubpassDescription-pDepthStencilAttachment-02650", "If pDepthStencilAttachment is not NULL and the attachment is not VK_ATTACHMENT_UNUSED then it must have a format whose features contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pDepthStencilAttachment-02650)"},
    {"VUID-VkSubpassDescription-pDepthStencilAttachment-parameter", "If pDepthStencilAttachment is not NULL, pDepthStencilAttachment must be a valid pointer to a valid VkAttachmentReference structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pDepthStencilAttachment-parameter)"},
    {"VUID-VkSubpassDescription-pInputAttachments-02647", "All attachments in pInputAttachments that are not VK_ATTACHMENT_UNUSED must have formats whose features contain at least one of VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pInputAttachments-02647)"},
    {"VUID-VkSubpassDescription-pInputAttachments-parameter", "If inputAttachmentCount is not 0, pInputAttachments must be a valid pointer to an array of inputAttachmentCount valid VkAttachmentReference structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pInputAttachments-parameter)"},
    {"VUID-VkSubpassDescription-pPreserveAttachments-00854", "Each element of pPreserveAttachments must not also be an element of any other member of the subpass description (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pPreserveAttachments-00854)"},
    {"VUID-VkSubpassDescription-pPreserveAttachments-parameter", "If preserveAttachmentCount is not 0, pPreserveAttachments must be a valid pointer to an array of preserveAttachmentCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pPreserveAttachments-parameter)"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00847", "If pResolveAttachments is not NULL, for each resolve attachment that is not VK_ATTACHMENT_UNUSED, the corresponding color attachment must not be VK_ATTACHMENT_UNUSED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pResolveAttachments-00847)"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00848", "If pResolveAttachments is not NULL, for each resolve attachment that is not VK_ATTACHMENT_UNUSED, the corresponding color attachment must not have a sample count of VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pResolveAttachments-00848)"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00849", "If pResolveAttachments is not NULL, each resolve attachment that is not VK_ATTACHMENT_UNUSED must have a sample count of VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pResolveAttachments-00849)"},
    {"VUID-VkSubpassDescription-pResolveAttachments-00850", "If pResolveAttachments is not NULL, each resolve attachment that is not VK_ATTACHMENT_UNUSED must have the same VkFormat as its corresponding color attachment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pResolveAttachments-00850)"},
    {"VUID-VkSubpassDescription-pResolveAttachments-02649", "All attachments in pResolveAttachments that are not VK_ATTACHMENT_UNUSED must have formats whose features contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pResolveAttachments-02649)"},
    {"VUID-VkSubpassDescription-pResolveAttachments-parameter", "If colorAttachmentCount is not 0, and pResolveAttachments is not NULL, pResolveAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pResolveAttachments-parameter)"},
    {"VUID-VkSubpassDescription-pipelineBindPoint-00844", "pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pipelineBindPoint-00844)"},
    {"VUID-VkSubpassDescription-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription-pipelineBindPoint-parameter)"},
    {"VUID-VkSubpassDescription2-attachment-02799", "If the attachment member of any element of pInputAttachments is not VK_ATTACHMENT_UNUSED, then the aspectMask member must be a valid combination of VkImageAspectFlagBits (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-attachment-02799)"},
    {"VUID-VkSubpassDescription2-attachment-02800", "If the attachment member of any element of pInputAttachments is not VK_ATTACHMENT_UNUSED, then the aspectMask member must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-attachment-02800)"},
    {"VUID-VkSubpassDescription2-attachment-02801", "If the attachment member of any element of pInputAttachments is not VK_ATTACHMENT_UNUSED, then the aspectMask member must not include VK_IMAGE_ASPECT_METADATA_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-attachment-02801)"},
    {"VUID-VkSubpassDescription2-attachment-03073", "The attachment member of any element of pPreserveAttachments must not be VK_ATTACHMENT_UNUSED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-attachment-03073)"},
    {"VUID-VkSubpassDescription2-colorAttachmentCount-03063", "colorAttachmentCount must be less than or equal to VkPhysicalDeviceLimits::maxColorAttachments (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-colorAttachmentCount-03063)"},
    {"VUID-VkSubpassDescription2-flags-03076", "If flags includes VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX, it must also include VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-flags-03076)"},
    {"VUID-VkSubpassDescription2-flags-parameter", "flags must be a valid combination of VkSubpassDescriptionFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-flags-parameter)"},
    {"VUID-VkSubpassDescription2-layout-02528", "If any attachment is used by more than one VkAttachmentReference member, then each use must use the same layout (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-layout-02528)"},
    {"VUID-VkSubpassDescription2-loadOp-03064", "If the first use of an attachment in this render pass is as an input attachment, and the attachment is not also used as a color or depth/stencil attachment in the same subpass, then loadOp must not be VK_ATTACHMENT_LOAD_OP_CLEAR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-loadOp-03064)"},
    {"VUID-VkSubpassDescription2-pColorAttachments-03069", "All attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have the same sample count (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pColorAttachments-03069)"},
    {"VUID-VkSubpassDescription2-pColorAttachments-03070", "If the VK_AMD_mixed_attachment_samples extension is enabled, all attachments in pColorAttachments that are not VK_ATTACHMENT_UNUSED must have a sample count that is smaller than or equal to the sample count of pDepthStencilAttachment if it is not VK_ATTACHMENT_UNUSED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pColorAttachments-03070)"},
    {"VUID-VkSubpassDescription2-pColorAttachments-parameter", "If colorAttachmentCount is not 0, pColorAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference2 structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pColorAttachments-parameter)"},
    {"VUID-VkSubpassDescription2-pDepthStencilAttachment-03071", "If neither the VK_AMD_mixed_attachment_samples nor the VK_NV_framebuffer_mixed_samples extensions are enabled, and if pDepthStencilAttachment is not VK_ATTACHMENT_UNUSED and any attachments in pColorAttachments are not VK_ATTACHMENT_UNUSED, they must have the same sample count (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pDepthStencilAttachment-03071)"},
    {"VUID-VkSubpassDescription2-pDepthStencilAttachment-parameter", "If pDepthStencilAttachment is not NULL, pDepthStencilAttachment must be a valid pointer to a valid VkAttachmentReference2 structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pDepthStencilAttachment-parameter)"},
    {"VUID-VkSubpassDescription2-pInputAttachments-parameter", "If inputAttachmentCount is not 0, pInputAttachments must be a valid pointer to an array of inputAttachmentCount valid VkAttachmentReference2 structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pInputAttachments-parameter)"},
    {"VUID-VkSubpassDescription2-pPreserveAttachments-03074", "Any given element of pPreserveAttachments must not also be an element of any other member of the subpass description (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pPreserveAttachments-03074)"},
    {"VUID-VkSubpassDescription2-pPreserveAttachments-parameter", "If preserveAttachmentCount is not 0, pPreserveAttachments must be a valid pointer to an array of preserveAttachmentCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pPreserveAttachments-parameter)"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03065", "If pResolveAttachments is not NULL, for each resolve attachment that does not have the value VK_ATTACHMENT_UNUSED, the corresponding color attachment must not have the value VK_ATTACHMENT_UNUSED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pResolveAttachments-03065)"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03066", "If pResolveAttachments is not NULL, for each resolve attachment that is not VK_ATTACHMENT_UNUSED, the corresponding color attachment must not have a sample count of VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pResolveAttachments-03066)"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03067", "If pResolveAttachments is not NULL, each resolve attachment that is not VK_ATTACHMENT_UNUSED must have a sample count of VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pResolveAttachments-03067)"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-03068", "Any given element of pResolveAttachments must have the same VkFormat as its corresponding color attachment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pResolveAttachments-03068)"},
    {"VUID-VkSubpassDescription2-pResolveAttachments-parameter", "If colorAttachmentCount is not 0, and pResolveAttachments is not NULL, pResolveAttachments must be a valid pointer to an array of colorAttachmentCount valid VkAttachmentReference2 structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pResolveAttachments-parameter)"},
    {"VUID-VkSubpassDescription2-pipelineBindPoint-03062", "pipelineBindPoint must be VK_PIPELINE_BIND_POINT_GRAPHICS (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pipelineBindPoint-03062)"},
    {"VUID-VkSubpassDescription2-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-pipelineBindPoint-parameter)"},
    {"VUID-VkSubpassDescription2-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescription2-sType-sType)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-depthResolveMode-03183", "The value of depthResolveMode must be one of the bits set in VkPhysicalDeviceDepthStencilResolveProperties::supportedDepthResolveModes or VK_RESOLVE_MODE_NONE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-depthResolveMode-03183)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-depthResolveMode-parameter", "depthResolveMode must be a valid VkResolveModeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-depthResolveMode-parameter)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-02651", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED then it must have a format whose features contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-02651)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03177", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, pDepthStencilAttachment must not have the value VK_ATTACHMENT_UNUSED (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03177)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03178", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, depthResolveMode and stencilResolveMode must not both be VK_RESOLVE_MODE_NONE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03178)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03179", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, pDepthStencilAttachment must not have a sample count of VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03179)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03180", "If pDepthStencilResolveAttachment is not NULL and does not have the value VK_ATTACHMENT_UNUSED, pDepthStencilResolveAttachment must have a sample count of VK_SAMPLE_COUNT_1_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03180)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03181", "If the VkFormat of pDepthStencilResolveAttachment has a depth component, then the VkFormat of pDepthStencilAttachment must have a depth component with the same number of bits and numerical type (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03181)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03182", "If the VkFormat of pDepthStencilResolveAttachment has a stencil component, then the VkFormat of pDepthStencilAttachment must have a stencil component with the same number of bits and numerical type (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03182)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03185", "If the VkFormat of pDepthStencilResolveAttachment has both depth and stencil components, VkPhysicalDeviceDepthStencilResolveProperties::independentResolve is VK_FALSE, and VkPhysicalDeviceDepthStencilResolveProperties::independentResolveNone is VK_FALSE, then the values of depthResolveMode and stencilResolveMode must be identical (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03185)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03186", "If the VkFormat of pDepthStencilResolveAttachment has both depth and stencil components, VkPhysicalDeviceDepthStencilResolveProperties::independentResolve is VK_FALSE and VkPhysicalDeviceDepthStencilResolveProperties::independentResolveNone is VK_TRUE, then the values of depthResolveMode and stencilResolveMode must be identical or one of them must be VK_RESOLVE_MODE_NONE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-03186)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-parameter", "If pDepthStencilResolveAttachment is not NULL, pDepthStencilResolveAttachment must be a valid pointer to a valid VkAttachmentReference2 structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-pDepthStencilResolveAttachment-parameter)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-sType-sType)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-stencilResolveMode-03184", "The value of stencilResolveMode must be one of the bits set in VkPhysicalDeviceDepthStencilResolveProperties::supportedStencilResolveModes or VK_RESOLVE_MODE_NONE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-stencilResolveMode-03184)"},
    {"VUID-VkSubpassDescriptionDepthStencilResolve-stencilResolveMode-parameter", "stencilResolveMode must be a valid VkResolveModeFlagBits value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassDescriptionDepthStencilResolve-stencilResolveMode-parameter)"},
    {"VUID-VkSubpassEndInfo-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassEndInfo-pNext-pNext)"},
    {"VUID-VkSubpassEndInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_SUBPASS_END_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassEndInfo-sType-sType)"},
    {"VUID-VkSubpassSampleLocationsEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassSampleLocationsEXT-sampleLocationsInfo-parameter)"},
    {"VUID-VkSubpassSampleLocationsEXT-subpassIndex-01532", "subpassIndex must be less than the subpassCount specified in VkRenderPassCreateInfo the render pass specified by VkRenderPassBeginInfo::renderPass was created with (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSubpassSampleLocationsEXT-subpassIndex-01532)"},
    {"VUID-VkSurfaceCapabilities2EXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceCapabilities2EXT-pNext-pNext)"},
    {"VUID-VkSurfaceCapabilities2EXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceCapabilities2EXT-sType-sType)"},
    {"VUID-VkSurfaceCapabilities2EXT-supportedSurfaceCounters-01246", "supportedSurfaceCounters must not include VK_SURFACE_COUNTER_VBLANK_EXT unless the surface queried is a display surface. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceCapabilities2EXT-supportedSurfaceCounters-01246)"},
    {"VUID-VkSurfaceCapabilities2KHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDisplayNativeHdrSurfaceCapabilitiesAMD, VkSharedPresentSurfaceCapabilitiesKHR, VkSurfaceCapabilitiesFullScreenExclusiveEXT, or VkSurfaceProtectedCapabilitiesKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceCapabilities2KHR-pNext-pNext)"},
    {"VUID-VkSurfaceCapabilities2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceCapabilities2KHR-sType-sType)"},
    {"VUID-VkSurfaceCapabilities2KHR-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceCapabilities2KHR-sType-unique)"},
    {"VUID-VkSurfaceCapabilitiesFullScreenExclusiveEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceCapabilitiesFullScreenExclusiveEXT-sType-sType)"},
    {"VUID-VkSurfaceFormat2KHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceFormat2KHR-pNext-pNext)"},
    {"VUID-VkSurfaceFormat2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceFormat2KHR-sType-sType)"},
    {"VUID-VkSurfaceFullScreenExclusiveInfoEXT-fullScreenExclusive-parameter", "fullScreenExclusive must be a valid VkFullScreenExclusiveEXT value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceFullScreenExclusiveInfoEXT-fullScreenExclusive-parameter)"},
    {"VUID-VkSurfaceFullScreenExclusiveInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceFullScreenExclusiveInfoEXT-sType-sType)"},
    {"VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-hmonitor-02673", "hmonitor must be a valid HMONITOR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-hmonitor-02673)"},
    {"VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceFullScreenExclusiveWin32InfoEXT-sType-sType)"},
    {"VUID-VkSurfaceProtectedCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSurfaceProtectedCapabilitiesKHR-sType-sType)"},
    {"VUID-VkSwapchainCounterCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCounterCreateInfoEXT-sType-sType)"},
    {"VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-01244", "The bits in surfaceCounters must be supported by VkSwapchainCreateInfoKHR::surface, as reported by vkGetPhysicalDeviceSurfaceCapabilities2EXT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-01244)"},
    {"VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-parameter", "surfaceCounters must be a valid combination of VkSurfaceCounterFlagBitsEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCounterCreateInfoEXT-surfaceCounters-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-commonparent", "Both of oldSwapchain, and surface that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkInstance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-commonparent)"},
    {"VUID-VkSwapchainCreateInfoKHR-compositeAlpha-01280", "compositeAlpha must be one of the bits present in the supportedCompositeAlpha member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-compositeAlpha-01280)"},
    {"VUID-VkSwapchainCreateInfoKHR-compositeAlpha-parameter", "compositeAlpha must be a valid VkCompositeAlphaFlagBitsKHR value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-compositeAlpha-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-flags-03168", "If flags contains VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR then the pNext chain must include a VkImageFormatListCreateInfo structure with a viewFormatCount greater than zero and pViewFormats must have an element equal to imageFormat (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-flags-03168)"},
    {"VUID-VkSwapchainCreateInfoKHR-flags-03187", "If flags contains VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR, then VkSurfaceProtectedCapabilitiesKHR::supportsProtected must be VK_TRUE in the VkSurfaceProtectedCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilities2KHR for surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-flags-03187)"},
    {"VUID-VkSwapchainCreateInfoKHR-flags-parameter", "flags must be a valid combination of VkSwapchainCreateFlagBitsKHR values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-flags-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageArrayLayers-01275", "imageArrayLayers must be greater than 0 and less than or equal to the maxImageArrayLayers member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageArrayLayers-01275)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageColorSpace-parameter", "imageColorSpace must be a valid VkColorSpaceKHR value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageColorSpace-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageExtent-01274", "imageExtent must be between minImageExtent and maxImageExtent, inclusive, where minImageExtent and maxImageExtent are members of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageExtent-01274)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageExtent-01689", "imageExtent members width and height must both be non-zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageExtent-01689)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageFormat-01273", "imageFormat and imageColorSpace must match the format and colorSpace members, respectively, of one of the VkSurfaceFormatKHR structures returned by vkGetPhysicalDeviceSurfaceFormatsKHR for the surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageFormat-01273)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageFormat-01778", "The implied image creation parameters of the swapchain must be supported as reported by vkGetPhysicalDeviceImageFormatProperties (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageFormat-01778)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageFormat-parameter", "imageFormat must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageFormat-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01277", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01277)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01278", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01278)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01393", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01393)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01428", "If imageSharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties or vkGetPhysicalDeviceQueueFamilyProperties2 for the physicalDevice that was used to create device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageSharingMode-01428)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageSharingMode-parameter", "imageSharingMode must be a valid VkSharingMode value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageSharingMode-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-01276", "imageUsage must be a subset of the supported usage flags present in the supportedUsageFlags member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkSwapchainCreateInfoKHR-imageUsage-01276)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-01384", "If presentMode is VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR, imageUsage must be a subset of the supported usage flags present in the sharedPresentSupportedUsageFlags member of the VkSharedPresentSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilities2KHR for surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageUsage-01384)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-parameter", "imageUsage must be a valid combination of VkImageUsageFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageUsage-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-imageUsage-requiredbitmask", "imageUsage must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-imageUsage-requiredbitmask)"},
    {"VUID-VkSwapchainCreateInfoKHR-minImageCount-01271", "minImageCount must be greater than or equal to the value returned in the minImageCount member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-VkSwapchainCreateInfoKHR-minImageCount-01271)"},
    {"VUID-VkSwapchainCreateInfoKHR-minImageCount-01272", "minImageCount must be less than or equal to the value returned in the maxImageCount member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface if the returned maxImageCount is not zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-minImageCount-01272)"},
    {"VUID-VkSwapchainCreateInfoKHR-minImageCount-01383", "minImageCount must be 1 if presentMode is either VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR or VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-minImageCount-01383)"},
    {"VUID-VkSwapchainCreateInfoKHR-oldSwapchain-01933", "If oldSwapchain is not VK_NULL_HANDLE, oldSwapchain must be a non-retired swapchain associated with native window referred to by surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-oldSwapchain-01933)"},
    {"VUID-VkSwapchainCreateInfoKHR-oldSwapchain-parameter", "If oldSwapchain is not VK_NULL_HANDLE, oldSwapchain must be a valid VkSwapchainKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-oldSwapchain-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-oldSwapchain-parent", "If oldSwapchain is a valid handle, it must have been created, allocated, or retrieved from surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-oldSwapchain-parent)"},
    {"VUID-VkSwapchainCreateInfoKHR-pNext-02679", "If the pNext chain includes a VkSurfaceFullScreenExclusiveInfoEXT structure with its fullScreenExclusive member set to VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT, and surface was created using vkCreateWin32SurfaceKHR, a VkSurfaceFullScreenExclusiveWin32InfoEXT structure must be included in the pNext chain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-pNext-02679)"},
    {"VUID-VkSwapchainCreateInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupSwapchainCreateInfoKHR, VkImageFormatListCreateInfo, VkSurfaceFullScreenExclusiveInfoEXT, VkSurfaceFullScreenExclusiveWin32InfoEXT, VkSwapchainCounterCreateInfoEXT, or VkSwapchainDisplayNativeHdrCreateInfoAMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkSwapchainCreateInfoKHR-physicalDeviceCount-01429", "If the logical device was created with VkDeviceGroupDeviceCreateInfo::physicalDeviceCount equal to 1, flags must not contain VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-physicalDeviceCount-01429)"},
    {"VUID-VkSwapchainCreateInfoKHR-preTransform-01279", "preTransform must be one of the bits present in the supportedTransforms member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-preTransform-01279)"},
    {"VUID-VkSwapchainCreateInfoKHR-preTransform-parameter", "preTransform must be a valid VkSurfaceTransformFlagBitsKHR value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-preTransform-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-01281", "presentMode must be one of the VkPresentModeKHR values returned by vkGetPhysicalDeviceSurfacePresentModesKHR for the surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-presentMode-01281)"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-01427", "If presentMode is VK_PRESENT_MODE_IMMEDIATE_KHR, VK_PRESENT_MODE_MAILBOX_KHR, VK_PRESENT_MODE_FIFO_KHR or VK_PRESENT_MODE_FIFO_RELAXED_KHR, imageUsage must be a subset of the supported usage flags present in the supportedUsageFlags member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-presentMode-01427)"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-02839", "If presentMode is not VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR nor VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR, then minImageCount must be greater than or equal to the value returned in the minImageCount member of the VkSurfaceCapabilitiesKHR structure returned by vkGetPhysicalDeviceSurfaceCapabilitiesKHR for the surface (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-presentMode-02839)"},
    {"VUID-VkSwapchainCreateInfoKHR-presentMode-parameter", "presentMode must be a valid VkPresentModeKHR value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-presentMode-parameter)"},
    {"VUID-VkSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-sType-sType)"},
    {"VUID-VkSwapchainCreateInfoKHR-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-sType-unique)"},
    {"VUID-VkSwapchainCreateInfoKHR-surface-01270", "surface must be a surface that is supported by the device as determined using vkGetPhysicalDeviceSurfaceSupportKHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-surface-01270)"},
    {"VUID-VkSwapchainCreateInfoKHR-surface-parameter", "surface must be a valid VkSurfaceKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainCreateInfoKHR-surface-parameter)"},
    {"VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-localDimmingEnable-XXXXX", "It is only valid to set localDimmingEnable to VK_TRUE if VkDisplayNativeHdrSurfaceCapabilitiesAMD::localDimmingSupport is supported. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-localDimmingEnable-XXXXX)"},
    {"VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkSwapchainDisplayNativeHdrCreateInfoAMD-sType-sType)"},
    {"VUID-VkTextureLODGatherFormatPropertiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkTextureLODGatherFormatPropertiesAMD-sType-sType)"},
    {"VUID-VkTimelineSemaphoreSubmitInfo-pSignalSemaphoreValues-parameter", "If signalSemaphoreValueCount is not 0, and pSignalSemaphoreValues is not NULL, pSignalSemaphoreValues must be a valid pointer to an array of signalSemaphoreValueCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkTimelineSemaphoreSubmitInfo-pSignalSemaphoreValues-parameter)"},
    {"VUID-VkTimelineSemaphoreSubmitInfo-pWaitSemaphoreValues-parameter", "If waitSemaphoreValueCount is not 0, and pWaitSemaphoreValues is not NULL, pWaitSemaphoreValues must be a valid pointer to an array of waitSemaphoreValueCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkTimelineSemaphoreSubmitInfo-pWaitSemaphoreValues-parameter)"},
    {"VUID-VkTimelineSemaphoreSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkTimelineSemaphoreSubmitInfo-sType-sType)"},
    {"VUID-VkValidationCacheCreateInfoEXT-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationCacheCreateInfoEXT-flags-zerobitmask)"},
    {"VUID-VkValidationCacheCreateInfoEXT-initialDataSize-01534", "If initialDataSize is not 0, it must be equal to the size of pInitialData, as returned by vkGetValidationCacheDataEXT when pInitialData was originally retrieved (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationCacheCreateInfoEXT-initialDataSize-01534)"},
    {"VUID-VkValidationCacheCreateInfoEXT-initialDataSize-01535", "If initialDataSize is not 0, pInitialData must have been retrieved from a previous call to vkGetValidationCacheDataEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationCacheCreateInfoEXT-initialDataSize-01535)"},
    {"VUID-VkValidationCacheCreateInfoEXT-pInitialData-parameter", "If initialDataSize is not 0, pInitialData must be a valid pointer to an array of initialDataSize bytes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationCacheCreateInfoEXT-pInitialData-parameter)"},
    {"VUID-VkValidationCacheCreateInfoEXT-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationCacheCreateInfoEXT-pNext-pNext)"},
    {"VUID-VkValidationCacheCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationCacheCreateInfoEXT-sType-sType)"},
    {"VUID-VkValidationFeaturesEXT-pDisabledValidationFeatures-parameter", "If disabledValidationFeatureCount is not 0, pDisabledValidationFeatures must be a valid pointer to an array of disabledValidationFeatureCount valid VkValidationFeatureDisableEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationFeaturesEXT-pDisabledValidationFeatures-parameter)"},
    {"VUID-VkValidationFeaturesEXT-pEnabledValidationFeatures-parameter", "If enabledValidationFeatureCount is not 0, pEnabledValidationFeatures must be a valid pointer to an array of enabledValidationFeatureCount valid VkValidationFeatureEnableEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationFeaturesEXT-pEnabledValidationFeatures-parameter)"},
    {"VUID-VkValidationFeaturesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationFeaturesEXT-sType-sType)"},
    {"VUID-VkValidationFlagsEXT-disabledValidationCheckCount-arraylength", "disabledValidationCheckCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationFlagsEXT-disabledValidationCheckCount-arraylength)"},
    {"VUID-VkValidationFlagsEXT-pDisabledValidationChecks-parameter", "pDisabledValidationChecks must be a valid pointer to an array of disabledValidationCheckCount valid VkValidationCheckEXT values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationFlagsEXT-pDisabledValidationChecks-parameter)"},
    {"VUID-VkValidationFlagsEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkValidationFlagsEXT-sType-sType)"},
    {"VUID-VkVertexInputAttributeDescription-binding-00621", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputAttributeDescription-binding-00621)"},
    {"VUID-VkVertexInputAttributeDescription-format-00623", "format must be allowed as a vertex buffer format, as specified by the VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT flag in VkFormatProperties::bufferFeatures returned by vkGetPhysicalDeviceFormatProperties (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputAttributeDescription-format-00623)"},
    {"VUID-VkVertexInputAttributeDescription-format-parameter", "format must be a valid VkFormat value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputAttributeDescription-format-parameter)"},
    {"VUID-VkVertexInputAttributeDescription-location-00620", "location must be less than VkPhysicalDeviceLimits::maxVertexInputAttributes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputAttributeDescription-location-00620)"},
    {"VUID-VkVertexInputAttributeDescription-offset-00622", "offset must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputAttributeOffset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputAttributeDescription-offset-00622)"},
    {"VUID-VkVertexInputBindingDescription-binding-00618", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDescription-binding-00618)"},
    {"VUID-VkVertexInputBindingDescription-inputRate-parameter", "inputRate must be a valid VkVertexInputRate value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDescription-inputRate-parameter)"},
    {"VUID-VkVertexInputBindingDescription-stride-00619", "stride must be less than or equal to VkPhysicalDeviceLimits::maxVertexInputBindingStride (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDescription-stride-00619)"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-binding-01869", "binding must be less than VkPhysicalDeviceLimits::maxVertexInputBindings (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDivisorDescriptionEXT-binding-01869)"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-divisor-01870", "divisor must be a value between 0 and VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT::maxVertexAttribDivisor, inclusive. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDivisorDescriptionEXT-divisor-01870)"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-inputRate-01871", "VkVertexInputBindingDescription::inputRate must be of type VK_VERTEX_INPUT_RATE_INSTANCE for this binding. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDivisorDescriptionEXT-inputRate-01871)"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-vertexAttributeInstanceRateDivisor-02229", "If the vertexAttributeInstanceRateDivisor feature is not enabled, divisor must be 1 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDivisorDescriptionEXT-vertexAttributeInstanceRateDivisor-02229)"},
    {"VUID-VkVertexInputBindingDivisorDescriptionEXT-vertexAttributeInstanceRateZeroDivisor-02228", "If the vertexAttributeInstanceRateZeroDivisor feature is not enabled, divisor must not be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkVertexInputBindingDivisorDescriptionEXT-vertexAttributeInstanceRateZeroDivisor-02228)"},
    {"VUID-VkViSurfaceCreateInfoNN-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViSurfaceCreateInfoNN-flags-zerobitmask)"},
    {"VUID-VkViSurfaceCreateInfoNN-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViSurfaceCreateInfoNN-pNext-pNext)"},
    {"VUID-VkViSurfaceCreateInfoNN-sType-sType", "sType must be VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViSurfaceCreateInfoNN-sType-sType)"},
    {"VUID-VkViSurfaceCreateInfoNN-window-01318", "window must be a valid nn::vi::NativeWindowHandle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViSurfaceCreateInfoNN-window-01318)"},
    {"VUID-VkViewport-height-01772", "height must be greater than 0.0 (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-VkViewport-height-01772)"},
    {"VUID-VkViewport-height-01773", "The absolute value of height must be less than or equal to VkPhysicalDeviceLimits::maxViewportDimensions[1] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-height-01773)"},
    {"VUID-VkViewport-maxDepth-01235", "Unless VK_EXT_depth_range_unrestricted extension is enabled maxDepth must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-maxDepth-01235)"},
    {"VUID-VkViewport-maxDepth-02541", "maxDepth must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkViewport-maxDepth-02541)"},
    {"VUID-VkViewport-minDepth-01234", "Unless VK_EXT_depth_range_unrestricted extension is enabled minDepth must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-minDepth-01234)"},
    {"VUID-VkViewport-minDepth-02540", "minDepth must be between 0.0 and 1.0, inclusive (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-VkViewport-minDepth-02540)"},
    {"VUID-VkViewport-width-01770", "width must be greater than 0.0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-width-01770)"},
    {"VUID-VkViewport-width-01771", "width must be less than or equal to VkPhysicalDeviceLimits::maxViewportDimensions[0] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-width-01771)"},
    {"VUID-VkViewport-x-01232", "(x + width) must be less than or equal to viewportBoundsRange[1] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-x-01232)"},
    {"VUID-VkViewport-x-01774", "x must be greater than or equal to viewportBoundsRange[0] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-x-01774)"},
    {"VUID-VkViewport-y-01233", "(y + height) must be less than or equal to viewportBoundsRange[1] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-y-01233)"},
    {"VUID-VkViewport-y-01775", "y must be greater than or equal to viewportBoundsRange[0] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-y-01775)"},
    {"VUID-VkViewport-y-01776", "y must be less than or equal to viewportBoundsRange[1] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-y-01776)"},
    {"VUID-VkViewport-y-01777", "(y + height) must be greater than or equal to viewportBoundsRange[0] (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewport-y-01777)"},
    {"VUID-VkViewportSwizzleNV-w-parameter", "w must be a valid VkViewportCoordinateSwizzleNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewportSwizzleNV-w-parameter)"},
    {"VUID-VkViewportSwizzleNV-x-parameter", "x must be a valid VkViewportCoordinateSwizzleNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewportSwizzleNV-x-parameter)"},
    {"VUID-VkViewportSwizzleNV-y-parameter", "y must be a valid VkViewportCoordinateSwizzleNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewportSwizzleNV-y-parameter)"},
    {"VUID-VkViewportSwizzleNV-z-parameter", "z must be a valid VkViewportCoordinateSwizzleNV value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkViewportSwizzleNV-z-parameter)"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-display-01304", "display must point to a valid Wayland wl_display. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWaylandSurfaceCreateInfoKHR-display-01304)"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWaylandSurfaceCreateInfoKHR-flags-zerobitmask)"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWaylandSurfaceCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWaylandSurfaceCreateInfoKHR-sType-sType)"},
    {"VUID-VkWaylandSurfaceCreateInfoKHR-surface-01305", "surface must point to a valid Wayland wl_surface. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWaylandSurfaceCreateInfoKHR-surface-01305)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-commonparent", "Both of the elements of pAcquireSyncs, and the elements of pReleaseSyncs that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-commonparent)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireKeys-parameter", "If acquireCount is not 0, pAcquireKeys must be a valid pointer to an array of acquireCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireKeys-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-00081", "Each member of pAcquireSyncs and pReleaseSyncs must be a device memory object imported by setting VkImportMemoryWin32HandleInfoKHR::handleType to VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT or VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-00081)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-parameter", "If acquireCount is not 0, pAcquireSyncs must be a valid pointer to an array of acquireCount valid VkDeviceMemory handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireSyncs-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireTimeouts-parameter", "If acquireCount is not 0, pAcquireTimeouts must be a valid pointer to an array of acquireCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pAcquireTimeouts-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseKeys-parameter", "If releaseCount is not 0, pReleaseKeys must be a valid pointer to an array of releaseCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseKeys-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseSyncs-parameter", "If releaseCount is not 0, pReleaseSyncs must be a valid pointer to an array of releaseCount valid VkDeviceMemory handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-pReleaseSyncs-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoKHR-sType-sType)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-commonparent", "Both of the elements of pAcquireSyncs, and the elements of pReleaseSyncs that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-commonparent)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireKeys-parameter", "If acquireCount is not 0, pAcquireKeys must be a valid pointer to an array of acquireCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireKeys-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireSyncs-parameter", "If acquireCount is not 0, pAcquireSyncs must be a valid pointer to an array of acquireCount valid VkDeviceMemory handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireSyncs-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireTimeoutMilliseconds-parameter", "If acquireCount is not 0, pAcquireTimeoutMilliseconds must be a valid pointer to an array of acquireCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pAcquireTimeoutMilliseconds-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseKeys-parameter", "If releaseCount is not 0, pReleaseKeys must be a valid pointer to an array of releaseCount uint64_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseKeys-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseSyncs-parameter", "If releaseCount is not 0, pReleaseSyncs must be a valid pointer to an array of releaseCount valid VkDeviceMemory handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-pReleaseSyncs-parameter)"},
    {"VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32KeyedMutexAcquireReleaseInfoNV-sType-sType)"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32SurfaceCreateInfoKHR-flags-zerobitmask)"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-hinstance-01307", "hinstance must be a valid Win32 HINSTANCE. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32SurfaceCreateInfoKHR-hinstance-01307)"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-hwnd-01308", "hwnd must be a valid Win32 HWND. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32SurfaceCreateInfoKHR-hwnd-01308)"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32SurfaceCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkWin32SurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWin32SurfaceCreateInfoKHR-sType-sType)"},
    {"VUID-VkWriteDescriptorSet-commonparent", "Both of dstSet, and the elements of pTexelBufferView that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-commonparent)"},
    {"VUID-VkWriteDescriptorSet-descriptorCount-00317", "All consecutive bindings updated via a single VkWriteDescriptorSet structure, except those with a descriptorCount of zero, must have identical descriptorType and stageFlags. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorCount-00317)"},
    {"VUID-VkWriteDescriptorSet-descriptorCount-00318", "All consecutive bindings updated via a single VkWriteDescriptorSet structure, except those with a descriptorCount of zero, must all either use immutable samplers or must all not use immutable samplers. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorCount-00318)"},
    {"VUID-VkWriteDescriptorSet-descriptorCount-03048", "All consecutive bindings updated via a single VkWriteDescriptorSet structure, except those with a descriptorCount of zero, must have identical VkDescriptorBindingFlagBits. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorCount-03048)"},
    {"VUID-VkWriteDescriptorSet-descriptorCount-arraylength", "descriptorCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorCount-arraylength)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00319", "descriptorType must match the type of dstBinding within dstSet (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00319)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00322", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER, VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, pImageInfo must be a valid pointer to an array of descriptorCount valid VkDescriptorImageInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00322)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00323", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, pTexelBufferView must be a valid pointer to an array of descriptorCount valid VkBufferView handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00323)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00324", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, pBufferInfo must be a valid pointer to an array of descriptorCount valid VkDescriptorBufferInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00324)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00325", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and dstSet was not allocated with a layout that included immutable samplers for dstBinding with descriptorType, the sampler member of each element of pImageInfo must be a valid VkSampler object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00325)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00326", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, or VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the imageView and imageLayout members of each element of pImageInfo must be a valid VkImageView and VkImageLayout, respectively (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00326)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00327", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER or VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the offset member of each element of pBufferInfo must be a multiple of VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00327)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00328", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the offset member of each element of pBufferInfo must be a multiple of VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00328)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00329", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, and the buffer member of any element of pBufferInfo is the handle of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00329)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00330", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER or VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the buffer member of each element of pBufferInfo must have been created with VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00330)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00331", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the buffer member of each element of pBufferInfo must have been created with VK_BUFFER_USAGE_STORAGE_BUFFER_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00331)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00332", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER or VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, the range member of each element of pBufferInfo, or the effective range if range is VK_WHOLE_SIZE, must be less than or equal to VkPhysicalDeviceLimits::maxUniformBufferRange (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00332)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00333", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC, the range member of each element of pBufferInfo, or the effective range if range is VK_WHOLE_SIZE, must be less than or equal to VkPhysicalDeviceLimits::maxStorageBufferRange (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00333)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00334", "If descriptorType is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, the VkBuffer that each element of pTexelBufferView was created from must have been created with VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00334)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00335", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, the VkBuffer that each element of pTexelBufferView was created from must have been created with VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00335)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00336", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE or VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the imageView member of each element of pImageInfo must have been created with the identity swizzle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00336)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00337", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the imageView member of each element of pImageInfo must have been created with VK_IMAGE_USAGE_SAMPLED_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00337)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00338", "If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the imageView member of each element of pImageInfo must have been created with VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00338)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-00339", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, the imageView member of each element of pImageInfo must have been created with VK_IMAGE_USAGE_STORAGE_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-00339)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-01402", "If descriptorType is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, for each descriptor that will be accessed via load or store operations the imageLayout member for corresponding elements of pImageInfo must be VK_IMAGE_LAYOUT_GENERAL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-01402)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-01403", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the imageLayout member of each element of pImageInfo must be a member of the list given in Sampled Image or Combined Image Sampler, corresponding to its type (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-01403)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-01946", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, then the imageView member of each pImageInfo element must have been created without a VkSamplerYcbcrConversionInfo structure in its pNext chain (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-01946)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-01948", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and dstSet was allocated with a layout that included immutable samplers for dstBinding, then the imageView member of each element of pImageInfo which corresponds to an immutable sampler that enables sampler {YCbCr} conversion must have been created with a VkSamplerYcbcrConversionInfo structure in its pNext chain with an identically defined VkSamplerYcbcrConversionInfo to the corresponding immutable sampler (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-01948)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02219", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, dstArrayElement must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-02219)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02220", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, descriptorCount must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-02220)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02221", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT, the pNext chain must include a VkWriteDescriptorSetInlineUniformBlockEXT structure whose dataSize member equals descriptorCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-02221)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02382", "If descriptorType is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, the pNext chain must include a VkWriteDescriptorSetAccelerationStructureNV structure whose accelerationStructureCount member equals descriptorCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-02382)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02738", "If descriptorType is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and if any element of pImageInfo has a imageView member that was created with a VkSamplerYcbcrConversionInfo structure in its pNext chain, then dstSet must have been allocated with a layout that included immutable samplers for dstBinding, and the corresponding immutable sampler must have been created with an identically defined VkSamplerYcbcrConversionInfo object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-02738)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-02752", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER, then dstSet must not have been allocated with a layout that included immutable samplers for dstBinding (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-02752)"},
    {"VUID-VkWriteDescriptorSet-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-descriptorType-parameter)"},
    {"VUID-VkWriteDescriptorSet-dstArrayElement-00321", "The sum of dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by dstBinding, and all applicable consecutive bindings, as described by consecutive binding updates (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-dstArrayElement-00321)"},
    {"VUID-VkWriteDescriptorSet-dstBinding-00315", "dstBinding must be less than or equal to the maximum value of binding of all VkDescriptorSetLayoutBinding structures specified when dstSet's descriptor set layout was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-dstBinding-00315)"},
    {"VUID-VkWriteDescriptorSet-dstBinding-00316", "dstBinding must be a binding with a non-zero descriptorCount (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-dstBinding-00316)"},
    {"VUID-VkWriteDescriptorSet-dstSet-00320", "dstSet must be a valid VkDescriptorSet handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-dstSet-00320)"},
    {"VUID-VkWriteDescriptorSet-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkWriteDescriptorSetAccelerationStructureNV or VkWriteDescriptorSetInlineUniformBlockEXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-pNext-pNext)"},
    {"VUID-VkWriteDescriptorSet-sType-sType", "sType must be VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-sType-sType)"},
    {"VUID-VkWriteDescriptorSet-sType-unique", "Each sType member in the pNext chain must be unique (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSet-sType-unique)"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-02236", "accelerationStructureCount must be equal to descriptorCount in the extended structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-02236)"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-arraylength", "accelerationStructureCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetAccelerationStructureNV-accelerationStructureCount-arraylength)"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-02764", "Each acceleration structure in pAccelerationStructures must have been created with VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-02764)"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-parameter", "pAccelerationStructures must be a valid pointer to an array of accelerationStructureCount valid VkAccelerationStructureNV handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetAccelerationStructureNV-pAccelerationStructures-parameter)"},
    {"VUID-VkWriteDescriptorSetAccelerationStructureNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetAccelerationStructureNV-sType-sType)"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-dataSize-02222", "dataSize must be an integer multiple of 4 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetInlineUniformBlockEXT-dataSize-02222)"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-dataSize-arraylength", "dataSize must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetInlineUniformBlockEXT-dataSize-arraylength)"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-pData-parameter", "pData must be a valid pointer to an array of dataSize bytes (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetInlineUniformBlockEXT-pData-parameter)"},
    {"VUID-VkWriteDescriptorSetInlineUniformBlockEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkWriteDescriptorSetInlineUniformBlockEXT-sType-sType)"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-connection-01310", "connection must point to a valid X11 xcb_connection_t. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXcbSurfaceCreateInfoKHR-connection-01310)"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXcbSurfaceCreateInfoKHR-flags-zerobitmask)"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXcbSurfaceCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXcbSurfaceCreateInfoKHR-sType-sType)"},
    {"VUID-VkXcbSurfaceCreateInfoKHR-window-01311", "window must be a valid X11 xcb_window_t. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXcbSurfaceCreateInfoKHR-window-01311)"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-dpy-01313", "dpy must point to a valid Xlib Display. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXlibSurfaceCreateInfoKHR-dpy-01313)"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXlibSurfaceCreateInfoKHR-flags-zerobitmask)"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXlibSurfaceCreateInfoKHR-pNext-pNext)"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXlibSurfaceCreateInfoKHR-sType-sType)"},
    {"VUID-VkXlibSurfaceCreateInfoKHR-window-01314", "window must be a valid Xlib Window. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-VkXlibSurfaceCreateInfoKHR-window-01314)"},
    {"VUID-vkAcquireFullScreenExclusiveModeEXT-commonparent", "Both of device, and swapchain must have been created, allocated, or retrieved from the same VkInstance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireFullScreenExclusiveModeEXT-commonparent)"},
    {"VUID-vkAcquireFullScreenExclusiveModeEXT-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireFullScreenExclusiveModeEXT-device-parameter)"},
    {"VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-02674", "swapchain must not be in the retired state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-02674)"},
    {"VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-02675", "swapchain must be a swapchain created with a VkSurfaceFullScreenExclusiveInfoEXT structure, with fullScreenExclusive set to VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-02675)"},
    {"VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-02676", "swapchain must not currently have exclusive full-screen access (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-02676)"},
    {"VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireFullScreenExclusiveModeEXT-swapchain-parameter)"},
    {"VUID-vkAcquireNextImage2KHR-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImage2KHR-device-parameter)"},
    {"VUID-vkAcquireNextImage2KHR-pAcquireInfo-parameter", "pAcquireInfo must be a valid pointer to a valid VkAcquireNextImageInfoKHR structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImage2KHR-pAcquireInfo-parameter)"},
    {"VUID-vkAcquireNextImage2KHR-pImageIndex-parameter", "pImageIndex must be a valid pointer to a uint32_t value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImage2KHR-pImageIndex-parameter)"},
    {"VUID-vkAcquireNextImage2KHR-swapchain-01803", "If the number of currently acquired images is greater than the difference between the number of images in the swapchain member of pAcquireInfo and the value of VkSurfaceCapabilitiesKHR::minImageCount as returned by a call to vkGetPhysicalDeviceSurfaceCapabilities2KHR with the surface used to create swapchain, the timeout member of pAcquireInfo must not be UINT64_MAX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImage2KHR-swapchain-01803)"},
    {"VUID-vkAcquireNextImageKHR-commonparent", "Both of device, and swapchain that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkInstance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-commonparent)"},
    {"VUID-vkAcquireNextImageKHR-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-device-parameter)"},
    {"VUID-vkAcquireNextImageKHR-fence-01287", "If fence is not VK_NULL_HANDLE it must be unsignaled and must not be associated with any other queue command that has not yet completed execution on that queue (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-fence-01287)"},
    {"VUID-vkAcquireNextImageKHR-fence-parameter", "If fence is not VK_NULL_HANDLE, fence must be a valid VkFence handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-fence-parameter)"},
    {"VUID-vkAcquireNextImageKHR-fence-parent", "If fence is a valid handle, it must have been created, allocated, or retrieved from device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-fence-parent)"},
    {"VUID-vkAcquireNextImageKHR-pImageIndex-parameter", "pImageIndex must be a valid pointer to a uint32_t value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-pImageIndex-parameter)"},
    {"VUID-vkAcquireNextImageKHR-semaphore-01286", "If semaphore is not VK_NULL_HANDLE it must be unsignaled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-semaphore-01286)"},
    {"VUID-vkAcquireNextImageKHR-semaphore-01779", "If semaphore is not VK_NULL_HANDLE it must not have any uncompleted signal or wait operations pending (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-semaphore-01779)"},
    {"VUID-vkAcquireNextImageKHR-semaphore-01780", "semaphore and fence must not both be equal to VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-semaphore-01780)"},
    {"VUID-vkAcquireNextImageKHR-semaphore-03265", "semaphore must have a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-semaphore-03265)"},
    {"VUID-vkAcquireNextImageKHR-semaphore-parameter", "If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-semaphore-parameter)"},
    {"VUID-vkAcquireNextImageKHR-semaphore-parent", "If semaphore is a valid handle, it must have been created, allocated, or retrieved from device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-semaphore-parent)"},
    {"VUID-vkAcquireNextImageKHR-swapchain-01285", "swapchain must not be in the retired state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-swapchain-01285)"},
    {"VUID-vkAcquireNextImageKHR-swapchain-01802", "If the number of currently acquired images is greater than the difference between the number of images in swapchain and the value of VkSurfaceCapabilitiesKHR::minImageCount as returned by a call to vkGetPhysicalDeviceSurfaceCapabilities2KHR with the surface used to create swapchain, timeout must not be UINT64_MAX (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-swapchain-01802)"},
    {"VUID-vkAcquireNextImageKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireNextImageKHR-swapchain-parameter)"},
    {"VUID-vkAcquirePerformanceConfigurationINTEL-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquirePerformanceConfigurationINTEL-device-parameter)"},
    {"VUID-vkAcquirePerformanceConfigurationINTEL-pAcquireInfo-parameter", "pAcquireInfo must be a valid pointer to a valid VkPerformanceConfigurationAcquireInfoINTEL structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquirePerformanceConfigurationINTEL-pAcquireInfo-parameter)"},
    {"VUID-vkAcquirePerformanceConfigurationINTEL-pConfiguration-parameter", "pConfiguration must be a valid pointer to a VkPerformanceConfigurationINTEL handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquirePerformanceConfigurationINTEL-pConfiguration-parameter)"},
    {"VUID-vkAcquireProfilingLockKHR-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireProfilingLockKHR-device-parameter)"},
    {"VUID-vkAcquireProfilingLockKHR-pInfo-parameter", "pInfo must be a valid pointer to a valid VkAcquireProfilingLockInfoKHR structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireProfilingLockKHR-pInfo-parameter)"},
    {"VUID-vkAcquireXlibDisplayEXT-display-parameter", "display must be a valid VkDisplayKHR handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireXlibDisplayEXT-display-parameter)"},
    {"VUID-vkAcquireXlibDisplayEXT-dpy-parameter", "dpy must be a valid pointer to a Display value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireXlibDisplayEXT-dpy-parameter)"},
    {"VUID-vkAcquireXlibDisplayEXT-physicalDevice-parameter", "physicalDevice must be a valid VkPhysicalDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAcquireXlibDisplayEXT-physicalDevice-parameter)"},
    {"VUID-vkAllocateCommandBuffers-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateCommandBuffers-device-parameter)"},
    {"VUID-vkAllocateCommandBuffers-pAllocateInfo-parameter", "pAllocateInfo must be a valid pointer to a valid VkCommandBufferAllocateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateCommandBuffers-pAllocateInfo-parameter)"},
    {"VUID-vkAllocateCommandBuffers-pAllocateInfo::commandBufferCount-arraylength", "The value referenced by pAllocateInfo::commandBufferCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateCommandBuffers-pAllocateInfo::commandBufferCount-arraylength)"},
    {"VUID-vkAllocateCommandBuffers-pCommandBuffers-parameter", "pCommandBuffers must be a valid pointer to an array of pAllocateInfo::commandBufferCount VkCommandBuffer handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateCommandBuffers-pCommandBuffers-parameter)"},
    {"VUID-vkAllocateDescriptorSets-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateDescriptorSets-device-parameter)"},
    {"VUID-vkAllocateDescriptorSets-pAllocateInfo-parameter", "pAllocateInfo must be a valid pointer to a valid VkDescriptorSetAllocateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateDescriptorSets-pAllocateInfo-parameter)"},
    {"VUID-vkAllocateDescriptorSets-pAllocateInfo::descriptorSetCount-arraylength", "The value referenced by pAllocateInfo::descriptorSetCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateDescriptorSets-pAllocateInfo::descriptorSetCount-arraylength)"},
    {"VUID-vkAllocateDescriptorSets-pDescriptorSets-parameter", "pDescriptorSets must be a valid pointer to an array of pAllocateInfo::descriptorSetCount VkDescriptorSet handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateDescriptorSets-pDescriptorSets-parameter)"},
    {"VUID-vkAllocateMemory-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateMemory-device-parameter)"},
    {"VUID-vkAllocateMemory-deviceCoherentMemory-02790", "If the deviceCoherentMemory feature is not enabled, pAllocateInfo->memoryTypeIndex must not identify a memory type supporting VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateMemory-deviceCoherentMemory-02790)"},
    {"VUID-vkAllocateMemory-pAllocateInfo-01713", "pAllocateInfo->allocationSize must be less than or equal to VkPhysicalDeviceMemoryProperties::memoryHeaps[memindex].size where memindex = VkPhysicalDeviceMemoryProperties::memoryTypes[pAllocateInfo->memoryTypeIndex].heapIndex as returned by vkGetPhysicalDeviceMemoryProperties for the VkPhysicalDevice that device was created from. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateMemory-pAllocateInfo-01713)"},
    {"VUID-vkAllocateMemory-pAllocateInfo-01714", "pAllocateInfo->memoryTypeIndex must be less than VkPhysicalDeviceMemoryProperties::memoryTypeCount as returned by vkGetPhysicalDeviceMemoryProperties for the VkPhysicalDevice that device was created from. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateMemory-pAllocateInfo-01714)"},
    {"VUID-vkAllocateMemory-pAllocateInfo-parameter", "pAllocateInfo must be a valid pointer to a valid VkMemoryAllocateInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateMemory-pAllocateInfo-parameter)"},
    {"VUID-vkAllocateMemory-pAllocator-parameter", "If pAllocator is not NULL, pAllocator must be a valid pointer to a valid VkAllocationCallbacks structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateMemory-pAllocator-parameter)"},
    {"VUID-vkAllocateMemory-pMemory-parameter", "pMemory must be a valid pointer to a VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkAllocateMemory-pMemory-parameter)"},
    {"VUID-vkBeginCommandBuffer-commandBuffer-00049", "commandBuffer must not be in the recording or pending state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBeginCommandBuffer-commandBuffer-00049)"},
    {"VUID-vkBeginCommandBuffer-commandBuffer-00050", "If commandBuffer was allocated from a VkCommandPool which did not have the VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT flag set, commandBuffer must be in the initial state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBeginCommandBuffer-commandBuffer-00050)"},
    {"VUID-vkBeginCommandBuffer-commandBuffer-00051", "If commandBuffer is a secondary command buffer, the pInheritanceInfo member of pBeginInfo must be a valid VkCommandBufferInheritanceInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBeginCommandBuffer-commandBuffer-00051)"},
    {"VUID-vkBeginCommandBuffer-commandBuffer-00052", "If commandBuffer is a secondary command buffer and either the occlusionQueryEnable member of the pInheritanceInfo member of pBeginInfo is VK_FALSE, or the precise occlusion queries feature is not enabled, the queryFlags member of the pInheritanceInfo member pBeginInfo must not contain VK_QUERY_CONTROL_PRECISE_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBeginCommandBuffer-commandBuffer-00052)"},
    {"VUID-vkBeginCommandBuffer-commandBuffer-02840", "If commandBuffer is a primary command buffer, then pBeginInfo->flags must not set both the VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT and the VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBeginCommandBuffer-commandBuffer-02840)"},
    {"VUID-vkBeginCommandBuffer-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBeginCommandBuffer-commandBuffer-parameter)"},
    {"VUID-vkBeginCommandBuffer-pBeginInfo-parameter", "pBeginInfo must be a valid pointer to a valid VkCommandBufferBeginInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBeginCommandBuffer-pBeginInfo-parameter)"},
    {"VUID-vkBindAccelerationStructureMemoryNV-bindInfoCount-arraylength", "bindInfoCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindAccelerationStructureMemoryNV-bindInfoCount-arraylength)"},
    {"VUID-vkBindAccelerationStructureMemoryNV-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindAccelerationStructureMemoryNV-device-parameter)"},
    {"VUID-vkBindAccelerationStructureMemoryNV-pBindInfos-parameter", "pBindInfos must be a valid pointer to an array of bindInfoCount valid VkBindAccelerationStructureMemoryInfoNV structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindAccelerationStructureMemoryNV-pBindInfos-parameter)"},
    {"VUID-vkBindBufferMemory-None-01898", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit set, the buffer must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-None-01898)"},
    {"VUID-vkBindBufferMemory-None-01899", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit not set, the buffer must not be bound to a memory object created with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-None-01899)"},
    {"VUID-vkBindBufferMemory-buffer-01029", "buffer must not already be backed by a memory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-buffer-01029)"},
    {"VUID-vkBindBufferMemory-buffer-01030", "buffer must not have been created with any sparse memory binding flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-buffer-01030)"},
    {"VUID-vkBindBufferMemory-buffer-01038", "If buffer was created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::buffer equal to a buffer handle created with identical creation parameters to buffer and memoryOffset must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-buffer-01038)"},
    {"VUID-vkBindBufferMemory-buffer-01039", "If buffer was not created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-vkBindBufferMemory-buffer-01039)"},
    {"VUID-vkBindBufferMemory-buffer-01444", "If buffer requires a dedicated allocation(as reported by vkGetBufferMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for buffer), memory must have been created with VkMemoryDedicatedAllocateInfo::buffer equal to buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-buffer-01444)"},
    {"VUID-vkBindBufferMemory-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-buffer-parameter)"},
    {"VUID-vkBindBufferMemory-buffer-parent", "buffer must have been created, allocated, or retrieved from device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-buffer-parent)"},
    {"VUID-vkBindBufferMemory-bufferDeviceAddress-03339", "If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddress feature is enabled and buffer was created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-bufferDeviceAddress-03339)"},
    {"VUID-vkBindBufferMemory-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-device-parameter)"},
    {"VUID-vkBindBufferMemory-memory-01035", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memory-01035)"},
    {"VUID-vkBindBufferMemory-memory-01508", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::buffer was not VK_NULL_HANDLE, then buffer must equal VkMemoryDedicatedAllocateInfo::buffer, and memoryOffset must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memory-01508)"},
    {"VUID-vkBindBufferMemory-memory-02726", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memory-02726)"},
    {"VUID-vkBindBufferMemory-memory-02727", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memory-02727)"},
    {"VUID-vkBindBufferMemory-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memory-parameter)"},
    {"VUID-vkBindBufferMemory-memory-parent", "memory must have been created, allocated, or retrieved from device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memory-parent)"},
    {"VUID-vkBindBufferMemory-memoryOffset-01031", "memoryOffset must be less than the size of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memoryOffset-01031)"},
    {"VUID-vkBindBufferMemory-memoryOffset-01036", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-memoryOffset-01036)"},
    {"VUID-vkBindBufferMemory-size-01037", "The size member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory-size-01037)"},
    {"VUID-vkBindBufferMemory2-bindInfoCount-arraylength", "bindInfoCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory2-bindInfoCount-arraylength)"},
    {"VUID-vkBindBufferMemory2-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory2-device-parameter)"},
    {"VUID-vkBindBufferMemory2-pBindInfos-parameter", "pBindInfos must be a valid pointer to an array of bindInfoCount valid VkBindBufferMemoryInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindBufferMemory2-pBindInfos-parameter)"},
    {"VUID-vkBindImageMemory-None-01901", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit set, the image must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-None-01901)"},
    {"VUID-vkBindImageMemory-None-01902", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit not set, the image must not be bound to a memory object created with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-None-01902)"},
    {"VUID-vkBindImageMemory-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-device-parameter)"},
    {"VUID-vkBindImageMemory-image-01044", "image must not already be backed by a memory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-image-01044)"},
    {"VUID-vkBindImageMemory-image-01045", "image must not have been created with any sparse memory binding flags (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-image-01045)"},
    {"VUID-vkBindImageMemory-image-01050", "If image was created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::image equal to an image handle created with identical creation parameters to image and memoryOffset must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-image-01050)"},
    {"VUID-vkBindImageMemory-image-01051", "If image was not created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image (https://github.com/KhronosGroup/Vulkan-Docs/search?q=VUID-vkBindImageMemory-image-01051)"},
    {"VUID-vkBindImageMemory-image-01445", "If image requires a dedicated allocation (as reported by vkGetImageMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for image), memory must have been created with VkMemoryDedicatedAllocateInfo::image equal to image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-image-01445)"},
    {"VUID-vkBindImageMemory-image-01608", "image must not have been created with the VK_IMAGE_CREATE_DISJOINT_BIT set. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-image-01608)"},
    {"VUID-vkBindImageMemory-image-parameter", "image must be a valid VkImage handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-image-parameter)"},
    {"VUID-vkBindImageMemory-image-parent", "image must have been created, allocated, or retrieved from device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-image-parent)"},
    {"VUID-vkBindImageMemory-memory-01047", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-01047)"},
    {"VUID-vkBindImageMemory-memory-01509", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-khr-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-01509)"},
    {"VUID-vkBindImageMemory-memory-02628", "If the dedicated allocation image aliasing feature is not enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-02628)"},
    {"VUID-vkBindImageMemory-memory-02629", "If the dedicated allocation image aliasing feature is enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then memoryOffset must be zero, and image must be either equal to VkMemoryDedicatedAllocateInfo::image or an image that was created using the same parameters in VkImageCreateInfo, with the exception that extent and arrayLayers may differ subject to the following restrictions: every dimension in the extent parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created; and the arrayLayers parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-02629)"},
    {"VUID-vkBindImageMemory-memory-02728", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryImageCreateInfo::handleTypes when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-02728)"},
    {"VUID-vkBindImageMemory-memory-02729", "If memory was created by a memory import operation, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-02729)"},
    {"VUID-vkBindImageMemory-memory-parameter", "memory must be a valid VkDeviceMemory handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-parameter)"},
    {"VUID-vkBindImageMemory-memory-parent", "memory must have been created, allocated, or retrieved from device (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memory-parent)"},
    {"VUID-vkBindImageMemory-memoryOffset-01046", "memoryOffset must be less than the size of memory (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memoryOffset-01046)"},
    {"VUID-vkBindImageMemory-memoryOffset-01048", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with image (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-memoryOffset-01048)"},
    {"VUID-vkBindImageMemory-size-01049", "The size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements with image must be less than or equal to the size of memory minus memoryOffset (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory-size-01049)"},
    {"VUID-vkBindImageMemory2-bindInfoCount-arraylength", "bindInfoCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory2-bindInfoCount-arraylength)"},
    {"VUID-vkBindImageMemory2-device-parameter", "device must be a valid VkDevice handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory2-device-parameter)"},
    {"VUID-vkBindImageMemory2-pBindInfos-02858", "If any VkBindImageMemoryInfo::image was created with VK_IMAGE_CREATE_DISJOINT_BIT then all planes of VkBindImageMemoryInfo::image must be bound individually in separate pBindInfos (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory2-pBindInfos-02858)"},
    {"VUID-vkBindImageMemory2-pBindInfos-parameter", "pBindInfos must be a valid pointer to an array of bindInfoCount valid VkBindImageMemoryInfo structures (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkBindImageMemory2-pBindInfos-parameter)"},
    {"VUID-vkCmdBeginConditionalRenderingEXT-None-01980", "Conditional rendering must not already be active (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginConditionalRenderingEXT-None-01980)"},
    {"VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics, or compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-parameter)"},
    {"VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-recording)"},
    {"VUID-vkCmdBeginConditionalRenderingEXT-pConditionalRenderingBegin-parameter", "pConditionalRenderingBegin must be a valid pointer to a valid VkConditionalRenderingBeginInfoEXT structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginConditionalRenderingEXT-pConditionalRenderingBegin-parameter)"},
    {"VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics, or compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-parameter)"},
    {"VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-recording)"},
    {"VUID-vkCmdBeginDebugUtilsLabelEXT-pLabelInfo-parameter", "pLabelInfo must be a valid pointer to a valid VkDebugUtilsLabelEXT structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginDebugUtilsLabelEXT-pLabelInfo-parameter)"},
    {"VUID-vkCmdBeginQuery-None-00807", "All queries used by the command must be unavailable (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-None-00807)"},
    {"VUID-vkCmdBeginQuery-commandBuffer-01885", "commandBuffer must not be a protected command buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-commandBuffer-01885)"},
    {"VUID-vkCmdBeginQuery-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics, or compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBeginQuery-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-commandBuffer-parameter)"},
    {"VUID-vkCmdBeginQuery-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-commandBuffer-recording)"},
    {"VUID-vkCmdBeginQuery-commonparent", "Both of commandBuffer, and queryPool must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-commonparent)"},
    {"VUID-vkCmdBeginQuery-flags-parameter", "flags must be a valid combination of VkQueryControlFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-flags-parameter)"},
    {"VUID-vkCmdBeginQuery-query-00802", "query must be less than the number of queries in queryPool (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-query-00802)"},
    {"VUID-vkCmdBeginQuery-query-00808", "If called within a render pass instance, the sum of query and the number of bits set in the current subpass's view mask must be less than or equal to the number of queries in queryPool (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-query-00808)"},
    {"VUID-vkCmdBeginQuery-queryPool-01922", "queryPool must have been created with a queryType that differs from that of any queries that are active within commandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryPool-01922)"},
    {"VUID-vkCmdBeginQuery-queryPool-03223", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR, the profiling lock must have been held before vkBeginCommandBuffer was called on commandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryPool-03223)"},
    {"VUID-vkCmdBeginQuery-queryPool-03224", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR and one of the counters used to create queryPool was VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR, the query begin must be the first recorded command in commandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryPool-03224)"},
    {"VUID-vkCmdBeginQuery-queryPool-03225", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR and one of the counters used to create queryPool was VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR, the begin command must not be recorded within a render pass instance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryPool-03225)"},
    {"VUID-vkCmdBeginQuery-queryPool-03226", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR and another query pool with a queryType VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR has been used within commandBuffer, its parent primary command buffer or secondary command buffer recorded within the same parent primary command buffer as commandBuffer, the performanceCounterMultipleQueryPools feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryPool-03226)"},
    {"VUID-vkCmdBeginQuery-queryPool-parameter", "queryPool must be a valid VkQueryPool handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryPool-parameter)"},
    {"VUID-vkCmdBeginQuery-queryType-00800", "If the precise occlusion queries feature is not enabled, or the queryType used to create queryPool was not VK_QUERY_TYPE_OCCLUSION, flags must not contain VK_QUERY_CONTROL_PRECISE_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryType-00800)"},
    {"VUID-vkCmdBeginQuery-queryType-00803", "If the queryType used to create queryPool was VK_QUERY_TYPE_OCCLUSION, the VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryType-00803)"},
    {"VUID-vkCmdBeginQuery-queryType-00804", "If the queryType used to create queryPool was VK_QUERY_TYPE_PIPELINE_STATISTICS and any of the pipelineStatistics indicate graphics operations, the VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryType-00804)"},
    {"VUID-vkCmdBeginQuery-queryType-00805", "If the queryType used to create queryPool was VK_QUERY_TYPE_PIPELINE_STATISTICS and any of the pipelineStatistics indicate compute operations, the VkCommandPool that commandBuffer was allocated from must support compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryType-00805)"},
    {"VUID-vkCmdBeginQuery-queryType-02327", "If the queryType used to create queryPool was VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT the VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryType-02327)"},
    {"VUID-vkCmdBeginQuery-queryType-02328", "If the queryType used to create queryPool was VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT then VkPhysicalDeviceTransformFeedbackPropertiesEXT::transformFeedbackQueries must be supported (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryType-02328)"},
    {"VUID-vkCmdBeginQuery-queryType-02804", "The queryType used to create queryPool must not be VK_QUERY_TYPE_TIMESTAMP (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQuery-queryType-02804)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-None-00807", "All queries used by the command must be unavailable (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-None-00807)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-01885", "commandBuffer must not be a protected command buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-01885)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics, or compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-parameter)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-recording)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-commonparent", "Both of commandBuffer, and queryPool must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-commonparent)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-flags-parameter", "flags must be a valid combination of VkQueryControlFlagBits values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-flags-parameter)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-query-00802", "query must be less than the number of queries in queryPool (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-query-00802)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-query-00808", "If called within a render pass instance, the sum of query and the number of bits set in the current subpass's view mask must be less than or equal to the number of queries in queryPool (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-query-00808)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryPool-01922", "queryPool must have been created with a queryType that differs from that of any queries that are active within commandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryPool-01922)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryPool-03223", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR, the profiling lock must have been held before vkBeginCommandBuffer was called on commandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryPool-03223)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryPool-03224", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR and one of the counters used to create queryPool was VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR, the query begin must be the first recorded command in commandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryPool-03224)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryPool-03225", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR and one of the counters used to create queryPool was VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR, the begin command must not be recorded within a render pass instance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryPool-03225)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryPool-03226", "If queryPool was created with a queryType of VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR and another query pool with a queryType VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR has been used within commandBuffer, its parent primary command buffer or secondary command buffer recorded within the same parent primary command buffer as commandBuffer, the performanceCounterMultipleQueryPools feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryPool-03226)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryPool-parameter", "queryPool must be a valid VkQueryPool handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryPool-parameter)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-00800", "If the precise occlusion queries feature is not enabled, or the queryType used to create queryPool was not VK_QUERY_TYPE_OCCLUSION, flags must not contain VK_QUERY_CONTROL_PRECISE_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-00800)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-00803", "If the queryType used to create queryPool was VK_QUERY_TYPE_OCCLUSION, the VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-00803)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-00804", "If the queryType used to create queryPool was VK_QUERY_TYPE_PIPELINE_STATISTICS and any of the pipelineStatistics indicate graphics operations, the VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-00804)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-00805", "If the queryType used to create queryPool was VK_QUERY_TYPE_PIPELINE_STATISTICS and any of the pipelineStatistics indicate compute operations, the VkCommandPool that commandBuffer was allocated from must support compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-00805)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-02338", "If the queryType used to create queryPool was VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT the VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-02338)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-02339", "If the queryType used to create queryPool was VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT the index parameter must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-02339)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-02340", "If the queryType used to create queryPool was not VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT the index must be zero (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-02340)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-02341", "If the queryType used to create queryPool was VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT then VkPhysicalDeviceTransformFeedbackPropertiesEXT::transformFeedbackQueries must be supported (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-02341)"},
    {"VUID-vkCmdBeginQueryIndexedEXT-queryType-02804", "The queryType used to create queryPool must not be VK_QUERY_TYPE_TIMESTAMP (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginQueryIndexedEXT-queryType-02804)"},
    {"VUID-vkCmdBeginRenderPass-bufferlevel", "commandBuffer must be a primary VkCommandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-bufferlevel)"},
    {"VUID-vkCmdBeginRenderPass-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBeginRenderPass-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-commandBuffer-parameter)"},
    {"VUID-vkCmdBeginRenderPass-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-commandBuffer-recording)"},
    {"VUID-vkCmdBeginRenderPass-contents-parameter", "contents must be a valid VkSubpassContents value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-contents-parameter)"},
    {"VUID-vkCmdBeginRenderPass-framebuffer-02532", "For any attachment in framebuffer that is used by renderPass and is bound to memory locations that are also bound to another attachment used by renderPass, and if at least one of those uses causes either attachment to be written to, both attachments must have had the VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-framebuffer-02532)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-00895", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-00895)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-00896", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-00896)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-00897", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_SAMPLED_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-00897)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-00898", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_TRANSFER_SRC_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-00898)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-00899", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_TRANSFER_DST_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-00899)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-00900", "If any of the initialLayout members of the VkAttachmentDescription structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is not VK_IMAGE_LAYOUT_UNDEFINED, then each such initialLayout must be equal to the current layout of the corresponding attachment image subresource of the framebuffer specified in the framebuffer member of pRenderPassBegin (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-00900)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-01758", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-01758)"},
    {"VUID-vkCmdBeginRenderPass-initialLayout-02842", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-initialLayout-02842)"},
    {"VUID-vkCmdBeginRenderPass-pRenderPassBegin-parameter", "pRenderPassBegin must be a valid pointer to a valid VkRenderPassBeginInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-pRenderPassBegin-parameter)"},
    {"VUID-vkCmdBeginRenderPass-renderpass", "This command must only be called outside of a render pass instance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-renderpass)"},
    {"VUID-vkCmdBeginRenderPass-srcStageMask-00901", "The srcStageMask and dstStageMask members of any element of the pDependencies member of VkRenderPassCreateInfo used to create renderPass must be supported by the capabilities of the queue family identified by the queueFamilyIndex member of the VkCommandPoolCreateInfo used to create the command pool which commandBuffer was allocated from (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-srcStageMask-00901)"},
    {"VUID-vkCmdBeginRenderPass-stencilInitialLayout-02843", "If any of the stencilInitialLayout or stencilFinalLayout member of the VkAttachmentDescriptionStencilLayout structures or the stencilLayout member of the VkAttachmentReferenceStencilLayout structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass-stencilInitialLayout-02843)"},
    {"VUID-vkCmdBeginRenderPass2-bufferlevel", "commandBuffer must be a primary VkCommandBuffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-bufferlevel)"},
    {"VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBeginRenderPass2-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-commandBuffer-parameter)"},
    {"VUID-vkCmdBeginRenderPass2-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-commandBuffer-recording)"},
    {"VUID-vkCmdBeginRenderPass2-framebuffer-02533", "For any attachment in framebuffer that is used by renderPass and is bound to memory locations that are also bound to another attachment used by renderPass, and if at least one of those uses causes either attachment to be written to, both attachments must have had the VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT set (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-framebuffer-02533)"},
    {"VUID-vkCmdBeginRenderPass2-framebuffer-02779", "Both the framebuffer and renderPass members of pRenderPassBegin must have been created on the same VkDevice that commandBuffer was allocated on (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-framebuffer-02779)"},
    {"VUID-vkCmdBeginRenderPass2-initialLayout-02844", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-initialLayout-02844)"},
    {"VUID-vkCmdBeginRenderPass2-initialLayout-03094", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-initialLayout-03094)"},
    {"VUID-vkCmdBeginRenderPass2-initialLayout-03096", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-initialLayout-03096)"},
    {"VUID-vkCmdBeginRenderPass2-initialLayout-03097", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_SAMPLED_BIT or VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-initialLayout-03097)"},
    {"VUID-vkCmdBeginRenderPass2-initialLayout-03098", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_TRANSFER_SRC_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-initialLayout-03098)"},
    {"VUID-vkCmdBeginRenderPass2-initialLayout-03099", "If any of the initialLayout or finalLayout member of the VkAttachmentDescription structures or the layout member of the VkAttachmentReference structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_TRANSFER_DST_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-initialLayout-03099)"},
    {"VUID-vkCmdBeginRenderPass2-initialLayout-03100", "If any of the initialLayout members of the VkAttachmentDescription structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is not VK_IMAGE_LAYOUT_UNDEFINED, then each such initialLayout must be equal to the current layout of the corresponding attachment image subresource of the framebuffer specified in the framebuffer member of pRenderPassBegin (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-initialLayout-03100)"},
    {"VUID-vkCmdBeginRenderPass2-pRenderPassBegin-parameter", "pRenderPassBegin must be a valid pointer to a valid VkRenderPassBeginInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-pRenderPassBegin-parameter)"},
    {"VUID-vkCmdBeginRenderPass2-pSubpassBeginInfo-parameter", "pSubpassBeginInfo must be a valid pointer to a valid VkSubpassBeginInfo structure (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-pSubpassBeginInfo-parameter)"},
    {"VUID-vkCmdBeginRenderPass2-renderpass", "This command must only be called outside of a render pass instance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-renderpass)"},
    {"VUID-vkCmdBeginRenderPass2-srcStageMask-03101", "The srcStageMask and dstStageMask members of any element of the pDependencies member of VkRenderPassCreateInfo used to create renderPass must be supported by the capabilities of the queue family identified by the queueFamilyIndex member of the VkCommandPoolCreateInfo used to create the command pool which commandBuffer was allocated from (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-srcStageMask-03101)"},
    {"VUID-vkCmdBeginRenderPass2-stencilInitialLayout-02845", "If any of the stencilInitialLayout or stencilFinalLayout member of the VkAttachmentDescriptionStencilLayout structures or the stencilLayout member of the VkAttachmentReferenceStencilLayout structures specified when creating the render pass specified in the renderPass member of pRenderPassBegin is VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL then the corresponding attachment image view of the framebuffer specified in the framebuffer member of pRenderPassBegin must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginRenderPass2-stencilInitialLayout-02845)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-None-02367", "Transform feedback must not be active (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-None-02367)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-None-02373", "Transform feedback must not be made active in a render pass instance with multiview enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-None-02373)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-parameter)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-recording)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-commonparent", "Both of commandBuffer, and the elements of pCounterBuffers that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-commonparent)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-counterBufferCount-02607", "If counterBufferCount is not 0, and pCounterBuffers is not NULL, pCounterBuffers must be a valid pointer to an array of counterBufferCount VkBuffer handles that are either valid or VK_NULL_HANDLE (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-counterBufferCount-02607)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-firstCounterBuffer-02368", "firstCounterBuffer must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-firstCounterBuffer-02368)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-firstCounterBuffer-02369", "The sum of firstCounterBuffer and counterBufferCount must be less than or equal to VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBuffers (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-firstCounterBuffer-02369)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-pCounterBuffer-02371", "If pCounterBuffer is NULL, then pCounterBufferOffsets must also be NULL (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-pCounterBuffer-02371)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-pCounterBufferOffsets-02370", "For each buffer handle in the array, if it is not VK_NULL_HANDLE it must reference a buffer large enough to hold 4 bytes at the corresponding offset from the pCounterBufferOffsets array (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-pCounterBufferOffsets-02370)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-pCounterBufferOffsets-parameter", "If counterBufferCount is not 0, and pCounterBufferOffsets is not NULL, pCounterBufferOffsets must be a valid pointer to an array of counterBufferCount VkDeviceSize values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-pCounterBufferOffsets-parameter)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-pCounterBuffers-02372", "For each buffer handle in the pCounterBuffers array that is not VK_NULL_HANDLE it must have been created with a usage value containing VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-pCounterBuffers-02372)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-renderpass", "This command must only be called inside of a render pass instance (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-renderpass)"},
    {"VUID-vkCmdBeginTransformFeedbackEXT-transformFeedback-02366", "VkPhysicalDeviceTransformFeedbackFeaturesEXT::transformFeedback must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBeginTransformFeedbackEXT-transformFeedback-02366)"},
    {"VUID-vkCmdBindDescriptorSets-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics, or compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBindDescriptorSets-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-commandBuffer-parameter)"},
    {"VUID-vkCmdBindDescriptorSets-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-commandBuffer-recording)"},
    {"VUID-vkCmdBindDescriptorSets-commonparent", "Each of commandBuffer, layout, and the elements of pDescriptorSets must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-commonparent)"},
    {"VUID-vkCmdBindDescriptorSets-descriptorSetCount-arraylength", "descriptorSetCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-descriptorSetCount-arraylength)"},
    {"VUID-vkCmdBindDescriptorSets-dynamicOffsetCount-00359", "dynamicOffsetCount must be equal to the total number of dynamic descriptors in pDescriptorSets (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-dynamicOffsetCount-00359)"},
    {"VUID-vkCmdBindDescriptorSets-firstSet-00360", "The sum of firstSet and descriptorSetCount must be less than or equal to VkPipelineLayoutCreateInfo::setLayoutCount provided when layout was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-firstSet-00360)"},
    {"VUID-vkCmdBindDescriptorSets-layout-parameter", "layout must be a valid VkPipelineLayout handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-layout-parameter)"},
    {"VUID-vkCmdBindDescriptorSets-pDescriptorSets-00358", "Each element of pDescriptorSets must have been allocated with a VkDescriptorSetLayout that matches (is the same as, or identically defined as) the VkDescriptorSetLayout at set n in layout, where n is the sum of firstSet and the index into pDescriptorSets (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pDescriptorSets-00358)"},
    {"VUID-vkCmdBindDescriptorSets-pDescriptorSets-01979", "For each dynamic uniform or storage buffer binding in pDescriptorSets, the sum of the effective offset, as defined above, and the range of the binding must be less than or equal to the size of the buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pDescriptorSets-01979)"},
    {"VUID-vkCmdBindDescriptorSets-pDescriptorSets-parameter", "pDescriptorSets must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSet handles (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pDescriptorSets-parameter)"},
    {"VUID-vkCmdBindDescriptorSets-pDynamicOffsets-01971", "Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pDynamicOffsets-01971)"},
    {"VUID-vkCmdBindDescriptorSets-pDynamicOffsets-01972", "Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pDynamicOffsets-01972)"},
    {"VUID-vkCmdBindDescriptorSets-pDynamicOffsets-parameter", "If dynamicOffsetCount is not 0, pDynamicOffsets must be a valid pointer to an array of dynamicOffsetCount uint32_t values (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pDynamicOffsets-parameter)"},
    {"VUID-vkCmdBindDescriptorSets-pipelineBindPoint-00361", "pipelineBindPoint must be supported by the commandBuffer's parent VkCommandPool's queue family (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pipelineBindPoint-00361)"},
    {"VUID-vkCmdBindDescriptorSets-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindDescriptorSets-pipelineBindPoint-parameter)"},
    {"VUID-vkCmdBindIndexBuffer-buffer-00433", "buffer must have been created with the VK_BUFFER_USAGE_INDEX_BUFFER_BIT flag (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-buffer-00433)"},
    {"VUID-vkCmdBindIndexBuffer-buffer-00434", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-buffer-00434)"},
    {"VUID-vkCmdBindIndexBuffer-buffer-parameter", "buffer must be a valid VkBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-buffer-parameter)"},
    {"VUID-vkCmdBindIndexBuffer-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBindIndexBuffer-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-commandBuffer-parameter)"},
    {"VUID-vkCmdBindIndexBuffer-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-commandBuffer-recording)"},
    {"VUID-vkCmdBindIndexBuffer-commonparent", "Both of buffer, and commandBuffer must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-commonparent)"},
    {"VUID-vkCmdBindIndexBuffer-indexType-02507", "indexType must not be VK_INDEX_TYPE_NONE_NV. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-indexType-02507)"},
    {"VUID-vkCmdBindIndexBuffer-indexType-02765", "If indexType is VK_INDEX_TYPE_UINT8_EXT, the indexTypeUint8 feature must be enabled (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-indexType-02765)"},
    {"VUID-vkCmdBindIndexBuffer-indexType-parameter", "indexType must be a valid VkIndexType value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-indexType-parameter)"},
    {"VUID-vkCmdBindIndexBuffer-offset-00431", "offset must be less than the size of buffer (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-offset-00431)"},
    {"VUID-vkCmdBindIndexBuffer-offset-00432", "The sum of offset and the address of the range of VkDeviceMemory object that is backing buffer, must be a multiple of the type indicated by indexType (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindIndexBuffer-offset-00432)"},
    {"VUID-vkCmdBindPipeline-None-02323", "This command must not be recorded when transform feedback is active (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-None-02323)"},
    {"VUID-vkCmdBindPipeline-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics, or compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBindPipeline-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-commandBuffer-parameter)"},
    {"VUID-vkCmdBindPipeline-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-commandBuffer-recording)"},
    {"VUID-vkCmdBindPipeline-commonparent", "Both of commandBuffer, and pipeline must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-commonparent)"},
    {"VUID-vkCmdBindPipeline-pipeline-00781", "If the variable multisample rate feature is not supported, pipeline is a graphics pipeline, the current subpass has no attachments, and this is not the first call to this function with a graphics pipeline after transitioning to the current subpass, then the sample count specified by this pipeline must match that set in the previous pipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipeline-00781)"},
    {"VUID-vkCmdBindPipeline-pipeline-parameter", "pipeline must be a valid VkPipeline handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipeline-parameter)"},
    {"VUID-vkCmdBindPipeline-pipelineBindPoint-00777", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_COMPUTE, the VkCommandPool that commandBuffer was allocated from must support compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipelineBindPoint-00777)"},
    {"VUID-vkCmdBindPipeline-pipelineBindPoint-00778", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_GRAPHICS, the VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipelineBindPoint-00778)"},
    {"VUID-vkCmdBindPipeline-pipelineBindPoint-00779", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_COMPUTE, pipeline must be a compute pipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipelineBindPoint-00779)"},
    {"VUID-vkCmdBindPipeline-pipelineBindPoint-00780", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_GRAPHICS, pipeline must be a graphics pipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipelineBindPoint-00780)"},
    {"VUID-vkCmdBindPipeline-pipelineBindPoint-02391", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_RAY_TRACING_NV, the VkCommandPool that commandBuffer was allocated from must support compute operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipelineBindPoint-02391)"},
    {"VUID-vkCmdBindPipeline-pipelineBindPoint-02392", "If pipelineBindPoint is VK_PIPELINE_BIND_POINT_RAY_TRACING_NV, the pipeline must be a ray tracing pipeline (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipelineBindPoint-02392)"},
    {"VUID-vkCmdBindPipeline-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-pipelineBindPoint-parameter)"},
    {"VUID-vkCmdBindPipeline-variableSampleLocations-01525", "If VkPhysicalDeviceSampleLocationsPropertiesEXT::variableSampleLocations is VK_FALSE, and pipeline is a graphics pipeline created with a VkPipelineSampleLocationsStateCreateInfoEXT structure having its sampleLocationsEnable member set to VK_TRUE but without VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT enabled then the current render pass instance must have been begun by specifying a VkRenderPassSampleLocationsBeginInfoEXT structure whose pPostSubpassSampleLocations member contains an element with a subpassIndex matching the current subpass index and the sampleLocationsInfo member of that element must match the sampleLocationsInfo specified in VkPipelineSampleLocationsStateCreateInfoEXT when the pipeline was created (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindPipeline-variableSampleLocations-01525)"},
    {"VUID-vkCmdBindShadingRateImageNV-None-02058", "The shading rate image feature must be enabled. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-None-02058)"},
    {"VUID-vkCmdBindShadingRateImageNV-commandBuffer-cmdpool", "The VkCommandPool that commandBuffer was allocated from must support graphics operations (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-commandBuffer-cmdpool)"},
    {"VUID-vkCmdBindShadingRateImageNV-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-commandBuffer-parameter)"},
    {"VUID-vkCmdBindShadingRateImageNV-commandBuffer-recording", "commandBuffer must be in the recording state (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-commandBuffer-recording)"},
    {"VUID-vkCmdBindShadingRateImageNV-commonparent", "Both of commandBuffer, and imageView that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-commonparent)"},
    {"VUID-vkCmdBindShadingRateImageNV-imageLayout-02063", "If imageView is not VK_NULL_HANDLE, imageLayout must be VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV or VK_IMAGE_LAYOUT_GENERAL. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-imageLayout-02063)"},
    {"VUID-vkCmdBindShadingRateImageNV-imageLayout-parameter", "imageLayout must be a valid VkImageLayout value (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-imageLayout-parameter)"},
    {"VUID-vkCmdBindShadingRateImageNV-imageView-02059", "If imageView is not VK_NULL_HANDLE, it must be a valid VkImageView handle of type VK_IMAGE_VIEW_TYPE_2D or VK_IMAGE_VIEW_TYPE_2D_ARRAY. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-imageView-02059)"},
    {"VUID-vkCmdBindShadingRateImageNV-imageView-02060", "If imageView is not VK_NULL_HANDLE, it must have a format of VK_FORMAT_R8_UINT. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-imageView-02060)"},
    {"VUID-vkCmdBindShadingRateImageNV-imageView-02061", "If imageView is not VK_NULL_HANDLE, it must have been created with a usage value including VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-imageView-02061)"},
    {"VUID-vkCmdBindShadingRateImageNV-imageView-02062", "If imageView is not VK_NULL_HANDLE, imageLayout must match the actual VkImageLayout of each subresource accessible from imageView at the time the subresource is accessed. (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-imageView-02062)"},
    {"VUID-vkCmdBindShadingRateImageNV-imageView-parameter", "If imageView is not VK_NULL_HANDLE, imageView must be a valid VkImageView handle (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindShadingRateImageNV-imageView-parameter)"},
    {"VUID-vkCmdBindTransformFeedbackBuffersEXT-None-02365", "Transform feedback must not be active when the vkCmdBindTransformFeedbackBuffersEXT command is recorded (https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VUID-vkCmdBindTransformFeedbackBuffersEXT-None-02365)"},
    {"VUID-vkCmdBindTransformFeedbackBuffersEXT-bindingCount-arraylength", "If pSizes is not NULL, bindingCount must be greater than 0 (https://www.khronos.org/registry/vulkan/specs/1.