/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheControllerFactory;
import org.gradle.caching.internal.controller.RootBuildCacheControllerRef;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.GZipBuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.TarBuildCacheEntryPacker;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.snapshot.FileSystemMirror;
import org.gradle.internal.time.Clock;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;

public class BuildCacheServices {
    private static final Path ROOT_BUILD_SRC_PATH = Path.path((String)":buildSrc");

    BuildCacheEntryPacker createResultPacker(FileSystem fileSystem, StreamHasher fileHasher, StringInterner stringInterner) {
        return new GZipBuildCacheEntryPacker((BuildCacheEntryPacker)new TarBuildCacheEntryPacker(fileSystem, fileHasher, stringInterner));
    }

    OriginMetadataFactory createOriginMetadataFactory(Clock clock, InetAddressFactory inetAddressFactory, GradleInternal gradleInternal, BuildInvocationScopeId buildInvocationScopeId) {
        File rootDir = gradleInternal.getRootProject().getRootDir();
        return new OriginMetadataFactory(clock, inetAddressFactory, rootDir, SystemProperties.getInstance().getUserName(), OperatingSystem.current().getName(), GradleVersion.current(), buildInvocationScopeId.getId());
    }

    BuildCacheCommandFactory createBuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, FileSystemMirror fileSystemMirror, StringInterner stringInterner) {
        return new BuildCacheCommandFactory(packer, originMetadataFactory, fileSystemMirror, stringInterner);
    }

    BuildCacheController createBuildCacheController(ServiceRegistry serviceRegistry, BuildCacheConfigurationInternal buildCacheConfiguration, BuildOperationExecutor buildOperationExecutor, InstantiatorFactory instantiatorFactory, GradleInternal gradle, RootBuildCacheControllerRef rootControllerRef) {
        if (this.isRoot(gradle) || this.isRootBuildSrc(gradle) || this.isGradleBuildTaskRoot(rootControllerRef)) {
            return this.doCreateBuildCacheController(serviceRegistry, buildCacheConfiguration, buildOperationExecutor, instantiatorFactory, gradle);
        }
        return rootControllerRef.getForNonRootBuild();
    }

    private boolean isGradleBuildTaskRoot(RootBuildCacheControllerRef rootControllerRef) {
        return !rootControllerRef.isSet();
    }

    private boolean isRootBuildSrc(GradleInternal gradle) {
        return gradle.getIdentityPath().equals((Object)ROOT_BUILD_SRC_PATH);
    }

    private boolean isRoot(GradleInternal gradle) {
        return gradle.getParent() == null;
    }

    private BuildCacheController doCreateBuildCacheController(ServiceRegistry serviceRegistry, BuildCacheConfigurationInternal buildCacheConfiguration, BuildOperationExecutor buildOperationExecutor, InstantiatorFactory instantiatorFactory, GradleInternal gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        Path buildIdentityPath = gradle.getIdentityPath();
        File gradleUserHomeDir = gradle.getGradleUserHomeDir();
        BuildCacheControllerFactory.BuildCacheMode buildCacheMode = startParameter.isBuildCacheEnabled() ? BuildCacheControllerFactory.BuildCacheMode.ENABLED : BuildCacheControllerFactory.BuildCacheMode.DISABLED;
        BuildCacheControllerFactory.RemoteAccessMode remoteAccessMode = startParameter.isOffline() ? BuildCacheControllerFactory.RemoteAccessMode.OFFLINE : BuildCacheControllerFactory.RemoteAccessMode.ONLINE;
        boolean logStackTraces = startParameter.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
        boolean emitDebugLogging = startParameter.isBuildCacheDebugLogging();
        return BuildCacheControllerFactory.create((BuildOperationExecutor)buildOperationExecutor, (Path)buildIdentityPath, (File)gradleUserHomeDir, (BuildCacheConfigurationInternal)buildCacheConfiguration, (BuildCacheControllerFactory.BuildCacheMode)buildCacheMode, (BuildCacheControllerFactory.RemoteAccessMode)remoteAccessMode, (boolean)logStackTraces, (boolean)emitDebugLogging, (Instantiator)instantiatorFactory.inject((ServiceLookup)serviceRegistry));
    }
}

