/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.AbstractParallelFtilesBuilder;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBlackBlock;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ParallelBuilderFork
extends AbstractParallelFtilesBuilder {
    private final String label;
    private final Swimlane in;
    private final Swimlane out;

    public ParallelBuilderFork(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> list, Ftile inner, String label, Swimlane in, Swimlane out) {
        super(skinParam, stringBounder, list, inner);
        this.label = label;
        this.in = in;
        this.out = out;
    }

    @Override
    protected Swimlane swimlaneOutForStep2() {
        return this.out;
    }

    @Override
    protected Ftile doStep1() {
        Ftile result = this.getMiddle();
        ArrayList<Connection> conns = new ArrayList<Connection>();
        Swimlane swimlaneBlack = this.in;
        FtileBlackBlock black = new FtileBlackBlock(this.skinParam(), this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityBar), swimlaneBlack);
        double x = 0.0;
        for (Ftile tmp : this.getList()) {
            Rainbow def;
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            if (SkinParam.USE_STYLES()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                def = Rainbow.build(style, this.skinParam().getIHtmlColorSet());
            } else {
                def = Rainbow.build(this.skinParam());
            }
            Rainbow rainbow = tmp.getInLinkRendering().getRainbow(def);
            conns.add(new ConnectionIn(black, tmp, x, rainbow));
            x += ((Dimension2D)dim).getWidth();
        }
        result = FtileUtils.addConnection(result, conns);
        black.setBlackBlockDimension(result.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        return new FtileAssemblySimple(black, result);
    }

    @Override
    protected Ftile doStep2(Ftile result) {
        Swimlane swimlaneBlack = this.out;
        FtileBlackBlock out = new FtileBlackBlock(this.skinParam(), this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityBar), swimlaneBlack);
        out.setBlackBlockDimension(result.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        if (this.label != null) {
            out.setLabel(this.getTextBlock(Display.getWithNewlines(this.label)));
        }
        result = new FtileAssemblySimple(result, out);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        double x = 0.0;
        for (Ftile tmp : this.getList()) {
            Rainbow def;
            UTranslate translate0 = new UTranslate(0.0, 6.0);
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            if (SkinParam.USE_STYLES()) {
                Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                def = Rainbow.build(style, this.skinParam().getIHtmlColorSet());
            } else {
                def = Rainbow.build(this.skinParam());
            }
            Rainbow rainbow = tmp.getOutLinkRendering().getRainbow(def);
            conns.add(new ConnectionOut(translate0, tmp, out, x, rainbow, this.getHeightOfMiddle()));
            x += ((Dimension2D)dim).getWidth();
        }
        result = FtileUtils.addConnection(result, conns);
        return result;
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final Display label;

        public ConnectionIn(Ftile ftile1, Ftile ftile2, double x, Rainbow arrowColor) {
            super(ftile1, ftile2);
            this.label = ftile2.getInLinkRendering().getDisplay();
            this.x = x;
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            snake.addPoint(geo.getLeft(), 0.0);
            snake.addPoint(geo.getLeft(), geo.getInY());
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            Point2D.Double p1 = new Point2D.Double(geo.getLeft(), 0.0);
            Point2D.Double p2 = new Point2D.Double(geo.getLeft(), geo.getInY());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = mp1a.getY() + 4.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            snake.setIgnoreForCompression(true);
            ug.draw(snake);
        }
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final double height;
        private final Display label;
        private final UTranslate translate0;

        public ConnectionOut(UTranslate translate0, Ftile ftile1, Ftile ftile2, double x, Rainbow arrowColor, double height) {
            super(ftile1, ftile2);
            this.translate0 = translate0;
            this.label = ftile1.getOutLinkRendering().getDisplay();
            this.x = x;
            this.arrowColor = arrowColor;
            this.height = height;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile1().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            if (!geo.hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            Point2D p1 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), geo.getOutY()));
            Point2D p2 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), this.height));
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(new UTranslate(this.x, 0.0));
            FtileGeometry geo = this.getFtile1().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), geo.getOutY()));
            Point2D p2 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), this.height));
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = mp2b.getY() - 14.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            snake.setIgnoreForCompression(true);
            ug.draw(snake);
        }
    }
}

