/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineList;
import net.sourceforge.plantuml.preproc2.ReadFilter;
import net.sourceforge.plantuml.preproc2.ReadLineQuoteComment;
import net.sourceforge.plantuml.utils.StartUtils;

public class ReadLineAddConfig
implements ReadFilter {
    private final List<String> config;

    public ReadLineAddConfig(List<String> config) {
        this.config = config;
    }

    @Override
    public ReadLine applyFilter(final ReadLine raw) {
        return new ReadLine(){
            private ReadLine inserted;

            @Override
            public void close() throws IOException {
                raw.close();
            }

            @Override
            public StringLocated readLine() throws IOException {
                StringLocated result = null;
                if (this.inserted != null) {
                    result = this.inserted.readLine();
                    if (result == null) {
                        this.inserted.close();
                        this.inserted = null;
                    } else {
                        return result;
                    }
                }
                if ((result = raw.readLine()) != null && StartUtils.isArobaseStartDiagram(result.getString()) && ReadLineAddConfig.this.config.size() > 0) {
                    this.inserted = new ReadLineQuoteComment(false).applyFilter(new ReadLineList(ReadLineAddConfig.this.config, result.getLocation()));
                }
                return result;
            }
        };
    }
}

