/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.UIUtils;

public final class ProfilerPopup {
    private static final boolean DEBUG = Boolean.getBoolean("ProfilerPopup.DebugWindows");
    private static final int IGNORE_OWNER_TIMEOUT = Integer.getInteger("ProfilerPopup.OwnerTimeout", 40);
    private static final int RESIZE_STRIPE = Integer.getInteger("ProfilerPopup.ResizeStripe", 10);
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_TOP = 1;
    public static final int RESIZE_LEFT = 2;
    public static final int RESIZE_BOTTOM = 4;
    public static final int RESIZE_RIGHT = 8;
    private final Reference<Window> ownerRef;
    private final PopupPane content;
    private final Rectangle location;
    private final int popupAlign;
    private JWindow window;
    private Window owner;
    private Point ownerLocation;
    private final Listener listener;
    private final int resizeMode;

    public static ProfilerPopup create(Component component, Component component2, int n, int n2) {
        return ProfilerPopup.create(component, component2, n, n2, 0);
    }

    public static ProfilerPopup createRelative(Component component, Component component2, int n) {
        if (component == null) {
            throw new IllegalArgumentException("Invoker cannot be null for relative popups");
        }
        return ProfilerPopup.createRelative(component, component2, n, 0);
    }

    public static ProfilerPopup create(Component component, Component component2, int n, int n2, int n3) {
        return ProfilerPopup.create(component, component2, n, n2, n3, null);
    }

    public static ProfilerPopup createRelative(Component component, Component component2, int n, int n2) {
        if (component == null) {
            throw new IllegalArgumentException("Invoker cannot be null for relative popups");
        }
        return ProfilerPopup.createRelative(component, component2, n, n2, null);
    }

    public static ProfilerPopup create(Component component, Component component2, int n, int n2, int n3, Listener listener) {
        return ProfilerPopup.create(component, component2, n, n2, -1, n3, listener);
    }

    public static ProfilerPopup createRelative(Component component, Component component2, int n, int n2, Listener listener) {
        if (component == null) {
            throw new IllegalArgumentException("Invoker cannot be null for relative popups");
        }
        return ProfilerPopup.create(component, component2, -1, -1, n, n2, listener);
    }

    private static ProfilerPopup create(Component component, Component component2, int n, int n2, int n3, int n4, Listener listener) {
        Point point = new Point(n, n2);
        Dimension dimension = new Dimension();
        Window window = null;
        if (component != null) {
            SwingUtilities.convertPointToScreen(point, component);
            dimension.setSize(component.getSize());
            window = SwingUtilities.getWindowAncestor(component);
        }
        return new ProfilerPopup(component2, new Rectangle(point, dimension), n3, window, n4, listener);
    }

    public void show() {
        Serializable serializable;
        this.owner = this.ownerRef == null ? null : this.ownerRef.get();
        this.ownerLocation = this.owner == null ? null : this.owner.getLocationOnScreen();
        this.window = new JWindow(this.owner);
        this.window.setType(Window.Type.POPUP);
        this.window.setAlwaysOnTop(false);
        this.window.setFocusable(true);
        this.window.setFocusableWindowState(true);
        this.window.setAutoRequestFocus(true);
        this.window.getContentPane().add(this.content);
        this.window.pack();
        if (this.popupAlign == -1) {
            this.window.setLocation(this.location.getLocation());
        } else {
            int n;
            int n2;
            serializable = this.content.getSize();
            switch (this.popupAlign) {
                case 2: 
                case 3: 
                case 4: {
                    n2 = this.location.x + this.location.width - ((Dimension)serializable).width + 1;
                    break;
                }
                default: {
                    n2 = this.location.x + 1;
                }
            }
            switch (this.popupAlign) {
                case 1: 
                case 2: 
                case 8: {
                    n = this.location.y - ((Dimension)serializable).height + 1;
                    break;
                }
                default: {
                    n = this.location.y + this.location.height + 1;
                }
            }
            this.window.setLocation(n2, n);
        }
        this.window.setVisible(true);
        serializable = this.content.getFocusTraversalPolicy().getDefaultComponent(this.content);
        if (serializable != null) {
            ((Component)serializable).requestFocusInWindow();
        }
        this.content.installListeners();
        if (this.listener != null) {
            this.listener.popupShown();
        }
    }

    public void hide() {
        this.content.uninstallListeners();
        this.owner = null;
        this.ownerLocation = null;
        this.window.setVisible(false);
        this.window.dispose();
        this.window = null;
        if (this.listener != null) {
            this.listener.popupHidden();
        }
    }

    public static boolean isInPopup(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof PopupPane)) continue;
            return true;
        }
        return false;
    }

    private ProfilerPopup(Component component, Rectangle rectangle, int n, Window window, int n2, Listener listener) {
        this.content = new PopupPane(component, n2 != 0);
        this.location = rectangle;
        this.popupAlign = n;
        this.ownerRef = window == null ? null : new WeakReference<Window>(window);
        this.resizeMode = n2;
        this.listener = listener;
    }

    private static class PopupFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private PopupFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            List<Component> list = PopupFocusTraversalPolicy.components(container);
            int n = list.indexOf(component);
            return n == -1 || n == list.size() - 1 ? null : list.get(n + 1);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            List<Component> list = PopupFocusTraversalPolicy.components(container);
            int n = list.indexOf(component);
            return n == -1 || n == 0 ? null : list.get(n - 1);
        }

        @Override
        public Component getFirstComponent(Container container) {
            List<Component> list = PopupFocusTraversalPolicy.components(container);
            return list.isEmpty() ? null : list.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            List<Component> list = PopupFocusTraversalPolicy.components(container);
            return list.isEmpty() ? null : list.get(list.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            ButtonModel buttonModel;
            Component component = this.getFirstComponent(container);
            if (component instanceof AbstractButton && (buttonModel = ((AbstractButton)component).getModel()) instanceof DefaultButtonModel) {
                Enumeration<AbstractButton> enumeration;
                ButtonGroup buttonGroup = ((DefaultButtonModel)buttonModel).getGroup();
                Enumeration<AbstractButton> enumeration2 = enumeration = buttonGroup == null ? null : buttonGroup.getElements();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (!abstractButton.isSelected()) continue;
                    return abstractButton;
                }
            }
            return component;
        }

        private static List<Component> components(Container container) {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (component instanceof JPanel || component instanceof JToolBar) {
                    arrayList.addAll(PopupFocusTraversalPolicy.components((Container)component));
                    continue;
                }
                if (component instanceof JScrollPane) {
                    arrayList.addAll(PopupFocusTraversalPolicy.components(((JScrollPane)component).getViewport()));
                    continue;
                }
                if (!PopupFocusTraversalPolicy.focusable(component)) continue;
                arrayList.add(component);
            }
            return arrayList;
        }

        private static boolean focusable(Component component) {
            if (component instanceof JLabel || component instanceof Box.Filler) {
                return false;
            }
            return component.isVisible() && component.isEnabled() && component.isFocusable();
        }
    }

    private class PopupPane
    extends JPanel
    implements WindowFocusListener,
    ComponentListener,
    KeyEventDispatcher,
    MouseListener,
    MouseMotionListener {
        private boolean skippingEvents;
        private long gainedFocusTime;
        private boolean dragging;
        private int currentResizing;
        private int dragX;
        private int dragY;

        PopupPane(Component component, boolean bl) {
            super(new BorderLayout());
            this.dragY = -1;
            this.add(component, "Center");
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new PopupFocusTraversalPolicy());
            if (UIUtils.isAquaLookAndFeel()) {
                if (bl) {
                    this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                }
            } else {
                Border border = BorderFactory.createLineBorder(UIUtils.getDisabledLineColor());
                if (bl) {
                    this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(8, 8, 8, 8)));
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                } else {
                    this.setBorder(border);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dragging = true;
            this.dragX = mouseEvent.getXOnScreen();
            this.dragY = mouseEvent.getYOnScreen();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragging = false;
            this.dragX = -1;
            this.dragY = -1;
            this.updateResizing(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.dragging) {
                this.updateResizing(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.dragging) {
                this.currentResizing = 0;
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.dragging) {
                this.updateResizing(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragX >= 0 && this.dragY >= 0) {
                int n = mouseEvent.getXOnScreen();
                int n2 = mouseEvent.getYOnScreen();
                int n3 = n - this.dragX;
                int n4 = n2 - this.dragY;
                int n5 = ProfilerPopup.this.window.getX();
                int n6 = ProfilerPopup.this.window.getY();
                int n7 = ProfilerPopup.this.window.getWidth();
                int n8 = ProfilerPopup.this.window.getHeight();
                int n9 = 0;
                int n10 = 0;
                Dimension dimension = ProfilerPopup.this.window.getMinimumSize();
                if (this.isResizeLeft(this.currentResizing)) {
                    n5 += n3;
                    if ((n7 -= n3) < dimension.width) {
                        n9 = n7 - dimension.width;
                        n5 += n9;
                        n7 = dimension.width;
                    }
                } else if (this.isResizeRight(this.currentResizing) && (n7 += n3) < dimension.width) {
                    n9 = dimension.width - n7;
                    n7 = dimension.width;
                }
                if (this.isResizeTop(this.currentResizing)) {
                    n6 += n4;
                    if ((n8 -= n4) < dimension.height) {
                        n10 = n8 - dimension.height;
                        n6 += n10;
                        n8 = dimension.height;
                    }
                } else if (this.isResizeBottom(this.currentResizing) && (n8 += n4) < dimension.height) {
                    n10 = dimension.height - n8;
                    n8 = dimension.height;
                }
                ProfilerPopup.this.window.setBounds(n5, n6, n7, n8);
                ProfilerPopup.this.content.setSize(n7, n8);
                this.dragX = n + n9;
                this.dragY = n2 + n10;
            }
        }

        private void updateResizing(MouseEvent mouseEvent) {
            int n = 0;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (this.isResizeLeft(ProfilerPopup.this.resizeMode) && n2 < 8 && n2 >= 0) {
                n |= 2;
            } else if (this.isResizeRight(ProfilerPopup.this.resizeMode) && n2 > this.getWidth() - RESIZE_STRIPE && n2 < this.getWidth()) {
                n |= 8;
            }
            if (this.isResizeTop(ProfilerPopup.this.resizeMode) && n3 < 8 && n3 >= 0) {
                n |= 1;
            } else if (this.isResizeBottom(ProfilerPopup.this.resizeMode) && n3 > this.getHeight() - RESIZE_STRIPE && n3 < this.getHeight()) {
                n |= 4;
            }
            this.currentResizing = n;
            switch (this.currentResizing) {
                case 0: {
                    this.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                case 4: {
                    this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 8: {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(6));
                    break;
                }
                case 6: {
                    this.setCursor(Cursor.getPredefinedCursor(4));
                    break;
                }
                case 12: {
                    this.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 9: {
                    this.setCursor(Cursor.getPredefinedCursor(7));
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (ProfilerPopup.this.resizeMode > 0) {
                graphics.setColor(UIUtils.getDisabledLineColor());
                switch (ProfilerPopup.this.resizeMode) {
                    case 3: {
                        graphics.drawLine(0, 5, 5, 0);
                        graphics.drawLine(0, 9, 9, 0);
                        break;
                    }
                    case 9: {
                        int n = this.getWidth();
                        graphics.drawLine(n - 6, 0, n, 6);
                        graphics.drawLine(n - 10, 0, n, 10);
                        break;
                    }
                    case 6: {
                        int n = this.getHeight();
                        graphics.drawLine(0, n - 6, 6, n);
                        graphics.drawLine(0, n - 10, 10, n);
                        break;
                    }
                    default: {
                        int n = this.getWidth();
                        int n2 = this.getHeight();
                        graphics.drawLine(n, n2 - 7, n - 7, n2);
                        graphics.drawLine(n, n2 - 11, n - 11, n2);
                    }
                }
            }
        }

        boolean isResizeTop(int n) {
            return (n & 1) != 0;
        }

        boolean isResizeLeft(int n) {
            return (n & 2) != 0;
        }

        boolean isResizeBottom(int n) {
            return (n & 4) != 0;
        }

        boolean isResizeRight(int n) {
            return (n & 8) != 0;
        }

        void installListeners() {
            ProfilerPopup.this.window.addWindowFocusListener(this);
            if (ProfilerPopup.this.owner != null) {
                ProfilerPopup.this.owner.addComponentListener(this);
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        }

        void uninstallListeners() {
            ProfilerPopup.this.window.removeWindowFocusListener(this);
            if (ProfilerPopup.this.owner != null) {
                ProfilerPopup.this.owner.removeComponentListener(this);
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            this.skippingEvents = false;
            this.gainedFocusTime = System.currentTimeMillis();
            if (DEBUG) {
                System.err.println(">>> Focus to popup gained");
            }
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            if (this.skippingEvents) {
                return;
            }
            if (windowEvent.getOppositeWindow() instanceof Dialog) {
                final Dialog dialog = (Dialog)windowEvent.getOppositeWindow();
                if (dialog != ProfilerPopup.this.owner && dialog.isModal()) {
                    this.skippingEvents = true;
                    if (DEBUG) {
                        System.err.println(">>> LOST TO DIALOG " + this.getString(dialog) + " owned by " + this.getString(dialog.getOwner()));
                    }
                    final JWindow jWindow = ProfilerPopup.this.window;
                    final Component component = ProfilerPopup.this.window.getMostRecentFocusOwner();
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            if (DEBUG) {
                                System.err.println(">>> BLOCKING DIALOG CLOSED " + PopupPane.this.getString(dialog));
                            }
                            jWindow.requestFocus();
                            if (component != null) {
                                component.requestFocus();
                            }
                        }
                    });
                    return;
                }
            } else if (windowEvent.getOppositeWindow() == ProfilerPopup.this.owner) {
                long l = System.currentTimeMillis();
                if (DEBUG) {
                    System.err.println(">>> ### HIDDEN BY OWNER, gained focus before " + (l - this.gainedFocusTime));
                }
                if (l - this.gainedFocusTime < (long)IGNORE_OWNER_TIMEOUT) {
                    this.gainedFocusTime = 0L;
                    final JWindow jWindow = ProfilerPopup.this.window;
                    final Component component = ProfilerPopup.this.window.getMostRecentFocusOwner();
                    if (DEBUG) {
                        System.err.println(">>>   Requesting focus again to " + this.getString(component));
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jWindow.requestFocus();
                            if (component != null) {
                                component.requestFocus();
                            }
                            if (DEBUG) {
                                System.err.println(">>>       REQUESTED lazily");
                            }
                        }
                    });
                    return;
                }
            }
            ProfilerPopup.this.hide();
            if (DEBUG) {
                System.err.println(">>> Focus to popup lost to " + this.getString(windowEvent.getOppositeWindow()));
            }
        }

        private String getString(Component component) {
            if (component instanceof Dialog) {
                return "[dialog] " + ((Dialog)component).getTitle();
            }
            if (component instanceof Frame) {
                return "[frame] " + ((Frame)component).getTitle();
            }
            return component == null ? "null" : component.getClass().getName();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(">>> Closed by componentResized");
            }
            ProfilerPopup.this.hide();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            Point point = ProfilerPopup.this.owner.getLocationOnScreen();
            ProfilerPopup.this.window.setLocation(ProfilerPopup.this.window.getX() + (point.x - ((ProfilerPopup)ProfilerPopup.this).ownerLocation.x), ProfilerPopup.this.window.getY() + (point.y - ((ProfilerPopup)ProfilerPopup.this).ownerLocation.y));
            ProfilerPopup.this.ownerLocation = point;
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(">>> Closed by componentHidden");
            }
            ProfilerPopup.this.hide();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (this.skippingEvents || keyEvent.isConsumed()) {
                return false;
            }
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && SwingUtilities.getRootPane(this) != keyEvent.getSource()) {
                keyEvent.consume();
                if (DEBUG) {
                    System.err.println(">>> Closed by ESC");
                }
                ProfilerPopup.this.hide();
                return true;
            }
            return false;
        }
    }

    public static abstract class Listener {
        protected void popupShown() {
        }

        protected void popupHidden() {
        }
    }
}

