/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;

public class FreeColOptionPaneUI
extends BasicOptionPaneUI {
    private Component initialFocusComponent = null;
    private int okIndex = -1;
    private int cancelIndex = -1;
    private JButton[] newButtons = null;

    private FreeColOptionPaneUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new FreeColOptionPaneUI();
    }

    public Component getInitialFocusComponent() {
        return this.initialFocusComponent;
    }

    private int getColumns(int nButtons) {
        return nButtons > 21 ? 4 : (nButtons % 4 == 0 && nButtons > 12 ? 4 : (nButtons % 3 == 0 && nButtons > 6 ? 3 : (nButtons % 2 == 0 && nButtons > 4 ? 2 : (nButtons > 5 ? 2 : 1))));
    }

    private void prepareButtons(Object[] buttons) {
        if (this.newButtons != null) {
            return;
        }
        String okLabel = Messages.message("ok");
        String cancelLabel = Messages.message("cancel");
        this.newButtons = new JButton[buttons.length];
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < buttons.length; ++i) {
            JButton b;
            if (buttons[i] instanceof ChoiceItem) {
                ChoiceItem ci = (ChoiceItem)buttons[i];
                String label = ci.toString();
                ImageIcon icon = ci.getIcon();
                b = icon == null ? new JButton(label) : (label == null || label.isEmpty() ? new JButton(icon) : new JButton(label, icon));
                b.setName("OptionPane.button." + label);
                if (ci.isOK()) {
                    this.okIndex = i;
                } else if (ci.isCancel()) {
                    this.cancelIndex = i;
                }
            } else if (buttons[i] instanceof Icon) {
                b = new JButton((Icon)buttons[i]);
                b.setName("OptionPane.button.withIcon");
            } else {
                String label = buttons[i].toString();
                b = new JButton(label);
                b.setName("OptionPane.button." + label);
                if (okLabel.equals(label)) {
                    this.okIndex = i;
                } else if (cancelLabel.equals(label)) {
                    this.cancelIndex = i;
                }
            }
            maxWidth = Math.max(maxWidth, b.getMinimumSize().width);
            maxHeight = Math.max(maxHeight, b.getMinimumSize().height);
            ActionListener buttonListener = this.createButtonActionListener(i);
            if (buttonListener != null) {
                b.addActionListener(buttonListener);
            }
            this.newButtons[i] = b;
        }
        if (maxWidth > 0) {
            Dimension dimension = new Dimension(maxWidth, maxHeight);
            for (int i = 0; i < buttons.length; ++i) {
                if (buttons[i] instanceof Icon) continue;
                this.newButtons[i].setPreferredSize(dimension);
                this.newButtons[i].setMinimumSize(dimension);
            }
        }
    }

    @Override
    protected Container createButtonArea() {
        Object[] buttons = this.getButtons();
        this.prepareButtons(buttons);
        MigPanel bottom = this.okIndex >= 0 ? new MigPanel(new MigLayout("insets dialog")) : new MigPanel(new MigLayout("wrap " + this.getColumns(buttons.length)));
        bottom.setOpaque(false);
        bottom.setName("OptionPane.buttonArea");
        this.addButtonComponents(bottom, buttons, this.getInitialValueIndex());
        bottom.setSize(bottom.getPreferredSize());
        return bottom;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        int i;
        if (buttons == null) {
            return;
        }
        if (0 <= initialIndex && initialIndex < buttons.length) {
            JButton b = this.newButtons[initialIndex];
            this.initialFocusComponent = b;
            b.addHierarchyListener(e -> {
                JButton button;
                JRootPane root;
                if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(button = (JButton)e.getComponent())) != null) {
                    root.setDefaultButton(button);
                }
            });
        }
        if (this.okIndex >= 0) {
            if (this.cancelIndex >= 0) {
                container.add((Component)this.newButtons[this.cancelIndex], "tag cancel");
            }
            container.add((Component)this.newButtons[this.okIndex], "tag ok");
            for (i = 0; i < buttons.length; ++i) {
                if (i == this.okIndex || i == this.cancelIndex) continue;
                container.add(this.newButtons[i]);
            }
        } else {
            for (i = 0; i < buttons.length; ++i) {
                if (i == this.cancelIndex) continue;
                container.add(this.newButtons[i]);
            }
            if (this.cancelIndex >= 0) {
                container.add((Component)this.newButtons[this.cancelIndex], "newline 20, tag cancel");
            }
        }
        Dimension prefer = container.getPreferredSize();
        prefer = new Dimension((int)(prefer.getWidth() + 100.0), (int)prefer.getHeight());
        container.setMinimumSize(prefer);
        container.setPreferredSize(prefer);
    }

    @Override
    public void selectInitialValue(JOptionPane op) {
        if (this.initialFocusComponent != null) {
            JRootPane root;
            this.initialFocusComponent.requestFocus();
            if (this.initialFocusComponent instanceof JButton && (root = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                root.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            ImageLibrary.drawTiledImage("image.background.FreeColOptionPane", g, c, null);
        }
    }
}

