/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsDiff;
import org.netbeans.lib.profiler.results.jdbc.StringCache;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public class JdbcResultsSnapshot
extends ResultsSnapshot {
    private JMethodIdTable table;
    String[] selectNames;
    long[] invocationsPerSelectId;
    long[] timePerSelectId;
    int[] typeForSelectId;
    int[] commandTypeForSelectId;
    String[][] tablesForSelectId;
    private RuntimeMemoryCCTNode[] stacksForSelects;
    int nProfiledSelects;

    public JdbcResultsSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcResultsSnapshot(long l, long l2, JdbcCCTProvider jdbcCCTProvider, ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        super(l, l2);
        jdbcCCTProvider.beginTrans(false);
        try {
            this.performInit(profilerClient, jdbcCCTProvider);
        }
        finally {
            jdbcCCTProvider.endTrans();
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.debugValues();
            }
        }
    }

    public String getSelectName(int n) {
        return this.selectNames[n];
    }

    public String[] getSelectNames() {
        return this.selectNames;
    }

    public JMethodIdTable getJMethodIdTable() {
        return this.table;
    }

    public int getNProfiledSelects() {
        return this.nProfiledSelects;
    }

    public long[] getInvocationsPerSelectId() {
        return this.invocationsPerSelectId;
    }

    public long[] getTimePerSelectId() {
        return this.timePerSelectId;
    }

    public int[] getTypeForSelectId() {
        return this.typeForSelectId;
    }

    public int[] getCommandTypeForSelectId() {
        return this.commandTypeForSelectId;
    }

    public String[][] getTablesForSelectId() {
        return this.tablesForSelectId;
    }

    public boolean containsStacks() {
        return this.stacksForSelects != null;
    }

    public void filterReverse(String string, int n, int n2, boolean bl, PresoObjAllocCCTNode presoObjAllocCCTNode, int n3, boolean bl2) {
        PresoObjAllocCCTNode presoObjAllocCCTNode2 = this.createPresentationCCT(n3, bl2);
        this.filter(string, n, presoObjAllocCCTNode2);
        presoObjAllocCCTNode.children = presoObjAllocCCTNode2.children;
        if (presoObjAllocCCTNode.children != null) {
            for (PresoObjAllocCCTNode presoObjAllocCCTNode3 : presoObjAllocCCTNode.children) {
                presoObjAllocCCTNode3.parent = presoObjAllocCCTNode;
            }
            presoObjAllocCCTNode.sortChildren(n2, bl);
        }
        if (!FilterSortSupport.passesFilter(string, n, presoObjAllocCCTNode.getNodeName())) {
            // empty if block
        }
    }

    private void filter(String string, int n, PresoObjAllocCCTNode presoObjAllocCCTNode) {
        if (presoObjAllocCCTNode.children != null) {
            PresoObjAllocCCTNode presoObjAllocCCTNode2 = null;
            ArrayList<PresoObjAllocCCTNode> arrayList = new ArrayList<PresoObjAllocCCTNode>();
            for (PresoObjAllocCCTNode presoObjAllocCCTNode3 : presoObjAllocCCTNode.children) {
                PresoObjAllocCCTNode presoObjAllocCCTNode4 = presoObjAllocCCTNode3;
                if (FilterSortSupport.passesFilter(string, n, presoObjAllocCCTNode4.getNodeName())) {
                    int n2 = arrayList.indexOf(presoObjAllocCCTNode4);
                    if (n2 == -1) {
                        arrayList.add(presoObjAllocCCTNode4);
                        continue;
                    }
                    ((PresoObjAllocCCTNode)arrayList.get(n2)).merge(presoObjAllocCCTNode4);
                    continue;
                }
                if (presoObjAllocCCTNode2 == null) {
                    presoObjAllocCCTNode2 = presoObjAllocCCTNode4;
                    arrayList.add(presoObjAllocCCTNode4);
                    continue;
                }
                presoObjAllocCCTNode2.merge(presoObjAllocCCTNode4);
            }
            if (arrayList.isEmpty()) {
                presoObjAllocCCTNode.children = null;
            } else if (presoObjAllocCCTNode.isFiltered() && presoObjAllocCCTNode2 != null && arrayList.size() == 1) {
                PresoObjAllocCCTNode presoObjAllocCCTNode5 = (PresoObjAllocCCTNode)arrayList.get(0);
                this.filter(string, n, presoObjAllocCCTNode5);
                presoObjAllocCCTNode.children = presoObjAllocCCTNode5.children;
            } else {
                presoObjAllocCCTNode.children = arrayList.toArray(new PresoObjAllocCCTNode[0]);
            }
            if (presoObjAllocCCTNode.children != null) {
                for (PresoObjAllocCCTNode presoObjAllocCCTNode3 : presoObjAllocCCTNode.children) {
                    this.filter(string, n, presoObjAllocCCTNode3);
                }
            }
        }
    }

    public PresoObjAllocCCTNode createPresentationCCT(int n, boolean bl) {
        if (this.stacksForSelects == null) {
            return null;
        }
        RuntimeMemoryCCTNode runtimeMemoryCCTNode = this.stacksForSelects[n];
        if (runtimeMemoryCCTNode == null) {
            return null;
        }
        return this.createPresentationCCT(runtimeMemoryCCTNode, n, bl);
    }

    public JdbcResultsSnapshot createDiff(JdbcResultsSnapshot jdbcResultsSnapshot) {
        if (!(jdbcResultsSnapshot instanceof JdbcResultsSnapshot)) {
            return null;
        }
        return new JdbcResultsDiff(this, jdbcResultsSnapshot);
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.readFromStream(dataInputStream);
        StringCache stringCache = new StringCache();
        this.nProfiledSelects = dataInputStream.readInt();
        this.selectNames = new String[this.nProfiledSelects];
        this.invocationsPerSelectId = new long[this.nProfiledSelects];
        this.timePerSelectId = new long[this.nProfiledSelects];
        this.typeForSelectId = new int[this.nProfiledSelects];
        this.commandTypeForSelectId = new int[this.nProfiledSelects];
        this.tablesForSelectId = new String[this.nProfiledSelects][];
        for (n2 = 1; n2 < this.nProfiledSelects; ++n2) {
            this.selectNames[n2] = dataInputStream.readUTF();
            this.invocationsPerSelectId[n2] = dataInputStream.readLong();
            this.timePerSelectId[n2] = dataInputStream.readLong();
            this.typeForSelectId[n2] = dataInputStream.readInt();
            this.commandTypeForSelectId[n2] = dataInputStream.readInt();
            this.tablesForSelectId[n2] = new String[dataInputStream.readInt()];
            for (n = 0; n < this.tablesForSelectId[n2].length; ++n) {
                this.tablesForSelectId[n2][n] = stringCache.intern(dataInputStream.readUTF());
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.stacksForSelects = new RuntimeMemoryCCTNode[n2];
            for (n = 0; n < n2; ++n) {
                int n3 = dataInputStream.readInt();
                if (n3 == 0) continue;
                this.stacksForSelects[n] = RuntimeMemoryCCTNode.create(n3);
                this.stacksForSelects[n].readFromStream(dataInputStream);
            }
            if (dataInputStream.readBoolean()) {
                this.table = new JMethodIdTable();
                this.table.readFromStream(dataInputStream);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        int n;
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.nProfiledSelects);
        for (n = 1; n < this.nProfiledSelects; ++n) {
            dataOutputStream.writeUTF(this.selectNames[n]);
            dataOutputStream.writeLong(this.invocationsPerSelectId[n]);
            dataOutputStream.writeLong(this.timePerSelectId[n]);
            dataOutputStream.writeInt(this.typeForSelectId[n]);
            dataOutputStream.writeInt(this.commandTypeForSelectId[n]);
            dataOutputStream.writeInt(this.tablesForSelectId[n].length);
            for (int i = 0; i < this.tablesForSelectId[n].length; ++i) {
                dataOutputStream.writeUTF(this.tablesForSelectId[n][i]);
            }
        }
        dataOutputStream.writeBoolean(this.stacksForSelects != null);
        if (this.stacksForSelects != null) {
            dataOutputStream.writeInt(this.stacksForSelects.length);
            for (n = 0; n < this.stacksForSelects.length; ++n) {
                if (this.stacksForSelects[n] == null) {
                    dataOutputStream.writeInt(0);
                    continue;
                }
                dataOutputStream.writeInt(this.stacksForSelects[n].getType());
                this.stacksForSelects[n].writeToStream(dataOutputStream);
            }
            dataOutputStream.writeBoolean(this.table != null);
            if (this.table != null) {
                this.table.writeToStream(dataOutputStream);
            }
        }
    }

    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, boolean bl) {
        return PresoObjAllocCCTNode.createPresentationCCTFromSnapshot(this.getJMethodIdTable(), runtimeMemoryCCTNode, this.getSelectName(n));
    }

    protected void performInit(ProfilerClient profilerClient, JdbcCCTProvider jdbcCCTProvider) throws ClientUtils.TargetAppOrVMTerminated {
        FlatProfileContainer flatProfileContainer = jdbcCCTProvider.createFlatProfile();
        if (flatProfileContainer != null) {
            int n;
            this.nProfiledSelects = flatProfileContainer.getNRows() + 1;
            this.invocationsPerSelectId = new long[this.nProfiledSelects];
            this.timePerSelectId = new long[this.nProfiledSelects];
            this.typeForSelectId = new int[this.nProfiledSelects];
            this.commandTypeForSelectId = new int[this.nProfiledSelects];
            this.tablesForSelectId = new String[this.nProfiledSelects][];
            this.selectNames = new String[this.nProfiledSelects];
            for (int i = 0; i < flatProfileContainer.getNRows(); ++i) {
                n = flatProfileContainer.getMethodIdAtRow(i);
                this.selectNames[n] = flatProfileContainer.getMethodNameAtRow(i);
                this.invocationsPerSelectId[n] = flatProfileContainer.getNInvocationsAtRow(i);
                this.timePerSelectId[n] = flatProfileContainer.getTotalTimeInMcs0AtRow(i);
                this.typeForSelectId[n] = jdbcCCTProvider.getCommandType(n);
                this.commandTypeForSelectId[n] = jdbcCCTProvider.getSQLCommand(n);
                this.tablesForSelectId[n] = jdbcCCTProvider.getTables(n);
            }
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = jdbcCCTProvider.getStacksForSelects();
            if (runtimeMemoryCCTNodeArray != null && this.checkContainsStacks(runtimeMemoryCCTNodeArray)) {
                this.stacksForSelects = new RuntimeMemoryCCTNode[runtimeMemoryCCTNodeArray.length];
                PresoObjAllocCCTNode.getNamesForMethodIdsFromVM(profilerClient, runtimeMemoryCCTNodeArray);
                for (n = 0; n < this.nProfiledSelects; ++n) {
                    if (runtimeMemoryCCTNodeArray[n] == null) continue;
                    this.stacksForSelects[n] = (RuntimeMemoryCCTNode)runtimeMemoryCCTNodeArray[n].clone();
                    this.updateTime(this.stacksForSelects[n], this.timePerSelectId[n] / this.invocationsPerSelectId[n]);
                }
                this.table = new JMethodIdTable(JMethodIdTable.getDefault());
            }
        } else {
            this.selectNames = new String[0];
        }
    }

    private boolean checkContainsStacks(RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray) {
        for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
            RuntimeMemoryCCTNode runtimeMemoryCCTNode = runtimeMemoryCCTNodeArray[i];
            if (runtimeMemoryCCTNode == null || runtimeMemoryCCTNode instanceof RuntimeObjAllocTermCCTNode || runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) continue;
            return true;
        }
        return false;
    }

    void debugValues() {
        LOGGER.finest("nProfiledSelects: " + this.nProfiledSelects);
        LOGGER.finest("stacksForSelects.length: " + this.debugLength(this.stacksForSelects));
        LOGGER.finest("invocationsPerSelectId.length: " + this.debugLength(this.invocationsPerSelectId));
        LOGGER.finest("timePerSelectId.length: " + this.debugLength(this.timePerSelectId));
        LOGGER.finest("typeForSelectId.length: " + this.debugLength(this.typeForSelectId));
        LOGGER.finest("commandTypeForSelectId.length: " + this.debugLength(this.commandTypeForSelectId));
        LOGGER.finest("tablesForSelectId.length: " + this.debugLength(this.tablesForSelectId));
        LOGGER.finest("selectNames.length: " + this.debugLength(this.selectNames));
        LOGGER.finest("table: " + (this.table == null ? "null" : this.table.debug()));
    }

    private void updateTime(RuntimeMemoryCCTNode runtimeMemoryCCTNode, long l) {
        Stack<Object> stack = new Stack<Object>();
        stack.add(runtimeMemoryCCTNode);
        while (!stack.empty()) {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
            RuntimeMemoryCCTNode runtimeMemoryCCTNode2 = (RuntimeMemoryCCTNode)stack.pop();
            if (runtimeMemoryCCTNode2 instanceof RuntimeObjAllocTermCCTNode) {
                runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])runtimeMemoryCCTNode2;
                runtimeMemoryCCTNodeArray.totalObjSize = l * runtimeMemoryCCTNodeArray.nCalls;
            }
            if (runtimeMemoryCCTNode2.children == null) continue;
            if (runtimeMemoryCCTNode2.children instanceof RuntimeMemoryCCTNode) {
                stack.push(runtimeMemoryCCTNode2.children);
                continue;
            }
            runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])runtimeMemoryCCTNode2.children;
            for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
                stack.push(runtimeMemoryCCTNodeArray[i]);
            }
        }
    }
}

