/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;

abstract class BimorphicCallSite
extends CachingCallSite {
    protected CacheEntry secondaryCache = CacheEntry.NULL_CACHE;

    public BimorphicCallSite(String methodName) {
        super(methodName, CallType.NORMAL);
    }

    public final CacheEntry getSecondaryCache() {
        return this.secondaryCache;
    }

    protected CacheEntry setSecondaryCache(CacheEntry entry, IRubyObject self2) {
        this.secondaryCache = entry;
        return this.secondaryCache;
    }

    public final CacheEntry retrieveSecondaryCache(IRubyObject self2) {
        CacheEntry cache = this.secondaryCache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache;
        }
        return this.cacheAndGetSecondary(self2, selfType, this.methodName);
    }

    public boolean isSecondaryBuiltin(IRubyObject self2) {
        CacheEntry cache = this.secondaryCache;
        RubyClass selfType = RubyBasicObject.getMetaClass(self2);
        if (cache.typeOk(selfType)) {
            return cache.method.isBuiltin();
        }
        return this.cacheAndGetSecondary((IRubyObject)self2, (RubyClass)selfType, (String)this.methodName).method.isBuiltin();
    }

    private CacheEntry cacheAndGetSecondary(IRubyObject self2, RubyClass selfType, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        if (!entry.method.isUndefined()) {
            entry = this.setSecondaryCache(entry, self2);
        }
        return entry;
    }
}

