/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.context;

import java.util.Timer;
import java.util.TimerTask;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;

public class ContextRefreshThread
extends TimerTask {
    private static final long PERIOD = 500L;
    private final Timer timer = new Timer("Context Refresh Thread", true);
    private final GraphModel graphModel;
    private final Runnable listener;
    private GraphObserver observer;

    public ContextRefreshThread(GraphModel graphModel, Runnable listener) {
        this.graphModel = graphModel;
        this.listener = listener;
        this.timer.schedule((TimerTask)this, 500L, 500L);
    }

    private boolean initObserver() {
        if (this.observer == null || this.observer.isDestroyed() || this.observer.getGraph().getView() != this.graphModel.getVisibleView()) {
            if (this.observer != null && !this.observer.isDestroyed()) {
                this.observer.destroy();
            }
            this.observer = this.graphModel.createGraphObserver(this.graphModel.getGraphVisible(), false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Graph graph = this.graphModel.getGraph();
        boolean runListener = false;
        graph.writeLock();
        try {
            runListener = this.initObserver();
        }
        finally {
            graph.writeUnlock();
            graph.readUnlockAll();
        }
        if (!runListener) {
            runListener = this.observer.hasGraphChanged();
        }
        if (runListener) {
            graph.readLock();
            try {
                this.listener.run();
            }
            finally {
                graph.readUnlockAll();
            }
        }
    }

    public void shutdown() {
        this.timer.cancel();
        if (this.observer != null && !this.observer.isDestroyed()) {
            this.observer.destroy();
        }
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }
}

