/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.progress.module.DefaultHandleFactory;
import org.netbeans.progress.module.ProgressApiAccessor;
import org.openide.modules.PatchedPublic;
import org.openide.util.Cancellable;

public final class ProgressHandle {
    private static final Logger LOG = Logger.getLogger(ProgressHandle.class.getName());
    private InternalHandle internal;

    public static ProgressHandle createHandle(String displayName) {
        return ProgressHandle.createHandle(displayName, null);
    }

    public static ProgressHandle createHandle(String displayName, Cancellable allowToCancel) {
        return DefaultHandleFactory.get().createHandle(displayName, allowToCancel, true);
    }

    public static ProgressHandle createSystemHandle(String displayName, Cancellable allowToCancel) {
        return DefaultHandleFactory.get().createHandle(displayName, allowToCancel, false);
    }

    ProgressHandle(InternalHandle internal) {
        LOG.fine(internal.getDisplayName());
        this.internal = internal;
    }

    public final void start() {
        this.start(0, -1L);
    }

    public final void start(int workunits) {
        this.start(workunits, -1L);
    }

    public final void start(int workunits, long estimate) {
        this.internal.start("", workunits, estimate);
    }

    public final void switchToIndeterminate() {
        this.internal.toIndeterminate();
    }

    public final void suspend(String message) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: {1}", new Object[]{this.internal.getDisplayName(), message});
        }
        this.internal.toSilent(message);
    }

    public final void switchToDeterminate(int workunits) {
        this.internal.toDeterminate(workunits, -1L);
    }

    public final void switchToDeterminate(int workunits, long estimate) {
        this.internal.toDeterminate(workunits, estimate);
    }

    public final void finish() {
        this.internal.finish();
    }

    public final void progress(int workunit) {
        this.progress(null, workunit);
    }

    public final void progress(String message) {
        this.progress(message, -2);
    }

    public final void progress(String message, int workunit) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: {1}", new Object[]{this.internal.getDisplayName(), message});
        }
        this.internal.progress(message, workunit);
    }

    public final void setInitialDelay(int millis) {
        this.internal.setInitialDelay(millis);
    }

    public final void setDisplayName(String newDisplayName) {
        LOG.fine(newDisplayName);
        this.internal.requestDisplayNameChange(newDisplayName);
    }

    @PatchedPublic
    final InternalHandle getInternalHandle() {
        return this.internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDisplayName() {
        InternalHandle internalHandle = this.internal;
        synchronized (internalHandle) {
            return this.internal.getDisplayName();
        }
    }

    static {
        ProgressApiAccessor.setInstance(new Accessor());
    }

    static class Accessor
    extends ProgressApiAccessor {
        Accessor() {
        }

        @Override
        public ProgressHandle create(InternalHandle h) {
            return new ProgressHandle(h);
        }

        @Override
        public InternalHandle getInternalHandle(ProgressHandle h) {
            return h.getInternalHandle();
        }
    }
}

