/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.pqc.crypto.xmss;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.python.bouncycastle.pqc.crypto.xmss.HashTreeAddress;
import org.python.bouncycastle.pqc.crypto.xmss.LTreeAddress;
import org.python.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.python.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import org.python.bouncycastle.pqc.crypto.xmss.WOTSPlusPublicKeyParameters;
import org.python.bouncycastle.pqc.crypto.xmss.XMSS;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSNode;
import org.python.bouncycastle.pqc.crypto.xmss.XMSSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BDS
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient XMSS xmss;
    private transient WOTSPlus wotsPlus;
    private final int treeHeight;
    private int k;
    private XMSSNode root;
    private List<XMSSNode> authenticationPath;
    private Map<Integer, LinkedList<XMSSNode>> retain;
    private Stack<XMSSNode> stack;
    private List<TreeHash> treeHashInstances;
    private Map<Integer, XMSSNode> keep;
    private int index;

    protected BDS(XMSS xMSS) {
        if (xMSS == null) {
            throw new NullPointerException("xmss == null");
        }
        this.xmss = xMSS;
        this.wotsPlus = xMSS.getWOTSPlus();
        this.treeHeight = xMSS.getParams().getHeight();
        this.k = xMSS.getParams().getK();
        if (this.k > this.treeHeight || this.k < 2 || (this.treeHeight - this.k) % 2 != 0) {
            throw new IllegalArgumentException("illegal value for BDS parameter k");
        }
        this.authenticationPath = new ArrayList<XMSSNode>();
        this.retain = new TreeMap<Integer, LinkedList<XMSSNode>>();
        this.stack = new Stack();
        this.initializeTreeHashInstances();
        this.keep = new TreeMap<Integer, XMSSNode>();
        this.index = 0;
    }

    private void initializeTreeHashInstances() {
        this.treeHashInstances = new ArrayList<TreeHash>();
        for (int i = 0; i < this.treeHeight - this.k; ++i) {
            this.treeHashInstances.add(new TreeHash(i));
        }
    }

    protected XMSSNode initialize(OTSHashAddress oTSHashAddress) {
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        for (int i = 0; i < 1 << this.treeHeight; ++i) {
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(i).withChainAddress(oTSHashAddress.getChainAddress()).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
            this.wotsPlus.importKeys(this.xmss.getWOTSPlusSecretKey(oTSHashAddress), this.xmss.getPublicSeed());
            WOTSPlusPublicKeyParameters wOTSPlusPublicKeyParameters = this.wotsPlus.getPublicKey(oTSHashAddress);
            lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(i).withTreeHeight(lTreeAddress.getTreeHeight()).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
            XMSSNode xMSSNode = this.xmss.lTree(wOTSPlusPublicKeyParameters, lTreeAddress);
            hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeIndex(i).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            while (!this.stack.isEmpty() && this.stack.peek().getHeight() == xMSSNode.getHeight()) {
                int n = (int)Math.floor(i / (1 << xMSSNode.getHeight()));
                if (n == 1) {
                    this.authenticationPath.add(xMSSNode.clone());
                }
                if (n == 3 && xMSSNode.getHeight() < this.treeHeight - this.k) {
                    this.treeHashInstances.get(xMSSNode.getHeight()).setNode(xMSSNode.clone());
                }
                if (n >= 3 && (n & 1) == 1 && xMSSNode.getHeight() >= this.treeHeight - this.k && xMSSNode.getHeight() <= this.treeHeight - 2) {
                    if (this.retain.get(xMSSNode.getHeight()) == null) {
                        LinkedList<XMSSNode> linkedList = new LinkedList<XMSSNode>();
                        linkedList.add(xMSSNode.clone());
                        this.retain.put(xMSSNode.getHeight(), linkedList);
                    } else {
                        this.retain.get(xMSSNode.getHeight()).add(xMSSNode.clone());
                    }
                }
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                xMSSNode = this.xmss.randomizeHash(this.stack.pop(), xMSSNode, hashTreeAddress);
                xMSSNode = new XMSSNode(xMSSNode.getHeight() + 1, xMSSNode.getValue());
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight() + 1).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            }
            this.stack.push(xMSSNode);
        }
        this.root = this.stack.pop();
        return this.root.clone();
    }

    protected void nextAuthenticationPath(OTSHashAddress oTSHashAddress) {
        Serializable serializable;
        Object object;
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        if (this.index > (1 << this.treeHeight) - 2) {
            throw new IllegalStateException("index out of bounds");
        }
        LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
        int n = XMSSUtil.calculateTau(this.index, this.treeHeight);
        if ((this.index >> n + 1 & 1) == 0 && n < this.treeHeight - 1) {
            this.keep.put(n, this.authenticationPath.get(n).clone());
        }
        if (n == 0) {
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(this.index).withChainAddress(oTSHashAddress.getChainAddress()).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
            this.wotsPlus.importKeys(this.xmss.getWOTSPlusSecretKey(oTSHashAddress), this.xmss.getPublicSeed());
            object = this.wotsPlus.getPublicKey(oTSHashAddress);
            lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(this.index).withTreeHeight(lTreeAddress.getTreeHeight()).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
            serializable = this.xmss.lTree((WOTSPlusPublicKeyParameters)object, lTreeAddress);
            this.authenticationPath.set(0, (XMSSNode)serializable);
        } else {
            int n2;
            hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(n - 1).withTreeIndex(this.index >> n).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            object = this.xmss.randomizeHash(this.authenticationPath.get(n - 1), this.keep.get(n - 1), hashTreeAddress);
            object = new XMSSNode(((XMSSNode)object).getHeight() + 1, ((XMSSNode)object).getValue());
            this.authenticationPath.set(n, (XMSSNode)object);
            this.keep.remove(n - 1);
            for (n2 = 0; n2 < n; ++n2) {
                if (n2 < this.treeHeight - this.k) {
                    this.authenticationPath.set(n2, this.treeHashInstances.get(n2).tailNode.clone());
                    continue;
                }
                this.authenticationPath.set(n2, this.retain.get(n2).removeFirst());
            }
            n2 = Math.min(n, this.treeHeight - this.k);
            for (int i = 0; i < n2; ++i) {
                int n3 = this.index + 1 + 3 * (1 << i);
                if (n3 >= 1 << this.treeHeight) continue;
                this.treeHashInstances.get(i).initialize(n3);
            }
        }
        for (int i = 0; i < this.treeHeight - this.k >> 1; ++i) {
            serializable = this.getTreeHashInstanceForUpdate();
            if (serializable == null) continue;
            ((TreeHash)serializable).update(oTSHashAddress);
        }
        ++this.index;
    }

    private TreeHash getTreeHashInstanceForUpdate() {
        TreeHash treeHash = null;
        for (TreeHash treeHash2 : this.treeHashInstances) {
            if (treeHash2.isFinished() || !treeHash2.isInitialized()) continue;
            if (treeHash == null) {
                treeHash = treeHash2;
                continue;
            }
            if (treeHash2.getHeight() < treeHash.getHeight()) {
                treeHash = treeHash2;
                continue;
            }
            if (treeHash2.getHeight() != treeHash.getHeight() || treeHash2.getIndexLeaf() >= treeHash.getIndexLeaf()) continue;
            treeHash = treeHash2;
        }
        return treeHash;
    }

    protected void validate() {
        if (this.treeHeight != this.xmss.getParams().getHeight()) {
            throw new IllegalStateException("wrong height");
        }
        if (this.authenticationPath == null) {
            throw new IllegalStateException("authenticationPath == null");
        }
        if (this.retain == null) {
            throw new IllegalStateException("retain == null");
        }
        if (this.stack == null) {
            throw new IllegalStateException("stack == null");
        }
        if (this.treeHashInstances == null) {
            throw new IllegalStateException("treeHashInstances == null");
        }
        if (this.keep == null) {
            throw new IllegalStateException("keep == null");
        }
        if (!XMSSUtil.isIndexValid(this.treeHeight, this.index)) {
            throw new IllegalStateException("index in BDS state out of bounds");
        }
    }

    protected int getTreeHeight() {
        return this.treeHeight;
    }

    protected XMSSNode getRoot() {
        return this.root.clone();
    }

    protected List<XMSSNode> getAuthenticationPath() {
        ArrayList<XMSSNode> arrayList = new ArrayList<XMSSNode>();
        for (XMSSNode xMSSNode : this.authenticationPath) {
            arrayList.add(xMSSNode.clone());
        }
        return arrayList;
    }

    protected void setXMSS(XMSS xMSS) {
        this.xmss = xMSS;
        this.wotsPlus = xMSS.getWOTSPlus();
    }

    protected int getIndex() {
        return this.index;
    }

    private final class TreeHash
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private XMSSNode tailNode;
        private final int initialHeight;
        private int height;
        private int nextIndex;
        private boolean initialized;
        private boolean finished;

        private TreeHash(int n) {
            this.initialHeight = n;
            this.initialized = false;
            this.finished = false;
        }

        private void initialize(int n) {
            this.tailNode = null;
            this.height = this.initialHeight;
            this.nextIndex = n;
            this.initialized = true;
            this.finished = false;
        }

        private void update(OTSHashAddress oTSHashAddress) {
            if (oTSHashAddress == null) {
                throw new NullPointerException("otsHashAddress == null");
            }
            if (this.finished || !this.initialized) {
                throw new IllegalStateException("finished or not initialized");
            }
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(this.nextIndex).withChainAddress(oTSHashAddress.getChainAddress()).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
            LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withLTreeAddress(this.nextIndex).build();
            HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withTreeIndex(this.nextIndex).build();
            BDS.this.wotsPlus.importKeys(BDS.this.xmss.getWOTSPlusSecretKey(oTSHashAddress), BDS.this.xmss.getPublicSeed());
            WOTSPlusPublicKeyParameters wOTSPlusPublicKeyParameters = BDS.this.wotsPlus.getPublicKey(oTSHashAddress);
            XMSSNode xMSSNode = BDS.this.xmss.lTree(wOTSPlusPublicKeyParameters, lTreeAddress);
            while (!BDS.this.stack.isEmpty() && ((XMSSNode)BDS.this.stack.peek()).getHeight() == xMSSNode.getHeight() && ((XMSSNode)BDS.this.stack.peek()).getHeight() != this.initialHeight) {
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                xMSSNode = BDS.this.xmss.randomizeHash((XMSSNode)BDS.this.stack.pop(), xMSSNode, hashTreeAddress);
                xMSSNode = new XMSSNode(xMSSNode.getHeight() + 1, xMSSNode.getValue());
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight() + 1).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            }
            if (this.tailNode == null) {
                this.tailNode = xMSSNode;
            } else if (this.tailNode.getHeight() == xMSSNode.getHeight()) {
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                xMSSNode = BDS.this.xmss.randomizeHash(this.tailNode, xMSSNode, hashTreeAddress);
                this.tailNode = xMSSNode = new XMSSNode(this.tailNode.getHeight() + 1, xMSSNode.getValue());
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight() + 1).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
            } else {
                BDS.this.stack.push(xMSSNode);
            }
            if (this.tailNode.getHeight() == this.initialHeight) {
                this.finished = true;
            } else {
                this.height = xMSSNode.getHeight();
                ++this.nextIndex;
            }
        }

        private int getHeight() {
            if (!this.initialized || this.finished) {
                return Integer.MAX_VALUE;
            }
            return this.height;
        }

        private int getIndexLeaf() {
            return this.nextIndex;
        }

        private void setNode(XMSSNode xMSSNode) {
            this.tailNode = xMSSNode;
            this.height = xMSSNode.getHeight();
            if (this.height == this.initialHeight) {
                this.finished = true;
            }
        }

        private boolean isFinished() {
            return this.finished;
        }

        private boolean isInitialized() {
            return this.initialized;
        }
    }
}

