/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.python.apache.tools.ant.BuildException;
import org.python.core.PyException;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.modules._py_compile;
import org.python.util.GlobMatchingTask;

public class JycompileAntTask
extends GlobMatchingTask {
    @Override
    public void process(Set<File> toCompile) throws BuildException {
        if (toCompile.size() == 0) {
            return;
        }
        if (toCompile.size() > 1) {
            this.log("Compiling " + toCompile.size() + " files");
        } else if (toCompile.size() == 1) {
            this.log("Compiling 1 file");
        }
        Properties props = new Properties();
        props.setProperty("python.cachedir.skip", "true");
        PySystemState.initialize(System.getProperties(), props);
        for (File src : toCompile) {
            try {
                String name = _py_compile.getModuleName(src);
                String compiledFilePath = name.replace('.', '/');
                compiledFilePath = src.getName().endsWith("__init__.py") ? compiledFilePath + "/__init__.py" : compiledFilePath + ".py";
                File compiled = new File(this.destDir, imp.makeCompiledFilename(compiledFilePath));
                this.compile(src, compiled, name);
            }
            catch (RuntimeException e) {
                this.log("Could not compile " + src);
                throw e;
            }
        }
    }

    protected void compile(File src, File compiled, String moduleName) {
        byte[] bytes;
        try {
            bytes = imp.compileSource(moduleName, src);
        }
        catch (PyException pye) {
            pye.printStackTrace();
            throw new BuildException("Compile failed; see the compiler error output for details.");
        }
        File dir = compiled.getParentFile();
        if (!dir.exists() && !compiled.getParentFile().mkdirs()) {
            throw new BuildException("Unable to make directory for compiled file: " + compiled);
        }
        imp.cacheCompiledSource(src.getAbsolutePath(), compiled.getAbsolutePath(), bytes);
    }

    @Override
    protected String getFrom() {
        return "*.py";
    }

    @Override
    protected String getTo() {
        return imp.makeCompiledFilename(this.getFrom());
    }
}

