/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.FragmentManager;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.MessageProcessor;
import net.sf.sdedit.diagram.NoteManager;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.diagram.SequenceDiagramDataProvider;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.Text;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.BroadcastMessage;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Bijection;
import net.sf.sdedit.util.MultiIterator;

public final class SequenceDiagram
implements Diagram,
Iterable<Lifeline> {
    private final Map<String, Lifeline> lifelineMap;
    private final List<List<Lifeline>> lifelineList;
    private int verticalPosition;
    private final SequenceDiagramDataProvider provider;
    private final SequenceConfiguration conf;
    private final ArrayList<LinkedList<Message>> threadStacks;
    private final ArrayList<Lifeline> first;
    private final PaintDevice paintDevice;
    private final Bijection<Drawable, Object> drawableBijection;
    private int callerThread;
    private final boolean threaded;
    private final ArrayList<String> threadStates;
    private final NoteManager noteManager;
    private final List<ForwardMessage> messages;
    private final FragmentManager fragmentManager;
    private final MessageProcessor processor;
    private boolean finished;
    public final int arrowSize;
    public final int messagePadding;
    public final int subLifelineWidth;
    public final int mainLifelineWidth;
    public final int messageLabelSpace;
    public final int arrowThickness;
    public final int activationBarBorderThickness;
    public final int lifelineThickness;
    public final int messageLineLength;
    public final boolean returnArrowVisible;
    public final Color[] threadColors;
    public final Color arrowColor;
    public final int selfMessageXExtent;
    public final boolean opaqueText;
    private final boolean requireReturn;
    private final Map<String, Integer> positionMap;
    private Map<String, Integer> idMap;
    private Map<Integer, List<String>> reverseIdMap;
    private int messageId;

    public SequenceDiagram(SequenceConfiguration configuration, SequenceDiagramDataProvider provider, PaintDevice paintDevice) {
        this.arrowSize = configuration.getArrowSize();
        this.arrowColor = configuration.getArrowColor();
        this.messagePadding = configuration.getMessagePadding();
        this.subLifelineWidth = configuration.getMessagePadding();
        this.selfMessageXExtent = configuration.getSelfMessageHorizontalSpace();
        this.mainLifelineWidth = configuration.getMainLifelineWidth();
        this.messageLabelSpace = configuration.getMessageLabelSpace();
        this.returnArrowVisible = configuration.isReturnArrowVisible();
        this.arrowThickness = configuration.getArrowThickness();
        this.activationBarBorderThickness = configuration.getActivationBarBorderThickness();
        this.lifelineThickness = configuration.getLifelineThickness();
        this.opaqueText = configuration.isOpaqueMessageText();
        this.messageLineLength = configuration.getMessageLineLength();
        this.paintDevice = paintDevice;
        this.lifelineMap = new HashMap<String, Lifeline>();
        this.lifelineList = new ArrayList<List<Lifeline>>();
        this.conf = configuration;
        paintDevice.setDiagram(this);
        this.verticalPosition = 0;
        this.first = new ArrayList();
        this.provider = provider;
        provider.setDiagram(this);
        this.threadStacks = new ArrayList();
        this.threadStates = new ArrayList();
        this.drawableBijection = new Bijection();
        this.threaded = this.conf.isThreaded();
        if (!this.threaded) {
            this.callerThread = this.spawnThread();
        }
        this.noteManager = new NoteManager(this);
        this.fragmentManager = new FragmentManager(this);
        this.processor = new MessageProcessor(this);
        this.finished = false;
        this.threadColors = new Color[]{configuration.getTc0(), configuration.getTc1(), configuration.getTc2(), configuration.getTc3(), configuration.getTc4(), configuration.getTc5(), configuration.getTc6(), configuration.getTc7(), configuration.getTc8(), configuration.getTc9()};
        this.requireReturn = this.conf.isExplicitReturns();
        this.messages = new LinkedList<ForwardMessage>();
        this.positionMap = new HashMap<String, Integer>();
        this.messageId = -1;
        this.idMap = new HashMap<String, Integer>();
    }

    public void setReverseIdMap(Map<Integer, List<String>> map) {
        this.reverseIdMap = map;
        this.idMap = null;
    }

    public Map<Integer, List<String>> makeReverseIdMap() {
        HashMap<Integer, List<String>> reverse = new HashMap<Integer, List<String>>(this.messageId + 1);
        for (Map.Entry<String, Integer> entry : this.idMap.entrySet()) {
            int messageId = entry.getValue();
            String lifelineName = entry.getKey();
            if (!reverse.containsKey(messageId)) {
                reverse.put(messageId, new ArrayList());
            }
            ((List)reverse.get(messageId)).add(lifelineName);
        }
        return reverse;
    }

    @Override
    public void generate() throws SemanticError, SyntaxError {
        this.generate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(boolean complete) throws SemanticError, SyntaxError {
        Fragment frame = null;
        Text text = null;
        String title = this.provider.getTitle();
        String[] description = this.provider.getDescription();
        if (description != null) {
            text = new Text(description, this.paintDevice);
            text.setTop(this.conf.getUpperMargin());
            text.setLeft(this.conf.getLeftMargin());
            this.verticalPosition = text.getBottom() + 3;
        } else {
            this.verticalPosition = this.conf.getUpperMargin();
        }
        if (title != null) {
            frame = new Fragment(title, "", this);
            frame.setTop(this.verticalPosition);
            this.verticalPosition += frame.getLabelHeight() + 5;
        }
        this.readObjects();
        if (this.lifelineList.isEmpty()) {
            return;
        }
        this.paintDevice.reinitialize();
        try {
            for (Lifeline lifeline : this) {
                this.paintDevice.addExtraordinary(lifeline.getHead());
                this.verticalPosition = Math.max(this.verticalPosition, lifeline.getHead().getTop() + lifeline.getHead().getHeight());
            }
            for (Lifeline lifeline : this) {
                lifeline.getView().setBottom(this.verticalPosition);
            }
            this.extendLifelines(this.conf.getInitialSpace());
            for (Lifeline lifeline : this) {
                if (!lifeline.hasThread()) continue;
                lifeline.setActive(true);
            }
            this.readMessages();
        }
        finally {
            this.fragmentManager.finishFragments();
            if (complete && this.getNumberOfLifelines() > 0) {
                this.paintDevice.callSpecial("computeAxes", this.conf.getLeftMargin() + 6 + this.getLifelineAt(0).getHead().getWidth() / 2);
                this.paintDevice.computeBounds();
                for (Lifeline lifeline : this) {
                    this.noteManager.closeNote(lifeline.getName());
                }
                this.noteManager.computeArrowAssociations();
                if (frame != null) {
                    frame.setLeft(this.conf.getLeftMargin());
                    frame.setRight(this.paintDevice.getWidth() - this.conf.getRightMargin() + 6);
                    frame.setBottom(this.verticalPosition + 4);
                    this.paintDevice.addExtraordinary(frame);
                }
                if (text != null) {
                    this.paintDevice.addExtraordinary(text);
                }
            }
            this.finished = true;
            this.paintDevice.close();
        }
    }

    public final boolean isFinished() {
        return this.finished;
    }

    private void readObjects() throws SyntaxError, SemanticError {
        while (this.provider.advance()) {
            Lifeline lifeline = this.provider.nextObject();
            if (lifeline == null) {
                return;
            }
            if (this.provider.getState() != null) {
                this.drawableBijection.add(lifeline.getHead(), this.provider.getState());
            }
            this.addLifeline(lifeline);
        }
    }

    private void readMessages() throws SyntaxError, SemanticError {
        while (this.provider.advance()) {
            Lifeline caller = null;
            if (this.fragmentManager.readFragments()) continue;
            if (!this.noteManager.step()) {
                MessageData data = this.provider.nextMessage();
                this.noteManager.closeNote(data.getCaller());
                String[] callees = data.getCallees();
                if (callees.length == 1) {
                    throw new SyntaxError(this.provider, "A broadcast message must have at least two receivers");
                }
                if (callees.length >= 2) {
                    if (data.isSpawnMessage()) {
                        throw new SyntaxError(this.provider, "Broadcast messages are spawning by default");
                    }
                    HashSet<String> calleeSet = new HashSet<String>();
                    Lifeline[] allButLast = new Lifeline[callees.length - 1];
                    for (int i = 0; i < callees.length; ++i) {
                        String callee = callees[i];
                        if (callee.length() == 0) {
                            throw new SyntaxError(this.provider, "Malformed broadcast message");
                        }
                        if (!calleeSet.add(callee)) {
                            throw new SyntaxError(this.provider, "Duplicate receiver: " + callee);
                        }
                        if (callee.equals(data.getCaller())) {
                            throw new SyntaxError(this.provider, "The sender " + callee + " cannot be a " + "receiver of the broadcast message");
                        }
                        this.noteManager.closeNote(callee);
                        MessageData part = new MessageData();
                        part.setCaller(data.getCaller());
                        part.setCallee(callee);
                        part.setLevel(data.getLevel());
                        part.setThread(data.getThread());
                        if (this.getLifeline(data.getCaller()) != null && !this.getLifeline(data.getCaller()).isAlwaysActive()) {
                            part.setSpawnMessage(true);
                        }
                        part.setReturnsInstantly(data.returnsInstantly());
                        if (i == 0) {
                            part.setNoteNumber(data.getNoteNumber());
                            part.setMessage(data.getMessage());
                            part.setBroadcastType(1);
                        } else if (i == callees.length - 1) {
                            part.setBroadcastType(3);
                        } else {
                            part.setBroadcastType(2);
                        }
                        BroadcastMessage msg = (BroadcastMessage)this.processor.processMessage(part, null);
                        if (i < callees.length - 1) {
                            allButLast[i] = msg.getCallee();
                        } else {
                            msg.setOtherCallees(allButLast);
                        }
                        this.processor.execute(msg);
                    }
                } else {
                    this.noteManager.closeNote(data.getCallee());
                    if (data.isReturning() && this.requireReturn) {
                        caller = this.processor.processReturn(data);
                    } else {
                        ForwardMessage msg = this.processor.processMessage(data, caller);
                        this.messages.add(msg);
                        this.processor.execute(msg);
                        caller = null;
                    }
                }
                this.fragmentManager.clearLabels();
            }
            this.fragmentManager.clearSectionLabel();
        }
        this.finish();
        for (Lifeline line : this.getLifelines()) {
            if (line.isAlwaysActive() || !line.isAlive()) continue;
            line.terminate();
        }
    }

    public List<ForwardMessage> getMessages() {
        return this.messages;
    }

    public int getNextFreeNoteNumber() {
        return this.noteManager.getNextFreeNoteNumber();
    }

    public FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    @Override
    public Object getStateForDrawable(Drawable drawable) {
        Message msg;
        if (drawable instanceof Arrow && (msg = ((Arrow)drawable).getMessage()) instanceof Answer) {
            drawable = ((Answer)msg).getForwardMessage().getArrow();
        }
        return this.drawableBijection.getImage(drawable);
    }

    @Override
    public Drawable getDrawableForState(Object state) {
        return this.drawableBijection.getPreImage(state);
    }

    private boolean addLifeline(Lifeline lifeline) throws SemanticError {
        if (lifeline.getDiagram() != this) {
            throw new IllegalArgumentException("cannot add a lifeline of another diagram");
        }
        if (this.lifelineMap.get(lifeline.getName()) != null) {
            throw new SemanticError(this.provider, lifeline.getName() + " already exists");
        }
        if (lifeline.hasThread()) {
            if (!this.threaded) {
                throw new SemanticError(this.provider, lifeline.getName() + " cannot have its own thread when multithreading is not enabled");
            }
            int thread = this.spawnThread();
            this.first.set(thread, lifeline);
            lifeline.setThread(thread);
        }
        if (!lifeline.isVariable()) {
            this.positionMap.put(lifeline.getName(), this.add(lifeline));
        }
        this.lifelineMap.put(lifeline.getName(), lifeline);
        return true;
    }

    private int add(Lifeline lifeline) {
        int position = this.lifelineList.size();
        this.lifelineList.add(new ArrayList());
        this.lifelineList.get(position).add(lifeline);
        return position;
    }

    public void reuseSpace(Lifeline lifeline) {
        int i = 0;
        int position = -1;
        for (List<Lifeline> list : this.lifelineList) {
            Lifeline line = list.get(list.size() - 1);
            if (line.getCross() != null) {
                list.add(lifeline);
                this.positionMap.put(lifeline.getName(), i);
                position = i;
                break;
            }
            ++i;
        }
        if (position == -1) {
            position = this.add(lifeline);
            this.paintDevice.callSpecial("addLifelineSlot", null);
        }
        this.positionMap.put(lifeline.getName(), position);
        this.paintDevice.addExtraordinary(lifeline.getHead());
    }

    public final void extendLifelines(int amount) {
        for (Lifeline lifeline : this.getLifelines()) {
            if (!lifeline.isAlive()) continue;
            for (Lifeline line : lifeline.getAllLifelines()) {
                line.getView().extend(amount);
            }
        }
        this.verticalPosition += amount;
    }

    int getPositionOf(Lifeline lifeline) {
        return this.positionMap.get(lifeline.getRoot().getName());
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public int getCallerThread() {
        return this.callerThread;
    }

    public void setCallerThread(int callerThread) {
        this.callerThread = callerThread;
    }

    @Override
    public PaintDevice getPaintDevice() {
        return this.paintDevice;
    }

    @Override
    public SequenceDiagramDataProvider getDataProvider() {
        return this.provider;
    }

    @Override
    public SequenceConfiguration getConfiguration() {
        return this.conf;
    }

    public Collection<Lifeline> getLifelines() {
        return this.lifelineMap.values();
    }

    public void removeLifeline(String name) {
        if (this.lifelineMap.remove(name) == null) {
            throw new IllegalArgumentException("lifeline " + name + " should be removed, but does not exist");
        }
    }

    LinkedList<Message> currentStack() {
        return this.threadStacks.get(this.callerThread);
    }

    Lifeline firstCaller() {
        return this.first.get(this.callerThread);
    }

    public void setFirstCaller(Lifeline caller) {
        this.first.set(this.callerThread, caller);
    }

    int spawnThread() {
        int num = this.threadStacks.size();
        this.threadStacks.add(new LinkedList());
        this.first.add(null);
        this.threadStates.add("new");
        return num;
    }

    boolean noThreadIsSpawned() {
        return this.threadStacks.isEmpty();
    }

    String threadState() {
        return this.threadStates.get(this.callerThread);
    }

    void setThreadState(String state) {
        this.threadStates.set(this.callerThread, state);
    }

    void deleteStack() {
        this.threadStacks.set(this.callerThread, null);
        this.first.set(this.callerThread, null);
    }

    void finish(int thread) throws SemanticError {
        Lifeline firstLifeline;
        LinkedList<Message> threadStack = this.threadStacks.get(thread);
        if (!this.conf.isExplicitReturns()) {
            while (threadStack != null && !threadStack.isEmpty()) {
                Message answer = threadStack.removeLast();
                this.sendAnswer(answer);
            }
        }
        if ((firstLifeline = this.first.get(thread)) != null) {
            firstLifeline.finish();
            if (firstLifeline.getRoot() != firstLifeline) {
                firstLifeline.dispose();
            }
        }
    }

    public void sendAnswer(Message answer) {
        this.sendAnswer(answer, false);
    }

    public void sendAnswer(Message answer, boolean removeFromStack) {
        if (removeFromStack) {
            int thread = answer.getThread();
            this.threadStacks.get(thread).removeLast();
        }
        this.noteManager.closeNote(answer.getCaller().getName());
        this.noteManager.closeNote(answer.getCallee().getName());
        answer.executeMessage();
    }

    public void finish() throws SemanticError {
        for (int t = 0; t < this.threadStacks.size(); ++t) {
            this.finish(t);
        }
        for (Lifeline line : this.getLifelines()) {
            if (line == null || line.isAlwaysActive() || !line.isActive()) continue;
            line.finish();
        }
    }

    public Lifeline getLifelineAt(int position) {
        List<Lifeline> list = this.lifelineList.get(position);
        return list.get(list.size() - 1);
    }

    public List<Lifeline> getLifelinesAt(int position) {
        return this.lifelineList.get(position);
    }

    public Lifeline getLifeline(String name) {
        return this.lifelineMap.get(name);
    }

    public int getNumberOfLifelines() {
        return this.lifelineList.size();
    }

    void setVerticalPosition(int verticalPosition) {
        this.verticalPosition = verticalPosition;
    }

    public int getVerticalPosition() {
        return this.verticalPosition;
    }

    public int getNumberOfThreads() {
        return this.threadStacks.size();
    }

    void addToStateMap(Drawable drawable, Object state) {
        this.drawableBijection.add(drawable, state);
    }

    public void associateMessage(int number, Message msg) {
        this.noteManager.associateMessage(number, msg);
    }

    @Override
    public Iterator<Lifeline> iterator() {
        ArrayList<Iterator<Iterator<Lifeline>>> iterators = new ArrayList<Iterator<Iterator<Lifeline>>>();
        for (List<Lifeline> list : this.lifelineList) {
            iterators.add(list.iterator());
        }
        return new MultiIterator<Lifeline>(iterators);
    }

    public void afterExecution(Message message) {
        ++this.messageId;
        if (this.idMap != null) {
            this.idMap.put(message.getCaller().getName(), this.messageId);
            if (message.getCallee() != null) {
                this.idMap.put(message.getCallee().getName(), this.messageId);
            }
        }
        if (this.reverseIdMap != null && this.reverseIdMap.containsKey(this.messageId)) {
            for (String name : this.reverseIdMap.get(this.messageId)) {
                Lifeline lifeline = this.getLifeline(name);
                if (lifeline == null || !lifeline.isAlive() || !lifeline.isAutodestroy()) continue;
                lifeline.terminate();
            }
        }
    }

    @Override
    public List<String> getSuggestions(String prefix) {
        String regexp = "^" + Pattern.quote(prefix.replaceAll("\\*", ".*")) + ".*$";
        Pattern pattern = Pattern.compile(regexp);
        LinkedList<String> suggestions = new LinkedList<String>();
        for (Lifeline lifeline : this) {
            String name = lifeline.getName();
            if (!pattern.matcher(name).matches()) continue;
            suggestions.add(name);
        }
        return suggestions;
    }
}

