#ifndef _EFL_TEXT_MARKUP_INTERACTIVE_EO_H_
#define _EFL_TEXT_MARKUP_INTERACTIVE_EO_H_

#ifndef _EFL_TEXT_MARKUP_INTERACTIVE_EO_CLASS_TYPE
#define _EFL_TEXT_MARKUP_INTERACTIVE_EO_CLASS_TYPE

typedef Eo Efl_Text_Markup_Interactive;

#endif

#ifndef _EFL_TEXT_MARKUP_INTERACTIVE_EO_TYPES
#define _EFL_TEXT_MARKUP_INTERACTIVE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Markup data that populates the text object's style and format
 *
 * @ingroup Efl_Text_Markup_Interactive
 */
#define EFL_TEXT_MARKUP_INTERACTIVE_INTERFACE efl_text_markup_interactive_interface_get()

EWAPI const Efl_Class *efl_text_markup_interactive_interface_get(void);

/**
 * @brief Markup of a given range in the text
 *
 * @param[in] obj The object.
 * @param[in] start Start of the markup region
 * @param[in] end End of markup region
 * @param[in] markup The markup-text representation set to this text of a given
 * range
 *
 * @ingroup Efl_Text_Markup_Interactive
 */
EOAPI void efl_text_markup_interactive_markup_range_set(Eo *obj, Efl_Text_Cursor_Cursor *start, Efl_Text_Cursor_Cursor *end, char *markup EFL_TRANSFER_OWNERSHIP);

/**
 * @brief Markup of a given range in the text
 *
 * @param[in] obj The object.
 * @param[in] start Start of the markup region
 * @param[in] end End of markup region
 *
 * @return The markup-text representation set to this text of a given range
 *
 * @ingroup Efl_Text_Markup_Interactive
 */
EOAPI char *efl_text_markup_interactive_markup_range_get(const Eo *obj, Efl_Text_Cursor_Cursor *start, Efl_Text_Cursor_Cursor *end) EFL_TRANSFER_OWNERSHIP;

/**
 * @brief Inserts a markup text to the text object in a given cursor position
 *
 * @param[in] obj The object.
 * @param[in] cur Cursor position to insert markup
 * @param[in] markup The markup text to insert
 *
 * @ingroup Efl_Text_Markup_Interactive
 */
EOAPI void efl_text_markup_interactive_cursor_markup_insert(Eo *obj, Efl_Text_Cursor_Cursor *cur, const char *markup);
#endif /* EFL_BETA_API_SUPPORT */

#endif
