﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace CloudFormation
{
namespace Model
{

  /**
   * <p>Contains logging configuration information for a type.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/LoggingConfig">AWS
   * API Reference</a></p>
   */
  class AWS_CLOUDFORMATION_API LoggingConfig
  {
  public:
    LoggingConfig();
    LoggingConfig(const Aws::Utils::Xml::XmlNode& xmlNode);
    LoggingConfig& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
    void OutputToStream(Aws::OStream& oStream, const char* location) const;


    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline const Aws::String& GetLogRoleArn() const{ return m_logRoleArn; }

    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline bool LogRoleArnHasBeenSet() const { return m_logRoleArnHasBeenSet; }

    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline void SetLogRoleArn(const Aws::String& value) { m_logRoleArnHasBeenSet = true; m_logRoleArn = value; }

    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline void SetLogRoleArn(Aws::String&& value) { m_logRoleArnHasBeenSet = true; m_logRoleArn = std::move(value); }

    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline void SetLogRoleArn(const char* value) { m_logRoleArnHasBeenSet = true; m_logRoleArn.assign(value); }

    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline LoggingConfig& WithLogRoleArn(const Aws::String& value) { SetLogRoleArn(value); return *this;}

    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline LoggingConfig& WithLogRoleArn(Aws::String&& value) { SetLogRoleArn(std::move(value)); return *this;}

    /**
     * <p>The ARN of the role that CloudFormation should assume when sending log
     * entries to CloudWatch logs.</p>
     */
    inline LoggingConfig& WithLogRoleArn(const char* value) { SetLogRoleArn(value); return *this;}


    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline const Aws::String& GetLogGroupName() const{ return m_logGroupName; }

    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline bool LogGroupNameHasBeenSet() const { return m_logGroupNameHasBeenSet; }

    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline void SetLogGroupName(const Aws::String& value) { m_logGroupNameHasBeenSet = true; m_logGroupName = value; }

    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline void SetLogGroupName(Aws::String&& value) { m_logGroupNameHasBeenSet = true; m_logGroupName = std::move(value); }

    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline void SetLogGroupName(const char* value) { m_logGroupNameHasBeenSet = true; m_logGroupName.assign(value); }

    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline LoggingConfig& WithLogGroupName(const Aws::String& value) { SetLogGroupName(value); return *this;}

    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline LoggingConfig& WithLogGroupName(Aws::String&& value) { SetLogGroupName(std::move(value)); return *this;}

    /**
     * <p>The Amazon CloudWatch log group to which CloudFormation sends error logging
     * information when invoking the type's handlers.</p>
     */
    inline LoggingConfig& WithLogGroupName(const char* value) { SetLogGroupName(value); return *this;}

  private:

    Aws::String m_logRoleArn;
    bool m_logRoleArnHasBeenSet;

    Aws::String m_logGroupName;
    bool m_logGroupNameHasBeenSet;
  };

} // namespace Model
} // namespace CloudFormation
} // namespace Aws
